/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.BuildStepListener;
import hudson.model.BuildVariableContributor;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.CheckPoint;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Environment;
import hudson.model.EnvironmentContributingAction;
import hudson.model.EnvironmentList;
import hudson.model.Executor;
import hudson.model.Fingerprint;
import hudson.model.Item;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.model.WorkspaceListener;
import hudson.model.labels.LabelAtom;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.RequestAbortedException;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.NullChangeLogParser;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.slaves.NodeProperty;
import hudson.slaves.OfflineCause;
import hudson.slaves.WorkspaceList;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildTrigger;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Fingerprinter;
import hudson.tasks.Publisher;
import hudson.util.AdaptedIterator;
import hudson.util.HttpResponses;
import hudson.util.Iterators;
import hudson.util.VariableResolver;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.WeakReference;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.lazy.BuildReference;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.scm.RunWithSCM;
import jenkins.util.SystemProperties;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.xml.sax.SAXException;

public abstract class AbstractBuild<P extends AbstractProject<P, R>, R extends AbstractBuild<P, R>>
extends Run<P, R>
implements Queue.Executable,
LazyBuildMixIn.LazyLoadingRun<P, R>,
RunWithSCM<P, R> {
    private static final boolean upstreamCulprits = SystemProperties.getBoolean("hudson.upstreamCulprits");
    private String builtOn;
    private String workspace;
    private String hudsonVersion;
    private ChangeLogParser scm;
    private volatile transient WeakReference<ChangeLogSet<? extends ChangeLogSet.Entry>> changeSet;
    private volatile Set<String> culprits;
    protected transient List<Environment> buildEnvironments;
    private final transient LazyBuildMixIn.RunMixIn<P, R> runMixIn = new LazyBuildMixIn.RunMixIn<P, R>(){

        @Override
        protected R asRun() {
            return (AbstractBuild)AbstractBuild.this._this();
        }
    };
    private transient Object changeSetLock = new Object();
    private static final Logger LOGGER = Logger.getLogger(AbstractBuild.class.getName());

    protected AbstractBuild(P job) throws IOException {
        super(job);
    }

    protected AbstractBuild(P job, Calendar timestamp) {
        super(job, timestamp);
    }

    protected AbstractBuild(P project, File buildDir) throws IOException {
        super(project, buildDir);
    }

    public final P getProject() {
        return (P)((AbstractProject)this.getParent());
    }

    @Override
    public final LazyBuildMixIn.RunMixIn<P, R> getRunMixIn() {
        return this.runMixIn;
    }

    @Override
    @NonNull
    protected final BuildReference<R> createReference() {
        return this.getRunMixIn().createReference();
    }

    @Override
    protected final void dropLinks() {
        this.getRunMixIn().dropLinks();
    }

    @Override
    public R getPreviousBuild() {
        return (R)((AbstractBuild)this.getRunMixIn().getPreviousBuild());
    }

    @Override
    public R getNextBuild() {
        return (R)((AbstractBuild)this.getRunMixIn().getNextBuild());
    }

    @CheckForNull
    public Node getBuiltOn() {
        if (this.builtOn == null || this.builtOn.equals("")) {
            return Jenkins.get();
        }
        return Jenkins.get().getNode(this.builtOn);
    }

    @Exported(name="builtOn")
    public String getBuiltOnStr() {
        return this.builtOn;
    }

    protected void setBuiltOnStr(String builtOn) {
        this.builtOn = builtOn;
    }

    public AbstractBuild<?, ?> getRootBuild() {
        return this;
    }

    @Override
    public Queue.Executable getParentExecutable() {
        AbstractBuild<?, ?> rootBuild = this.getRootBuild();
        return rootBuild != this ? rootBuild : null;
    }

    public String getUpUrl() {
        return Functions.getNearestAncestorUrl(Stapler.getCurrentRequest(), this.getParent()) + "/";
    }

    @CheckForNull
    public final FilePath getWorkspace() {
        if (this.workspace == null) {
            return null;
        }
        Node n = this.getBuiltOn();
        if (n == null) {
            return null;
        }
        return n.createPath(this.workspace);
    }

    protected void setWorkspace(@NonNull FilePath ws) {
        this.workspace = ws.getRemote();
    }

    public final FilePath getModuleRoot() {
        FilePath ws = this.getWorkspace();
        if (ws == null) {
            return null;
        }
        return ((AbstractProject)this.getParent()).getScm().getModuleRoot(ws, this);
    }

    public FilePath[] getModuleRoots() {
        FilePath ws = this.getWorkspace();
        if (ws == null) {
            return null;
        }
        return ((AbstractProject)this.getParent()).getScm().getModuleRoots(ws, this);
    }

    @Override
    @CheckForNull
    public Set<String> getCulpritIds() {
        return this.culprits;
    }

    @Override
    @Exported
    @NonNull
    public Set<User> getCulprits() {
        return RunWithSCM.super.getCulprits();
    }

    @Override
    public boolean shouldCalculateCulprits() {
        return this.getCulpritIds() == null;
    }

    @Override
    @NonNull
    public Set<User> calculateCulprits() {
        Set<User> c = RunWithSCM.super.calculateCulprits();
        AbstractBuild p = (AbstractBuild)this.getPreviousCompletedBuild();
        if (upstreamCulprits && p != null && p.getPreviousNotFailedBuild() != null) {
            Map<AbstractProject, DependencyChange> depmap = p.getDependencyChanges((AbstractBuild)p.getPreviousSuccessfulBuild());
            for (DependencyChange dep : depmap.values()) {
                for (AbstractBuild b : dep.getBuilds()) {
                    for (ChangeLogSet.Entry entry : b.getChangeSet()) {
                        c.add(entry.getAuthor());
                    }
                }
            }
        }
        return c;
    }

    public String getHudsonVersion() {
        return this.hudsonVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported
    @NonNull
    public ChangeLogSet<? extends ChangeLogSet.Entry> getChangeSet() {
        Object object = this.changeSetLock;
        synchronized (object) {
            if (this.scm == null) {
                this.scm = NullChangeLogParser.INSTANCE;
            }
        }
        ChangeLogSet<ChangeLogSet.Entry> cs = null;
        if (this.changeSet != null) {
            cs = (ChangeLogSet<ChangeLogSet.Entry>)this.changeSet.get();
        }
        if (cs == null) {
            cs = this.calcChangeSet();
        }
        if (cs == null) {
            cs = ChangeLogSet.createEmpty(this);
        }
        this.changeSet = new WeakReference<ChangeLogSet<ChangeLogSet.Entry>>(cs);
        return cs;
    }

    @Override
    @NonNull
    public List<ChangeLogSet<? extends ChangeLogSet.Entry>> getChangeSets() {
        ChangeLogSet<ChangeLogSet.Entry> cs = this.getChangeSet();
        return cs.isEmptySet() ? Collections.emptyList() : List.of(cs);
    }

    public boolean hasChangeSetComputed() {
        File changelogFile = new File(this.getRootDir(), "changelog.xml");
        return changelogFile.exists();
    }

    private ChangeLogSet<? extends ChangeLogSet.Entry> calcChangeSet() {
        File changelogFile = new File(this.getRootDir(), "changelog.xml");
        if (!changelogFile.exists()) {
            return ChangeLogSet.createEmpty(this);
        }
        try {
            return this.scm.parse(this, changelogFile);
        }
        catch (IOException | SAXException e) {
            LOGGER.log(Level.WARNING, "Failed to parse " + changelogFile, e);
            return ChangeLogSet.createEmpty(this);
        }
    }

    @Override
    @NonNull
    public EnvVars getEnvironment(@NonNull TaskListener log) throws IOException, InterruptedException {
        EnvVars env = super.getEnvironment(log);
        FilePath ws = this.getWorkspace();
        if (ws != null) {
            env.put("WORKSPACE", ws.getRemote());
            FilePath tempDir = WorkspaceList.tempDir(ws);
            if (tempDir != null) {
                env.put("WORKSPACE_TMP", tempDir.getRemote());
            }
        }
        ((AbstractProject)this.project).getScm().buildEnvVars(this, env);
        if (this.buildEnvironments != null) {
            for (Environment e : this.buildEnvironments) {
                e.buildEnvVars(env);
            }
        }
        for (EnvironmentContributingAction a : this.getActions(EnvironmentContributingAction.class)) {
            a.buildEnvVars(this, env);
        }
        EnvVars.resolve(env);
        return env;
    }

    public EnvironmentList getEnvironments() {
        Executor e = Executor.currentExecutor();
        if (e != null && e.getCurrentExecutable() == this) {
            if (this.buildEnvironments == null) {
                this.buildEnvironments = new ArrayList<Environment>();
            }
            return new EnvironmentList(this.buildEnvironments);
        }
        return new EnvironmentList(this.buildEnvironments == null ? Collections.emptyList() : List.copyOf(this.buildEnvironments));
    }

    public Calendar due() {
        return this.getTimestamp();
    }

    @Override
    public void addAction(@NonNull Action a) {
        super.addAction(a);
    }

    public List<Action> getPersistentActions() {
        return super.getActions();
    }

    public Set<String> getSensitiveBuildVariables() {
        HashSet<String> s = new HashSet<String>();
        ParametersAction parameters = this.getAction(ParametersAction.class);
        if (parameters != null) {
            for (ParameterValue p : parameters) {
                if (!p.isSensitive()) continue;
                s.add(p.getName());
            }
        }
        if (this.project instanceof BuildableItemWithBuildWrappers) {
            for (BuildWrapper bw : ((BuildableItemWithBuildWrappers)((Object)this.project)).getBuildWrappersList()) {
                bw.makeSensitiveBuildVariables(this, s);
            }
        }
        return s;
    }

    public Map<String, String> getBuildVariables() {
        HashMap<String, String> r = new HashMap<String, String>();
        ParametersAction parameters = this.getAction(ParametersAction.class);
        if (parameters != null) {
            for (ParameterValue p : parameters) {
                String v = p.createVariableResolver(this).resolve(p.getName());
                if (v == null) continue;
                r.put(p.getName(), v);
            }
        }
        if (this.project instanceof BuildableItemWithBuildWrappers) {
            for (BuildWrapper bw : ((BuildableItemWithBuildWrappers)((Object)this.project)).getBuildWrappersList()) {
                bw.makeBuildVariables(this, r);
            }
        }
        for (BuildVariableContributor bvc : BuildVariableContributor.all()) {
            bvc.buildVariablesFor(this, r);
        }
        return r;
    }

    public final VariableResolver<String> getBuildVariableResolver() {
        return new VariableResolver.ByMap<String>(this.getBuildVariables());
    }

    @Deprecated
    public Action getTestResultAction() {
        try {
            return this.getAction(Jenkins.get().getPluginManager().uberClassLoader.loadClass("hudson.tasks.test.AbstractTestResultAction").asSubclass(Action.class));
        }
        catch (ClassNotFoundException x) {
            return null;
        }
    }

    @Deprecated
    public Action getAggregatedTestResultAction() {
        try {
            return this.getAction(Jenkins.get().getPluginManager().uberClassLoader.loadClass("hudson.tasks.test.AggregatedTestResultAction").asSubclass(Action.class));
        }
        catch (ClassNotFoundException x) {
            return null;
        }
    }

    @Override
    public abstract void run();

    @Override
    public String getWhyKeepLog() {
        for (AbstractProject p : ((AbstractProject)this.getParent()).getDownstreamProjects()) {
            int i;
            Run fb;
            if (!p.isKeepDependencies() || (fb = p.getFirstBuild()) == null) continue;
            Iterator<Integer> iterator = this.getDownstreamRelationship(p).listNumbersReverse().iterator();
            while (iterator.hasNext() && (i = iterator.next().intValue()) >= fb.getNumber()) {
                Run b = p.getBuildByNumber(i);
                if (b == null) continue;
                return Messages.AbstractBuild_KeptBecause(p.hasPermission(Item.READ) ? b.toString() : "?");
            }
        }
        return super.getWhyKeepLog();
    }

    public Fingerprint.RangeSet getDownstreamRelationship(AbstractProject that) {
        Fingerprint.RangeSet rs = new Fingerprint.RangeSet();
        Fingerprinter.FingerprintAction f = this.getAction(Fingerprinter.FingerprintAction.class);
        if (f == null) {
            return rs;
        }
        for (Fingerprint e : f.getFingerprints().values()) {
            if (upstreamCulprits) {
                rs.add(e.getRangeSet(that));
                continue;
            }
            Fingerprint.BuildPtr o = e.getOriginal();
            if (o == null || !o.is(this)) continue;
            rs.add(e.getRangeSet(that));
        }
        return rs;
    }

    public Iterable<AbstractBuild<?, ?>> getDownstreamBuilds(final AbstractProject<?, ?> that) {
        final Iterable<Integer> nums = this.getDownstreamRelationship(that).listNumbers();
        return new Iterable<AbstractBuild<?, ?>>(){

            @Override
            public Iterator<AbstractBuild<?, ?>> iterator() {
                return Iterators.removeNull(new AdaptedIterator<Integer, AbstractBuild<?, ?>>(nums){

                    @Override
                    protected AbstractBuild<?, ?> adapt(Integer item) {
                        return that.getBuildByNumber(item);
                    }
                });
            }
        };
    }

    public int getUpstreamRelationship(AbstractProject that) {
        Fingerprinter.FingerprintAction f = this.getAction(Fingerprinter.FingerprintAction.class);
        if (f == null) {
            return -1;
        }
        int n = -1;
        for (Fingerprint e : f.getFingerprints().values()) {
            if (upstreamCulprits) {
                Fingerprint.RangeSet rangeset = e.getRangeSet(that);
                if (rangeset.isEmpty()) continue;
                n = Math.max(n, rangeset.listNumbersReverse().iterator().next());
                continue;
            }
            Fingerprint.BuildPtr o = e.getOriginal();
            if (o == null || !o.belongsTo(that)) continue;
            n = Math.max(n, o.getNumber());
        }
        return n;
    }

    public AbstractBuild<?, ?> getUpstreamRelationshipBuild(AbstractProject<?, ?> that) {
        int n = this.getUpstreamRelationship(that);
        if (n == -1) {
            return null;
        }
        return that.getBuildByNumber(n);
    }

    public Map<AbstractProject, Fingerprint.RangeSet> getDownstreamBuilds() {
        HashMap<AbstractProject, Fingerprint.RangeSet> r = new HashMap<AbstractProject, Fingerprint.RangeSet>();
        for (AbstractProject p : ((AbstractProject)this.getParent()).getDownstreamProjects()) {
            if (!p.isFingerprintConfigured()) continue;
            r.put(p, this.getDownstreamRelationship(p));
        }
        return r;
    }

    public Map<AbstractProject, Integer> getUpstreamBuilds() {
        return this._getUpstreamBuilds(((AbstractProject)this.getParent()).getUpstreamProjects());
    }

    public Map<AbstractProject, Integer> getTransitiveUpstreamBuilds() {
        return this._getUpstreamBuilds(((AbstractProject)this.getParent()).getTransitiveUpstreamProjects());
    }

    private Map<AbstractProject, Integer> _getUpstreamBuilds(Collection<AbstractProject> projects) {
        HashMap<AbstractProject, Integer> r = new HashMap<AbstractProject, Integer>();
        for (AbstractProject p : projects) {
            int n = this.getUpstreamRelationship(p);
            if (n < 0) continue;
            r.put(p, n);
        }
        return r;
    }

    public Map<AbstractProject, DependencyChange> getDependencyChanges(AbstractBuild from) {
        if (from == null) {
            return Collections.emptyMap();
        }
        Fingerprinter.FingerprintAction n = this.getAction(Fingerprinter.FingerprintAction.class);
        Fingerprinter.FingerprintAction o = from.getAction(Fingerprinter.FingerprintAction.class);
        if (n == null || o == null) {
            return Collections.emptyMap();
        }
        Map<AbstractProject, Integer> ndep = n.getDependencies(true);
        Map<AbstractProject, Integer> odep = o.getDependencies(true);
        HashMap<AbstractProject, DependencyChange> r = new HashMap<AbstractProject, DependencyChange>();
        for (Map.Entry<AbstractProject, Integer> entry : odep.entrySet()) {
            AbstractProject p = entry.getKey();
            Integer oldNumber = entry.getValue();
            Integer newNumber = ndep.get(p);
            if (newNumber == null || oldNumber.compareTo(newNumber) >= 0) continue;
            r.put(p, new DependencyChange(p, oldNumber, newNumber));
        }
        return r;
    }

    @Deprecated
    @RequirePOST
    public void doStop(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.doStop().generateResponse(req, rsp, (Object)this);
    }

    @RequirePOST
    public synchronized HttpResponse doStop() throws IOException, ServletException {
        Executor e = this.getExecutor();
        if (e == null) {
            e = this.getOneOffExecutor();
        }
        if (e != null) {
            return e.doStop();
        }
        return HttpResponses.forwardToPreviousPage();
    }

    public static final class DependencyChange {
        public final AbstractProject project;
        public final int fromId;
        public final AbstractBuild from;
        public final int toId;
        public final AbstractBuild to;

        public DependencyChange(AbstractProject<?, ?> project, int fromId, int toId) {
            this.project = project;
            this.fromId = fromId;
            this.toId = toId;
            this.from = project.getBuildByNumber(fromId);
            this.to = project.getBuildByNumber(toId);
        }

        public List<AbstractBuild> getBuilds() {
            ArrayList<AbstractBuild> r = new ArrayList<AbstractBuild>();
            Run b = this.project.getNearestBuild(this.fromId);
            if (b != null && b.getNumber() == this.fromId) {
                b = ((AbstractBuild)b).getNextBuild();
            }
            while (b != null && b.getNumber() <= this.toId) {
                r.add((AbstractBuild)b);
                b = ((AbstractBuild)b).getNextBuild();
            }
            return r;
        }
    }

    private static class TearDownCheckEnvironment
    extends Environment {
        private boolean tornDown = false;

        private TearDownCheckEnvironment() {
        }

        @Override
        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            this.tornDown = true;
            return true;
        }
    }

    public abstract class AbstractBuildExecution
    extends Run.Runner {
        protected Launcher launcher;
        protected BuildListener listener;
        private WorkspaceList.Lease lease;

        @NonNull
        protected final Node getCurrentNode() throws IllegalStateException {
            Executor exec = Executor.currentExecutor();
            if (exec == null) {
                throw new IllegalStateException("not being called from an executor thread");
            }
            Computer c = exec.getOwner();
            Node node = c.getNode();
            if (node == null) {
                throw new IllegalStateException("no longer a configured node for " + c.getName());
            }
            return node;
        }

        public Launcher getLauncher() {
            return this.launcher;
        }

        public BuildListener getListener() {
            return this.listener;
        }

        protected WorkspaceList.Lease decideWorkspace(@NonNull Node n, WorkspaceList wsl) throws InterruptedException, IOException {
            String customWorkspace = ((AbstractProject)this.getProject()).getCustomWorkspace();
            if (customWorkspace != null) {
                FilePath rootPath = n.getRootPath();
                if (rootPath == null) {
                    throw new AbortException(n.getDisplayName() + " seems to be offline");
                }
                return WorkspaceList.Lease.createDummyLease(rootPath.child(AbstractBuild.this.getEnvironment(this.listener).expand(customWorkspace)));
            }
            FilePath ws = n.getWorkspaceFor((TopLevelItem)this.getProject());
            if (ws == null) {
                throw new AbortException(n.getDisplayName() + " seems to be offline");
            }
            return wsl.allocate(ws, this.getBuild());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        @NonNull
        public Result run(@NonNull BuildListener listener) throws Exception {
            block18: {
                block19: {
                    node = this.getCurrentNode();
                    if (!AbstractBuildExecution.$assertionsDisabled && AbstractBuild.this.builtOn != null) {
                        throw new AssertionError();
                    }
                    AbstractBuild.this.builtOn = node.getNodeName();
                    AbstractBuild.this.hudsonVersion = Jenkins.VERSION;
                    this.listener = listener;
                    result = null;
                    AbstractBuild.this.buildEnvironments = new ArrayList<Environment>();
                    tearDownMarker = new TearDownCheckEnvironment();
                    AbstractBuild.this.buildEnvironments.add(tearDownMarker);
                    try {
                        this.launcher = this.createLauncher(listener);
                        if (!Jenkins.get().getNodes().isEmpty()) {
                            if (node instanceof Jenkins) {
                                listener.getLogger().print(Messages.AbstractBuild_BuildingOnMaster());
                            } else {
                                listener.getLogger().print(Messages.AbstractBuild_BuildingRemotely(ModelHyperlinkNote.encodeTo("/computer/" + AbstractBuild.this.builtOn, node.getDisplayName())));
                                assignedLabels = new HashSet<LabelAtom>(node.getAssignedLabels());
                                assignedLabels.remove(node.getSelfLabel());
                                if (!assignedLabels.isEmpty()) {
                                    first = true;
                                    for (LabelAtom label : assignedLabels) {
                                        if (first) {
                                            listener.getLogger().print(" (");
                                            first = false;
                                        } else {
                                            listener.getLogger().print(' ');
                                        }
                                        listener.getLogger().print(label.getName());
                                    }
                                    listener.getLogger().print(')');
                                }
                            }
                        } else {
                            listener.getLogger().print(Messages.AbstractBuild_Building());
                        }
                        this.lease = this.decideWorkspace(node, Computer.currentComputer().getWorkspaceList());
                        AbstractBuild.this.workspace = this.lease.path.getRemote();
                        listener.getLogger().println(Messages.AbstractBuild_BuildingInWorkspace(AbstractBuild.this.workspace));
                        for (WorkspaceListener wl : WorkspaceListener.all()) {
                            wl.beforeUse(AbstractBuild.this, this.lease.path, listener);
                        }
                        ((AbstractProject)this.getProject()).getScmCheckoutStrategy().preCheckout(AbstractBuild.this, this.launcher, this.listener);
                        ((AbstractProject)this.getProject()).getScmCheckoutStrategy().checkout(this);
                        if (this.preBuild(listener, ((AbstractProject)AbstractBuild.this.project).getProperties())) break block18;
                        var5_5 = Result.FAILURE;
                        if (tearDownMarker.tornDown) break block19;
                    }
                    catch (Throwable var9_10) {
                        if (!tearDownMarker.tornDown) {
                            result = Result.combine(result, this.tearDownBuildEnvironments(listener));
                        }
                        throw var9_10;
                    }
                    result = Result.combine(result, this.tearDownBuildEnvironments(listener));
                }
                return var5_5;
            }
            result = this.doRun(listener);
            ** if (tearDownMarker.tornDown) goto lbl59
lbl-1000:
            // 1 sources

            {
                result = Result.combine(result, this.tearDownBuildEnvironments(listener));
            }
            {
            }
lbl59:
            // 2 sources

            if (node.getChannel() != null) {
                this.launcher.kill(AbstractBuild.this.getCharacteristicEnvVars());
            }
            if (result == null) {
                result = AbstractBuild.this.getResult();
            }
            if (result == null) {
                result = Result.SUCCESS;
            }
            return result;
        }

        private Result tearDownBuildEnvironments(@NonNull BuildListener listener) throws InterruptedException {
            Result result = null;
            InterruptedException firstInterruptedException = null;
            for (int i = AbstractBuild.this.buildEnvironments.size() - 1; i >= 0; --i) {
                Environment environment = AbstractBuild.this.buildEnvironments.get(i);
                try {
                    if (environment.tearDown(AbstractBuild.this, listener)) continue;
                    result = Result.combine(result, Result.FAILURE);
                    continue;
                }
                catch (InterruptedException e) {
                    if (firstInterruptedException == null) {
                        firstInterruptedException = e;
                        continue;
                    }
                    Functions.printStackTrace((Throwable)e, listener.error("Interrupted during tear down: " + e.getMessage()));
                    continue;
                }
                catch (IOException | RuntimeException e) {
                    if (e instanceof IOException) {
                        Util.displayIOException((IOException)e, listener);
                    }
                    Functions.printStackTrace((Throwable)e, listener.error("Unable to tear down: " + e.getMessage()));
                    result = Result.combine(result, Result.FAILURE);
                }
            }
            if (firstInterruptedException != null) {
                throw firstInterruptedException;
            }
            return result;
        }

        @NonNull
        protected Launcher createLauncher(@NonNull BuildListener listener) throws IOException, InterruptedException {
            Environment environment;
            Node currentNode = this.getCurrentNode();
            Launcher l = currentNode.createLauncher(listener);
            if (AbstractBuild.this.project instanceof BuildableItemWithBuildWrappers) {
                BuildableItemWithBuildWrappers biwbw = (BuildableItemWithBuildWrappers)((Object)AbstractBuild.this.project);
                for (BuildWrapper bw : biwbw.getBuildWrappersList()) {
                    l = bw.decorateLauncher(AbstractBuild.this, l, listener);
                }
            }
            for (RunListener rl : RunListener.all()) {
                environment = rl.setUpEnvironment(AbstractBuild.this, l, listener);
                if (environment == null) continue;
                AbstractBuild.this.buildEnvironments.add(environment);
            }
            for (NodeProperty nodeProperty : Jenkins.get().getGlobalNodeProperties()) {
                environment = nodeProperty.setUp(AbstractBuild.this, l, listener);
                if (environment == null) continue;
                AbstractBuild.this.buildEnvironments.add(environment);
            }
            for (NodeProperty nodeProperty : currentNode.getNodeProperties()) {
                environment = nodeProperty.setUp(AbstractBuild.this, l, listener);
                if (environment == null) continue;
                AbstractBuild.this.buildEnvironments.add(environment);
            }
            return l;
        }

        public void defaultCheckout() throws IOException, InterruptedException {
            AbstractBuild build = AbstractBuild.this;
            Object project = build.getProject();
            int retryCount = ((AbstractProject)project).getScmCheckoutRetryCount();
            while (true) {
                build.scm = NullChangeLogParser.INSTANCE;
                try {
                    File changeLogFile = new File(build.getRootDir(), "changelog.xml");
                    if (((AbstractProject)project).checkout(build, this.launcher, this.listener, changeLogFile)) {
                        SCM scm = ((AbstractProject)project).getScm();
                        for (SCMListener sCMListener : SCMListener.all()) {
                            try {
                                sCMListener.onCheckout(build, scm, build.getWorkspace(), this.listener, changeLogFile, build.getAction(SCMRevisionState.class));
                            }
                            catch (Exception e) {
                                throw new IOException(e);
                            }
                        }
                        build.scm = scm.createChangeLogParser();
                        build.changeSet = new WeakReference<ChangeLogSet<ChangeLogSet.Entry>>(build.calcChangeSet());
                        for (SCMListener sCMListener : SCMListener.all()) {
                            try {
                                sCMListener.onChangeLogParsed(build, this.listener, build.getChangeSet());
                            }
                            catch (Exception e) {
                                throw new IOException("Failed to parse changelog", e);
                            }
                        }
                        scm.postCheckout(build, this.launcher, build.getWorkspace(), this.listener);
                        return;
                    }
                }
                catch (AbortException e) {
                    this.listener.error(e.getMessage());
                }
                catch (InterruptedIOException | ClosedByInterruptException e) {
                    throw (InterruptedException)new InterruptedException().initCause(e);
                }
                catch (IOException e) {
                    Functions.printStackTrace((Throwable)e, this.listener.getLogger());
                }
                if (retryCount == 0) {
                    throw new Run.RunnerAbortedException();
                }
                this.listener.getLogger().println("Retrying after 10 seconds");
                Thread.sleep(10000L);
                --retryCount;
            }
        }

        protected abstract Result doRun(BuildListener var1) throws Exception;

        protected abstract void post2(BuildListener var1) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void post(@NonNull BuildListener listener) throws Exception {
            try {
                this.post2(listener);
            }
            finally {
                TreeSet<String> r = new TreeSet<String>();
                for (User u : AbstractBuild.this.getCulprits()) {
                    r.add(u.getId());
                }
                AbstractBuild.this.culprits = Collections.unmodifiableSet(r);
                CheckPoint.CULPRITS_DETERMINED.report();
            }
        }

        @Override
        public void cleanUp(@NonNull BuildListener listener) throws Exception {
            if (this.lease != null) {
                this.lease.release();
                this.lease = null;
            }
            BuildTrigger.execute(AbstractBuild.this, listener);
            AbstractBuild.this.buildEnvironments = null;
        }

        @Deprecated
        protected final void performAllBuildStep(BuildListener listener, Map<?, ? extends BuildStep> buildSteps, boolean phase) throws InterruptedException, IOException {
            this.performAllBuildSteps(listener, buildSteps.values(), phase);
        }

        protected final boolean performAllBuildSteps(BuildListener listener, Map<?, ? extends BuildStep> buildSteps, boolean phase) throws InterruptedException, IOException {
            return this.performAllBuildSteps(listener, buildSteps.values(), phase);
        }

        @Deprecated
        protected final void performAllBuildStep(BuildListener listener, Iterable<? extends BuildStep> buildSteps, boolean phase) throws InterruptedException, IOException {
            this.performAllBuildSteps(listener, buildSteps, phase);
        }

        protected final boolean performAllBuildSteps(BuildListener listener, Iterable<? extends BuildStep> buildSteps, boolean phase) throws InterruptedException, IOException {
            boolean r = true;
            for (BuildStep buildStep : buildSteps) {
                if (!((buildStep instanceof Publisher && ((Publisher)buildStep).needsToRunAfterFinalized()) ^ phase)) continue;
                try {
                    if (this.perform(buildStep, listener)) continue;
                    LOGGER.log(Level.FINE, "{0} : {1} failed", new Object[]{AbstractBuild.this, buildStep});
                    r = false;
                    if (!phase) continue;
                    AbstractBuild.this.setResult(Result.FAILURE);
                }
                catch (Exception | LinkageError e) {
                    this.reportError(buildStep, e, listener, phase);
                    r = false;
                }
            }
            return r;
        }

        private void reportError(BuildStep bs, Throwable e, BuildListener listener, boolean phase) {
            String buildStep = bs instanceof Describable ? ((Describable)((Object)bs)).getDescriptor().getDisplayName() : bs.getClass().getName();
            if (e instanceof AbortException) {
                LOGGER.log(Level.FINE, "{0} : {1} failed", new Object[]{AbstractBuild.this, buildStep});
                listener.error("Step \u2018" + buildStep + "\u2019 failed: " + e.getMessage());
            } else {
                String msg = "Step \u2018" + buildStep + "\u2019 aborted due to exception: ";
                Functions.printStackTrace(e, listener.error(msg));
                LOGGER.log(Level.WARNING, msg, e);
            }
            if (phase) {
                AbstractBuild.this.setResult(Result.FAILURE);
            }
        }

        protected final boolean perform(BuildStep bs, BuildListener listener) throws InterruptedException, IOException {
            String buildStepName;
            BuildStepMonitor mon = bs.getRequiredMonitorService();
            Result oldResult = AbstractBuild.this.getResult();
            for (BuildStepListener bsl : BuildStepListener.all()) {
                bsl.started(AbstractBuild.this, bs, listener);
            }
            boolean canContinue = false;
            try {
                canContinue = mon.perform(bs, AbstractBuild.this, this.launcher, listener);
            }
            catch (ChannelClosedException | RequestAbortedException ex) {
                this.reportBrokenChannel(listener);
            }
            catch (RuntimeException ex) {
                Functions.printStackTrace((Throwable)ex, listener.error("Build step failed with exception"));
            }
            for (BuildStepListener bsl : BuildStepListener.all()) {
                bsl.finished(AbstractBuild.this, bs, listener, canContinue);
            }
            Result newResult = AbstractBuild.this.getResult();
            if (newResult != oldResult) {
                buildStepName = this.getBuildStepName(bs);
                listener.getLogger().format("Build step '%s' changed build result to %s%n", buildStepName, newResult);
            }
            if (!canContinue) {
                buildStepName = this.getBuildStepName(bs);
                listener.getLogger().format("Build step '%s' marked build as failure%n", buildStepName);
            }
            return canContinue;
        }

        private void reportBrokenChannel(BuildListener listener) throws IOException {
            Node node = this.getCurrentNode();
            listener.hyperlink("/" + node.toComputer().getUrl() + "log", "Agent went offline during the build");
            listener.getLogger().println();
            OfflineCause offlineCause = node.toComputer().getOfflineCause();
            if (offlineCause != null) {
                listener.error(offlineCause.toString());
            }
        }

        private String getBuildStepName(BuildStep bs) {
            if (bs instanceof Describable) {
                return ((Describable)((Object)bs)).getDescriptor().getDisplayName();
            }
            return bs.getClass().getSimpleName();
        }

        protected final boolean preBuild(BuildListener listener, Map<?, ? extends BuildStep> steps) {
            return this.preBuild(listener, steps.values());
        }

        protected final boolean preBuild(BuildListener listener, Collection<? extends BuildStep> steps) {
            return this.preBuild(listener, (Iterable<? extends BuildStep>)steps);
        }

        protected final boolean preBuild(BuildListener listener, Iterable<? extends BuildStep> steps) {
            for (BuildStep buildStep : steps) {
                if (buildStep.prebuild(AbstractBuild.this, listener)) continue;
                LOGGER.log(Level.FINE, "{0} : {1} failed", new Object[]{AbstractBuild.this, buildStep});
                return false;
            }
            return true;
        }
    }

    @Deprecated
    public abstract class AbstractRunner
    extends AbstractBuildExecution {
    }
}

