/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import hudson.Functions;
import hudson.Util;
import hudson.node_monitors.AbstractAsyncNodeMonitorDescriptor;
import hudson.node_monitors.AbstractDiskSpaceMonitor;
import hudson.node_monitors.Messages;
import hudson.node_monitors.MonitorOfflineCause;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Locale;
import jenkins.MasterToSlaveFileCallable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

public abstract class DiskSpaceMonitorDescriptor
extends AbstractAsyncNodeMonitorDescriptor<DiskSpace> {

    protected static final class GetUsableSpace
    extends MasterToSlaveFileCallable<DiskSpace> {
        private static final long serialVersionUID = 1L;

        @Override
        public DiskSpace invoke(File f, VirtualChannel channel) throws IOException {
            long s = f.getUsableSpace();
            if (s <= 0L) {
                return null;
            }
            return new DiskSpace(f.getCanonicalPath(), s);
        }
    }

    @ExportedBean
    public static final class DiskSpace
    extends MonitorOfflineCause
    implements Serializable {
        private final String path;
        @Exported
        public final long size;
        private boolean triggered;
        private Class<? extends AbstractDiskSpaceMonitor> trigger;
        private static final long serialVersionUID = 2L;

        public DiskSpace(String path, long size) {
            this.path = path;
            this.size = size;
        }

        public String toString() {
            if (this.triggered) {
                return Messages.DiskSpaceMonitorDescriptor_DiskSpace_FreeSpaceTooLow(this.getGbLeft(), this.path);
            }
            return Messages.DiskSpaceMonitorDescriptor_DiskSpace_FreeSpace(this.getGbLeft(), this.path);
        }

        @Exported
        public String getPath() {
            return this.path;
        }

        @Restricted(value={DoNotUse.class})
        public long getFreeSize() {
            return this.size;
        }

        public String getGbLeft() {
            long space = this.size;
            space /= 1024L;
            return new BigDecimal(space /= 1024L).scaleByPowerOfTen(-3).toPlainString();
        }

        public String toHtml() {
            String humanReadableSpace = Functions.humanReadableByteSize(this.size);
            if (this.triggered) {
                return Util.wrapToErrorSpan(humanReadableSpace);
            }
            return humanReadableSpace;
        }

        protected void setTriggered(boolean triggered) {
            this.triggered = triggered;
        }

        protected void setTriggered(Class<? extends AbstractDiskSpaceMonitor> trigger, boolean triggered) {
            this.trigger = trigger;
            this.triggered = triggered;
        }

        public Class<? extends AbstractDiskSpaceMonitor> getTrigger() {
            return this.trigger;
        }

        public static DiskSpace parse(String size) throws ParseException {
            if ((size = size.toUpperCase(Locale.ENGLISH).trim()).endsWith("B")) {
                size = size.substring(0, size.length() - 1);
            }
            long multiplier = 1L;
            String suffix = "KMGT";
            for (int i = 0; i < suffix.length(); ++i) {
                if (!size.endsWith(suffix.substring(i, i + 1))) continue;
                multiplier = 1L;
                for (int j = 0; j <= i; ++j) {
                    multiplier *= 1024L;
                }
                size = size.substring(0, size.length() - 1);
            }
            return new DiskSpace("", (long)(Double.parseDouble(size.trim()) * (double)multiplier));
        }
    }
}

