/*
 * Decompiled with CFR 0.152.
 */
package hudson.triggers;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AdministrativeMonitor;
import hudson.triggers.Messages;
import hudson.triggers.TriggerDescriptor;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Restricted(value={NoExternalUse.class})
@Extension
public class SlowTriggerAdminMonitor
extends AdministrativeMonitor {
    @NonNull
    private final Map<String, Value> errors = new ConcurrentHashMap<String, Value>();
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static int MAX_ENTRIES = SystemProperties.getInteger(SlowTriggerAdminMonitor.class.getName() + ".maxEntries", 10);
    @NonNull
    private static final Logger LOGGER = Logger.getLogger(SlowTriggerAdminMonitor.class.getName());

    @NonNull
    public static SlowTriggerAdminMonitor getInstance() {
        return ExtensionList.lookup(SlowTriggerAdminMonitor.class).get(0);
    }

    @Override
    public boolean isActivated() {
        return !this.errors.isEmpty();
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return Messages.SlowTriggerAdminMonitor_DisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Value> map = this.errors;
        synchronized (map) {
            this.errors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(@NonNull Class<? extends TriggerDescriptor> trigger, @NonNull String fullJobName, long duration) {
        Map<String, Value> map = this.errors;
        synchronized (map) {
            if (this.errors.size() >= MAX_ENTRIES && !this.errors.containsKey(trigger.getName())) {
                String oldest_trigger = null;
                LocalDateTime oldest_time = null;
                for (Map.Entry<String, Value> entry : this.errors.entrySet()) {
                    String local_trigger = entry.getKey();
                    if (oldest_trigger != null && entry.getValue().time.compareTo(oldest_time) >= 0) continue;
                    oldest_trigger = local_trigger;
                    oldest_time = entry.getValue().time;
                }
                this.errors.remove(oldest_trigger);
            }
        }
        this.errors.put(trigger.getName(), new Value(trigger, fullJobName, duration));
    }

    @NonNull
    public Map<String, Value> getErrors() {
        return new HashMap<String, Value>(this.errors);
    }

    @Restricted(value={DoNotUse.class})
    @RequirePOST
    @NonNull
    public HttpResponse doClear() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.clear();
        return HttpResponses.redirectViaContextPath((String)"/manage");
    }

    public static class Value {
        private final LocalDateTime time;
        private Class<? extends TriggerDescriptor> trigger;
        private final String fullJobName;
        private final long duration;

        Value(Class<? extends TriggerDescriptor> trigger, @NonNull String fullJobName, long duration) {
            this.trigger = trigger;
            this.fullJobName = fullJobName;
            this.duration = duration;
            this.time = LocalDateTime.now();
        }

        @NonNull
        public String getTimeString() {
            return DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).format(this.time);
        }

        @NonNull
        public String getFullJobName() {
            return this.fullJobName;
        }

        public Class<? extends TriggerDescriptor> getTrigger() {
            return this.trigger;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

