/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Functions;
import hudson.ProxyConfiguration;
import hudson.RelativePath;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.DOSToUnixPathHelper;
import hudson.util.Messages;
import hudson.util.ReflectionUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class FormValidation
extends IOException
implements HttpResponse {
    static boolean APPLY_CONTENT_SECURITY_POLICY_HEADERS = SystemProperties.getBoolean(FormValidation.class.getName() + ".applyContentSecurityPolicyHeaders", true);
    private static final FormValidation OK = FormValidation.respond(Kind.OK, "<div/>");
    public final Kind kind;

    public static FormValidation error(String message) {
        return FormValidation.errorWithMarkup(message == null ? null : Util.escape(message));
    }

    public static FormValidation warning(String message) {
        return FormValidation.warningWithMarkup(message == null ? null : Util.escape(message));
    }

    public static FormValidation ok(String message) {
        return FormValidation.okWithMarkup(message == null ? null : Util.escape(message));
    }

    public static FormValidation ok() {
        return OK;
    }

    public static FormValidation error(String format, Object ... args) {
        return FormValidation.error(String.format(format, args));
    }

    public static FormValidation warning(String format, Object ... args) {
        return FormValidation.warning(String.format(format, args));
    }

    public static FormValidation ok(String format, Object ... args) {
        return FormValidation.ok(String.format(format, args));
    }

    public static FormValidation error(Throwable e, String message) {
        return FormValidation._error(Kind.ERROR, e, message);
    }

    public static FormValidation warning(Throwable e, String message) {
        return FormValidation._error(Kind.WARNING, e, message);
    }

    private static FormValidation _error(Kind kind, Throwable e, String message) {
        if (e == null) {
            return FormValidation._errorWithMarkup(Util.escape(message), kind);
        }
        return FormValidation._errorWithMarkup(Util.escape(message) + " </div><div><a href='#' class='showDetails'>" + Messages.FormValidation_Error_Details() + "</a><pre style='display:none'>" + Util.escape(Functions.printThrowable(e)) + "</pre>", kind);
    }

    public static FormValidation error(Throwable e, String format, Object ... args) {
        return FormValidation.error(e, String.format(format, args));
    }

    public static FormValidation warning(Throwable e, String format, Object ... args) {
        return FormValidation.warning(e, String.format(format, args));
    }

    @NonNull
    public static FormValidation aggregate(@NonNull Collection<FormValidation> validations) {
        if (validations == null || validations.isEmpty()) {
            return FormValidation.ok();
        }
        if (validations.size() == 1) {
            return validations.iterator().next();
        }
        StringBuilder sb = new StringBuilder("<ul style='list-style-type: none; padding-left: 0; margin: 0'>");
        Kind worst = Kind.OK;
        for (FormValidation validation : validations) {
            sb.append("<li>").append(validation.renderHtml()).append("</li>");
            if (validation.kind.ordinal() <= worst.ordinal()) continue;
            worst = validation.kind;
        }
        sb.append("</ul>");
        return FormValidation.respond(worst, sb.toString());
    }

    public static FormValidation errorWithMarkup(String message) {
        return FormValidation._errorWithMarkup(message, Kind.ERROR);
    }

    public static FormValidation warningWithMarkup(String message) {
        return FormValidation._errorWithMarkup(message, Kind.WARNING);
    }

    public static FormValidation okWithMarkup(String message) {
        return FormValidation._errorWithMarkup(message, Kind.OK);
    }

    private static FormValidation _errorWithMarkup(final String message, Kind kind) {
        if (message == null) {
            return FormValidation.ok();
        }
        return new FormValidation(kind, message){

            @Override
            public String renderHtml() {
                StaplerRequest req = Stapler.getCurrentRequest();
                if (req == null) {
                    return message;
                }
                return "<div class=\"" + this.kind.name().toLowerCase(Locale.ENGLISH) + "\">" + message + "</div>";
            }

            @Override
            public String toString() {
                return this.kind + ": " + message;
            }
        };
    }

    public static FormValidation respond(Kind kind, final String html) {
        return new FormValidation(kind){

            @Override
            public String renderHtml() {
                return html;
            }

            @Override
            public String toString() {
                return this.kind + ": " + html;
            }
        };
    }

    public static FormValidation validateExecutable(String exe) {
        return FormValidation.validateExecutable(exe, FileValidator.NOOP);
    }

    public static FormValidation validateExecutable(String exe, final FileValidator exeValidator) {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return FormValidation.ok();
        }
        final FormValidation[] result = new FormValidation[]{null};
        try {
            DOSToUnixPathHelper.iteratePath(exe, new DOSToUnixPathHelper.Helper(){

                @Override
                public void ok() {
                    result[0] = FormValidation.ok();
                }

                @Override
                public void checkExecutable(File fexe) {
                    result[0] = exeValidator.validate(fexe);
                }

                @Override
                public void error(String string) {
                    result[0] = FormValidation.error(string);
                }

                @Override
                public void validate(File fexe) {
                    result[0] = exeValidator.validate(fexe);
                }
            });
            return result[0];
        }
        catch (RuntimeException e) {
            return FormValidation.error(e, "Unexpected error");
        }
    }

    public static FormValidation validateNonNegativeInteger(String value) {
        try {
            if (Integer.parseInt(value) < 0) {
                return FormValidation.error(hudson.model.Messages.Hudson_NotANonNegativeNumber());
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error(hudson.model.Messages.Hudson_NotANumber());
        }
    }

    public static FormValidation validateIntegerInRange(String value, int lower, int upper) {
        try {
            int intValue = Integer.parseInt(value);
            if (intValue < lower) {
                return FormValidation.error(hudson.model.Messages.Hudson_MustBeAtLeast(lower));
            }
            if (intValue > upper) {
                return FormValidation.error(hudson.model.Messages.Hudson_MustBeAtMost(upper));
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error(hudson.model.Messages.Hudson_NotANumber());
        }
    }

    public static FormValidation validatePositiveInteger(String value) {
        try {
            if (Integer.parseInt(value) <= 0) {
                return FormValidation.error(hudson.model.Messages.Hudson_NotAPositiveNumber());
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error(hudson.model.Messages.Hudson_NotANumber());
        }
    }

    public static FormValidation validateRequired(String value) {
        if (Util.fixEmptyAndTrim(value) == null) {
            return FormValidation.error(Messages.FormValidation_ValidateRequired());
        }
        return FormValidation.ok();
    }

    public static FormValidation validateBase64(String value, boolean allowWhitespace, boolean allowEmpty, String errorMessage) {
        try {
            String v = value;
            if (!(allowWhitespace || v.indexOf(32) < 0 && v.indexOf(10) < 0)) {
                return FormValidation.error(errorMessage);
            }
            v = v.trim();
            if (!allowEmpty && v.length() == 0) {
                return FormValidation.error(errorMessage);
            }
            Base64.getDecoder().decode(v.getBytes(StandardCharsets.UTF_8));
            return FormValidation.ok();
        }
        catch (IllegalArgumentException e) {
            return FormValidation.error(errorMessage);
        }
    }

    private FormValidation(Kind kind) {
        this.kind = kind;
    }

    private FormValidation(Kind kind, String message) {
        super(message);
        this.kind = kind;
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        this.respond(rsp, this.renderHtml());
    }

    public abstract String renderHtml();

    protected void respond(StaplerResponse rsp, String html) throws IOException, ServletException {
        rsp.setContentType("text/html;charset=UTF-8");
        if (APPLY_CONTENT_SECURITY_POLICY_HEADERS) {
            for (String header : new String[]{"Content-Security-Policy", "X-WebKit-CSP", "X-Content-Security-Policy"}) {
                rsp.setHeader(header, "sandbox; default-src 'none';");
            }
        }
        rsp.getWriter().print(html);
    }

    public static class CheckMethod {
        private final Descriptor descriptor;
        private final Method method;
        private final String capitalizedFieldName;
        private final List<String> names;
        private volatile String checkUrl;
        private volatile String dependsOn;

        public CheckMethod(Descriptor descriptor, String fieldName) {
            this.descriptor = descriptor;
            this.capitalizedFieldName = StringUtils.capitalize((String)fieldName);
            this.method = ReflectionUtils.getPublicMethodNamed(descriptor.getClass(), "doCheck" + this.capitalizedFieldName);
            if (this.method != null) {
                this.names = new ArrayList<String>();
                this.findParameters(this.method);
            } else {
                this.names = null;
            }
        }

        private void findParameters(Method method) {
            for (ReflectionUtils.Parameter p : ReflectionUtils.getParameters(method)) {
                QueryParameter qp = p.annotation(QueryParameter.class);
                if (qp != null) {
                    Object name = qp.value();
                    if (((String)name).length() == 0) {
                        name = p.name();
                    }
                    if (name == null || ((String)name).length() == 0 || ((String)name).equals("value")) continue;
                    RelativePath rp = p.annotation(RelativePath.class);
                    if (rp != null) {
                        name = rp.value() + "/" + (String)name;
                    }
                    this.names.add((String)name);
                    continue;
                }
                Method m = ReflectionUtils.getPublicMethodNamed(p.type(), "fromStapler");
                if (m == null) continue;
                this.findParameters(m);
            }
        }

        public String toCheckUrl() {
            if (this.names == null) {
                return null;
            }
            if (this.checkUrl == null) {
                StringBuilder buf = new StringBuilder(Util.singleQuote(this.relativePath()));
                if (!this.names.isEmpty()) {
                    buf.append("+qs(this).addThis()");
                    for (String name : this.names) {
                        buf.append(".nearBy('").append(name).append("')");
                    }
                    buf.append(".toString()");
                }
                this.checkUrl = buf.toString();
            }
            return "'" + Functions.jsStringEscape(Descriptor.getCurrentDescriptorByNameUrl()) + "/'+" + this.checkUrl;
        }

        public String toStemUrl() {
            if (this.names == null) {
                return null;
            }
            return Descriptor.getCurrentDescriptorByNameUrl() + "/" + this.relativePath();
        }

        public String getDependsOn() {
            if (this.names == null) {
                return null;
            }
            if (this.dependsOn == null) {
                this.dependsOn = String.join((CharSequence)" ", this.names);
            }
            return this.dependsOn;
        }

        private String relativePath() {
            return this.descriptor.getDescriptorUrl() + "/check" + this.capitalizedFieldName;
        }
    }

    public static abstract class URLCheck {
        protected BufferedReader open(URL url) throws IOException {
            URLConnection con = ProxyConfiguration.open(url);
            if (con == null) {
                throw new IOException(url.toExternalForm());
            }
            return new BufferedReader(new InputStreamReader(con.getInputStream(), this.getCharset(con)));
        }

        protected boolean findText(BufferedReader in, String literal) throws IOException {
            String line;
            while ((line = in.readLine()) != null) {
                if (!line.contains(literal)) continue;
                return true;
            }
            return false;
        }

        protected FormValidation handleIOException(String url, IOException e) throws IOException, ServletException {
            if (e.getMessage().equals(url)) {
                return FormValidation.error("Unable to connect " + url);
            }
            return FormValidation.error(e.getMessage());
        }

        private String getCharset(URLConnection con) {
            for (String t : con.getContentType().split(";")) {
                if (!(t = t.trim().toLowerCase(Locale.ENGLISH)).startsWith("charset=")) continue;
                return t.substring(8);
            }
            return "UTF-8";
        }

        protected abstract FormValidation check() throws IOException, ServletException;
    }

    public static abstract class FileValidator {
        public static final FileValidator NOOP = new FileValidator(){

            @Override
            public FormValidation validate(File f) {
                return FormValidation.ok();
            }
        };

        public abstract FormValidation validate(File var1);
    }

    public static enum Kind {
        OK,
        WARNING,
        ERROR;

    }
}

