/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import hudson.Util;
import hudson.util.IOUtils;
import hudson.util.io.Archiver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.zip.Zip64Mode;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

final class ZipArchiver
extends Archiver {
    private final byte[] buf = new byte[8192];
    private final ZipOutputStream zip;
    private final OpenOption[] openOptions;
    private final String prefix;
    private static final long BITMASK_IS_DIRECTORY = 16L;

    ZipArchiver(OutputStream out) {
        this(out, false, "");
    }

    @Restricted(value={NoExternalUse.class})
    ZipArchiver(OutputStream out, boolean failOnSymLink, String prefix) {
        OpenOption[] openOptionArray;
        this.prefix = StringUtils.isBlank((String)prefix) ? "" : Util.ensureEndsWith(prefix, "/");
        this.zip = new ZipOutputStream(out);
        if (failOnSymLink) {
            LinkOption[] linkOptionArray = new LinkOption[1];
            openOptionArray = linkOptionArray;
            linkOptionArray[0] = LinkOption.NOFOLLOW_LINKS;
        } else {
            openOptionArray = new OpenOption[]{};
        }
        this.openOptions = openOptionArray;
        this.zip.setEncoding(System.getProperty("file.encoding"));
        this.zip.setUseZip64(Zip64Mode.AsNeeded);
    }

    @Override
    public void visit(File f, String _relativePath) throws IOException {
        int mode = IOUtils.mode(f);
        String relativePath = _relativePath.replace('\\', '/');
        if (f.isDirectory()) {
            ZipEntry dirZipEntry = new ZipEntry(this.prefix + relativePath + "/");
            dirZipEntry.setExternalAttributes(16L);
            if (mode != -1) {
                dirZipEntry.setUnixMode(mode);
            }
            dirZipEntry.setTime(f.lastModified());
            this.zip.putNextEntry(dirZipEntry);
            this.zip.closeEntry();
        } else {
            ZipEntry fileZipEntry = new ZipEntry(this.prefix + relativePath);
            if (mode != -1) {
                fileZipEntry.setUnixMode(mode);
            }
            fileZipEntry.setTime(f.lastModified());
            fileZipEntry.setSize(f.length());
            this.zip.putNextEntry(fileZipEntry);
            try (InputStream in = Files.newInputStream(f.toPath(), this.openOptions);){
                int len;
                while ((len = in.read(this.buf)) >= 0) {
                    this.zip.write(this.buf, 0, len);
                }
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            this.zip.closeEntry();
        }
        ++this.entriesWritten;
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }
}

