// CHECKSTYLE:OFF

package jenkins.model;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Hudson.ViewAlreadyExists}: {@code A view already exists
     * with the name "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A view already exists with the name "{0}"}
     */
    public static String Hudson_ViewAlreadyExists(Object arg0) {
        return holder.format("Hudson.ViewAlreadyExists", arg0);
    }

    /**
     * Key {@code Hudson.ViewAlreadyExists}: {@code A view already exists
     * with the name "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A view already exists with the name "{0}"}
     */
    public static Localizable _Hudson_ViewAlreadyExists(Object arg0) {
        return new Localizable(holder, "Hudson.ViewAlreadyExists", arg0);
    }

    /**
     * Key {@code BuiltInNodeMigration.DisplayName}: {@code Built-In Node
     * Name and Label Migration}.
     * 
     * @return
     *     {@code Built-In Node Name and Label Migration}
     */
    public static String BuiltInNodeMigration_DisplayName() {
        return holder.format("BuiltInNodeMigration.DisplayName");
    }

    /**
     * Key {@code BuiltInNodeMigration.DisplayName}: {@code Built-In Node
     * Name and Label Migration}.
     * 
     * @return
     *     {@code Built-In Node Name and Label Migration}
     */
    public static Localizable _BuiltInNodeMigration_DisplayName() {
        return new Localizable(holder, "BuiltInNodeMigration.DisplayName");
    }

    /**
     * Key {@code Hudson.NodeDescription}: {@code the Jenkins controller''s
     * built-in node}.
     * 
     * @return
     *     {@code the Jenkins controller''s built-in node}
     */
    public static String Hudson_NodeDescription() {
        return holder.format("Hudson.NodeDescription");
    }

    /**
     * Key {@code Hudson.NodeDescription}: {@code the Jenkins controller''s
     * built-in node}.
     * 
     * @return
     *     {@code the Jenkins controller''s built-in node}
     */
    public static Localizable _Hudson_NodeDescription() {
        return new Localizable(holder, "Hudson.NodeDescription");
    }

    /**
     * Key {@code IdStrategy.CaseSensitiveEmailAddress.DisplayName}: {@code
     * Case sensitive (email address)}.
     * 
     * @return
     *     {@code Case sensitive (email address)}
     */
    public static String IdStrategy_CaseSensitiveEmailAddress_DisplayName() {
        return holder.format("IdStrategy.CaseSensitiveEmailAddress.DisplayName");
    }

    /**
     * Key {@code IdStrategy.CaseSensitiveEmailAddress.DisplayName}: {@code
     * Case sensitive (email address)}.
     * 
     * @return
     *     {@code Case sensitive (email address)}
     */
    public static Localizable _IdStrategy_CaseSensitiveEmailAddress_DisplayName() {
        return new Localizable(holder, "IdStrategy.CaseSensitiveEmailAddress.DisplayName");
    }

    /**
     * Key {@code CLI.disable-job.shortDescription}: {@code Disables a job.}.
     * 
     * @return
     *     {@code Disables a job.}
     */
    public static String CLI_disable_job_shortDescription() {
        return holder.format("CLI.disable-job.shortDescription");
    }

    /**
     * Key {@code CLI.disable-job.shortDescription}: {@code Disables a job.}.
     * 
     * @return
     *     {@code Disables a job.}
     */
    public static Localizable _CLI_disable_job_shortDescription() {
        return new Localizable(holder, "CLI.disable-job.shortDescription");
    }

    /**
     * Key {@code Hudson.Computer.Caption}: {@code Built-in Node}.
     * 
     * @return
     *     {@code Built-in Node}
     */
    public static String Hudson_Computer_Caption() {
        return holder.format("Hudson.Computer.Caption");
    }

    /**
     * Key {@code Hudson.Computer.Caption}: {@code Built-in Node}.
     * 
     * @return
     *     {@code Built-in Node}
     */
    public static Localizable _Hudson_Computer_Caption() {
        return new Localizable(holder, "Hudson.Computer.Caption");
    }

    /**
     * Key {@code PatternProjectNamingStrategy.NamePatternInvalidSyntax}:
     * {@code regular expression''s syntax is invalid.}.
     * 
     * @return
     *     {@code regular expression''s syntax is invalid.}
     */
    public static String PatternProjectNamingStrategy_NamePatternInvalidSyntax() {
        return holder.format("PatternProjectNamingStrategy.NamePatternInvalidSyntax");
    }

    /**
     * Key {@code PatternProjectNamingStrategy.NamePatternInvalidSyntax}:
     * {@code regular expression''s syntax is invalid.}.
     * 
     * @return
     *     {@code regular expression''s syntax is invalid.}
     */
    public static Localizable _PatternProjectNamingStrategy_NamePatternInvalidSyntax() {
        return new Localizable(holder, "PatternProjectNamingStrategy.NamePatternInvalidSyntax");
    }

    /**
     * Key {@code DefaultProjectNamingStrategy.DisplayName}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static String DefaultProjectNamingStrategy_DisplayName() {
        return holder.format("DefaultProjectNamingStrategy.DisplayName");
    }

    /**
     * Key {@code DefaultProjectNamingStrategy.DisplayName}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static Localizable _DefaultProjectNamingStrategy_DisplayName() {
        return new Localizable(holder, "DefaultProjectNamingStrategy.DisplayName");
    }

    /**
     * Key {@code Hudson.ControlCodeNotAllowed}: {@code No control code is
     * allowed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No control code is allowed: {0}}
     */
    public static String Hudson_ControlCodeNotAllowed(Object arg0) {
        return holder.format("Hudson.ControlCodeNotAllowed", arg0);
    }

    /**
     * Key {@code Hudson.ControlCodeNotAllowed}: {@code No control code is
     * allowed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No control code is allowed: {0}}
     */
    public static Localizable _Hudson_ControlCodeNotAllowed(Object arg0) {
        return new Localizable(holder, "Hudson.ControlCodeNotAllowed", arg0);
    }

    /**
     * Key {@code
     * JenkinsLocationConfiguration.does_not_look_like_an_email_address}:
     * {@code Does not look like an email address}.
     * 
     * @return
     *     {@code Does not look like an email address}
     */
    public static String JenkinsLocationConfiguration_does_not_look_like_an_email_address() {
        return holder.format("JenkinsLocationConfiguration.does_not_look_like_an_email_address");
    }

    /**
     * Key {@code
     * JenkinsLocationConfiguration.does_not_look_like_an_email_address}:
     * {@code Does not look like an email address}.
     * 
     * @return
     *     {@code Does not look like an email address}
     */
    public static Localizable _JenkinsLocationConfiguration_does_not_look_like_an_email_address() {
        return new Localizable(holder, "JenkinsLocationConfiguration.does_not_look_like_an_email_address");
    }

    /**
     * Key {@code IdStrategy.CaseInsensitive.DisplayName}: {@code Case
     * insensitive}.
     * 
     * @return
     *     {@code Case insensitive}
     */
    public static String IdStrategy_CaseInsensitive_DisplayName() {
        return holder.format("IdStrategy.CaseInsensitive.DisplayName");
    }

    /**
     * Key {@code IdStrategy.CaseInsensitive.DisplayName}: {@code Case
     * insensitive}.
     * 
     * @return
     *     {@code Case insensitive}
     */
    public static Localizable _IdStrategy_CaseInsensitive_DisplayName() {
        return new Localizable(holder, "IdStrategy.CaseInsensitive.DisplayName");
    }

    /**
     * Key {@code Hudson.ViewName}: {@code All}.
     * 
     * @return
     *     {@code All}
     */
    public static String Hudson_ViewName() {
        return holder.format("Hudson.ViewName");
    }

    /**
     * Key {@code Hudson.ViewName}: {@code All}.
     * 
     * @return
     *     {@code All}
     */
    public static Localizable _Hudson_ViewName() {
        return new Localizable(holder, "Hudson.ViewName");
    }

    /**
     * Key {@code Hudson.NoJavaInPath}: {@code java is not in your PATH.
     * Maybe you need to <a href="{0}/configure">configure JDKs</a>?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code java is not in your PATH. Maybe you need to <a
     *     href="{0}/configure">configure JDKs</a>?}
     */
    public static String Hudson_NoJavaInPath(Object arg0) {
        return holder.format("Hudson.NoJavaInPath", arg0);
    }

    /**
     * Key {@code Hudson.NoJavaInPath}: {@code java is not in your PATH.
     * Maybe you need to <a href="{0}/configure">configure JDKs</a>?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code java is not in your PATH. Maybe you need to <a
     *     href="{0}/configure">configure JDKs</a>?}
     */
    public static Localizable _Hudson_NoJavaInPath(Object arg0) {
        return new Localizable(holder, "Hudson.NoJavaInPath", arg0);
    }

    /**
     * Key {@code CLI.shutdown.shortDescription}: {@code Immediately shuts
     * down Jenkins server.}.
     * 
     * @return
     *     {@code Immediately shuts down Jenkins server.}
     */
    public static String CLI_shutdown_shortDescription() {
        return holder.format("CLI.shutdown.shortDescription");
    }

    /**
     * Key {@code CLI.shutdown.shortDescription}: {@code Immediately shuts
     * down Jenkins server.}.
     * 
     * @return
     *     {@code Immediately shuts down Jenkins server.}
     */
    public static Localizable _CLI_shutdown_shortDescription() {
        return new Localizable(holder, "CLI.shutdown.shortDescription");
    }

    /**
     * Key {@code ParameterizedJobMixIn.build_with_parameters}: {@code Build
     * with Parameters}.
     * 
     * @return
     *     {@code Build with Parameters}
     */
    public static String ParameterizedJobMixIn_build_with_parameters() {
        return holder.format("ParameterizedJobMixIn.build_with_parameters");
    }

    /**
     * Key {@code ParameterizedJobMixIn.build_with_parameters}: {@code Build
     * with Parameters}.
     * 
     * @return
     *     {@code Build with Parameters}
     */
    public static Localizable _ParameterizedJobMixIn_build_with_parameters() {
        return new Localizable(holder, "ParameterizedJobMixIn.build_with_parameters");
    }

    /**
     * Key {@code GlobalCloudConfiguration.DisplayName}: {@code Clouds}.
     * 
     * @return
     *     {@code Clouds}
     */
    public static String GlobalCloudConfiguration_DisplayName() {
        return holder.format("GlobalCloudConfiguration.DisplayName");
    }

    /**
     * Key {@code GlobalCloudConfiguration.DisplayName}: {@code Clouds}.
     * 
     * @return
     *     {@code Clouds}
     */
    public static Localizable _GlobalCloudConfiguration_DisplayName() {
        return new Localizable(holder, "GlobalCloudConfiguration.DisplayName");
    }

    /**
     * Key {@code ParameterizedJobMixIn.build_now}: {@code Build Now}.
     * 
     * @return
     *     {@code Build Now}
     */
    public static String ParameterizedJobMixIn_build_now() {
        return holder.format("ParameterizedJobMixIn.build_now");
    }

    /**
     * Key {@code ParameterizedJobMixIn.build_now}: {@code Build Now}.
     * 
     * @return
     *     {@code Build Now}
     */
    public static Localizable _ParameterizedJobMixIn_build_now() {
        return new Localizable(holder, "ParameterizedJobMixIn.build_now");
    }

    /**
     * Key {@code Hudson.DisplayName}: {@code Jenkins}.
     * 
     * @return
     *     {@code Jenkins}
     */
    public static String Hudson_DisplayName() {
        return holder.format("Hudson.DisplayName");
    }

    /**
     * Key {@code Hudson.DisplayName}: {@code Jenkins}.
     * 
     * @return
     *     {@code Jenkins}
     */
    public static Localizable _Hudson_DisplayName() {
        return new Localizable(holder, "Hudson.DisplayName");
    }

    /**
     * Key {@code JobGlobalBuildDiscarderStrategy.displayName}: {@code
     * Project Build Discarder}.
     * 
     * @return
     *     {@code Project Build Discarder}
     */
    public static String JobGlobalBuildDiscarderStrategy_displayName() {
        return holder.format("JobGlobalBuildDiscarderStrategy.displayName");
    }

    /**
     * Key {@code JobGlobalBuildDiscarderStrategy.displayName}: {@code
     * Project Build Discarder}.
     * 
     * @return
     *     {@code Project Build Discarder}
     */
    public static Localizable _JobGlobalBuildDiscarderStrategy_displayName() {
        return new Localizable(holder, "JobGlobalBuildDiscarderStrategy.displayName");
    }

    /**
     * Key {@code Mailer.Localhost.Error}: {@code Please set a valid host
     * name, instead of localhost}.
     * 
     * @return
     *     {@code Please set a valid host name, instead of localhost}
     */
    public static String Mailer_Localhost_Error() {
        return holder.format("Mailer.Localhost.Error");
    }

    /**
     * Key {@code Mailer.Localhost.Error}: {@code Please set a valid host
     * name, instead of localhost}.
     * 
     * @return
     *     {@code Please set a valid host name, instead of localhost}
     */
    public static Localizable _Mailer_Localhost_Error() {
        return new Localizable(holder, "Mailer.Localhost.Error");
    }

    /**
     * Key {@code Hudson.Computer.IncorrectNumberOfExecutors}: {@code
     * Incorrect field "Number of executors". It should be a non-negative
     * number.}.
     * 
     * @return
     *     {@code Incorrect field "Number of executors". It should be a
     *     non-negative number.}
     */
    public static String Hudson_Computer_IncorrectNumberOfExecutors() {
        return holder.format("Hudson.Computer.IncorrectNumberOfExecutors");
    }

    /**
     * Key {@code Hudson.Computer.IncorrectNumberOfExecutors}: {@code
     * Incorrect field "Number of executors". It should be a non-negative
     * number.}.
     * 
     * @return
     *     {@code Incorrect field "Number of executors". It should be a
     *     non-negative number.}
     */
    public static Localizable _Hudson_Computer_IncorrectNumberOfExecutors() {
        return new Localizable(holder, "Hudson.Computer.IncorrectNumberOfExecutors");
    }

    /**
     * Key {@code Hudson.UnsafeChar}: {@code â{0}â is an unsafe
     * character}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is an unsafe character}
     */
    public static String Hudson_UnsafeChar(Object arg0) {
        return holder.format("Hudson.UnsafeChar", arg0);
    }

    /**
     * Key {@code Hudson.UnsafeChar}: {@code â{0}â is an unsafe
     * character}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is an unsafe character}
     */
    public static Localizable _Hudson_UnsafeChar(Object arg0) {
        return new Localizable(holder, "Hudson.UnsafeChar", arg0);
    }

    /**
     * Key {@code CLI.safe-shutdown.shortDescription}: {@code Puts Jenkins
     * into the quiet mode, wait for existing builds to be completed, and
     * then shut down Jenkins.}.
     * 
     * @return
     *     {@code Puts Jenkins into the quiet mode, wait for existing builds to
     *     be completed, and then shut down Jenkins.}
     */
    public static String CLI_safe_shutdown_shortDescription() {
        return holder.format("CLI.safe-shutdown.shortDescription");
    }

    /**
     * Key {@code CLI.safe-shutdown.shortDescription}: {@code Puts Jenkins
     * into the quiet mode, wait for existing builds to be completed, and
     * then shut down Jenkins.}.
     * 
     * @return
     *     {@code Puts Jenkins into the quiet mode, wait for existing builds to
     *     be completed, and then shut down Jenkins.}
     */
    public static Localizable _CLI_safe_shutdown_shortDescription() {
        return new Localizable(holder, "CLI.safe-shutdown.shortDescription");
    }

    /**
     * Key {@code SimpleGlobalBuildDiscarderStrategy.displayName}: {@code
     * Specific Build Discarder}.
     * 
     * @return
     *     {@code Specific Build Discarder}
     */
    public static String SimpleGlobalBuildDiscarderStrategy_displayName() {
        return holder.format("SimpleGlobalBuildDiscarderStrategy.displayName");
    }

    /**
     * Key {@code SimpleGlobalBuildDiscarderStrategy.displayName}: {@code
     * Specific Build Discarder}.
     * 
     * @return
     *     {@code Specific Build Discarder}
     */
    public static Localizable _SimpleGlobalBuildDiscarderStrategy_displayName() {
        return new Localizable(holder, "SimpleGlobalBuildDiscarderStrategy.displayName");
    }

    /**
     * Key {@code BlockedBecauseOfBuildInProgress.ETA}: {@code  (ETA: {0})}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code  (ETA: {0})}
     */
    public static String BlockedBecauseOfBuildInProgress_ETA(Object arg0) {
        return holder.format("BlockedBecauseOfBuildInProgress.ETA", arg0);
    }

    /**
     * Key {@code BlockedBecauseOfBuildInProgress.ETA}: {@code  (ETA: {0})}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code  (ETA: {0})}
     */
    public static Localizable _BlockedBecauseOfBuildInProgress_ETA(Object arg0) {
        return new Localizable(holder, "BlockedBecauseOfBuildInProgress.ETA", arg0);
    }

    /**
     * Key {@code Hudson.NodeBeingRemoved}: {@code Node is being removed}.
     * 
     * @return
     *     {@code Node is being removed}
     */
    public static String Hudson_NodeBeingRemoved() {
        return holder.format("Hudson.NodeBeingRemoved");
    }

    /**
     * Key {@code Hudson.NodeBeingRemoved}: {@code Node is being removed}.
     * 
     * @return
     *     {@code Node is being removed}
     */
    public static Localizable _Hudson_NodeBeingRemoved() {
        return new Localizable(holder, "Hudson.NodeBeingRemoved");
    }

    /**
     * Key {@code CLI.safe-restart.shortDescription}: {@code Safely restart
     * Jenkins.}.
     * 
     * @return
     *     {@code Safely restart Jenkins.}
     */
    public static String CLI_safe_restart_shortDescription() {
        return holder.format("CLI.safe-restart.shortDescription");
    }

    /**
     * Key {@code CLI.safe-restart.shortDescription}: {@code Safely restart
     * Jenkins.}.
     * 
     * @return
     *     {@code Safely restart Jenkins.}
     */
    public static Localizable _CLI_safe_restart_shortDescription() {
        return new Localizable(holder, "CLI.safe-restart.shortDescription");
    }

    /**
     * Key {@code Hudson.JobNameConventionNotApplyed}: {@code â{0}â does
     * not match the job name convention pattern {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â does not match the job name convention pattern {1}}
     */
    public static String Hudson_JobNameConventionNotApplyed(Object arg0, Object arg1) {
        return holder.format("Hudson.JobNameConventionNotApplyed", arg0, arg1);
    }

    /**
     * Key {@code Hudson.JobNameConventionNotApplyed}: {@code â{0}â does
     * not match the job name convention pattern {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â does not match the job name convention pattern {1}}
     */
    public static Localizable _Hudson_JobNameConventionNotApplyed(Object arg0, Object arg1) {
        return new Localizable(holder, "Hudson.JobNameConventionNotApplyed", arg0, arg1);
    }

    /**
     * Key {@code CLI.restart.shortDescription}: {@code Restart Jenkins.}.
     * 
     * @return
     *     {@code Restart Jenkins.}
     */
    public static String CLI_restart_shortDescription() {
        return holder.format("CLI.restart.shortDescription");
    }

    /**
     * Key {@code CLI.restart.shortDescription}: {@code Restart Jenkins.}.
     * 
     * @return
     *     {@code Restart Jenkins.}
     */
    public static Localizable _CLI_restart_shortDescription() {
        return new Localizable(holder, "CLI.restart.shortDescription");
    }

    /**
     * Key {@code CLI.enable-job.shortDescription}: {@code Enables a job.}.
     * 
     * @return
     *     {@code Enables a job.}
     */
    public static String CLI_enable_job_shortDescription() {
        return holder.format("CLI.enable-job.shortDescription");
    }

    /**
     * Key {@code CLI.enable-job.shortDescription}: {@code Enables a job.}.
     * 
     * @return
     *     {@code Enables a job.}
     */
    public static Localizable _CLI_enable_job_shortDescription() {
        return new Localizable(holder, "CLI.enable-job.shortDescription");
    }

    /**
     * Key {@code Mailer.Address.Not.Configured}: {@code address not
     * configured yet <nobody@nowhere>}.
     * 
     * @return
     *     {@code address not configured yet <nobody@nowhere>}
     */
    public static String Mailer_Address_Not_Configured() {
        return holder.format("Mailer.Address.Not.Configured");
    }

    /**
     * Key {@code Mailer.Address.Not.Configured}: {@code address not
     * configured yet <nobody@nowhere>}.
     * 
     * @return
     *     {@code address not configured yet <nobody@nowhere>}
     */
    public static Localizable _Mailer_Address_Not_Configured() {
        return new Localizable(holder, "Mailer.Address.Not.Configured");
    }

    /**
     * Key {@code CauseOfInterruption.ShortDescription}: {@code Aborted by
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Aborted by {0}}
     */
    public static String CauseOfInterruption_ShortDescription(Object arg0) {
        return holder.format("CauseOfInterruption.ShortDescription", arg0);
    }

    /**
     * Key {@code CauseOfInterruption.ShortDescription}: {@code Aborted by
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Aborted by {0}}
     */
    public static Localizable _CauseOfInterruption_ShortDescription(Object arg0) {
        return new Localizable(holder, "CauseOfInterruption.ShortDescription", arg0);
    }

    /**
     * Key {@code Hudson.BadPortNumber}: {@code Bad port number {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Bad port number {0}}
     */
    public static String Hudson_BadPortNumber(Object arg0) {
        return holder.format("Hudson.BadPortNumber", arg0);
    }

    /**
     * Key {@code Hudson.BadPortNumber}: {@code Bad port number {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Bad port number {0}}
     */
    public static Localizable _Hudson_BadPortNumber(Object arg0) {
        return new Localizable(holder, "Hudson.BadPortNumber", arg0);
    }

    /**
     * Key {@code Hudson.NotUsesUTF8ToDecodeURL}: {@code Your container
     * doesnât use UTF-8 to decode URLs. If you use non-ASCII characters as
     * a job name etc, this will cause problems. See <a
     * href="https://www.jenkins.io/redirect/troubleshooting/utf8-url-decoding">Tomcat
     * i18n</a> for more details.}.
     * 
     * @return
     *     {@code Your container doesnât use UTF-8 to decode URLs. If you use
     *     non-ASCII characters as a job name etc, this will cause problems. See
     *     <a
     *     href="https://www.jenkins.io/redirect/troubleshooting/utf8-url-decoding">Tomcat
     *     i18n</a> for more details.}
     */
    public static String Hudson_NotUsesUTF8ToDecodeURL() {
        return holder.format("Hudson.NotUsesUTF8ToDecodeURL");
    }

    /**
     * Key {@code Hudson.NotUsesUTF8ToDecodeURL}: {@code Your container
     * doesnât use UTF-8 to decode URLs. If you use non-ASCII characters as
     * a job name etc, this will cause problems. See <a
     * href="https://www.jenkins.io/redirect/troubleshooting/utf8-url-decoding">Tomcat
     * i18n</a> for more details.}.
     * 
     * @return
     *     {@code Your container doesnât use UTF-8 to decode URLs. If you use
     *     non-ASCII characters as a job name etc, this will cause problems. See
     *     <a
     *     href="https://www.jenkins.io/redirect/troubleshooting/utf8-url-decoding">Tomcat
     *     i18n</a> for more details.}
     */
    public static Localizable _Hudson_NotUsesUTF8ToDecodeURL() {
        return new Localizable(holder, "Hudson.NotUsesUTF8ToDecodeURL");
    }

    /**
     * Key {@code BlockedBecauseOfBuildInProgress.shortDescription}: {@code
     * Build #{0} is already in progress{1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build #{0} is already in progress{1}}
     */
    public static String BlockedBecauseOfBuildInProgress_shortDescription(Object arg0, Object arg1) {
        return holder.format("BlockedBecauseOfBuildInProgress.shortDescription", arg0, arg1);
    }

    /**
     * Key {@code BlockedBecauseOfBuildInProgress.shortDescription}: {@code
     * Build #{0} is already in progress{1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build #{0} is already in progress{1}}
     */
    public static Localizable _BlockedBecauseOfBuildInProgress_shortDescription(Object arg0, Object arg1) {
        return new Localizable(holder, "BlockedBecauseOfBuildInProgress.shortDescription", arg0, arg1);
    }

    /**
     * Key {@code Hudson.Computer.DisplayName}: {@code Built-in}.
     * 
     * @return
     *     {@code Built-in}
     */
    public static String Hudson_Computer_DisplayName() {
        return holder.format("Hudson.Computer.DisplayName");
    }

    /**
     * Key {@code Hudson.Computer.DisplayName}: {@code Built-in}.
     * 
     * @return
     *     {@code Built-in}
     */
    public static Localizable _Hudson_Computer_DisplayName() {
        return new Localizable(holder, "Hudson.Computer.DisplayName");
    }

    /**
     * Key {@code EnforceSlaveAgentPortAdministrativeMonitor.displayName}:
     * {@code Enforce TCP Agent Port}.
     * 
     * @return
     *     {@code Enforce TCP Agent Port}
     */
    public static String EnforceSlaveAgentPortAdministrativeMonitor_displayName() {
        return holder.format("EnforceSlaveAgentPortAdministrativeMonitor.displayName");
    }

    /**
     * Key {@code EnforceSlaveAgentPortAdministrativeMonitor.displayName}:
     * {@code Enforce TCP Agent Port}.
     * 
     * @return
     *     {@code Enforce TCP Agent Port}
     */
    public static Localizable _EnforceSlaveAgentPortAdministrativeMonitor_displayName() {
        return new Localizable(holder, "EnforceSlaveAgentPortAdministrativeMonitor.displayName");
    }

    /**
     * Key {@code Mailer.NotHttp.Error}: {@code The URL is invalid, please
     * ensure you are using http:// or https:// with a valid domain.}.
     * 
     * @return
     *     {@code The URL is invalid, please ensure you are using http:// or
     *     https:// with a valid domain.}
     */
    public static String Mailer_NotHttp_Error() {
        return holder.format("Mailer.NotHttp.Error");
    }

    /**
     * Key {@code Mailer.NotHttp.Error}: {@code The URL is invalid, please
     * ensure you are using http:// or https:// with a valid domain.}.
     * 
     * @return
     *     {@code The URL is invalid, please ensure you are using http:// or
     *     https:// with a valid domain.}
     */
    public static Localizable _Mailer_NotHttp_Error() {
        return new Localizable(holder, "Mailer.NotHttp.Error");
    }

    /**
     * Key {@code IdStrategy.CaseSensitive.DisplayName}: {@code Case
     * sensitive}.
     * 
     * @return
     *     {@code Case sensitive}
     */
    public static String IdStrategy_CaseSensitive_DisplayName() {
        return holder.format("IdStrategy.CaseSensitive.DisplayName");
    }

    /**
     * Key {@code IdStrategy.CaseSensitive.DisplayName}: {@code Case
     * sensitive}.
     * 
     * @return
     *     {@code Case sensitive}
     */
    public static Localizable _IdStrategy_CaseSensitive_DisplayName() {
        return new Localizable(holder, "IdStrategy.CaseSensitive.DisplayName");
    }

    /**
     * Key {@code Hudson.NoName}: {@code No name is specified}.
     * 
     * @return
     *     {@code No name is specified}
     */
    public static String Hudson_NoName() {
        return holder.format("Hudson.NoName");
    }

    /**
     * Key {@code Hudson.NoName}: {@code No name is specified}.
     * 
     * @return
     *     {@code No name is specified}
     */
    public static Localizable _Hudson_NoName() {
        return new Localizable(holder, "Hudson.NoName");
    }

    /**
     * Key {@code PatternProjectNamingStrategy.DisplayName}: {@code Pattern}.
     * 
     * @return
     *     {@code Pattern}
     */
    public static String PatternProjectNamingStrategy_DisplayName() {
        return holder.format("PatternProjectNamingStrategy.DisplayName");
    }

    /**
     * Key {@code PatternProjectNamingStrategy.DisplayName}: {@code Pattern}.
     * 
     * @return
     *     {@code Pattern}
     */
    public static Localizable _PatternProjectNamingStrategy_DisplayName() {
        return new Localizable(holder, "PatternProjectNamingStrategy.DisplayName");
    }

    /**
     * Key {@code Hudson.JobAlreadyExists}: {@code A job already exists with
     * the name â{0}â}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A job already exists with the name â{0}â}
     */
    public static String Hudson_JobAlreadyExists(Object arg0) {
        return holder.format("Hudson.JobAlreadyExists", arg0);
    }

    /**
     * Key {@code Hudson.JobAlreadyExists}: {@code A job already exists with
     * the name â{0}â}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A job already exists with the name â{0}â}
     */
    public static Localizable _Hudson_JobAlreadyExists(Object arg0) {
        return new Localizable(holder, "Hudson.JobAlreadyExists", arg0);
    }

    /**
     * Key {@code CLI.keep-build.shortDescription}: {@code Mark the build to
     * keep the build forever.}.
     * 
     * @return
     *     {@code Mark the build to keep the build forever.}
     */
    public static String CLI_keep_build_shortDescription() {
        return holder.format("CLI.keep-build.shortDescription");
    }

    /**
     * Key {@code CLI.keep-build.shortDescription}: {@code Mark the build to
     * keep the build forever.}.
     * 
     * @return
     *     {@code Mark the build to keep the build forever.}
     */
    public static Localizable _CLI_keep_build_shortDescription() {
        return new Localizable(holder, "CLI.keep-build.shortDescription");
    }

    /**
     * Key {@code BuildDiscarderProperty.displayName}: {@code Discard old
     * builds}.
     * 
     * @return
     *     {@code Discard old builds}
     */
    public static String BuildDiscarderProperty_displayName() {
        return holder.format("BuildDiscarderProperty.displayName");
    }

    /**
     * Key {@code BuildDiscarderProperty.displayName}: {@code Discard old
     * builds}.
     * 
     * @return
     *     {@code Discard old builds}
     */
    public static Localizable _BuildDiscarderProperty_displayName() {
        return new Localizable(holder, "BuildDiscarderProperty.displayName");
    }

    /**
     * Key {@code PatternProjectNamingStrategy.NamePatternRequired}: {@code
     * Name Pattern is required}.
     * 
     * @return
     *     {@code Name Pattern is required}
     */
    public static String PatternProjectNamingStrategy_NamePatternRequired() {
        return holder.format("PatternProjectNamingStrategy.NamePatternRequired");
    }

    /**
     * Key {@code PatternProjectNamingStrategy.NamePatternRequired}: {@code
     * Name Pattern is required}.
     * 
     * @return
     *     {@code Name Pattern is required}
     */
    public static Localizable _PatternProjectNamingStrategy_NamePatternRequired() {
        return new Localizable(holder, "PatternProjectNamingStrategy.NamePatternRequired");
    }

}
