/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.console.HyperlinkNote;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.User;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;

public class ModelHyperlinkNote
extends HyperlinkNote {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ModelHyperlinkNote.class.getName());

    public ModelHyperlinkNote(String url, int length) {
        super(url, length);
    }

    @Override
    protected String extraAttributes() {
        return " class='jenkins-table__link model-link model-link--float'";
    }

    public static String encodeTo(@NonNull User u) {
        return ModelHyperlinkNote.encodeTo(u, u.getDisplayName());
    }

    public static String encodeTo(User u, String text) {
        return ModelHyperlinkNote.encodeTo("/" + u.getUrl(), text);
    }

    public static String encodeTo(Item item) {
        return ModelHyperlinkNote.encodeTo(item, item.getFullDisplayName());
    }

    public static String encodeTo(Item item, String text) {
        return ModelHyperlinkNote.encodeTo("/" + item.getUrl(), text);
    }

    public static String encodeTo(Run r) {
        return ModelHyperlinkNote.encodeTo("/" + r.getUrl(), r.getDisplayName());
    }

    public static String encodeTo(Node node) {
        Computer c = node.toComputer();
        if (c != null) {
            return ModelHyperlinkNote.encodeTo("/" + c.getUrl(), node.getDisplayName());
        }
        String nodePath = node == Jenkins.get() ? "(built-in)" : node.getNodeName();
        return ModelHyperlinkNote.encodeTo("/computer/" + nodePath, node.getDisplayName());
    }

    public static String encodeTo(Label label) {
        return ModelHyperlinkNote.encodeTo("/" + label.getUrl(), label.getName());
    }

    public static String encodeTo(String url, String text) {
        return HyperlinkNote.encodeTo(url, text, ModelHyperlinkNote::new);
    }

    @Extension
    @Symbol(value={"hyperlinkToModels"})
    public static class DescriptorImpl
    extends HyperlinkNote.DescriptorImpl {
        @Override
        @NonNull
        public String getDisplayName() {
            return "Hyperlinks to models";
        }
    }
}

