/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.FederatedLoginServiceUserProperty;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class FederatedLoginService
implements ExtensionPoint {
    @NonNull
    public abstract String getUrlName();

    @NonNull
    public abstract Class<? extends FederatedLoginServiceUserProperty> getUserPropertyClass();

    public static ExtensionList<FederatedLoginService> all() {
        return ExtensionList.lookup(FederatedLoginService.class);
    }

    public static class UnclaimedIdentityException
    extends RuntimeException
    implements HttpResponse {
        public final FederatedIdentity identity;

        public UnclaimedIdentityException(FederatedIdentity identity) {
            this.identity = identity;
        }

        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            SecurityRealm sr = Jenkins.get().getSecurityRealm();
            if (sr.allowsSignup()) {
                try {
                    sr.commenceSignup(this.identity).generateResponse(req, rsp, node);
                    return;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            req.getView((Object)this, "error").forward((ServletRequest)req, (ServletResponse)rsp);
        }
    }

    public abstract class FederatedIdentity
    implements Serializable {
        @NonNull
        public abstract String getIdentifier();

        @CheckForNull
        public abstract String getNickname();

        @CheckForNull
        public abstract String getFullName();

        @CheckForNull
        public abstract String getEmailAddress();

        public abstract String getPronoun();

        @CheckForNull
        public final User locateUser() {
            Class<? extends FederatedLoginServiceUserProperty> pt = FederatedLoginService.this.getUserPropertyClass();
            String id = this.getIdentifier();
            for (User u : User.getAll()) {
                if (!u.getProperty(pt).has(id)) continue;
                return u;
            }
            return null;
        }

        @NonNull
        public User signin() throws UnclaimedIdentityException {
            User u = this.locateUser();
            if (u != null) {
                UserDetails d = Jenkins.get().getSecurityRealm().loadUserByUsername2(u.getId());
                UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)d, (Object)"", d.getAuthorities());
                token.setDetails((Object)d);
                SecurityContextHolder.getContext().setAuthentication((Authentication)token);
                return u;
            }
            throw new UnclaimedIdentityException(this);
        }

        public void addToCurrentUser() throws IOException {
            User u = User.current();
            if (u == null) {
                throw new IllegalStateException("Current request is unauthenticated");
            }
            this.addTo(u);
        }

        public void addTo(User u) throws IOException {
            FederatedLoginServiceUserProperty p = u.getProperty(FederatedLoginService.this.getUserPropertyClass());
            if (p == null) {
                p = (FederatedLoginServiceUserProperty)UserProperty.all().find(FederatedLoginService.this.getUserPropertyClass()).newInstance(u);
                u.addProperty(p);
            }
            p.addIdentifier(this.getIdentifier());
        }

        public String toString() {
            return this.getIdentifier();
        }
    }
}

