/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.Messages;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import jenkins.model.identity.InstanceIdentityProvider;
import jenkins.slaves.RemotingWorkDirSettings;
import jenkins.util.SystemProperties;
import jenkins.websocket.WebSockets;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class JNLPLauncher
extends ComputerLauncher {
    @CheckForNull
    public final String tunnel;
    @Deprecated
    public final transient String vmargs;
    @NonNull
    private RemotingWorkDirSettings workDirSettings = RemotingWorkDirSettings.getEnabledDefaults();
    private boolean webSocket;
    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static final String CUSTOM_INBOUND_URL_PROPERTY = "jenkins.agent.inboundUrl";
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static Descriptor<ComputerLauncher> DESCRIPTOR;

    @Deprecated
    public JNLPLauncher(@CheckForNull String tunnel, @CheckForNull String vmargs, @CheckForNull RemotingWorkDirSettings workDirSettings) {
        this(tunnel, vmargs);
        if (workDirSettings != null) {
            this.setWorkDirSettings(workDirSettings);
        }
    }

    @DataBoundConstructor
    public JNLPLauncher(@CheckForNull String tunnel) {
        this.vmargs = null;
        this.tunnel = Util.fixEmptyAndTrim(tunnel);
    }

    @Deprecated
    public JNLPLauncher(@CheckForNull String tunnel, @CheckForNull String vmargs) {
        this.vmargs = null;
        this.tunnel = Util.fixEmptyAndTrim(tunnel);
    }

    @Deprecated
    public JNLPLauncher() {
        this(false);
    }

    public JNLPLauncher(boolean enableWorkDir) {
        this(null, null, enableWorkDir ? RemotingWorkDirSettings.getEnabledDefaults() : RemotingWorkDirSettings.getDisabledDefaults());
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="workDirSettings in readResolve is needed for data migration.")
    protected Object readResolve() {
        if (this.workDirSettings == null) {
            this.workDirSettings = RemotingWorkDirSettings.getDisabledDefaults();
        }
        return this;
    }

    @NonNull
    public RemotingWorkDirSettings getWorkDirSettings() {
        return this.workDirSettings;
    }

    @DataBoundSetter
    public final void setWorkDirSettings(@NonNull RemotingWorkDirSettings workDirSettings) {
        this.workDirSettings = workDirSettings;
    }

    @Override
    public boolean isLaunchSupported() {
        return false;
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    @DataBoundSetter
    public void setWebSocket(boolean webSocket) {
        this.webSocket = webSocket;
    }

    @Override
    public void launch(SlaveComputer computer, TaskListener listener) {
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public String getWorkDirOptions(@NonNull Computer computer) {
        if (!(computer instanceof SlaveComputer)) {
            return "";
        }
        return this.workDirSettings.toCommandLineString((SlaveComputer)computer);
    }

    @Restricted(value={NoExternalUse.class})
    public static String getInboundAgentUrl() {
        String url = SystemProperties.getString(CUSTOM_INBOUND_URL_PROPERTY);
        if (url == null || url.isEmpty()) {
            return Jenkins.get().getRootUrl();
        }
        return url;
    }

    @Extension
    @Symbol(value={"inbound", "jnlp"})
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="for backward compatibility")
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.JNLPLauncher_displayName();
        }

        public boolean isWorkDirSupported() {
            return DescriptorImpl.class.equals(this.getClass());
        }

        public FormValidation doCheckWebSocket(@QueryParameter boolean webSocket, @QueryParameter String tunnel) {
            if (webSocket) {
                if (!WebSockets.isSupported()) {
                    return FormValidation.error(Messages.JNLPLauncher_WebsocketNotEnabled());
                }
                if (Util.fixEmptyAndTrim(tunnel) != null) {
                    return FormValidation.error(Messages.JNLPLauncher_TunnelingNotSupported());
                }
            } else {
                if (Jenkins.get().getTcpSlaveAgentListener() == null) {
                    return FormValidation.error(Messages.JNLPLauncher_TCPPortDisabled());
                }
                if (InstanceIdentityProvider.RSA.getCertificate() == null || InstanceIdentityProvider.RSA.getPrivateKey() == null) {
                    return FormValidation.error(Messages.JNLPLauncher_InstanceIdentityRequired());
                }
            }
            return FormValidation.ok();
        }
    }
}

