/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.jna;

import hudson.util.jna.JnaException;
import hudson.util.jna.RegistryKey;
import java.net.UnknownHostException;
import org.jinterop.dcom.common.IJIAuthInfo;
import org.jinterop.dcom.common.JIException;
import org.jinterop.winreg.IJIWinReg;
import org.jinterop.winreg.JIPolicyHandle;
import org.jinterop.winreg.JIWinRegFactory;

public class DotNet {
    private static final String PATH20 = "SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v2.0.50727";
    private static final String PATH30 = "SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v3.0\\Setup";
    private static final String PATH35 = "SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v3.5";
    private static final String PATH4 = "SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v4\\Full";
    private static final String VALUE_INSTALL = "Install";
    private static final String VALUE_INSTALL_SUCCESS = "InstallSuccess";
    private static final String VALUE_RELEASE = "Release";

    public static boolean isInstalled(int major, int minor) {
        try {
            if (major == 4 && minor >= 5) {
                return DotNet.isV45PlusInstalled(minor);
            }
            if (major == 4 && minor == 0) {
                return DotNet.isV40Installed();
            }
            if (major == 3 && minor == 5) {
                return DotNet.isV35Installed();
            }
            if (major == 3 && minor == 0) {
                return DotNet.isV35Installed() || DotNet.isV30Installed();
            }
            if (major == 2 && minor == 0) {
                return DotNet.isV35Installed() || DotNet.isV30Installed() || DotNet.isV20Installed();
            }
            return false;
        }
        catch (JnaException e) {
            if (e.getErrorCode() == 2) {
                return false;
            }
            throw e;
        }
    }

    private static boolean isV45PlusInstalled(int minor) {
        try (RegistryKey key = RegistryKey.LOCAL_MACHINE.openReadonly(PATH4);){
            boolean bl = key.getIntValue(VALUE_RELEASE) >= DotNet.GetV45PlusMinRelease(minor);
            return bl;
        }
    }

    private static boolean isV40Installed() {
        try (RegistryKey key = RegistryKey.LOCAL_MACHINE.openReadonly(PATH4);){
            boolean bl = key.getIntValue(VALUE_INSTALL) == 1;
            return bl;
        }
    }

    private static boolean isV35Installed() {
        try (RegistryKey key = RegistryKey.LOCAL_MACHINE.openReadonly(PATH35);){
            boolean bl = key.getIntValue(VALUE_INSTALL) == 1;
            return bl;
        }
    }

    private static boolean isV30Installed() {
        try (RegistryKey key = RegistryKey.LOCAL_MACHINE.openReadonly(PATH30);){
            boolean bl = key.getIntValue(VALUE_INSTALL_SUCCESS) == 1;
            return bl;
        }
    }

    private static boolean isV20Installed() {
        try (RegistryKey key = RegistryKey.LOCAL_MACHINE.openReadonly(PATH20);){
            boolean bl = key.getIntValue(VALUE_INSTALL) == 1;
            return bl;
        }
    }

    public static boolean isInstalled(int major, int minor, String targetMachine, IJIAuthInfo session) throws JIException, UnknownHostException {
        IJIWinReg registry = JIWinRegFactory.getSingleTon().getWinreg(session, targetMachine, true);
        JIPolicyHandle hklm = null;
        try {
            hklm = registry.winreg_OpenHKLM();
            if (major == 4 && minor >= 5) {
                boolean bl = DotNet.isV45PlusInstalled(minor, registry, hklm);
                return bl;
            }
            if (major == 4 && minor == 0) {
                boolean bl = DotNet.isV40Installed(registry, hklm);
                return bl;
            }
            if (major == 3 && minor == 5) {
                boolean bl = DotNet.isV35Installed(registry, hklm);
                return bl;
            }
            if (major == 3 && minor == 0) {
                boolean bl = DotNet.isV35Installed(registry, hklm) || DotNet.isV30Installed(registry, hklm);
                return bl;
            }
            if (major == 2 && minor == 0) {
                boolean bl = DotNet.isV35Installed(registry, hklm) || DotNet.isV30Installed(registry, hklm) || DotNet.isV20Installed(registry, hklm);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (JIException e) {
            if (e.getErrorCode() == 2) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (hklm != null) {
                registry.winreg_CloseKey(hklm);
            }
            registry.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isV45PlusInstalled(int minor, IJIWinReg registry, JIPolicyHandle hklm) throws JIException {
        JIPolicyHandle key = null;
        try {
            key = registry.winreg_OpenKey(hklm, PATH4, 131097);
            boolean bl = DotNet.GetIntValue(registry, key, VALUE_RELEASE) >= DotNet.GetV45PlusMinRelease(minor);
            return bl;
        }
        finally {
            if (key != null) {
                registry.winreg_CloseKey(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isV40Installed(IJIWinReg registry, JIPolicyHandle hklm) throws JIException {
        JIPolicyHandle key = null;
        try {
            key = registry.winreg_OpenKey(hklm, PATH4, 131097);
            boolean bl = DotNet.GetIntValue(registry, key, VALUE_INSTALL) == 1;
            return bl;
        }
        finally {
            if (key != null) {
                registry.winreg_CloseKey(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isV35Installed(IJIWinReg registry, JIPolicyHandle hklm) throws JIException {
        JIPolicyHandle key = null;
        try {
            key = registry.winreg_OpenKey(hklm, PATH35, 131097);
            boolean bl = DotNet.GetIntValue(registry, key, VALUE_INSTALL) == 1;
            return bl;
        }
        finally {
            if (key != null) {
                registry.winreg_CloseKey(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isV30Installed(IJIWinReg registry, JIPolicyHandle hklm) throws JIException {
        JIPolicyHandle key = null;
        try {
            key = registry.winreg_OpenKey(hklm, PATH30, 131097);
            boolean bl = DotNet.GetIntValue(registry, key, VALUE_INSTALL_SUCCESS) == 1;
            return bl;
        }
        finally {
            if (key != null) {
                registry.winreg_CloseKey(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isV20Installed(IJIWinReg registry, JIPolicyHandle hklm) throws JIException {
        JIPolicyHandle key = null;
        try {
            key = registry.winreg_OpenKey(hklm, PATH20, 131097);
            boolean bl = DotNet.GetIntValue(registry, key, VALUE_INSTALL) == 1;
            return bl;
        }
        finally {
            if (key != null) {
                registry.winreg_CloseKey(key);
            }
        }
    }

    private static int GetIntValue(IJIWinReg registry, JIPolicyHandle key, String name) throws JIException {
        return RegistryKey.convertBufferToInt((byte[])registry.winreg_QueryValue(key, name, 4)[1]);
    }

    private static int GetV45PlusMinRelease(int minor) {
        switch (minor) {
            case 5: {
                return 378389;
            }
            case 6: {
                return 393295;
            }
            case 7: {
                return 460798;
            }
            case 8: {
                return 528040;
            }
        }
        return Integer.MAX_VALUE;
    }
}

