/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.Serializable;
import java.util.Map;
import jenkins.util.TreeStringBuilder;
import org.apache.commons.lang.StringUtils;

public final class TreeString
implements Serializable {
    private static final long serialVersionUID = 3621959682117480904L;
    private TreeString parent;
    private char[] label;

    TreeString() {
        this(null, "");
    }

    TreeString(TreeString parent, String label) {
        assert (parent == null || label.length() > 0);
        this.parent = parent;
        this.label = label.toCharArray();
    }

    String getLabel() {
        return new String(this.label);
    }

    TreeString split(String prefix) {
        assert (this.getLabel().startsWith(prefix));
        char[] suffix = new char[this.label.length - prefix.length()];
        System.arraycopy(this.label, prefix.length(), suffix, 0, suffix.length);
        TreeString middle = new TreeString(this.parent, prefix);
        this.label = suffix;
        this.parent = middle;
        return middle;
    }

    private int depth() {
        int i = 0;
        TreeString p = this;
        while (p != null) {
            ++i;
            p = p.parent;
        }
        return i;
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs.getClass() == TreeString.class && ((TreeString)rhs).getLabel().equals(this.getLabel());
    }

    public int hashCode() {
        int h = this.parent == null ? 0 : this.parent.hashCode();
        for (char c : this.label) {
            h = 31 * h + c;
        }
        assert (this.toString().hashCode() == h);
        return h;
    }

    public String toString() {
        char[][] tokens = new char[this.depth()][];
        int i = tokens.length;
        int sz = 0;
        TreeString p = this;
        while (p != null) {
            tokens[--i] = p.label;
            sz += p.label.length;
            p = p.parent;
        }
        StringBuilder buf = new StringBuilder(sz);
        for (char[] token : tokens) {
            buf.append(token);
        }
        return buf.toString();
    }

    void dedup(Map<String, char[]> table) {
        String l = this.getLabel();
        char[] v = table.get(l);
        if (v != null) {
            this.label = v;
        } else {
            table.put(l, this.label);
        }
    }

    public boolean isBlank() {
        return StringUtils.isBlank((String)this.toString());
    }

    public static String toString(TreeString t) {
        return t == null ? null : t.toString();
    }

    public static TreeString of(String s) {
        if (s == null) {
            return null;
        }
        return new TreeString(null, s);
    }

    public static final class ConverterImpl
    implements Converter {
        public ConverterImpl(XStream xs) {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            writer.setValue(source == null ? null : source.toString());
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            TreeStringBuilder builder = (TreeStringBuilder)context.get(TreeStringBuilder.class);
            if (builder == null) {
                builder = new TreeStringBuilder();
                context.put(TreeStringBuilder.class, (Object)builder);
                TreeStringBuilder _builder = builder;
                context.addCompletionCallback(_builder::dedup, 0);
            }
            return builder.intern(reader.getValue());
        }

        public boolean canConvert(Class type) {
            return type == TreeString.class;
        }
    }
}

