// CHECKSTYLE:OFF

package hudson.model;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code View.ConfigurePermission.Description}: {@code This
     * permission allows users to change the configuration of views.}.
     * 
     * @return
     *     {@code This permission allows users to change the configuration of
     *     views.}
     */
    public static String View_ConfigurePermission_Description() {
        return holder.format("View.ConfigurePermission.Description");
    }

    /**
     * Key {@code View.ConfigurePermission.Description}: {@code This
     * permission allows users to change the configuration of views.}.
     * 
     * @return
     *     {@code This permission allows users to change the configuration of
     *     views.}
     */
    public static Localizable _View_ConfigurePermission_Description() {
        return new Localizable(holder, "View.ConfigurePermission.Description");
    }

    /**
     * Key {@code Job.NOfMFailed}: {@code {0} out of the last {1} builds
     * failed.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} out of the last {1} builds failed.}
     */
    public static String Job_NOfMFailed(Object arg0, Object arg1) {
        return holder.format("Job.NOfMFailed", arg0, arg1);
    }

    /**
     * Key {@code Job.NOfMFailed}: {@code {0} out of the last {1} builds
     * failed.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} out of the last {1} builds failed.}
     */
    public static Localizable _Job_NOfMFailed(Object arg0, Object arg1) {
        return new Localizable(holder, "Job.NOfMFailed", arg0, arg1);
    }

    /**
     * Key {@code Permalink.LastBuild}: {@code Last build}.
     * 
     * @return
     *     {@code Last build}
     */
    public static String Permalink_LastBuild() {
        return holder.format("Permalink.LastBuild");
    }

    /**
     * Key {@code Permalink.LastBuild}: {@code Last build}.
     * 
     * @return
     *     {@code Last build}
     */
    public static Localizable _Permalink_LastBuild() {
        return new Localizable(holder, "Permalink.LastBuild");
    }

    /**
     * Key {@code ComputerSet.NoSuchSlave}: {@code No such agent: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such agent: {0}}
     */
    public static String ComputerSet_NoSuchSlave(Object arg0) {
        return holder.format("ComputerSet.NoSuchSlave", arg0);
    }

    /**
     * Key {@code ComputerSet.NoSuchSlave}: {@code No such agent: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such agent: {0}}
     */
    public static Localizable _ComputerSet_NoSuchSlave(Object arg0) {
        return new Localizable(holder, "ComputerSet.NoSuchSlave", arg0);
    }

    /**
     * Key {@code Hudson.RunScriptsPermission.Description}: {@code Deprecated
     * - please use the Overall/Administer permission instead}.
     * 
     * @return
     *     {@code Deprecated - please use the Overall/Administer permission
     *     instead}
     */
    public static String Hudson_RunScriptsPermission_Description() {
        return holder.format("Hudson.RunScriptsPermission.Description");
    }

    /**
     * Key {@code Hudson.RunScriptsPermission.Description}: {@code Deprecated
     * - please use the Overall/Administer permission instead}.
     * 
     * @return
     *     {@code Deprecated - please use the Overall/Administer permission
     *     instead}
     */
    public static Localizable _Hudson_RunScriptsPermission_Description() {
        return new Localizable(holder, "Hudson.RunScriptsPermission.Description");
    }

    /**
     * Key {@code Queue.AllNodesOffline}: {@code All nodes of label â{0}â
     * are offline}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code All nodes of label â{0}â are offline}
     */
    public static String Queue_AllNodesOffline(Object arg0) {
        return holder.format("Queue.AllNodesOffline", arg0);
    }

    /**
     * Key {@code Queue.AllNodesOffline}: {@code All nodes of label â{0}â
     * are offline}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code All nodes of label â{0}â are offline}
     */
    public static Localizable _Queue_AllNodesOffline(Object arg0) {
        return new Localizable(holder, "Queue.AllNodesOffline", arg0);
    }

    /**
     * Key {@code Cause.UpstreamCause.ShortDescription}: {@code Started by
     * upstream project "{0}" build number {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by upstream project "{0}" build number {1}}
     */
    public static String Cause_UpstreamCause_ShortDescription(Object arg0, Object arg1) {
        return holder.format("Cause.UpstreamCause.ShortDescription", arg0, arg1);
    }

    /**
     * Key {@code Cause.UpstreamCause.ShortDescription}: {@code Started by
     * upstream project "{0}" build number {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by upstream project "{0}" build number {1}}
     */
    public static Localizable _Cause_UpstreamCause_ShortDescription(Object arg0, Object arg1) {
        return new Localizable(holder, "Cause.UpstreamCause.ShortDescription", arg0, arg1);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.security}: {@code Security}.
     * 
     * @return
     *     {@code Security}
     */
    public static String UpdateCenter_PluginCategory_security() {
        return holder.format("UpdateCenter.PluginCategory.security");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.security}: {@code Security}.
     * 
     * @return
     *     {@code Security}
     */
    public static Localizable _UpdateCenter_PluginCategory_security() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.security");
    }

    /**
     * Key {@code Node.LabelMissing}: {@code â{0}â doesnât have label
     * â{1}â}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â doesnât have label â{1}â}
     */
    public static String Node_LabelMissing(Object arg0, Object arg1) {
        return holder.format("Node.LabelMissing", arg0, arg1);
    }

    /**
     * Key {@code Node.LabelMissing}: {@code â{0}â doesnât have label
     * â{1}â}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â doesnât have label â{1}â}
     */
    public static Localizable _Node_LabelMissing(Object arg0, Object arg1) {
        return new Localizable(holder, "Node.LabelMissing", arg0, arg1);
    }

    /**
     * Key {@code Jenkins.NotAllowedName}: {@code â{0}â is not an allowed
     * name}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is not an allowed name}
     */
    public static String Jenkins_NotAllowedName(Object arg0) {
        return holder.format("Jenkins.NotAllowedName", arg0);
    }

    /**
     * Key {@code Jenkins.NotAllowedName}: {@code â{0}â is not an allowed
     * name}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is not an allowed name}
     */
    public static Localizable _Jenkins_NotAllowedName(Object arg0) {
        return new Localizable(holder, "Jenkins.NotAllowedName", arg0);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.trigger}: {@code Build
     * Triggers}.
     * 
     * @return
     *     {@code Build Triggers}
     */
    public static String UpdateCenter_PluginCategory_trigger() {
        return holder.format("UpdateCenter.PluginCategory.trigger");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.trigger}: {@code Build
     * Triggers}.
     * 
     * @return
     *     {@code Build Triggers}
     */
    public static Localizable _UpdateCenter_PluginCategory_trigger() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.trigger");
    }

    /**
     * Key {@code JDK.DisplayName}: {@code JDK}.
     * 
     * @return
     *     {@code JDK}
     */
    public static String JDK_DisplayName() {
        return holder.format("JDK.DisplayName");
    }

    /**
     * Key {@code JDK.DisplayName}: {@code JDK}.
     * 
     * @return
     *     {@code JDK}
     */
    public static Localizable _JDK_DisplayName() {
        return new Localizable(holder, "JDK.DisplayName");
    }

    /**
     * Key {@code Computer.DisconnectPermission.Description}: {@code This
     * permission allows users to disconnect agents or mark agents as
     * temporarily offline.}.
     * 
     * @return
     *     {@code This permission allows users to disconnect agents or mark
     *     agents as temporarily offline.}
     */
    public static String Computer_DisconnectPermission_Description() {
        return holder.format("Computer.DisconnectPermission.Description");
    }

    /**
     * Key {@code Computer.DisconnectPermission.Description}: {@code This
     * permission allows users to disconnect agents or mark agents as
     * temporarily offline.}.
     * 
     * @return
     *     {@code This permission allows users to disconnect agents or mark
     *     agents as temporarily offline.}
     */
    public static Localizable _Computer_DisconnectPermission_Description() {
        return new Localizable(holder, "Computer.DisconnectPermission.Description");
    }

    /**
     * Key {@code Hudson.NotAPlugin}: {@code {0} is not a Jenkins plugin}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is not a Jenkins plugin}
     */
    public static String Hudson_NotAPlugin(Object arg0) {
        return holder.format("Hudson.NotAPlugin", arg0);
    }

    /**
     * Key {@code Hudson.NotAPlugin}: {@code {0} is not a Jenkins plugin}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is not a Jenkins plugin}
     */
    public static Localizable _Hudson_NotAPlugin(Object arg0) {
        return new Localizable(holder, "Hudson.NotAPlugin", arg0);
    }

    /**
     * Key {@code Run.Summary.NotBuilt}: {@code not built}.
     * 
     * @return
     *     {@code not built}
     */
    public static String Run_Summary_NotBuilt() {
        return holder.format("Run.Summary.NotBuilt");
    }

    /**
     * Key {@code Run.Summary.NotBuilt}: {@code not built}.
     * 
     * @return
     *     {@code not built}
     */
    public static Localizable _Run_Summary_NotBuilt() {
        return new Localizable(holder, "Run.Summary.NotBuilt");
    }

    /**
     * Key {@code Hudson.ViewName}: {@code All}.
     * 
     * @return
     *     {@code All}
     */
    public static String Hudson_ViewName() {
        return holder.format("Hudson.ViewName");
    }

    /**
     * Key {@code Hudson.ViewName}: {@code All}.
     * 
     * @return
     *     {@code All}
     */
    public static Localizable _Hudson_ViewName() {
        return new Localizable(holder, "Hudson.ViewName");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.listview-column}: {@code List
     * view columns}.
     * 
     * @return
     *     {@code List view columns}
     */
    public static String UpdateCenter_PluginCategory_listview_column() {
        return holder.format("UpdateCenter.PluginCategory.listview-column");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.listview-column}: {@code List
     * view columns}.
     * 
     * @return
     *     {@code List view columns}
     */
    public static Localizable _UpdateCenter_PluginCategory_listview_column() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.listview-column");
    }

    /**
     * Key {@code Permalink.LastStableBuild}: {@code Last stable build}.
     * 
     * @return
     *     {@code Last stable build}
     */
    public static String Permalink_LastStableBuild() {
        return holder.format("Permalink.LastStableBuild");
    }

    /**
     * Key {@code Permalink.LastStableBuild}: {@code Last stable build}.
     * 
     * @return
     *     {@code Last stable build}
     */
    public static Localizable _Permalink_LastStableBuild() {
        return new Localizable(holder, "Permalink.LastStableBuild");
    }

    /**
     * Key {@code Queue.WaitingForNextAvailableExecutor}: {@code Waiting for
     * next available executor}.
     * 
     * @return
     *     {@code Waiting for next available executor}
     */
    public static String Queue_WaitingForNextAvailableExecutor() {
        return holder.format("Queue.WaitingForNextAvailableExecutor");
    }

    /**
     * Key {@code Queue.WaitingForNextAvailableExecutor}: {@code Waiting for
     * next available executor}.
     * 
     * @return
     *     {@code Waiting for next available executor}
     */
    public static Localizable _Queue_WaitingForNextAvailableExecutor() {
        return new Localizable(holder, "Queue.WaitingForNextAvailableExecutor");
    }

    /**
     * Key {@code AbstractBuild.KeptBecause}: {@code This build is kept
     * because of {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code This build is kept because of {0}.}
     */
    public static String AbstractBuild_KeptBecause(Object arg0) {
        return holder.format("AbstractBuild.KeptBecause", arg0);
    }

    /**
     * Key {@code AbstractBuild.KeptBecause}: {@code This build is kept
     * because of {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code This build is kept because of {0}.}
     */
    public static Localizable _AbstractBuild_KeptBecause(Object arg0) {
        return new Localizable(holder, "AbstractBuild.KeptBecause", arg0);
    }

    /**
     * Key {@code Label.ProvisionedFrom}: {@code Provisioned from {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Provisioned from {0}}
     */
    public static String Label_ProvisionedFrom(Object arg0) {
        return holder.format("Label.ProvisionedFrom", arg0);
    }

    /**
     * Key {@code Label.ProvisionedFrom}: {@code Provisioned from {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Provisioned from {0}}
     */
    public static Localizable _Label_ProvisionedFrom(Object arg0) {
        return new Localizable(holder, "Label.ProvisionedFrom", arg0);
    }

    /**
     * Key {@code Hudson.DisplayName}: {@code Jenkins}.
     * 
     * @return
     *     {@code Jenkins}
     */
    public static String Hudson_DisplayName() {
        return holder.format("Hudson.DisplayName");
    }

    /**
     * Key {@code Hudson.DisplayName}: {@code Jenkins}.
     * 
     * @return
     *     {@code Jenkins}
     */
    public static Localizable _Hudson_DisplayName() {
        return new Localizable(holder, "Hudson.DisplayName");
    }

    /**
     * Key {@code AbstractItem.Pronoun}: {@code Item}.
     * 
     * @return
     *     {@code Item}
     */
    public static String AbstractItem_Pronoun() {
        return holder.format("AbstractItem.Pronoun");
    }

    /**
     * Key {@code AbstractItem.Pronoun}: {@code Item}.
     * 
     * @return
     *     {@code Item}
     */
    public static Localizable _AbstractItem_Pronoun() {
        return new Localizable(holder, "AbstractItem.Pronoun");
    }

    /**
     * Key {@code Item.DELETE.description}: {@code Delete a job.}.
     * 
     * @return
     *     {@code Delete a job.}
     */
    public static String Item_DELETE_description() {
        return holder.format("Item.DELETE.description");
    }

    /**
     * Key {@code Item.DELETE.description}: {@code Delete a job.}.
     * 
     * @return
     *     {@code Delete a job.}
     */
    public static Localizable _Item_DELETE_description() {
        return new Localizable(holder, "Item.DELETE.description");
    }

    /**
     * Key {@code Queue.NodeOffline}: {@code â{0}â is offline}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is offline}
     */
    public static String Queue_NodeOffline(Object arg0) {
        return holder.format("Queue.NodeOffline", arg0);
    }

    /**
     * Key {@code Queue.NodeOffline}: {@code â{0}â is offline}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is offline}
     */
    public static Localizable _Queue_NodeOffline(Object arg0) {
        return new Localizable(holder, "Queue.NodeOffline", arg0);
    }

    /**
     * Key {@code LoadStatistics.Legends.DefinedExecutors}: {@code Defined
     * executors}.
     * 
     * @return
     *     {@code Defined executors}
     */
    public static String LoadStatistics_Legends_DefinedExecutors() {
        return holder.format("LoadStatistics.Legends.DefinedExecutors");
    }

    /**
     * Key {@code LoadStatistics.Legends.DefinedExecutors}: {@code Defined
     * executors}.
     * 
     * @return
     *     {@code Defined executors}
     */
    public static Localizable _LoadStatistics_Legends_DefinedExecutors() {
        return new Localizable(holder, "LoadStatistics.Legends.DefinedExecutors");
    }

    /**
     * Key {@code Run.ArtifactsPermission.Description}: {@code This
     * permission grants the ability to retrieve the artifacts produced by
     * builds. If you donât want an user to access the artifacts, you can
     * do so by revoking this permission.}.
     * 
     * @return
     *     {@code This permission grants the ability to retrieve the artifacts
     *     produced by builds. If you donât want an user to access the
     *     artifacts, you can do so by revoking this permission.}
     */
    public static String Run_ArtifactsPermission_Description() {
        return holder.format("Run.ArtifactsPermission.Description");
    }

    /**
     * Key {@code Run.ArtifactsPermission.Description}: {@code This
     * permission grants the ability to retrieve the artifacts produced by
     * builds. If you donât want an user to access the artifacts, you can
     * do so by revoking this permission.}.
     * 
     * @return
     *     {@code This permission grants the ability to retrieve the artifacts
     *     produced by builds. If you donât want an user to access the
     *     artifacts, you can do so by revoking this permission.}
     */
    public static Localizable _Run_ArtifactsPermission_Description() {
        return new Localizable(holder, "Run.ArtifactsPermission.Description");
    }

    /**
     * Key {@code CLI.safe-restart.shortDescription}: {@code Safely restart
     * Jenkins}.
     * 
     * @return
     *     {@code Safely restart Jenkins}
     */
    public static String CLI_safe_restart_shortDescription() {
        return holder.format("CLI.safe-restart.shortDescription");
    }

    /**
     * Key {@code CLI.safe-restart.shortDescription}: {@code Safely restart
     * Jenkins}.
     * 
     * @return
     *     {@code Safely restart Jenkins}
     */
    public static Localizable _CLI_safe_restart_shortDescription() {
        return new Localizable(holder, "CLI.safe-restart.shortDescription");
    }

    /**
     * Key {@code CLI.restart.shortDescription}: {@code Restart Jenkins}.
     * 
     * @return
     *     {@code Restart Jenkins}
     */
    public static String CLI_restart_shortDescription() {
        return holder.format("CLI.restart.shortDescription");
    }

    /**
     * Key {@code CLI.restart.shortDescription}: {@code Restart Jenkins}.
     * 
     * @return
     *     {@code Restart Jenkins}
     */
    public static Localizable _CLI_restart_shortDescription() {
        return new Localizable(holder, "CLI.restart.shortDescription");
    }

    /**
     * Key {@code FreeStyleProject.DisplayName}: {@code Freestyle project}.
     * 
     * @return
     *     {@code Freestyle project}
     */
    public static String FreeStyleProject_DisplayName() {
        return holder.format("FreeStyleProject.DisplayName");
    }

    /**
     * Key {@code FreeStyleProject.DisplayName}: {@code Freestyle project}.
     * 
     * @return
     *     {@code Freestyle project}
     */
    public static Localizable _FreeStyleProject_DisplayName() {
        return new Localizable(holder, "FreeStyleProject.DisplayName");
    }

    /**
     * Key {@code Computer.NoSuchSlaveExists}: {@code No such agent "{0}"
     * exists. Did you mean "{1}"?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such agent "{0}" exists. Did you mean "{1}"?}
     */
    public static String Computer_NoSuchSlaveExists(Object arg0, Object arg1) {
        return holder.format("Computer.NoSuchSlaveExists", arg0, arg1);
    }

    /**
     * Key {@code Computer.NoSuchSlaveExists}: {@code No such agent "{0}"
     * exists. Did you mean "{1}"?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such agent "{0}" exists. Did you mean "{1}"?}
     */
    public static Localizable _Computer_NoSuchSlaveExists(Object arg0, Object arg1) {
        return new Localizable(holder, "Computer.NoSuchSlaveExists", arg0, arg1);
    }

    /**
     * Key {@code AbstractBuild.BuildingInWorkspace}: {@code  in workspace
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code  in workspace {0}}
     */
    public static String AbstractBuild_BuildingInWorkspace(Object arg0) {
        return holder.format("AbstractBuild.BuildingInWorkspace", arg0);
    }

    /**
     * Key {@code AbstractBuild.BuildingInWorkspace}: {@code  in workspace
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code  in workspace {0}}
     */
    public static Localizable _AbstractBuild_BuildingInWorkspace(Object arg0) {
        return new Localizable(holder, "AbstractBuild.BuildingInWorkspace", arg0);
    }

    /**
     * Key {@code FileParameterValue.IndexTitle}: {@code File Parameters}.
     * 
     * @return
     *     {@code File Parameters}
     */
    public static String FileParameterValue_IndexTitle() {
        return holder.format("FileParameterValue.IndexTitle");
    }

    /**
     * Key {@code FileParameterValue.IndexTitle}: {@code File Parameters}.
     * 
     * @return
     *     {@code File Parameters}
     */
    public static Localizable _FileParameterValue_IndexTitle() {
        return new Localizable(holder, "FileParameterValue.IndexTitle");
    }

    /**
     * Key {@code Queue.InProgress}: {@code A build is already in progress}.
     * 
     * @return
     *     {@code A build is already in progress}
     */
    public static String Queue_InProgress() {
        return holder.format("Queue.InProgress");
    }

    /**
     * Key {@code Queue.InProgress}: {@code A build is already in progress}.
     * 
     * @return
     *     {@code A build is already in progress}
     */
    public static Localizable _Queue_InProgress() {
        return new Localizable(holder, "Queue.InProgress");
    }

    /**
     * Key {@code Node.Mode.EXCLUSIVE}: {@code Only build jobs with label
     * expressions matching this node}.
     * 
     * @return
     *     {@code Only build jobs with label expressions matching this node}
     */
    public static String Node_Mode_EXCLUSIVE() {
        return holder.format("Node.Mode.EXCLUSIVE");
    }

    /**
     * Key {@code Node.Mode.EXCLUSIVE}: {@code Only build jobs with label
     * expressions matching this node}.
     * 
     * @return
     *     {@code Only build jobs with label expressions matching this node}
     */
    public static Localizable _Node_Mode_EXCLUSIVE() {
        return new Localizable(holder, "Node.Mode.EXCLUSIVE");
    }

    /**
     * Key {@code User.IllegalFullname}: {@code "{0}" is prohibited as a full
     * name for security reasons.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is prohibited as a full name for security reasons.}
     */
    public static String User_IllegalFullname(Object arg0) {
        return holder.format("User.IllegalFullname", arg0);
    }

    /**
     * Key {@code User.IllegalFullname}: {@code "{0}" is prohibited as a full
     * name for security reasons.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is prohibited as a full name for security reasons.}
     */
    public static Localizable _User_IllegalFullname(Object arg0) {
        return new Localizable(holder, "User.IllegalFullname", arg0);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.misc}: {@code Miscellaneous}.
     * 
     * @return
     *     {@code Miscellaneous}
     */
    public static String UpdateCenter_PluginCategory_misc() {
        return holder.format("UpdateCenter.PluginCategory.misc");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.misc}: {@code Miscellaneous}.
     * 
     * @return
     *     {@code Miscellaneous}
     */
    public static Localizable _UpdateCenter_PluginCategory_misc() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.misc");
    }

    /**
     * Key {@code Hudson.NotAPositiveNumber}: {@code Not a positive number}.
     * 
     * @return
     *     {@code Not a positive number}
     */
    public static String Hudson_NotAPositiveNumber() {
        return holder.format("Hudson.NotAPositiveNumber");
    }

    /**
     * Key {@code Hudson.NotAPositiveNumber}: {@code Not a positive number}.
     * 
     * @return
     *     {@code Not a positive number}
     */
    public static Localizable _Hudson_NotAPositiveNumber() {
        return new Localizable(holder, "Hudson.NotAPositiveNumber");
    }

    /**
     * Key {@code LoadStatistics.Legends.AvailableExecutors}: {@code
     * Available executors}.
     * 
     * @return
     *     {@code Available executors}
     */
    public static String LoadStatistics_Legends_AvailableExecutors() {
        return holder.format("LoadStatistics.Legends.AvailableExecutors");
    }

    /**
     * Key {@code LoadStatistics.Legends.AvailableExecutors}: {@code
     * Available executors}.
     * 
     * @return
     *     {@code Available executors}
     */
    public static Localizable _LoadStatistics_Legends_AvailableExecutors() {
        return new Localizable(holder, "LoadStatistics.Legends.AvailableExecutors");
    }

    /**
     * Key {@code Run.Summary.Stable}: {@code stable}.
     * 
     * @return
     *     {@code stable}
     */
    public static String Run_Summary_Stable() {
        return holder.format("Run.Summary.Stable");
    }

    /**
     * Key {@code Run.Summary.Stable}: {@code stable}.
     * 
     * @return
     *     {@code stable}
     */
    public static Localizable _Run_Summary_Stable() {
        return new Localizable(holder, "Run.Summary.Stable");
    }

    /**
     * Key {@code ProxyView.NoSuchViewExists}: {@code Global view {0} does
     * not exist}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Global view {0} does not exist}
     */
    public static String ProxyView_NoSuchViewExists(Object arg0) {
        return holder.format("ProxyView.NoSuchViewExists", arg0);
    }

    /**
     * Key {@code ProxyView.NoSuchViewExists}: {@code Global view {0} does
     * not exist}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Global view {0} does not exist}
     */
    public static Localizable _ProxyView_NoSuchViewExists(Object arg0) {
        return new Localizable(holder, "ProxyView.NoSuchViewExists", arg0);
    }

    /**
     * Key {@code Cause.RemoteCause.ShortDescriptionWithNote}: {@code Started
     * by remote host {0} with note: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by remote host {0} with note: {1}}
     */
    public static String Cause_RemoteCause_ShortDescriptionWithNote(Object arg0, Object arg1) {
        return holder.format("Cause.RemoteCause.ShortDescriptionWithNote", arg0, arg1);
    }

    /**
     * Key {@code Cause.RemoteCause.ShortDescriptionWithNote}: {@code Started
     * by remote host {0} with note: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by remote host {0} with note: {1}}
     */
    public static Localizable _Cause_RemoteCause_ShortDescriptionWithNote(Object arg0, Object arg1) {
        return new Localizable(holder, "Cause.RemoteCause.ShortDescriptionWithNote", arg0, arg1);
    }

    /**
     * Key {@code Hudson.ViewAlreadyExists}: {@code A view already exists
     * with the name "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A view already exists with the name "{0}"}
     */
    public static String Hudson_ViewAlreadyExists(Object arg0) {
        return holder.format("Hudson.ViewAlreadyExists", arg0);
    }

    /**
     * Key {@code Hudson.ViewAlreadyExists}: {@code A view already exists
     * with the name "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A view already exists with the name "{0}"}
     */
    public static Localizable _Hudson_ViewAlreadyExists(Object arg0) {
        return new Localizable(holder, "Hudson.ViewAlreadyExists", arg0);
    }

    /**
     * Key {@code BallColor.Pending}: {@code Pending}.
     * 
     * @return
     *     {@code Pending}
     */
    public static String BallColor_Pending() {
        return holder.format("BallColor.Pending");
    }

    /**
     * Key {@code BallColor.Pending}: {@code Pending}.
     * 
     * @return
     *     {@code Pending}
     */
    public static Localizable _BallColor_Pending() {
        return new Localizable(holder, "BallColor.Pending");
    }

    /**
     * Key {@code Queue.LabelHasNoNodes}: {@code There are no nodes with the
     * label â{0}â}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code There are no nodes with the label â{0}â}
     */
    public static String Queue_LabelHasNoNodes(Object arg0) {
        return holder.format("Queue.LabelHasNoNodes", arg0);
    }

    /**
     * Key {@code Queue.LabelHasNoNodes}: {@code There are no nodes with the
     * label â{0}â}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code There are no nodes with the label â{0}â}
     */
    public static Localizable _Queue_LabelHasNoNodes(Object arg0) {
        return new Localizable(holder, "Queue.LabelHasNoNodes", arg0);
    }

    /**
     * Key {@code UpdateCenter.CoreUpdateMonitor.DisplayName}: {@code Jenkins
     * Update Notification}.
     * 
     * @return
     *     {@code Jenkins Update Notification}
     */
    public static String UpdateCenter_CoreUpdateMonitor_DisplayName() {
        return holder.format("UpdateCenter.CoreUpdateMonitor.DisplayName");
    }

    /**
     * Key {@code UpdateCenter.CoreUpdateMonitor.DisplayName}: {@code Jenkins
     * Update Notification}.
     * 
     * @return
     *     {@code Jenkins Update Notification}
     */
    public static Localizable _UpdateCenter_CoreUpdateMonitor_DisplayName() {
        return new Localizable(holder, "UpdateCenter.CoreUpdateMonitor.DisplayName");
    }

    /**
     * Key {@code Run._is_waiting_for_a_checkpoint_on_}: {@code {0} is
     * waiting for a checkpoint on {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is waiting for a checkpoint on {1}}
     */
    public static String Run__is_waiting_for_a_checkpoint_on_(Object arg0, Object arg1) {
        return holder.format("Run._is_waiting_for_a_checkpoint_on_", arg0, arg1);
    }

    /**
     * Key {@code Run._is_waiting_for_a_checkpoint_on_}: {@code {0} is
     * waiting for a checkpoint on {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is waiting for a checkpoint on {1}}
     */
    public static Localizable _Run__is_waiting_for_a_checkpoint_on_(Object arg0, Object arg1) {
        return new Localizable(holder, "Run._is_waiting_for_a_checkpoint_on_", arg0, arg1);
    }

    /**
     * Key {@code Hudson.NodeDescription}: {@code the Jenkins controller''s
     * built-in node}.
     * 
     * @return
     *     {@code the Jenkins controller''s built-in node}
     */
    public static String Hudson_NodeDescription() {
        return holder.format("Hudson.NodeDescription");
    }

    /**
     * Key {@code Hudson.NodeDescription}: {@code the Jenkins controller''s
     * built-in node}.
     * 
     * @return
     *     {@code the Jenkins controller''s built-in node}
     */
    public static Localizable _Hudson_NodeDescription() {
        return new Localizable(holder, "Hudson.NodeDescription");
    }

    /**
     * Key {@code Computer.ExtendedReadPermission.Description}: {@code This
     * permission allows users to read agent configuration.}.
     * 
     * @return
     *     {@code This permission allows users to read agent configuration.}
     */
    public static String Computer_ExtendedReadPermission_Description() {
        return holder.format("Computer.ExtendedReadPermission.Description");
    }

    /**
     * Key {@code Computer.ExtendedReadPermission.Description}: {@code This
     * permission allows users to read agent configuration.}.
     * 
     * @return
     *     {@code This permission allows users to read agent configuration.}
     */
    public static Localizable _Computer_ExtendedReadPermission_Description() {
        return new Localizable(holder, "Computer.ExtendedReadPermission.Description");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.test}: {@code Testing}.
     * 
     * @return
     *     {@code Testing}
     */
    public static String UpdateCenter_PluginCategory_test() {
        return holder.format("UpdateCenter.PluginCategory.test");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.test}: {@code Testing}.
     * 
     * @return
     *     {@code Testing}
     */
    public static Localizable _UpdateCenter_PluginCategory_test() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.test");
    }

    /**
     * Key {@code MyViewsProperty.DisplayName}: {@code My Views}.
     * 
     * @return
     *     {@code My Views}
     */
    public static String MyViewsProperty_DisplayName() {
        return holder.format("MyViewsProperty.DisplayName");
    }

    /**
     * Key {@code MyViewsProperty.DisplayName}: {@code My Views}.
     * 
     * @return
     *     {@code My Views}
     */
    public static Localizable _MyViewsProperty_DisplayName() {
        return new Localizable(holder, "MyViewsProperty.DisplayName");
    }

    /**
     * Key {@code Run.Summary.Aborted}: {@code aborted}.
     * 
     * @return
     *     {@code aborted}
     */
    public static String Run_Summary_Aborted() {
        return holder.format("Run.Summary.Aborted");
    }

    /**
     * Key {@code Run.Summary.Aborted}: {@code aborted}.
     * 
     * @return
     *     {@code aborted}
     */
    public static Localizable _Run_Summary_Aborted() {
        return new Localizable(holder, "Run.Summary.Aborted");
    }

    /**
     * Key {@code PasswordParameterDefinition.DisplayName}: {@code Password
     * Parameter}.
     * 
     * @return
     *     {@code Password Parameter}
     */
    public static String PasswordParameterDefinition_DisplayName() {
        return holder.format("PasswordParameterDefinition.DisplayName");
    }

    /**
     * Key {@code PasswordParameterDefinition.DisplayName}: {@code Password
     * Parameter}.
     * 
     * @return
     *     {@code Password Parameter}
     */
    public static Localizable _PasswordParameterDefinition_DisplayName() {
        return new Localizable(holder, "PasswordParameterDefinition.DisplayName");
    }

    /**
     * Key {@code Run.running_as_SYSTEM}: {@code Running as SYSTEM}.
     * 
     * @return
     *     {@code Running as SYSTEM}
     */
    public static String Run_running_as_SYSTEM() {
        return holder.format("Run.running_as_SYSTEM");
    }

    /**
     * Key {@code Run.running_as_SYSTEM}: {@code Running as SYSTEM}.
     * 
     * @return
     *     {@code Running as SYSTEM}
     */
    public static Localizable _Run_running_as_SYSTEM() {
        return new Localizable(holder, "Run.running_as_SYSTEM");
    }

    /**
     * Key {@code BuildAuthorizationToken.InvalidTokenProvided}: {@code
     * Invalid token provided.}.
     * 
     * @return
     *     {@code Invalid token provided.}
     */
    public static String BuildAuthorizationToken_InvalidTokenProvided() {
        return holder.format("BuildAuthorizationToken.InvalidTokenProvided");
    }

    /**
     * Key {@code BuildAuthorizationToken.InvalidTokenProvided}: {@code
     * Invalid token provided.}.
     * 
     * @return
     *     {@code Invalid token provided.}
     */
    public static Localizable _BuildAuthorizationToken_InvalidTokenProvided() {
        return new Localizable(holder, "BuildAuthorizationToken.InvalidTokenProvided");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.devsecops}: {@code DevSecOps}.
     * 
     * @return
     *     {@code DevSecOps}
     */
    public static String UpdateCenter_PluginCategory_devsecops() {
        return holder.format("UpdateCenter.PluginCategory.devsecops");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.devsecops}: {@code DevSecOps}.
     * 
     * @return
     *     {@code DevSecOps}
     */
    public static Localizable _UpdateCenter_PluginCategory_devsecops() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.devsecops");
    }

    /**
     * Key {@code BooleanParameterDefinition.DisplayName}: {@code Boolean
     * Parameter}.
     * 
     * @return
     *     {@code Boolean Parameter}
     */
    public static String BooleanParameterDefinition_DisplayName() {
        return holder.format("BooleanParameterDefinition.DisplayName");
    }

    /**
     * Key {@code BooleanParameterDefinition.DisplayName}: {@code Boolean
     * Parameter}.
     * 
     * @return
     *     {@code Boolean Parameter}
     */
    public static Localizable _BooleanParameterDefinition_DisplayName() {
        return new Localizable(holder, "BooleanParameterDefinition.DisplayName");
    }

    /**
     * Key {@code Node.LackingBuildPermission}: {@code â{0}â lacks
     * permission to run on â{1}â}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â lacks permission to run on â{1}â}
     */
    public static String Node_LackingBuildPermission(Object arg0, Object arg1) {
        return holder.format("Node.LackingBuildPermission", arg0, arg1);
    }

    /**
     * Key {@code Node.LackingBuildPermission}: {@code â{0}â lacks
     * permission to run on â{1}â}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â lacks permission to run on â{1}â}
     */
    public static Localizable _Node_LackingBuildPermission(Object arg0, Object arg1) {
        return new Localizable(holder, "Node.LackingBuildPermission", arg0, arg1);
    }

    /**
     * Key {@code LabelExpression.LabelLink}: {@code <a href="{0}{2}">Label
     * {1}</a> matches {3,choice,0#no nodes|1#1 node|1<{3}
     * nodes}{4,choice,0#|1# and 1 cloud|1< and {4} clouds}. Permissions or
     * other restrictions provided by plugins may further reduce that list.}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, a number.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code <a href="{0}{2}">Label {1}</a> matches {3,choice,0#no nodes|1#1
     *     node|1<{3} nodes}{4,choice,0#|1# and 1 cloud|1< and {4} clouds}.
     *     Permissions or other restrictions provided by plugins may further
     *     reduce that list.}
     */
    public static String LabelExpression_LabelLink(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return holder.format("LabelExpression.LabelLink", arg0, arg1, arg2, arg3, arg4);
    }

    /**
     * Key {@code LabelExpression.LabelLink}: {@code <a href="{0}{2}">Label
     * {1}</a> matches {3,choice,0#no nodes|1#1 node|1<{3}
     * nodes}{4,choice,0#|1# and 1 cloud|1< and {4} clouds}. Permissions or
     * other restrictions provided by plugins may further reduce that list.}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, a number.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, a number.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code <a href="{0}{2}">Label {1}</a> matches {3,choice,0#no nodes|1#1
     *     node|1<{3} nodes}{4,choice,0#|1# and 1 cloud|1< and {4} clouds}.
     *     Permissions or other restrictions provided by plugins may further
     *     reduce that list.}
     */
    public static Localizable _LabelExpression_LabelLink(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return new Localizable(holder, "LabelExpression.LabelLink", arg0, arg1, arg2, arg3, arg4);
    }

    /**
     * Key {@code Run.NotStartedYet}: {@code Not started yet}.
     * 
     * @return
     *     {@code Not started yet}
     */
    public static String Run_NotStartedYet() {
        return holder.format("Run.NotStartedYet");
    }

    /**
     * Key {@code Run.NotStartedYet}: {@code Not started yet}.
     * 
     * @return
     *     {@code Not started yet}
     */
    public static Localizable _Run_NotStartedYet() {
        return new Localizable(holder, "Run.NotStartedYet");
    }

    /**
     * Key {@code LoadStatistics.Legends.TotalExecutors}: {@code Total
     * executors}.
     * 
     * @return
     *     {@code Total executors}
     */
    public static String LoadStatistics_Legends_TotalExecutors() {
        return holder.format("LoadStatistics.Legends.TotalExecutors");
    }

    /**
     * Key {@code LoadStatistics.Legends.TotalExecutors}: {@code Total
     * executors}.
     * 
     * @return
     *     {@code Total executors}
     */
    public static Localizable _LoadStatistics_Legends_TotalExecutors() {
        return new Localizable(holder, "LoadStatistics.Legends.TotalExecutors");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.post-build}: {@code Other
     * Post-Build Actions}.
     * 
     * @return
     *     {@code Other Post-Build Actions}
     */
    public static String UpdateCenter_PluginCategory_post_build() {
        return holder.format("UpdateCenter.PluginCategory.post-build");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.post-build}: {@code Other
     * Post-Build Actions}.
     * 
     * @return
     *     {@code Other Post-Build Actions}
     */
    public static Localizable _UpdateCenter_PluginCategory_post_build() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.post-build");
    }

    /**
     * Key {@code Executor.NotAvailable}: {@code N/A}.
     * 
     * @return
     *     {@code N/A}
     */
    public static String Executor_NotAvailable() {
        return holder.format("Executor.NotAvailable");
    }

    /**
     * Key {@code Executor.NotAvailable}: {@code N/A}.
     * 
     * @return
     *     {@code N/A}
     */
    public static Localizable _Executor_NotAvailable() {
        return new Localizable(holder, "Executor.NotAvailable");
    }

    /**
     * Key {@code AbstractItem.BeingDeleted}: {@code {0} is currently being
     * deleted}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is currently being deleted}
     */
    public static String AbstractItem_BeingDeleted(Object arg0) {
        return holder.format("AbstractItem.BeingDeleted", arg0);
    }

    /**
     * Key {@code AbstractItem.BeingDeleted}: {@code {0} is currently being
     * deleted}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is currently being deleted}
     */
    public static Localizable _AbstractItem_BeingDeleted(Object arg0) {
        return new Localizable(holder, "AbstractItem.BeingDeleted", arg0);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.page-decorator}: {@code Page
     * Decorators}.
     * 
     * @return
     *     {@code Page Decorators}
     */
    public static String UpdateCenter_PluginCategory_page_decorator() {
        return holder.format("UpdateCenter.PluginCategory.page-decorator");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.page-decorator}: {@code Page
     * Decorators}.
     * 
     * @return
     *     {@code Page Decorators}
     */
    public static Localizable _UpdateCenter_PluginCategory_page_decorator() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.page-decorator");
    }

    /**
     * Key {@code Run.UnableToDelete}: {@code Unable to delete {0}: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to delete {0}: {1}}
     */
    public static String Run_UnableToDelete(Object arg0, Object arg1) {
        return holder.format("Run.UnableToDelete", arg0, arg1);
    }

    /**
     * Key {@code Run.UnableToDelete}: {@code Unable to delete {0}: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to delete {0}: {1}}
     */
    public static Localizable _Run_UnableToDelete(Object arg0, Object arg1) {
        return new Localizable(holder, "Run.UnableToDelete", arg0, arg1);
    }

    /**
     * Key {@code ManageJenkinsAction.DisplayName}: {@code Manage Jenkins}.
     * 
     * @return
     *     {@code Manage Jenkins}
     */
    public static String ManageJenkinsAction_DisplayName() {
        return holder.format("ManageJenkinsAction.DisplayName");
    }

    /**
     * Key {@code ManageJenkinsAction.DisplayName}: {@code Manage Jenkins}.
     * 
     * @return
     *     {@code Manage Jenkins}
     */
    public static Localizable _ManageJenkinsAction_DisplayName() {
        return new Localizable(holder, "ManageJenkinsAction.DisplayName");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.buildwrapper}: {@code Build
     * Wrappers}.
     * 
     * @return
     *     {@code Build Wrappers}
     */
    public static String UpdateCenter_PluginCategory_buildwrapper() {
        return holder.format("UpdateCenter.PluginCategory.buildwrapper");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.buildwrapper}: {@code Build
     * Wrappers}.
     * 
     * @return
     *     {@code Build Wrappers}
     */
    public static Localizable _UpdateCenter_PluginCategory_buildwrapper() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.buildwrapper");
    }

    /**
     * Key {@code Hudson.UnsafeChar}: {@code â{0}â is an unsafe
     * character}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is an unsafe character}
     */
    public static String Hudson_UnsafeChar(Object arg0) {
        return holder.format("Hudson.UnsafeChar", arg0);
    }

    /**
     * Key {@code Hudson.UnsafeChar}: {@code â{0}â is an unsafe
     * character}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is an unsafe character}
     */
    public static Localizable _Hudson_UnsafeChar(Object arg0) {
        return new Localizable(holder, "Hudson.UnsafeChar", arg0);
    }

    /**
     * Key {@code Label.InvalidLabel}: {@code invalid label}.
     * 
     * @return
     *     {@code invalid label}
     */
    public static String Label_InvalidLabel() {
        return holder.format("Label.InvalidLabel");
    }

    /**
     * Key {@code Label.InvalidLabel}: {@code invalid label}.
     * 
     * @return
     *     {@code invalid label}
     */
    public static Localizable _Label_InvalidLabel() {
        return new Localizable(holder, "Label.InvalidLabel");
    }

    /**
     * Key {@code Run.BuildAborted}: {@code Build was aborted}.
     * 
     * @return
     *     {@code Build was aborted}
     */
    public static String Run_BuildAborted() {
        return holder.format("Run.BuildAborted");
    }

    /**
     * Key {@code Run.BuildAborted}: {@code Build was aborted}.
     * 
     * @return
     *     {@code Build was aborted}
     */
    public static Localizable _Run_BuildAborted() {
        return new Localizable(holder, "Run.BuildAborted");
    }

    /**
     * Key {@code Run.MarkedExplicitly}: {@code This record is explicitly
     * marked to be kept.}.
     * 
     * @return
     *     {@code This record is explicitly marked to be kept.}
     */
    public static String Run_MarkedExplicitly() {
        return holder.format("Run.MarkedExplicitly");
    }

    /**
     * Key {@code Run.MarkedExplicitly}: {@code This record is explicitly
     * marked to be kept.}.
     * 
     * @return
     *     {@code This record is explicitly marked to be kept.}
     */
    public static Localizable _Run_MarkedExplicitly() {
        return new Localizable(holder, "Run.MarkedExplicitly");
    }

    /**
     * Key {@code LabelExpression.InvalidBooleanExpression}: {@code Invalid
     * boolean expression: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid boolean expression: {0}}
     */
    public static String LabelExpression_InvalidBooleanExpression(Object arg0) {
        return holder.format("LabelExpression.InvalidBooleanExpression", arg0);
    }

    /**
     * Key {@code LabelExpression.InvalidBooleanExpression}: {@code Invalid
     * boolean expression: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid boolean expression: {0}}
     */
    public static Localizable _LabelExpression_InvalidBooleanExpression(Object arg0) {
        return new Localizable(holder, "LabelExpression.InvalidBooleanExpression", arg0);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.view}: {@code Views}.
     * 
     * @return
     *     {@code Views}
     */
    public static String UpdateCenter_PluginCategory_view() {
        return holder.format("UpdateCenter.PluginCategory.view");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.view}: {@code Views}.
     * 
     * @return
     *     {@code Views}
     */
    public static Localizable _UpdateCenter_PluginCategory_view() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.view");
    }

    /**
     * Key {@code Run.ArtifactsBrowserTitle}: {@code Artifacts of {0} {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Artifacts of {0} {1}}
     */
    public static String Run_ArtifactsBrowserTitle(Object arg0, Object arg1) {
        return holder.format("Run.ArtifactsBrowserTitle", arg0, arg1);
    }

    /**
     * Key {@code Run.ArtifactsBrowserTitle}: {@code Artifacts of {0} {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Artifacts of {0} {1}}
     */
    public static Localizable _Run_ArtifactsBrowserTitle(Object arg0, Object arg1) {
        return new Localizable(holder, "Run.ArtifactsBrowserTitle", arg0, arg1);
    }

    /**
     * Key {@code Cause.LegacyCodeCause.ShortDescription}: {@code Legacy code
     * started this job.  No cause information is available}.
     * 
     * @return
     *     {@code Legacy code started this job.  No cause information is
     *     available}
     */
    public static String Cause_LegacyCodeCause_ShortDescription() {
        return holder.format("Cause.LegacyCodeCause.ShortDescription");
    }

    /**
     * Key {@code Cause.LegacyCodeCause.ShortDescription}: {@code Legacy code
     * started this job.  No cause information is available}.
     * 
     * @return
     *     {@code Legacy code started this job.  No cause information is
     *     available}
     */
    public static Localizable _Cause_LegacyCodeCause_ShortDescription() {
        return new Localizable(holder, "Cause.LegacyCodeCause.ShortDescription");
    }

    /**
     * Key {@code ChoiceParameterDefinition.MissingChoices}: {@code Requires
     * Choices.}.
     * 
     * @return
     *     {@code Requires Choices.}
     */
    public static String ChoiceParameterDefinition_MissingChoices() {
        return holder.format("ChoiceParameterDefinition.MissingChoices");
    }

    /**
     * Key {@code ChoiceParameterDefinition.MissingChoices}: {@code Requires
     * Choices.}.
     * 
     * @return
     *     {@code Requires Choices.}
     */
    public static Localizable _ChoiceParameterDefinition_MissingChoices() {
        return new Localizable(holder, "ChoiceParameterDefinition.MissingChoices");
    }

    /**
     * Key {@code ResultTrend.Failure}: {@code Failure}.
     * 
     * @return
     *     {@code Failure}
     */
    public static String ResultTrend_Failure() {
        return holder.format("ResultTrend.Failure");
    }

    /**
     * Key {@code ResultTrend.Failure}: {@code Failure}.
     * 
     * @return
     *     {@code Failure}
     */
    public static Localizable _ResultTrend_Failure() {
        return new Localizable(holder, "ResultTrend.Failure");
    }

    /**
     * Key {@code Run.InProgressDuration}: {@code {0} and counting}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} and counting}
     */
    public static String Run_InProgressDuration(Object arg0) {
        return holder.format("Run.InProgressDuration", arg0);
    }

    /**
     * Key {@code Run.InProgressDuration}: {@code {0} and counting}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} and counting}
     */
    public static Localizable _Run_InProgressDuration(Object arg0) {
        return new Localizable(holder, "Run.InProgressDuration", arg0);
    }

    /**
     * Key {@code Queue.WaitingForNextAvailableExecutorOn}: {@code Waiting
     * for next available executor on â{0}â}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Waiting for next available executor on â{0}â}
     */
    public static String Queue_WaitingForNextAvailableExecutorOn(Object arg0) {
        return holder.format("Queue.WaitingForNextAvailableExecutorOn", arg0);
    }

    /**
     * Key {@code Queue.WaitingForNextAvailableExecutorOn}: {@code Waiting
     * for next available executor on â{0}â}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Waiting for next available executor on â{0}â}
     */
    public static Localizable _Queue_WaitingForNextAvailableExecutorOn(Object arg0) {
        return new Localizable(holder, "Queue.WaitingForNextAvailableExecutorOn", arg0);
    }

    /**
     * Key {@code LoadStatistics.Legends.OnlineExecutors}: {@code Online
     * executors}.
     * 
     * @return
     *     {@code Online executors}
     */
    public static String LoadStatistics_Legends_OnlineExecutors() {
        return holder.format("LoadStatistics.Legends.OnlineExecutors");
    }

    /**
     * Key {@code LoadStatistics.Legends.OnlineExecutors}: {@code Online
     * executors}.
     * 
     * @return
     *     {@code Online executors}
     */
    public static Localizable _LoadStatistics_Legends_OnlineExecutors() {
        return new Localizable(holder, "LoadStatistics.Legends.OnlineExecutors");
    }

    /**
     * Key {@code LoadStatistics.Legends.IdleExecutors}: {@code Idle
     * executors}.
     * 
     * @return
     *     {@code Idle executors}
     */
    public static String LoadStatistics_Legends_IdleExecutors() {
        return holder.format("LoadStatistics.Legends.IdleExecutors");
    }

    /**
     * Key {@code LoadStatistics.Legends.IdleExecutors}: {@code Idle
     * executors}.
     * 
     * @return
     *     {@code Idle executors}
     */
    public static Localizable _LoadStatistics_Legends_IdleExecutors() {
        return new Localizable(holder, "LoadStatistics.Legends.IdleExecutors");
    }

    /**
     * Key {@code AbstractItem.NoSuchJobExistsWithoutSuggestion}: {@code No
     * such job â{0}â exists.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such job â{0}â exists.}
     */
    public static String AbstractItem_NoSuchJobExistsWithoutSuggestion(Object arg0) {
        return holder.format("AbstractItem.NoSuchJobExistsWithoutSuggestion", arg0);
    }

    /**
     * Key {@code AbstractItem.NoSuchJobExistsWithoutSuggestion}: {@code No
     * such job â{0}â exists.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such job â{0}â exists.}
     */
    public static Localizable _AbstractItem_NoSuchJobExistsWithoutSuggestion(Object arg0) {
        return new Localizable(holder, "AbstractItem.NoSuchJobExistsWithoutSuggestion", arg0);
    }

    /**
     * Key {@code UpdateCenter.DownloadButNotActivated}: {@code Downloaded
     * Successfully. Will be activated during the next boot}.
     * 
     * @return
     *     {@code Downloaded Successfully. Will be activated during the next
     *     boot}
     */
    public static String UpdateCenter_DownloadButNotActivated() {
        return holder.format("UpdateCenter.DownloadButNotActivated");
    }

    /**
     * Key {@code UpdateCenter.DownloadButNotActivated}: {@code Downloaded
     * Successfully. Will be activated during the next boot}.
     * 
     * @return
     *     {@code Downloaded Successfully. Will be activated during the next
     *     boot}
     */
    public static Localizable _UpdateCenter_DownloadButNotActivated() {
        return new Localizable(holder, "UpdateCenter.DownloadButNotActivated");
    }

    /**
     * Key {@code MyViewsProperty.ViewExistsCheck.NotExist}: {@code A view
     * with name {0} does not exist}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A view with name {0} does not exist}
     */
    public static String MyViewsProperty_ViewExistsCheck_NotExist(Object arg0) {
        return holder.format("MyViewsProperty.ViewExistsCheck.NotExist", arg0);
    }

    /**
     * Key {@code MyViewsProperty.ViewExistsCheck.NotExist}: {@code A view
     * with name {0} does not exist}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A view with name {0} does not exist}
     */
    public static Localizable _MyViewsProperty_ViewExistsCheck_NotExist(Object arg0) {
        return new Localizable(holder, "MyViewsProperty.ViewExistsCheck.NotExist", arg0);
    }

    /**
     * Key {@code Permalink.LastUnstableBuild}: {@code Last unstable build}.
     * 
     * @return
     *     {@code Last unstable build}
     */
    public static String Permalink_LastUnstableBuild() {
        return holder.format("Permalink.LastUnstableBuild");
    }

    /**
     * Key {@code Permalink.LastUnstableBuild}: {@code Last unstable build}.
     * 
     * @return
     *     {@code Last unstable build}
     */
    public static Localizable _Permalink_LastUnstableBuild() {
        return new Localizable(holder, "Permalink.LastUnstableBuild");
    }

    /**
     * Key {@code Hudson.JobAlreadyExists}: {@code A job already exists with
     * the name â{0}â}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A job already exists with the name â{0}â}
     */
    public static String Hudson_JobAlreadyExists(Object arg0) {
        return holder.format("Hudson.JobAlreadyExists", arg0);
    }

    /**
     * Key {@code Hudson.JobAlreadyExists}: {@code A job already exists with
     * the name â{0}â}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A job already exists with the name â{0}â}
     */
    public static Localizable _Hudson_JobAlreadyExists(Object arg0) {
        return new Localizable(holder, "Hudson.JobAlreadyExists", arg0);
    }

    /**
     * Key {@code Permalink.LastFailedBuild}: {@code Last failed build}.
     * 
     * @return
     *     {@code Last failed build}
     */
    public static String Permalink_LastFailedBuild() {
        return holder.format("Permalink.LastFailedBuild");
    }

    /**
     * Key {@code Permalink.LastFailedBuild}: {@code Last failed build}.
     * 
     * @return
     *     {@code Last failed build}
     */
    public static Localizable _Permalink_LastFailedBuild() {
        return new Localizable(holder, "Permalink.LastFailedBuild");
    }

    /**
     * Key {@code Queue.ExceptionCanRun}: {@code Exception evaluating if the
     * queue can run the task}.
     * 
     * @return
     *     {@code Exception evaluating if the queue can run the task}
     */
    public static String Queue_ExceptionCanRun() {
        return holder.format("Queue.ExceptionCanRun");
    }

    /**
     * Key {@code Queue.ExceptionCanRun}: {@code Exception evaluating if the
     * queue can run the task}.
     * 
     * @return
     *     {@code Exception evaluating if the queue can run the task}
     */
    public static Localizable _Queue_ExceptionCanRun() {
        return new Localizable(holder, "Queue.ExceptionCanRun");
    }

    /**
     * Key {@code Run.running_as_}: {@code Running as {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Running as {0}}
     */
    public static String Run_running_as_(Object arg0) {
        return holder.format("Run.running_as_", arg0);
    }

    /**
     * Key {@code Run.running_as_}: {@code Running as {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Running as {0}}
     */
    public static Localizable _Run_running_as_(Object arg0) {
        return new Localizable(holder, "Run.running_as_", arg0);
    }

    /**
     * Key {@code Slave.WindowsSlave}: {@code This is a Windows agent}.
     * 
     * @return
     *     {@code This is a Windows agent}
     */
    public static String Slave_WindowsSlave() {
        return holder.format("Slave.WindowsSlave");
    }

    /**
     * Key {@code Slave.WindowsSlave}: {@code This is a Windows agent}.
     * 
     * @return
     *     {@code This is a Windows agent}
     */
    public static Localizable _Slave_WindowsSlave() {
        return new Localizable(holder, "Slave.WindowsSlave");
    }

    /**
     * Key {@code Run.Summary.BrokenSinceThisBuild}: {@code broken since this
     * build}.
     * 
     * @return
     *     {@code broken since this build}
     */
    public static String Run_Summary_BrokenSinceThisBuild() {
        return holder.format("Run.Summary.BrokenSinceThisBuild");
    }

    /**
     * Key {@code Run.Summary.BrokenSinceThisBuild}: {@code broken since this
     * build}.
     * 
     * @return
     *     {@code broken since this build}
     */
    public static Localizable _Run_Summary_BrokenSinceThisBuild() {
        return new Localizable(holder, "Run.Summary.BrokenSinceThisBuild");
    }

    /**
     * Key {@code Queue.executor_slot_already_in_use}: {@code Executor slot
     * already in use}.
     * 
     * @return
     *     {@code Executor slot already in use}
     */
    public static String Queue_executor_slot_already_in_use() {
        return holder.format("Queue.executor_slot_already_in_use");
    }

    /**
     * Key {@code Queue.executor_slot_already_in_use}: {@code Executor slot
     * already in use}.
     * 
     * @return
     *     {@code Executor slot already in use}
     */
    public static Localizable _Queue_executor_slot_already_in_use() {
        return new Localizable(holder, "Queue.executor_slot_already_in_use");
    }

    /**
     * Key {@code Job.NoRecentBuildFailed}: {@code No recent builds failed.}.
     * 
     * @return
     *     {@code No recent builds failed.}
     */
    public static String Job_NoRecentBuildFailed() {
        return holder.format("Job.NoRecentBuildFailed");
    }

    /**
     * Key {@code Job.NoRecentBuildFailed}: {@code No recent builds failed.}.
     * 
     * @return
     *     {@code No recent builds failed.}
     */
    public static Localizable _Job_NoRecentBuildFailed() {
        return new Localizable(holder, "Job.NoRecentBuildFailed");
    }

    /**
     * Key {@code Descriptor.From}: {@code (from <a href="{1}" rel="noopener
     * noreferrer" target="_blank">{0}</a>)}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code (from <a href="{1}" rel="noopener noreferrer"
     *     target="_blank">{0}</a>)}
     */
    public static String Descriptor_From(Object arg0, Object arg1) {
        return holder.format("Descriptor.From", arg0, arg1);
    }

    /**
     * Key {@code Descriptor.From}: {@code (from <a href="{1}" rel="noopener
     * noreferrer" target="_blank">{0}</a>)}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code (from <a href="{1}" rel="noopener noreferrer"
     *     target="_blank">{0}</a>)}
     */
    public static Localizable _Descriptor_From(Object arg0, Object arg1) {
        return new Localizable(holder, "Descriptor.From", arg0, arg1);
    }

    /**
     * Key {@code ParameterAction.DisplayName}: {@code Parameters}.
     * 
     * @return
     *     {@code Parameters}
     */
    public static String ParameterAction_DisplayName() {
        return holder.format("ParameterAction.DisplayName");
    }

    /**
     * Key {@code ParameterAction.DisplayName}: {@code Parameters}.
     * 
     * @return
     *     {@code Parameters}
     */
    public static Localizable _ParameterAction_DisplayName() {
        return new Localizable(holder, "ParameterAction.DisplayName");
    }

    /**
     * Key {@code ManagementLink.Category.CONFIGURATION}: {@code System
     * Configuration}.
     * 
     * @return
     *     {@code System Configuration}
     */
    public static String ManagementLink_Category_CONFIGURATION() {
        return holder.format("ManagementLink.Category.CONFIGURATION");
    }

    /**
     * Key {@code ManagementLink.Category.CONFIGURATION}: {@code System
     * Configuration}.
     * 
     * @return
     *     {@code System Configuration}
     */
    public static Localizable _ManagementLink_Category_CONFIGURATION() {
        return new Localizable(holder, "ManagementLink.Category.CONFIGURATION");
    }

    /**
     * Key {@code Item.RENAME.description}: {@code Rename a job.}.
     * 
     * @return
     *     {@code Rename a job.}
     */
    public static String Item_RENAME_description() {
        return holder.format("Item.RENAME.description");
    }

    /**
     * Key {@code Item.RENAME.description}: {@code Rename a job.}.
     * 
     * @return
     *     {@code Rename a job.}
     */
    public static Localizable _Item_RENAME_description() {
        return new Localizable(holder, "Item.RENAME.description");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.parameter}: {@code Build
     * Parameters}.
     * 
     * @return
     *     {@code Build Parameters}
     */
    public static String UpdateCenter_PluginCategory_parameter() {
        return holder.format("UpdateCenter.PluginCategory.parameter");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.parameter}: {@code Build
     * Parameters}.
     * 
     * @return
     *     {@code Build Parameters}
     */
    public static Localizable _UpdateCenter_PluginCategory_parameter() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.parameter");
    }

    /**
     * Key {@code AbstractProject.PollingABorted}: {@code SCM polling
     * aborted}.
     * 
     * @return
     *     {@code SCM polling aborted}
     */
    public static String AbstractProject_PollingABorted() {
        return holder.format("AbstractProject.PollingABorted");
    }

    /**
     * Key {@code AbstractProject.PollingABorted}: {@code SCM polling
     * aborted}.
     * 
     * @return
     *     {@code SCM polling aborted}
     */
    public static Localizable _AbstractProject_PollingABorted() {
        return new Localizable(holder, "AbstractProject.PollingABorted");
    }

    /**
     * Key {@code AbstractProject.ScmAborted}: {@code SCM check out aborted}.
     * 
     * @return
     *     {@code SCM check out aborted}
     */
    public static String AbstractProject_ScmAborted() {
        return holder.format("AbstractProject.ScmAborted");
    }

    /**
     * Key {@code AbstractProject.ScmAborted}: {@code SCM check out aborted}.
     * 
     * @return
     *     {@code SCM check out aborted}
     */
    public static Localizable _AbstractProject_ScmAborted() {
        return new Localizable(holder, "AbstractProject.ScmAborted");
    }

    /**
     * Key {@code Hudson.NoJavaInPath}: {@code java is not in your PATH.
     * Maybe you need to <a href="{0}/configure">configure JDKs</a>?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code java is not in your PATH. Maybe you need to <a
     *     href="{0}/configure">configure JDKs</a>?}
     */
    public static String Hudson_NoJavaInPath(Object arg0) {
        return holder.format("Hudson.NoJavaInPath", arg0);
    }

    /**
     * Key {@code Hudson.NoJavaInPath}: {@code java is not in your PATH.
     * Maybe you need to <a href="{0}/configure">configure JDKs</a>?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code java is not in your PATH. Maybe you need to <a
     *     href="{0}/configure">configure JDKs</a>?}
     */
    public static Localizable _Hudson_NoJavaInPath(Object arg0) {
        return new Localizable(holder, "Hudson.NoJavaInPath", arg0);
    }

    /**
     * Key {@code Job.you_must_use_the_save_button_if_you_wish}: {@code You
     * must use the Save button if you wish to rename a job.}.
     * 
     * @return
     *     {@code You must use the Save button if you wish to rename a job.}
     */
    public static String Job_you_must_use_the_save_button_if_you_wish() {
        return holder.format("Job.you_must_use_the_save_button_if_you_wish");
    }

    /**
     * Key {@code Job.you_must_use_the_save_button_if_you_wish}: {@code You
     * must use the Save button if you wish to rename a job.}.
     * 
     * @return
     *     {@code You must use the Save button if you wish to rename a job.}
     */
    public static Localizable _Job_you_must_use_the_save_button_if_you_wish() {
        return new Localizable(holder, "Job.you_must_use_the_save_button_if_you_wish");
    }

    /**
     * Key {@code AbstractProject.UpstreamBuildInProgress}: {@code Upstream
     * project â{0}â is already building}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Upstream project â{0}â is already building}
     */
    public static String AbstractProject_UpstreamBuildInProgress(Object arg0) {
        return holder.format("AbstractProject.UpstreamBuildInProgress", arg0);
    }

    /**
     * Key {@code AbstractProject.UpstreamBuildInProgress}: {@code Upstream
     * project â{0}â is already building}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Upstream project â{0}â is already building}
     */
    public static Localizable _AbstractProject_UpstreamBuildInProgress(Object arg0) {
        return new Localizable(holder, "AbstractProject.UpstreamBuildInProgress", arg0);
    }

    /**
     * Key {@code AbstractItem.FailureToStopBuilds}: {@code Failed to
     * interrupt and stop {0,choice,1#{0,number,integer}
     * build|1<{0,number,integer} builds} of {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code Failed to interrupt and stop {0,choice,1#{0,number,integer}
     *     build|1<{0,number,integer} builds} of {1}}
     */
    public static String AbstractItem_FailureToStopBuilds(Object arg0, Object arg1) {
        return holder.format("AbstractItem.FailureToStopBuilds", arg0, arg1);
    }

    /**
     * Key {@code AbstractItem.FailureToStopBuilds}: {@code Failed to
     * interrupt and stop {0,choice,1#{0,number,integer}
     * build|1<{0,number,integer} builds} of {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code Failed to interrupt and stop {0,choice,1#{0,number,integer}
     *     build|1<{0,number,integer} builds} of {1}}
     */
    public static Localizable _AbstractItem_FailureToStopBuilds(Object arg0, Object arg1) {
        return new Localizable(holder, "AbstractItem.FailureToStopBuilds", arg0, arg1);
    }

    /**
     * Key {@code ProxyView.DisplayName}: {@code Include a global view}.
     * 
     * @return
     *     {@code Include a global view}
     */
    public static String ProxyView_DisplayName() {
        return holder.format("ProxyView.DisplayName");
    }

    /**
     * Key {@code ProxyView.DisplayName}: {@code Include a global view}.
     * 
     * @return
     *     {@code Include a global view}
     */
    public static Localizable _ProxyView_DisplayName() {
        return new Localizable(holder, "ProxyView.DisplayName");
    }

    /**
     * Key {@code Run.Summary.BackToNormal}: {@code back to normal}.
     * 
     * @return
     *     {@code back to normal}
     */
    public static String Run_Summary_BackToNormal() {
        return holder.format("Run.Summary.BackToNormal");
    }

    /**
     * Key {@code Run.Summary.BackToNormal}: {@code back to normal}.
     * 
     * @return
     *     {@code back to normal}
     */
    public static Localizable _Run_Summary_BackToNormal() {
        return new Localizable(holder, "Run.Summary.BackToNormal");
    }

    /**
     * Key {@code Permalink.LastUnsuccessfulBuild}: {@code Last unsuccessful
     * build}.
     * 
     * @return
     *     {@code Last unsuccessful build}
     */
    public static String Permalink_LastUnsuccessfulBuild() {
        return holder.format("Permalink.LastUnsuccessfulBuild");
    }

    /**
     * Key {@code Permalink.LastUnsuccessfulBuild}: {@code Last unsuccessful
     * build}.
     * 
     * @return
     *     {@code Last unsuccessful build}
     */
    public static Localizable _Permalink_LastUnsuccessfulBuild() {
        return new Localizable(holder, "Permalink.LastUnsuccessfulBuild");
    }

    /**
     * Key {@code RunParameterDefinition.DisplayName}: {@code Run Parameter}.
     * 
     * @return
     *     {@code Run Parameter}
     */
    public static String RunParameterDefinition_DisplayName() {
        return holder.format("RunParameterDefinition.DisplayName");
    }

    /**
     * Key {@code RunParameterDefinition.DisplayName}: {@code Run Parameter}.
     * 
     * @return
     *     {@code Run Parameter}
     */
    public static Localizable _RunParameterDefinition_DisplayName() {
        return new Localizable(holder, "RunParameterDefinition.DisplayName");
    }

    /**
     * Key {@code Node.Mode.NORMAL}: {@code Use this node as much as
     * possible}.
     * 
     * @return
     *     {@code Use this node as much as possible}
     */
    public static String Node_Mode_NORMAL() {
        return holder.format("Node.Mode.NORMAL");
    }

    /**
     * Key {@code Node.Mode.NORMAL}: {@code Use this node as much as
     * possible}.
     * 
     * @return
     *     {@code Use this node as much as possible}
     */
    public static Localizable _Node_Mode_NORMAL() {
        return new Localizable(holder, "Node.Mode.NORMAL");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.devops}: {@code DevOps}.
     * 
     * @return
     *     {@code DevOps}
     */
    public static String UpdateCenter_PluginCategory_devops() {
        return holder.format("UpdateCenter.PluginCategory.devops");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.devops}: {@code DevOps}.
     * 
     * @return
     *     {@code DevOps}
     */
    public static Localizable _UpdateCenter_PluginCategory_devops() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.devops");
    }

    /**
     * Key {@code ManagementLink.Category.STATUS}: {@code Status
     * Information}.
     * 
     * @return
     *     {@code Status Information}
     */
    public static String ManagementLink_Category_STATUS() {
        return holder.format("ManagementLink.Category.STATUS");
    }

    /**
     * Key {@code ManagementLink.Category.STATUS}: {@code Status
     * Information}.
     * 
     * @return
     *     {@code Status Information}
     */
    public static Localizable _ManagementLink_Category_STATUS() {
        return new Localizable(holder, "ManagementLink.Category.STATUS");
    }

    /**
     * Key {@code TimeZoneProperty.DisplayDefaultTimeZone}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static String TimeZoneProperty_DisplayDefaultTimeZone() {
        return holder.format("TimeZoneProperty.DisplayDefaultTimeZone");
    }

    /**
     * Key {@code TimeZoneProperty.DisplayDefaultTimeZone}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static Localizable _TimeZoneProperty_DisplayDefaultTimeZone() {
        return new Localizable(holder, "TimeZoneProperty.DisplayDefaultTimeZone");
    }

    /**
     * Key {@code Job.BuildStability}: {@code Build stability: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build stability: {0}}
     */
    public static String Job_BuildStability(Object arg0) {
        return holder.format("Job.BuildStability", arg0);
    }

    /**
     * Key {@code Job.BuildStability}: {@code Build stability: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build stability: {0}}
     */
    public static Localizable _Job_BuildStability(Object arg0) {
        return new Localizable(holder, "Job.BuildStability", arg0);
    }

    /**
     * Key {@code Hudson.NotANonNegativeNumber}: {@code Number may not be
     * negative}.
     * 
     * @return
     *     {@code Number may not be negative}
     */
    public static String Hudson_NotANonNegativeNumber() {
        return holder.format("Hudson.NotANonNegativeNumber");
    }

    /**
     * Key {@code Hudson.NotANonNegativeNumber}: {@code Number may not be
     * negative}.
     * 
     * @return
     *     {@code Number may not be negative}
     */
    public static Localizable _Hudson_NotANonNegativeNumber() {
        return new Localizable(holder, "Hudson.NotANonNegativeNumber");
    }

    /**
     * Key {@code Queue.FinishedWaiting}: {@code Finished waiting}.
     * 
     * @return
     *     {@code Finished waiting}
     */
    public static String Queue_FinishedWaiting() {
        return holder.format("Queue.FinishedWaiting");
    }

    /**
     * Key {@code Queue.FinishedWaiting}: {@code Finished waiting}.
     * 
     * @return
     *     {@code Finished waiting}
     */
    public static Localizable _Queue_FinishedWaiting() {
        return new Localizable(holder, "Queue.FinishedWaiting");
    }

    /**
     * Key {@code Label.GroupOf}: {@code group of {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code group of {0}}
     */
    public static String Label_GroupOf(Object arg0) {
        return holder.format("Label.GroupOf", arg0);
    }

    /**
     * Key {@code Label.GroupOf}: {@code group of {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code group of {0}}
     */
    public static Localizable _Label_GroupOf(Object arg0) {
        return new Localizable(holder, "Label.GroupOf", arg0);
    }

    /**
     * Key {@code ChoiceParameterDefinition.DisplayName}: {@code Choice
     * Parameter}.
     * 
     * @return
     *     {@code Choice Parameter}
     */
    public static String ChoiceParameterDefinition_DisplayName() {
        return holder.format("ChoiceParameterDefinition.DisplayName");
    }

    /**
     * Key {@code ChoiceParameterDefinition.DisplayName}: {@code Choice
     * Parameter}.
     * 
     * @return
     *     {@code Choice Parameter}
     */
    public static Localizable _ChoiceParameterDefinition_DisplayName() {
        return new Localizable(holder, "ChoiceParameterDefinition.DisplayName");
    }

    /**
     * Key {@code Api.NoXPathMatch}: {@code XPath {0} didnât match}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code XPath {0} didnât match}
     */
    public static String Api_NoXPathMatch(Object arg0) {
        return holder.format("Api.NoXPathMatch", arg0);
    }

    /**
     * Key {@code Api.NoXPathMatch}: {@code XPath {0} didnât match}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code XPath {0} didnât match}
     */
    public static Localizable _Api_NoXPathMatch(Object arg0) {
        return new Localizable(holder, "Api.NoXPathMatch", arg0);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.scala}: {@code Scala
     * Development}.
     * 
     * @return
     *     {@code Scala Development}
     */
    public static String UpdateCenter_PluginCategory_scala() {
        return holder.format("UpdateCenter.PluginCategory.scala");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.scala}: {@code Scala
     * Development}.
     * 
     * @return
     *     {@code Scala Development}
     */
    public static Localizable _UpdateCenter_PluginCategory_scala() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.scala");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.ui}: {@code User Interface}.
     * 
     * @return
     *     {@code User Interface}
     */
    public static String UpdateCenter_PluginCategory_ui() {
        return holder.format("UpdateCenter.PluginCategory.ui");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.ui}: {@code User Interface}.
     * 
     * @return
     *     {@code User Interface}
     */
    public static Localizable _UpdateCenter_PluginCategory_ui() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.ui");
    }

    /**
     * Key {@code AbstractProject.CancelPermission.Description}: {@code This
     * permission grants the ability to cancel a scheduled, or abort a
     * running, build.}.
     * 
     * @return
     *     {@code This permission grants the ability to cancel a scheduled, or
     *     abort a running, build.}
     */
    public static String AbstractProject_CancelPermission_Description() {
        return holder.format("AbstractProject.CancelPermission.Description");
    }

    /**
     * Key {@code AbstractProject.CancelPermission.Description}: {@code This
     * permission grants the ability to cancel a scheduled, or abort a
     * running, build.}.
     * 
     * @return
     *     {@code This permission grants the ability to cancel a scheduled, or
     *     abort a running, build.}
     */
    public static Localizable _AbstractProject_CancelPermission_Description() {
        return new Localizable(holder, "AbstractProject.CancelPermission.Description");
    }

    /**
     * Key {@code Hudson.Computer.Caption}: {@code Built-In Node}.
     * 
     * @return
     *     {@code Built-In Node}
     */
    public static String Hudson_Computer_Caption() {
        return holder.format("Hudson.Computer.Caption");
    }

    /**
     * Key {@code Hudson.Computer.Caption}: {@code Built-In Node}.
     * 
     * @return
     *     {@code Built-In Node}
     */
    public static Localizable _Hudson_Computer_Caption() {
        return new Localizable(holder, "Hudson.Computer.Caption");
    }

    /**
     * Key {@code Hudson.MustBeAtMost}: {@code Must be {0} or less}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Must be {0} or less}
     */
    public static String Hudson_MustBeAtMost(Object arg0) {
        return holder.format("Hudson.MustBeAtMost", arg0);
    }

    /**
     * Key {@code Hudson.MustBeAtMost}: {@code Must be {0} or less}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Must be {0} or less}
     */
    public static Localizable _Hudson_MustBeAtMost(Object arg0) {
        return new Localizable(holder, "Hudson.MustBeAtMost", arg0);
    }

    /**
     * Key {@code MyViewsProperty.GlobalAction.DisplayName}: {@code My
     * Views}.
     * 
     * @return
     *     {@code My Views}
     */
    public static String MyViewsProperty_GlobalAction_DisplayName() {
        return holder.format("MyViewsProperty.GlobalAction.DisplayName");
    }

    /**
     * Key {@code MyViewsProperty.GlobalAction.DisplayName}: {@code My
     * Views}.
     * 
     * @return
     *     {@code My Views}
     */
    public static Localizable _MyViewsProperty_GlobalAction_DisplayName() {
        return new Localizable(holder, "MyViewsProperty.GlobalAction.DisplayName");
    }

    /**
     * Key {@code View.DisplayNameNotUniqueWarning}: {@code The display name,
     * "{0}", is already in use by another view and could cause confusion and
     * delay.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The display name, "{0}", is already in use by another view and
     *     could cause confusion and delay.}
     */
    public static String View_DisplayNameNotUniqueWarning(Object arg0) {
        return holder.format("View.DisplayNameNotUniqueWarning", arg0);
    }

    /**
     * Key {@code View.DisplayNameNotUniqueWarning}: {@code The display name,
     * "{0}", is already in use by another view and could cause confusion and
     * delay.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The display name, "{0}", is already in use by another view and
     *     could cause confusion and delay.}
     */
    public static Localizable _View_DisplayNameNotUniqueWarning(Object arg0) {
        return new Localizable(holder, "View.DisplayNameNotUniqueWarning", arg0);
    }

    /**
     * Key {@code ManagementLink.Category.TOOLS}: {@code Tools and Actions}.
     * 
     * @return
     *     {@code Tools and Actions}
     */
    public static String ManagementLink_Category_TOOLS() {
        return holder.format("ManagementLink.Category.TOOLS");
    }

    /**
     * Key {@code ManagementLink.Category.TOOLS}: {@code Tools and Actions}.
     * 
     * @return
     *     {@code Tools and Actions}
     */
    public static Localizable _ManagementLink_Category_TOOLS() {
        return new Localizable(holder, "ManagementLink.Category.TOOLS");
    }

    /**
     * Key {@code Computer.CreatePermission.Description}: {@code This
     * permission allows users to create agents.}.
     * 
     * @return
     *     {@code This permission allows users to create agents.}
     */
    public static String Computer_CreatePermission_Description() {
        return holder.format("Computer.CreatePermission.Description");
    }

    /**
     * Key {@code Computer.CreatePermission.Description}: {@code This
     * permission allows users to create agents.}.
     * 
     * @return
     *     {@code This permission allows users to create agents.}
     */
    public static Localizable _Computer_CreatePermission_Description() {
        return new Localizable(holder, "Computer.CreatePermission.Description");
    }

    /**
     * Key {@code BallColor.InProgress}: {@code In progress}.
     * 
     * @return
     *     {@code In progress}
     */
    public static String BallColor_InProgress() {
        return holder.format("BallColor.InProgress");
    }

    /**
     * Key {@code BallColor.InProgress}: {@code In progress}.
     * 
     * @return
     *     {@code In progress}
     */
    public static Localizable _BallColor_InProgress() {
        return new Localizable(holder, "BallColor.InProgress");
    }

    /**
     * Key {@code Item.CREATE.description}: {@code Create a new job.}.
     * 
     * @return
     *     {@code Create a new job.}
     */
    public static String Item_CREATE_description() {
        return holder.format("Item.CREATE.description");
    }

    /**
     * Key {@code Item.CREATE.description}: {@code Create a new job.}.
     * 
     * @return
     *     {@code Create a new job.}
     */
    public static Localizable _Item_CREATE_description() {
        return new Localizable(holder, "Item.CREATE.description");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.maven}: {@code Maven}.
     * 
     * @return
     *     {@code Maven}
     */
    public static String UpdateCenter_PluginCategory_maven() {
        return holder.format("UpdateCenter.PluginCategory.maven");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.maven}: {@code Maven}.
     * 
     * @return
     *     {@code Maven}
     */
    public static Localizable _UpdateCenter_PluginCategory_maven() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.maven");
    }

    /**
     * Key {@code LabelExpression.NoMatch_DidYouMean}: {@code No agent/cloud
     * matches this label expression. Did you mean â{1}â instead of
     * â{0}â?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No agent/cloud matches this label expression. Did you mean
     *     â{1}â instead of â{0}â?}
     */
    public static String LabelExpression_NoMatch_DidYouMean(Object arg0, Object arg1) {
        return holder.format("LabelExpression.NoMatch_DidYouMean", arg0, arg1);
    }

    /**
     * Key {@code LabelExpression.NoMatch_DidYouMean}: {@code No agent/cloud
     * matches this label expression. Did you mean â{1}â instead of
     * â{0}â?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No agent/cloud matches this label expression. Did you mean
     *     â{1}â instead of â{0}â?}
     */
    public static Localizable _LabelExpression_NoMatch_DidYouMean(Object arg0, Object arg1) {
        return new Localizable(holder, "LabelExpression.NoMatch_DidYouMean", arg0, arg1);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.python}: {@code Python
     * Development}.
     * 
     * @return
     *     {@code Python Development}
     */
    public static String UpdateCenter_PluginCategory_python() {
        return holder.format("UpdateCenter.PluginCategory.python");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.python}: {@code Python
     * Development}.
     * 
     * @return
     *     {@code Python Development}
     */
    public static Localizable _UpdateCenter_PluginCategory_python() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.python");
    }

    /**
     * Key {@code StringParameterDefinition.DisplayName}: {@code String
     * Parameter}.
     * 
     * @return
     *     {@code String Parameter}
     */
    public static String StringParameterDefinition_DisplayName() {
        return holder.format("StringParameterDefinition.DisplayName");
    }

    /**
     * Key {@code StringParameterDefinition.DisplayName}: {@code String
     * Parameter}.
     * 
     * @return
     *     {@code String Parameter}
     */
    public static Localizable _StringParameterDefinition_DisplayName() {
        return new Localizable(holder, "StringParameterDefinition.DisplayName");
    }

    /**
     * Key {@code Hudson.NodeBeingRemoved}: {@code Node is being removed}.
     * 
     * @return
     *     {@code Node is being removed}
     */
    public static String Hudson_NodeBeingRemoved() {
        return holder.format("Hudson.NodeBeingRemoved");
    }

    /**
     * Key {@code Hudson.NodeBeingRemoved}: {@code Node is being removed}.
     * 
     * @return
     *     {@code Node is being removed}
     */
    public static Localizable _Hudson_NodeBeingRemoved() {
        return new Localizable(holder, "Hudson.NodeBeingRemoved");
    }

    /**
     * Key {@code Run.Summary.Unstable}: {@code unstable}.
     * 
     * @return
     *     {@code unstable}
     */
    public static String Run_Summary_Unstable() {
        return holder.format("Run.Summary.Unstable");
    }

    /**
     * Key {@code Run.Summary.Unstable}: {@code unstable}.
     * 
     * @return
     *     {@code unstable}
     */
    public static Localizable _Run_Summary_Unstable() {
        return new Localizable(holder, "Run.Summary.Unstable");
    }

    /**
     * Key {@code FreeStyleProject.Description}: {@code This is the central
     * feature of Jenkins. Jenkins will build your project, combining any SCM
     * with any build system, and this can be even used for something other
     * than software build.}.
     * 
     * @return
     *     {@code This is the central feature of Jenkins. Jenkins will build your
     *     project, combining any SCM with any build system, and this can be even
     *     used for something other than software build.}
     */
    public static String FreeStyleProject_Description() {
        return holder.format("FreeStyleProject.Description");
    }

    /**
     * Key {@code FreeStyleProject.Description}: {@code This is the central
     * feature of Jenkins. Jenkins will build your project, combining any SCM
     * with any build system, and this can be even used for something other
     * than software build.}.
     * 
     * @return
     *     {@code This is the central feature of Jenkins. Jenkins will build your
     *     project, combining any SCM with any build system, and this can be even
     *     used for something other than software build.}
     */
    public static Localizable _FreeStyleProject_Description() {
        return new Localizable(holder, "FreeStyleProject.Description");
    }

    /**
     * Key {@code Slave.Remote.Relative.Path.Warning}: {@code Are you sure
     * you want to use a relative path for the FS root? Note that relative
     * paths require that you can assure that the selected launcher provides
     * a consistent current working directory. Using an absolute path is
     * highly recommended.}.
     * 
     * @return
     *     {@code Are you sure you want to use a relative path for the FS root?
     *     Note that relative paths require that you can assure that the selected
     *     launcher provides a consistent current working directory. Using an
     *     absolute path is highly recommended.}
     */
    public static String Slave_Remote_Relative_Path_Warning() {
        return holder.format("Slave.Remote.Relative.Path.Warning");
    }

    /**
     * Key {@code Slave.Remote.Relative.Path.Warning}: {@code Are you sure
     * you want to use a relative path for the FS root? Note that relative
     * paths require that you can assure that the selected launcher provides
     * a consistent current working directory. Using an absolute path is
     * highly recommended.}.
     * 
     * @return
     *     {@code Are you sure you want to use a relative path for the FS root?
     *     Note that relative paths require that you can assure that the selected
     *     launcher provides a consistent current working directory. Using an
     *     absolute path is highly recommended.}
     */
    public static Localizable _Slave_Remote_Relative_Path_Warning() {
        return new Localizable(holder, "Slave.Remote.Relative.Path.Warning");
    }

    /**
     * Key {@code Computer.ConfigurePermission.Description}: {@code This
     * permission allows users to configure agents.}.
     * 
     * @return
     *     {@code This permission allows users to configure agents.}
     */
    public static String Computer_ConfigurePermission_Description() {
        return holder.format("Computer.ConfigurePermission.Description");
    }

    /**
     * Key {@code Computer.ConfigurePermission.Description}: {@code This
     * permission allows users to configure agents.}.
     * 
     * @return
     *     {@code This permission allows users to configure agents.}
     */
    public static Localizable _Computer_ConfigurePermission_Description() {
        return new Localizable(holder, "Computer.ConfigurePermission.Description");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.groovy-related}: {@code
     * Groovy-related}.
     * 
     * @return
     *     {@code Groovy-related}
     */
    public static String UpdateCenter_PluginCategory_groovy_related() {
        return holder.format("UpdateCenter.PluginCategory.groovy-related");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.groovy-related}: {@code
     * Groovy-related}.
     * 
     * @return
     *     {@code Groovy-related}
     */
    public static Localizable _UpdateCenter_PluginCategory_groovy_related() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.groovy-related");
    }

    /**
     * Key {@code ManagementLink.Category.UNCATEGORIZED}: {@code
     * Uncategorized}.
     * 
     * @return
     *     {@code Uncategorized}
     */
    public static String ManagementLink_Category_UNCATEGORIZED() {
        return holder.format("ManagementLink.Category.UNCATEGORIZED");
    }

    /**
     * Key {@code ManagementLink.Category.UNCATEGORIZED}: {@code
     * Uncategorized}.
     * 
     * @return
     *     {@code Uncategorized}
     */
    public static Localizable _ManagementLink_Category_UNCATEGORIZED() {
        return new Localizable(holder, "ManagementLink.Category.UNCATEGORIZED");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.external}: {@code External
     * Site/Tool Integrations}.
     * 
     * @return
     *     {@code External Site/Tool Integrations}
     */
    public static String UpdateCenter_PluginCategory_external() {
        return holder.format("UpdateCenter.PluginCategory.external");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.external}: {@code External
     * Site/Tool Integrations}.
     * 
     * @return
     *     {@code External Site/Tool Integrations}
     */
    public static Localizable _UpdateCenter_PluginCategory_external() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.external");
    }

    /**
     * Key {@code AbstractProject.Pronoun}: {@code Project}.
     * 
     * @return
     *     {@code Project}
     */
    public static String AbstractProject_Pronoun() {
        return holder.format("AbstractProject.Pronoun");
    }

    /**
     * Key {@code AbstractProject.Pronoun}: {@code Project}.
     * 
     * @return
     *     {@code Project}
     */
    public static Localizable _AbstractProject_Pronoun() {
        return new Localizable(holder, "AbstractProject.Pronoun");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.orchestration}: {@code
     * Orchestration}.
     * 
     * @return
     *     {@code Orchestration}
     */
    public static String UpdateCenter_PluginCategory_orchestration() {
        return holder.format("UpdateCenter.PluginCategory.orchestration");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.orchestration}: {@code
     * Orchestration}.
     * 
     * @return
     *     {@code Orchestration}
     */
    public static Localizable _UpdateCenter_PluginCategory_orchestration() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.orchestration");
    }

    /**
     * Key {@code BallColor.NotBuilt}: {@code Not built}.
     * 
     * @return
     *     {@code Not built}
     */
    public static String BallColor_NotBuilt() {
        return holder.format("BallColor.NotBuilt");
    }

    /**
     * Key {@code BallColor.NotBuilt}: {@code Not built}.
     * 
     * @return
     *     {@code Not built}
     */
    public static Localizable _BallColor_NotBuilt() {
        return new Localizable(holder, "BallColor.NotBuilt");
    }

    /**
     * Key {@code HealthReport.EmptyString}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static String HealthReport_EmptyString() {
        return holder.format("HealthReport.EmptyString");
    }

    /**
     * Key {@code HealthReport.EmptyString}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static Localizable _HealthReport_EmptyString() {
        return new Localizable(holder, "HealthReport.EmptyString");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.cli}: {@code Command Line
     * Interface}.
     * 
     * @return
     *     {@code Command Line Interface}
     */
    public static String UpdateCenter_PluginCategory_cli() {
        return holder.format("UpdateCenter.PluginCategory.cli");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.cli}: {@code Command Line
     * Interface}.
     * 
     * @return
     *     {@code Command Line Interface}
     */
    public static Localizable _UpdateCenter_PluginCategory_cli() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.cli");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.dotnet}: {@code .NET
     * Development}.
     * 
     * @return
     *     {@code .NET Development}
     */
    public static String UpdateCenter_PluginCategory_dotnet() {
        return holder.format("UpdateCenter.PluginCategory.dotnet");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.dotnet}: {@code .NET
     * Development}.
     * 
     * @return
     *     {@code .NET Development}
     */
    public static Localizable _UpdateCenter_PluginCategory_dotnet() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.dotnet");
    }

    /**
     * Key {@code Node.BecauseNodeIsNotAcceptingTasks}: {@code â{0}â is
     * not accepting tasks}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is not accepting tasks}
     */
    public static String Node_BecauseNodeIsNotAcceptingTasks(Object arg0) {
        return holder.format("Node.BecauseNodeIsNotAcceptingTasks", arg0);
    }

    /**
     * Key {@code Node.BecauseNodeIsNotAcceptingTasks}: {@code â{0}â is
     * not accepting tasks}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is not accepting tasks}
     */
    public static Localizable _Node_BecauseNodeIsNotAcceptingTasks(Object arg0) {
        return new Localizable(holder, "Node.BecauseNodeIsNotAcceptingTasks", arg0);
    }

    /**
     * Key {@code AbstractProject.NoSCM}: {@code No SCM}.
     * 
     * @return
     *     {@code No SCM}
     */
    public static String AbstractProject_NoSCM() {
        return holder.format("AbstractProject.NoSCM");
    }

    /**
     * Key {@code AbstractProject.NoSCM}: {@code No SCM}.
     * 
     * @return
     *     {@code No SCM}
     */
    public static Localizable _AbstractProject_NoSCM() {
        return new Localizable(holder, "AbstractProject.NoSCM");
    }

    /**
     * Key {@code TimeZoneProperty.DisplayName}: {@code User Defined Time
     * Zone}.
     * 
     * @return
     *     {@code User Defined Time Zone}
     */
    public static String TimeZoneProperty_DisplayName() {
        return holder.format("TimeZoneProperty.DisplayName");
    }

    /**
     * Key {@code TimeZoneProperty.DisplayName}: {@code User Defined Time
     * Zone}.
     * 
     * @return
     *     {@code User Defined Time Zone}
     */
    public static Localizable _TimeZoneProperty_DisplayName() {
        return new Localizable(holder, "TimeZoneProperty.DisplayName");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.cloud}: {@code Cloud
     * Providers}.
     * 
     * @return
     *     {@code Cloud Providers}
     */
    public static String UpdateCenter_PluginCategory_cloud() {
        return holder.format("UpdateCenter.PluginCategory.cloud");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.cloud}: {@code Cloud
     * Providers}.
     * 
     * @return
     *     {@code Cloud Providers}
     */
    public static Localizable _UpdateCenter_PluginCategory_cloud() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.cloud");
    }

    /**
     * Key {@code Item.CONFIGURE.description}: {@code Change the
     * configuration of a job.}.
     * 
     * @return
     *     {@code Change the configuration of a job.}
     */
    public static String Item_CONFIGURE_description() {
        return holder.format("Item.CONFIGURE.description");
    }

    /**
     * Key {@code Item.CONFIGURE.description}: {@code Change the
     * configuration of a job.}.
     * 
     * @return
     *     {@code Change the configuration of a job.}
     */
    public static Localizable _Item_CONFIGURE_description() {
        return new Localizable(holder, "Item.CONFIGURE.description");
    }

    /**
     * Key {@code Jenkins.Manage.Description}: {@code This permission grants
     * the ability to configure parts of the overall system configuration
     * that are not expected to have an impact on the overall stability and
     * security of the system.}.
     * 
     * @return
     *     {@code This permission grants the ability to configure parts of the
     *     overall system configuration that are not expected to have an impact
     *     on the overall stability and security of the system.}
     */
    public static String Jenkins_Manage_Description() {
        return holder.format("Jenkins.Manage.Description");
    }

    /**
     * Key {@code Jenkins.Manage.Description}: {@code This permission grants
     * the ability to configure parts of the overall system configuration
     * that are not expected to have an impact on the overall stability and
     * security of the system.}.
     * 
     * @return
     *     {@code This permission grants the ability to configure parts of the
     *     overall system configuration that are not expected to have an impact
     *     on the overall stability and security of the system.}
     */
    public static Localizable _Jenkins_Manage_Description() {
        return new Localizable(holder, "Jenkins.Manage.Description");
    }

    /**
     * Key {@code Node.BecauseNodeIsReserved}: {@code â{0}â is reserved
     * for jobs with matching label expression}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is reserved for jobs with matching label expression}
     */
    public static String Node_BecauseNodeIsReserved(Object arg0) {
        return holder.format("Node.BecauseNodeIsReserved", arg0);
    }

    /**
     * Key {@code Node.BecauseNodeIsReserved}: {@code â{0}â is reserved
     * for jobs with matching label expression}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code â{0}â is reserved for jobs with matching label expression}
     */
    public static Localizable _Node_BecauseNodeIsReserved(Object arg0) {
        return new Localizable(holder, "Node.BecauseNodeIsReserved", arg0);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.user}: {@code Authentication
     * and User Management}.
     * 
     * @return
     *     {@code Authentication and User Management}
     */
    public static String UpdateCenter_PluginCategory_user() {
        return holder.format("UpdateCenter.PluginCategory.user");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.user}: {@code Authentication
     * and User Management}.
     * 
     * @return
     *     {@code Authentication and User Management}
     */
    public static Localizable _UpdateCenter_PluginCategory_user() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.user");
    }

    /**
     * Key {@code LoadStatistics.Legends.QueueLength}: {@code Queue length}.
     * 
     * @return
     *     {@code Queue length}
     */
    public static String LoadStatistics_Legends_QueueLength() {
        return holder.format("LoadStatistics.Legends.QueueLength");
    }

    /**
     * Key {@code LoadStatistics.Legends.QueueLength}: {@code Queue length}.
     * 
     * @return
     *     {@code Queue length}
     */
    public static Localizable _LoadStatistics_Legends_QueueLength() {
        return new Localizable(holder, "LoadStatistics.Legends.QueueLength");
    }

    /**
     * Key {@code Cause.RemoteCause.ShortDescription}: {@code Started by
     * remote host {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by remote host {0}}
     */
    public static String Cause_RemoteCause_ShortDescription(Object arg0) {
        return holder.format("Cause.RemoteCause.ShortDescription", arg0);
    }

    /**
     * Key {@code Cause.RemoteCause.ShortDescription}: {@code Started by
     * remote host {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by remote host {0}}
     */
    public static Localizable _Cause_RemoteCause_ShortDescription(Object arg0) {
        return new Localizable(holder, "Cause.RemoteCause.ShortDescription", arg0);
    }

    /**
     * Key {@code Hudson.NotANumber}: {@code Not a number}.
     * 
     * @return
     *     {@code Not a number}
     */
    public static String Hudson_NotANumber() {
        return holder.format("Hudson.NotANumber");
    }

    /**
     * Key {@code Hudson.NotANumber}: {@code Not a number}.
     * 
     * @return
     *     {@code Not a number}
     */
    public static Localizable _Hudson_NotANumber() {
        return new Localizable(holder, "Hudson.NotANumber");
    }

    /**
     * Key {@code View.Permissions.Title}: {@code View}.
     * 
     * @return
     *     {@code View}
     */
    public static String View_Permissions_Title() {
        return holder.format("View.Permissions.Title");
    }

    /**
     * Key {@code View.Permissions.Title}: {@code View}.
     * 
     * @return
     *     {@code View}
     */
    public static Localizable _View_Permissions_Title() {
        return new Localizable(holder, "View.Permissions.Title");
    }

    /**
     * Key {@code AbstractItem.TaskNoun}: {@code Build}.
     * 
     * @return
     *     {@code Build}
     */
    public static String AbstractItem_TaskNoun() {
        return holder.format("AbstractItem.TaskNoun");
    }

    /**
     * Key {@code AbstractItem.TaskNoun}: {@code Build}.
     * 
     * @return
     *     {@code Build}
     */
    public static Localizable _AbstractItem_TaskNoun() {
        return new Localizable(holder, "AbstractItem.TaskNoun");
    }

    /**
     * Key {@code AbstractProject.WorkspaceOffline}: {@code Workspace is
     * offline.}.
     * 
     * @return
     *     {@code Workspace is offline.}
     */
    public static String AbstractProject_WorkspaceOffline() {
        return holder.format("AbstractProject.WorkspaceOffline");
    }

    /**
     * Key {@code AbstractProject.WorkspaceOffline}: {@code Workspace is
     * offline.}.
     * 
     * @return
     *     {@code Workspace is offline.}
     */
    public static Localizable _AbstractProject_WorkspaceOffline() {
        return new Localizable(holder, "AbstractProject.WorkspaceOffline");
    }

    /**
     * Key {@code MyViewsProperty.ViewExistsCheck.AlreadyExists}: {@code A
     * view with name {0} already exists}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A view with name {0} already exists}
     */
    public static String MyViewsProperty_ViewExistsCheck_AlreadyExists(Object arg0) {
        return holder.format("MyViewsProperty.ViewExistsCheck.AlreadyExists", arg0);
    }

    /**
     * Key {@code MyViewsProperty.ViewExistsCheck.AlreadyExists}: {@code A
     * view with name {0} already exists}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code A view with name {0} already exists}
     */
    public static Localizable _MyViewsProperty_ViewExistsCheck_AlreadyExists(Object arg0) {
        return new Localizable(holder, "MyViewsProperty.ViewExistsCheck.AlreadyExists", arg0);
    }

    /**
     * Key {@code View.ReadPermission.Description}: {@code This permission
     * allows users to see views (implied by generic read access).}.
     * 
     * @return
     *     {@code This permission allows users to see views (implied by generic
     *     read access).}
     */
    public static String View_ReadPermission_Description() {
        return holder.format("View.ReadPermission.Description");
    }

    /**
     * Key {@code View.ReadPermission.Description}: {@code This permission
     * allows users to see views (implied by generic read access).}.
     * 
     * @return
     *     {@code This permission allows users to see views (implied by generic
     *     read access).}
     */
    public static Localizable _View_ReadPermission_Description() {
        return new Localizable(holder, "View.ReadPermission.Description");
    }

    /**
     * Key {@code Queue.Unknown}: {@code ???}.
     * 
     * @return
     *     {@code ???}
     */
    public static String Queue_Unknown() {
        return holder.format("Queue.Unknown");
    }

    /**
     * Key {@code Queue.Unknown}: {@code ???}.
     * 
     * @return
     *     {@code ???}
     */
    public static Localizable _Queue_Unknown() {
        return new Localizable(holder, "Queue.Unknown");
    }

    /**
     * Key {@code Run.UpdatePermission.Description}: {@code This permission
     * allows users to update description and other properties of a build,
     * for example to leave notes about the cause of a build failure.}.
     * 
     * @return
     *     {@code This permission allows users to update description and other
     *     properties of a build, for example to leave notes about the cause of a
     *     build failure.}
     */
    public static String Run_UpdatePermission_Description() {
        return holder.format("Run.UpdatePermission.Description");
    }

    /**
     * Key {@code Run.UpdatePermission.Description}: {@code This permission
     * allows users to update description and other properties of a build,
     * for example to leave notes about the cause of a build failure.}.
     * 
     * @return
     *     {@code This permission allows users to update description and other
     *     properties of a build, for example to leave notes about the cause of a
     *     build failure.}
     */
    public static Localizable _Run_UpdatePermission_Description() {
        return new Localizable(holder, "Run.UpdatePermission.Description");
    }

    /**
     * Key {@code AbstractItem.NewNameInUse}: {@code The name â{0}â is
     * already in use.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The name â{0}â is already in use.}
     */
    public static String AbstractItem_NewNameInUse(Object arg0) {
        return holder.format("AbstractItem.NewNameInUse", arg0);
    }

    /**
     * Key {@code AbstractItem.NewNameInUse}: {@code The name â{0}â is
     * already in use.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The name â{0}â is already in use.}
     */
    public static Localizable _AbstractItem_NewNameInUse(Object arg0) {
        return new Localizable(holder, "AbstractItem.NewNameInUse", arg0);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.deployment}: {@code
     * Deployment}.
     * 
     * @return
     *     {@code Deployment}
     */
    public static String UpdateCenter_PluginCategory_deployment() {
        return holder.format("UpdateCenter.PluginCategory.deployment");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.deployment}: {@code
     * Deployment}.
     * 
     * @return
     *     {@code Deployment}
     */
    public static Localizable _UpdateCenter_PluginCategory_deployment() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.deployment");
    }

    /**
     * Key {@code CLI.clear-queue.shortDescription}: {@code Clears the build
     * queue.}.
     * 
     * @return
     *     {@code Clears the build queue.}
     */
    public static String CLI_clear_queue_shortDescription() {
        return holder.format("CLI.clear-queue.shortDescription");
    }

    /**
     * Key {@code CLI.clear-queue.shortDescription}: {@code Clears the build
     * queue.}.
     * 
     * @return
     *     {@code Clears the build queue.}
     */
    public static Localizable _CLI_clear_queue_shortDescription() {
        return new Localizable(holder, "CLI.clear-queue.shortDescription");
    }

    /**
     * Key {@code AbstractProject.NewBuildForWorkspace}: {@code Scheduling a
     * new build to get a workspace.}.
     * 
     * @return
     *     {@code Scheduling a new build to get a workspace.}
     */
    public static String AbstractProject_NewBuildForWorkspace() {
        return holder.format("AbstractProject.NewBuildForWorkspace");
    }

    /**
     * Key {@code AbstractProject.NewBuildForWorkspace}: {@code Scheduling a
     * new build to get a workspace.}.
     * 
     * @return
     *     {@code Scheduling a new build to get a workspace.}
     */
    public static Localizable _AbstractProject_NewBuildForWorkspace() {
        return new Localizable(holder, "AbstractProject.NewBuildForWorkspace");
    }

    /**
     * Key {@code Slave.Remote.Director.Mandatory}: {@code Remote directory
     * is mandatory}.
     * 
     * @return
     *     {@code Remote directory is mandatory}
     */
    public static String Slave_Remote_Director_Mandatory() {
        return holder.format("Slave.Remote.Director.Mandatory");
    }

    /**
     * Key {@code Slave.Remote.Director.Mandatory}: {@code Remote directory
     * is mandatory}.
     * 
     * @return
     *     {@code Remote directory is mandatory}
     */
    public static Localizable _Slave_Remote_Director_Mandatory() {
        return new Localizable(holder, "Slave.Remote.Director.Mandatory");
    }

    /**
     * Key {@code Item.READ.description}: {@code See a job. (You may deny
     * this permission but allow Discover to force an anonymous user to log
     * in to see the job.)}.
     * 
     * @return
     *     {@code See a job. (You may deny this permission but allow Discover to
     *     force an anonymous user to log in to see the job.)}
     */
    public static String Item_READ_description() {
        return holder.format("Item.READ.description");
    }

    /**
     * Key {@code Item.READ.description}: {@code See a job. (You may deny
     * this permission but allow Discover to force an anonymous user to log
     * in to see the job.)}.
     * 
     * @return
     *     {@code See a job. (You may deny this permission but allow Discover to
     *     force an anonymous user to log in to see the job.)}
     */
    public static Localizable _Item_READ_description() {
        return new Localizable(holder, "Item.READ.description");
    }

    /**
     * Key {@code MultiStageTimeSeries.EMPTY_STRING}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static String MultiStageTimeSeries_EMPTY_STRING() {
        return holder.format("MultiStageTimeSeries.EMPTY_STRING");
    }

    /**
     * Key {@code MultiStageTimeSeries.EMPTY_STRING}: {@code }.
     * 
     * @return
     *     {@code }
     */
    public static Localizable _MultiStageTimeSeries_EMPTY_STRING() {
        return new Localizable(holder, "MultiStageTimeSeries.EMPTY_STRING");
    }

    /**
     * Key {@code Queue.BlockedBy}: {@code Blocked by â{0}â}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Blocked by â{0}â}
     */
    public static String Queue_BlockedBy(Object arg0) {
        return holder.format("Queue.BlockedBy", arg0);
    }

    /**
     * Key {@code Queue.BlockedBy}: {@code Blocked by â{0}â}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Blocked by â{0}â}
     */
    public static Localizable _Queue_BlockedBy(Object arg0) {
        return new Localizable(holder, "Queue.BlockedBy", arg0);
    }

    /**
     * Key {@code Queue.node_has_been_removed_from_configuration}: {@code {0}
     * has been removed from configuration}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} has been removed from configuration}
     */
    public static String Queue_node_has_been_removed_from_configuration(Object arg0) {
        return holder.format("Queue.node_has_been_removed_from_configuration", arg0);
    }

    /**
     * Key {@code Queue.node_has_been_removed_from_configuration}: {@code {0}
     * has been removed from configuration}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} has been removed from configuration}
     */
    public static Localizable _Queue_node_has_been_removed_from_configuration(Object arg0) {
        return new Localizable(holder, "Queue.node_has_been_removed_from_configuration", arg0);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.android}: {@code Android
     * Development}.
     * 
     * @return
     *     {@code Android Development}
     */
    public static String UpdateCenter_PluginCategory_android() {
        return holder.format("UpdateCenter.PluginCategory.android");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.android}: {@code Android
     * Development}.
     * 
     * @return
     *     {@code Android Development}
     */
    public static Localizable _UpdateCenter_PluginCategory_android() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.android");
    }

    /**
     * Key {@code Hudson.USER_CONTENT_README}: {@code Files in this directory
     * will be served under your http://yourjenkins/userContent/}.
     * 
     * @return
     *     {@code Files in this directory will be served under your
     *     http://yourjenkins/userContent/}
     */
    public static String Hudson_USER_CONTENT_README() {
        return holder.format("Hudson.USER_CONTENT_README");
    }

    /**
     * Key {@code Hudson.USER_CONTENT_README}: {@code Files in this directory
     * will be served under your http://yourjenkins/userContent/}.
     * 
     * @return
     *     {@code Files in this directory will be served under your
     *     http://yourjenkins/userContent/}
     */
    public static Localizable _Hudson_USER_CONTENT_README() {
        return new Localizable(holder, "Hudson.USER_CONTENT_README");
    }

    /**
     * Key {@code UpdateCenter.Status.CheckingJavaNet}: {@code Checking
     * update center connectivity}.
     * 
     * @return
     *     {@code Checking update center connectivity}
     */
    public static String UpdateCenter_Status_CheckingJavaNet() {
        return holder.format("UpdateCenter.Status.CheckingJavaNet");
    }

    /**
     * Key {@code UpdateCenter.Status.CheckingJavaNet}: {@code Checking
     * update center connectivity}.
     * 
     * @return
     *     {@code Checking update center connectivity}
     */
    public static Localizable _UpdateCenter_Status_CheckingJavaNet() {
        return new Localizable(holder, "UpdateCenter.Status.CheckingJavaNet");
    }

    /**
     * Key {@code AbstractProject.AwaitingWorkspaceToComeOnline}: {@code We
     * need to schedule a new build to get a workspace, but deferring {0}ms
     * in the hope that one will become available soon}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code We need to schedule a new build to get a workspace, but
     *     deferring {0}ms in the hope that one will become available soon}
     */
    public static String AbstractProject_AwaitingWorkspaceToComeOnline(Object arg0) {
        return holder.format("AbstractProject.AwaitingWorkspaceToComeOnline", arg0);
    }

    /**
     * Key {@code AbstractProject.AwaitingWorkspaceToComeOnline}: {@code We
     * need to schedule a new build to get a workspace, but deferring {0}ms
     * in the hope that one will become available soon}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code We need to schedule a new build to get a workspace, but
     *     deferring {0}ms in the hope that one will become available soon}
     */
    public static Localizable _AbstractProject_AwaitingWorkspaceToComeOnline(Object arg0) {
        return new Localizable(holder, "AbstractProject.AwaitingWorkspaceToComeOnline", arg0);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.builder}: {@code Build Tools}.
     * 
     * @return
     *     {@code Build Tools}
     */
    public static String UpdateCenter_PluginCategory_builder() {
        return holder.format("UpdateCenter.PluginCategory.builder");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.builder}: {@code Build Tools}.
     * 
     * @return
     *     {@code Build Tools}
     */
    public static Localizable _UpdateCenter_PluginCategory_builder() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.builder");
    }

    /**
     * Key {@code Api.MultipleMatch}: {@code XPath "{0}" matched {1} nodes.
     * Create XPath that only matches one, or use the "wrapper" query
     * parameter to wrap them all under a root element.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code XPath "{0}" matched {1} nodes. Create XPath that only matches
     *     one, or use the "wrapper" query parameter to wrap them all under a
     *     root element.}
     */
    public static String Api_MultipleMatch(Object arg0, Object arg1) {
        return holder.format("Api.MultipleMatch", arg0, arg1);
    }

    /**
     * Key {@code Api.MultipleMatch}: {@code XPath "{0}" matched {1} nodes.
     * Create XPath that only matches one, or use the "wrapper" query
     * parameter to wrap them all under a root element.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code XPath "{0}" matched {1} nodes. Create XPath that only matches
     *     one, or use the "wrapper" query parameter to wrap them all under a
     *     root element.}
     */
    public static Localizable _Api_MultipleMatch(Object arg0, Object arg1) {
        return new Localizable(holder, "Api.MultipleMatch", arg0, arg1);
    }

    /**
     * Key {@code ResultTrend.Unstable}: {@code Unstable}.
     * 
     * @return
     *     {@code Unstable}
     */
    public static String ResultTrend_Unstable() {
        return holder.format("ResultTrend.Unstable");
    }

    /**
     * Key {@code ResultTrend.Unstable}: {@code Unstable}.
     * 
     * @return
     *     {@code Unstable}
     */
    public static Localizable _ResultTrend_Unstable() {
        return new Localizable(holder, "ResultTrend.Unstable");
    }

    /**
     * Key {@code TimeZoneProperty.current_time_in_}: {@code Current time in
     * {0}: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Current time in {0}: {1}}
     */
    public static String TimeZoneProperty_current_time_in_(Object arg0, Object arg1) {
        return holder.format("TimeZoneProperty.current_time_in_", arg0, arg1);
    }

    /**
     * Key {@code TimeZoneProperty.current_time_in_}: {@code Current time in
     * {0}: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Current time in {0}: {1}}
     */
    public static Localizable _TimeZoneProperty_current_time_in_(Object arg0, Object arg1) {
        return new Localizable(holder, "TimeZoneProperty.current_time_in_", arg0, arg1);
    }

    /**
     * Key {@code ComputerSet.SpecifySlaveToCopy}: {@code Specify which agent
     * to copy}.
     * 
     * @return
     *     {@code Specify which agent to copy}
     */
    public static String ComputerSet_SpecifySlaveToCopy() {
        return holder.format("ComputerSet.SpecifySlaveToCopy");
    }

    /**
     * Key {@code ComputerSet.SpecifySlaveToCopy}: {@code Specify which agent
     * to copy}.
     * 
     * @return
     *     {@code Specify which agent to copy}
     */
    public static Localizable _ComputerSet_SpecifySlaveToCopy() {
        return new Localizable(holder, "ComputerSet.SpecifySlaveToCopy");
    }

    /**
     * Key {@code Queue.ExceptionCanTake}: {@code Exception evaluating if the
     * node can take the task}.
     * 
     * @return
     *     {@code Exception evaluating if the node can take the task}
     */
    public static String Queue_ExceptionCanTake() {
        return holder.format("Queue.ExceptionCanTake");
    }

    /**
     * Key {@code Queue.ExceptionCanTake}: {@code Exception evaluating if the
     * node can take the task}.
     * 
     * @return
     *     {@code Exception evaluating if the node can take the task}
     */
    public static Localizable _Queue_ExceptionCanTake() {
        return new Localizable(holder, "Queue.ExceptionCanTake");
    }

    /**
     * Key {@code Hudson.NotUsesUTF8ToDecodeURL}: {@code Your container
     * doesnât use UTF-8 to decode URLs. If you use non-ASCII characters as
     * a job name etc, this will cause problems. See <a
     * href="https://www.jenkins.io/redirect/configuring-servlet-containers">Containers</a>
     * and <a
     * href="https://www.jenkins.io/redirect/troubleshooting/utf8-url-decoding">Tomcat
     * i18n</a> for more details.}.
     * 
     * @return
     *     {@code Your container doesnât use UTF-8 to decode URLs. If you use
     *     non-ASCII characters as a job name etc, this will cause problems. See
     *     <a
     *     href="https://www.jenkins.io/redirect/configuring-servlet-containers">Containers</a>
     *     and <a
     *     href="https://www.jenkins.io/redirect/troubleshooting/utf8-url-decoding">Tomcat
     *     i18n</a> for more details.}
     */
    public static String Hudson_NotUsesUTF8ToDecodeURL() {
        return holder.format("Hudson.NotUsesUTF8ToDecodeURL");
    }

    /**
     * Key {@code Hudson.NotUsesUTF8ToDecodeURL}: {@code Your container
     * doesnât use UTF-8 to decode URLs. If you use non-ASCII characters as
     * a job name etc, this will cause problems. See <a
     * href="https://www.jenkins.io/redirect/configuring-servlet-containers">Containers</a>
     * and <a
     * href="https://www.jenkins.io/redirect/troubleshooting/utf8-url-decoding">Tomcat
     * i18n</a> for more details.}.
     * 
     * @return
     *     {@code Your container doesnât use UTF-8 to decode URLs. If you use
     *     non-ASCII characters as a job name etc, this will cause problems. See
     *     <a
     *     href="https://www.jenkins.io/redirect/configuring-servlet-containers">Containers</a>
     *     and <a
     *     href="https://www.jenkins.io/redirect/troubleshooting/utf8-url-decoding">Tomcat
     *     i18n</a> for more details.}
     */
    public static Localizable _Hudson_NotUsesUTF8ToDecodeURL() {
        return new Localizable(holder, "Hudson.NotUsesUTF8ToDecodeURL");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.ruby}: {@code Ruby
     * Development}.
     * 
     * @return
     *     {@code Ruby Development}
     */
    public static String UpdateCenter_PluginCategory_ruby() {
        return holder.format("UpdateCenter.PluginCategory.ruby");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.ruby}: {@code Ruby
     * Development}.
     * 
     * @return
     *     {@code Ruby Development}
     */
    public static Localizable _UpdateCenter_PluginCategory_ruby() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.ruby");
    }

    /**
     * Key {@code Computer.BadChannel}: {@code Agent node offline or not a
     * remote channel (such as the built-in node).}.
     * 
     * @return
     *     {@code Agent node offline or not a remote channel (such as the
     *     built-in node).}
     */
    public static String Computer_BadChannel() {
        return holder.format("Computer.BadChannel");
    }

    /**
     * Key {@code Computer.BadChannel}: {@code Agent node offline or not a
     * remote channel (such as the built-in node).}.
     * 
     * @return
     *     {@code Agent node offline or not a remote channel (such as the
     *     built-in node).}
     */
    public static Localizable _Computer_BadChannel() {
        return new Localizable(holder, "Computer.BadChannel");
    }

    /**
     * Key {@code AbstractProject.WorkspacePermission.Description}: {@code
     * This permission grants the ability to retrieve the contents of a
     * workspace Jenkins checked out for performing builds. If you donât
     * want a user to access files in the workspace (e.g. source code checked
     * out from SCM or intermediate build results) through the workspace
     * browser, you can revoke this permission.}.
     * 
     * @return
     *     {@code This permission grants the ability to retrieve the contents of
     *     a workspace Jenkins checked out for performing builds. If you donât
     *     want a user to access files in the workspace (e.g. source code checked
     *     out from SCM or intermediate build results) through the workspace
     *     browser, you can revoke this permission.}
     */
    public static String AbstractProject_WorkspacePermission_Description() {
        return holder.format("AbstractProject.WorkspacePermission.Description");
    }

    /**
     * Key {@code AbstractProject.WorkspacePermission.Description}: {@code
     * This permission grants the ability to retrieve the contents of a
     * workspace Jenkins checked out for performing builds. If you donât
     * want a user to access files in the workspace (e.g. source code checked
     * out from SCM or intermediate build results) through the workspace
     * browser, you can revoke this permission.}.
     * 
     * @return
     *     {@code This permission grants the ability to retrieve the contents of
     *     a workspace Jenkins checked out for performing builds. If you donât
     *     want a user to access files in the workspace (e.g. source code checked
     *     out from SCM or intermediate build results) through the workspace
     *     browser, you can revoke this permission.}
     */
    public static Localizable _AbstractProject_WorkspacePermission_Description() {
        return new Localizable(holder, "AbstractProject.WorkspacePermission.Description");
    }

    /**
     * Key {@code ResultTrend.StillUnstable}: {@code Still unstable}.
     * 
     * @return
     *     {@code Still unstable}
     */
    public static String ResultTrend_StillUnstable() {
        return holder.format("ResultTrend.StillUnstable");
    }

    /**
     * Key {@code ResultTrend.StillUnstable}: {@code Still unstable}.
     * 
     * @return
     *     {@code Still unstable}
     */
    public static Localizable _ResultTrend_StillUnstable() {
        return new Localizable(holder, "ResultTrend.StillUnstable");
    }

    /**
     * Key {@code FileParameterDefinition.DisplayName}: {@code File
     * Parameter}.
     * 
     * @return
     *     {@code File Parameter}
     */
    public static String FileParameterDefinition_DisplayName() {
        return holder.format("FileParameterDefinition.DisplayName");
    }

    /**
     * Key {@code FileParameterDefinition.DisplayName}: {@code File
     * Parameter}.
     * 
     * @return
     *     {@code File Parameter}
     */
    public static Localizable _FileParameterDefinition_DisplayName() {
        return new Localizable(holder, "FileParameterDefinition.DisplayName");
    }

    /**
     * Key {@code ListView.DisplayName}: {@code List View}.
     * 
     * @return
     *     {@code List View}
     */
    public static String ListView_DisplayName() {
        return holder.format("ListView.DisplayName");
    }

    /**
     * Key {@code ListView.DisplayName}: {@code List View}.
     * 
     * @return
     *     {@code List View}
     */
    public static Localizable _ListView_DisplayName() {
        return new Localizable(holder, "ListView.DisplayName");
    }

    /**
     * Key {@code Hudson.NoSuchDirectory}: {@code No such directory: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such directory: {0}}
     */
    public static String Hudson_NoSuchDirectory(Object arg0) {
        return holder.format("Hudson.NoSuchDirectory", arg0);
    }

    /**
     * Key {@code Hudson.NoSuchDirectory}: {@code No such directory: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such directory: {0}}
     */
    public static Localizable _Hudson_NoSuchDirectory(Object arg0) {
        return new Localizable(holder, "Hudson.NoSuchDirectory", arg0);
    }

    /**
     * Key {@code Build.post_build_steps_failed}: {@code Post-build steps
     * failed}.
     * 
     * @return
     *     {@code Post-build steps failed}
     */
    public static String Build_post_build_steps_failed() {
        return holder.format("Build.post_build_steps_failed");
    }

    /**
     * Key {@code Build.post_build_steps_failed}: {@code Post-build steps
     * failed}.
     * 
     * @return
     *     {@code Post-build steps failed}
     */
    public static Localizable _Build_post_build_steps_failed() {
        return new Localizable(holder, "Build.post_build_steps_failed");
    }

    /**
     * Key {@code TextParameterDefinition.DisplayName}: {@code Multi-line
     * String Parameter}.
     * 
     * @return
     *     {@code Multi-line String Parameter}
     */
    public static String TextParameterDefinition_DisplayName() {
        return holder.format("TextParameterDefinition.DisplayName");
    }

    /**
     * Key {@code TextParameterDefinition.DisplayName}: {@code Multi-line
     * String Parameter}.
     * 
     * @return
     *     {@code Multi-line String Parameter}
     */
    public static Localizable _TextParameterDefinition_DisplayName() {
        return new Localizable(holder, "TextParameterDefinition.DisplayName");
    }

    /**
     * Key {@code TopLevelItemDescriptor.NotApplicableIn}: {@code {0} items
     * are not applicable within {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} items are not applicable within {1}}
     */
    public static String TopLevelItemDescriptor_NotApplicableIn(Object arg0, Object arg1) {
        return holder.format("TopLevelItemDescriptor.NotApplicableIn", arg0, arg1);
    }

    /**
     * Key {@code TopLevelItemDescriptor.NotApplicableIn}: {@code {0} items
     * are not applicable within {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} items are not applicable within {1}}
     */
    public static Localizable _TopLevelItemDescriptor_NotApplicableIn(Object arg0, Object arg1) {
        return new Localizable(holder, "TopLevelItemDescriptor.NotApplicableIn", arg0, arg1);
    }

    /**
     * Key {@code AbstractProject.ExtendedReadPermission.Description}: {@code
     * This permission grants read-only access to project configurations.
     * Please be aware that sensitive information in your builds, such as
     * passwords, will be exposed to a wider audience by granting this
     * permission.}.
     * 
     * @return
     *     {@code This permission grants read-only access to project
     *     configurations. Please be aware that sensitive information in your
     *     builds, such as passwords, will be exposed to a wider audience by
     *     granting this permission.}
     */
    public static String AbstractProject_ExtendedReadPermission_Description() {
        return holder.format("AbstractProject.ExtendedReadPermission.Description");
    }

    /**
     * Key {@code AbstractProject.ExtendedReadPermission.Description}: {@code
     * This permission grants read-only access to project configurations.
     * Please be aware that sensitive information in your builds, such as
     * passwords, will be exposed to a wider audience by granting this
     * permission.}.
     * 
     * @return
     *     {@code This permission grants read-only access to project
     *     configurations. Please be aware that sensitive information in your
     *     builds, such as passwords, will be exposed to a wider audience by
     *     granting this permission.}
     */
    public static Localizable _AbstractProject_ExtendedReadPermission_Description() {
        return new Localizable(holder, "AbstractProject.ExtendedReadPermission.Description");
    }

    /**
     * Key {@code Computer.ConnectPermission.Description}: {@code This
     * permission allows users to connect agents or mark agents as online.}.
     * 
     * @return
     *     {@code This permission allows users to connect agents or mark agents
     *     as online.}
     */
    public static String Computer_ConnectPermission_Description() {
        return holder.format("Computer.ConnectPermission.Description");
    }

    /**
     * Key {@code Computer.ConnectPermission.Description}: {@code This
     * permission allows users to connect agents or mark agents as online.}.
     * 
     * @return
     *     {@code This permission allows users to connect agents or mark agents
     *     as online.}
     */
    public static Localizable _Computer_ConnectPermission_Description() {
        return new Localizable(holder, "Computer.ConnectPermission.Description");
    }

    /**
     * Key {@code View.CreatePermission.Description}: {@code This permission
     * allows users to create new views.}.
     * 
     * @return
     *     {@code This permission allows users to create new views.}
     */
    public static String View_CreatePermission_Description() {
        return holder.format("View.CreatePermission.Description");
    }

    /**
     * Key {@code View.CreatePermission.Description}: {@code This permission
     * allows users to create new views.}.
     * 
     * @return
     *     {@code This permission allows users to create new views.}
     */
    public static Localizable _View_CreatePermission_Description() {
        return new Localizable(holder, "View.CreatePermission.Description");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.scm-related}: {@code Source
     * Code Management related}.
     * 
     * @return
     *     {@code Source Code Management related}
     */
    public static String UpdateCenter_PluginCategory_scm_related() {
        return holder.format("UpdateCenter.PluginCategory.scm-related");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.scm-related}: {@code Source
     * Code Management related}.
     * 
     * @return
     *     {@code Source Code Management related}
     */
    public static Localizable _UpdateCenter_PluginCategory_scm_related() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.scm-related");
    }

    /**
     * Key {@code Queue.init}: {@code Restoring the build queue}.
     * 
     * @return
     *     {@code Restoring the build queue}
     */
    public static String Queue_init() {
        return holder.format("Queue.init");
    }

    /**
     * Key {@code Queue.init}: {@code Restoring the build queue}.
     * 
     * @return
     *     {@code Restoring the build queue}
     */
    public static Localizable _Queue_init() {
        return new Localizable(holder, "Queue.init");
    }

    /**
     * Key {@code Hudson.ReadPermission.Description}: {@code The read
     * permission is necessary for viewing almost all pages of Jenkins. This
     * permission is useful when you donât want unauthenticated users to
     * see Jenkins pages: revoke this permission from the anonymous user,
     * then add "authenticated" pseudo-user and grant the read access.}.
     * 
     * @return
     *     {@code The read permission is necessary for viewing almost all pages
     *     of Jenkins. This permission is useful when you donât want
     *     unauthenticated users to see Jenkins pages: revoke this permission
     *     from the anonymous user, then add "authenticated" pseudo-user and
     *     grant the read access.}
     */
    public static String Hudson_ReadPermission_Description() {
        return holder.format("Hudson.ReadPermission.Description");
    }

    /**
     * Key {@code Hudson.ReadPermission.Description}: {@code The read
     * permission is necessary for viewing almost all pages of Jenkins. This
     * permission is useful when you donât want unauthenticated users to
     * see Jenkins pages: revoke this permission from the anonymous user,
     * then add "authenticated" pseudo-user and grant the read access.}.
     * 
     * @return
     *     {@code The read permission is necessary for viewing almost all pages
     *     of Jenkins. This permission is useful when you donât want
     *     unauthenticated users to see Jenkins pages: revoke this permission
     *     from the anonymous user, then add "authenticated" pseudo-user and
     *     grant the read access.}
     */
    public static Localizable _Hudson_ReadPermission_Description() {
        return new Localizable(holder, "Hudson.ReadPermission.Description");
    }

    /**
     * Key {@code Api.WrapperParamInvalid}: {@code The wrapper parameter can
     * only contain alphanumeric characters or dash/dot/underscore. The first
     * character has to be a letter or underscore.}.
     * 
     * @return
     *     {@code The wrapper parameter can only contain alphanumeric characters
     *     or dash/dot/underscore. The first character has to be a letter or
     *     underscore.}
     */
    public static String Api_WrapperParamInvalid() {
        return holder.format("Api.WrapperParamInvalid");
    }

    /**
     * Key {@code Api.WrapperParamInvalid}: {@code The wrapper parameter can
     * only contain alphanumeric characters or dash/dot/underscore. The first
     * character has to be a letter or underscore.}.
     * 
     * @return
     *     {@code The wrapper parameter can only contain alphanumeric characters
     *     or dash/dot/underscore. The first character has to be a letter or
     *     underscore.}
     */
    public static Localizable _Api_WrapperParamInvalid() {
        return new Localizable(holder, "Api.WrapperParamInvalid");
    }

    /**
     * Key {@code TimeZoneProperty.current_time_on_server_in_in_proposed_di}:
     * {@code Current time on server in {0}: {1}; in proposed display zone:
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Current time on server in {0}: {1}; in proposed display zone:
     *     {2}}
     */
    public static String TimeZoneProperty_current_time_on_server_in_in_proposed_di(Object arg0, Object arg1, Object arg2) {
        return holder.format("TimeZoneProperty.current_time_on_server_in_in_proposed_di", arg0, arg1, arg2);
    }

    /**
     * Key {@code TimeZoneProperty.current_time_on_server_in_in_proposed_di}:
     * {@code Current time on server in {0}: {1}; in proposed display zone:
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Current time on server in {0}: {1}; in proposed display zone:
     *     {2}}
     */
    public static Localizable _TimeZoneProperty_current_time_on_server_in_in_proposed_di(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "TimeZoneProperty.current_time_on_server_in_in_proposed_di", arg0, arg1, arg2);
    }

    /**
     * Key {@code Computer.BuildPermission.Description}: {@code This
     * permission allows users to run jobs as them on agents.}.
     * 
     * @return
     *     {@code This permission allows users to run jobs as them on agents.}
     */
    public static String Computer_BuildPermission_Description() {
        return holder.format("Computer.BuildPermission.Description");
    }

    /**
     * Key {@code Computer.BuildPermission.Description}: {@code This
     * permission allows users to run jobs as them on agents.}.
     * 
     * @return
     *     {@code This permission allows users to run jobs as them on agents.}
     */
    public static Localizable _Computer_BuildPermission_Description() {
        return new Localizable(holder, "Computer.BuildPermission.Description");
    }

    /**
     * Key {@code ManagementLink.Category.MISC}: {@code Other}.
     * 
     * @return
     *     {@code Other}
     */
    public static String ManagementLink_Category_MISC() {
        return holder.format("ManagementLink.Category.MISC");
    }

    /**
     * Key {@code ManagementLink.Category.MISC}: {@code Other}.
     * 
     * @return
     *     {@code Other}
     */
    public static Localizable _ManagementLink_Category_MISC() {
        return new Localizable(holder, "ManagementLink.Category.MISC");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.unrecognized}: {@code Misc
     * ({0})}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Misc ({0})}
     */
    public static String UpdateCenter_PluginCategory_unrecognized(Object arg0) {
        return holder.format("UpdateCenter.PluginCategory.unrecognized", arg0);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.unrecognized}: {@code Misc
     * ({0})}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Misc ({0})}
     */
    public static Localizable _UpdateCenter_PluginCategory_unrecognized(Object arg0) {
        return new Localizable(holder, "UpdateCenter.PluginCategory.unrecognized", arg0);
    }

    /**
     * Key {@code AbstractBuild.BuildingOnMaster}: {@code Building on the
     * built-in node}.
     * 
     * @return
     *     {@code Building on the built-in node}
     */
    public static String AbstractBuild_BuildingOnMaster() {
        return holder.format("AbstractBuild.BuildingOnMaster");
    }

    /**
     * Key {@code AbstractBuild.BuildingOnMaster}: {@code Building on the
     * built-in node}.
     * 
     * @return
     *     {@code Building on the built-in node}
     */
    public static Localizable _AbstractBuild_BuildingOnMaster() {
        return new Localizable(holder, "AbstractBuild.BuildingOnMaster");
    }

    /**
     * Key {@code Item.Permissions.Title}: {@code Job}.
     * 
     * @return
     *     {@code Job}
     */
    public static String Item_Permissions_Title() {
        return holder.format("Item.Permissions.Title");
    }

    /**
     * Key {@code Item.Permissions.Title}: {@code Job}.
     * 
     * @return
     *     {@code Job}
     */
    public static Localizable _Item_Permissions_Title() {
        return new Localizable(holder, "Item.Permissions.Title");
    }

    /**
     * Key {@code UpdateCenter.Status.ConnectionFailed}: {@code <span
     * class=error>Failed to connect to {0}. Perhaps you need to <a
     * href="{1}manage/pluginManager/advanced">configure HTTP
     * proxy?</a></span>}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code <span class=error>Failed to connect to {0}. Perhaps you need to
     *     <a href="{1}manage/pluginManager/advanced">configure HTTP
     *     proxy?</a></span>}
     */
    public static String UpdateCenter_Status_ConnectionFailed(Object arg0, Object arg1) {
        return holder.format("UpdateCenter.Status.ConnectionFailed", arg0, arg1);
    }

    /**
     * Key {@code UpdateCenter.Status.ConnectionFailed}: {@code <span
     * class=error>Failed to connect to {0}. Perhaps you need to <a
     * href="{1}manage/pluginManager/advanced">configure HTTP
     * proxy?</a></span>}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code <span class=error>Failed to connect to {0}. Perhaps you need to
     *     <a href="{1}manage/pluginManager/advanced">configure HTTP
     *     proxy?</a></span>}
     */
    public static Localizable _UpdateCenter_Status_ConnectionFailed(Object arg0, Object arg1) {
        return new Localizable(holder, "UpdateCenter.Status.ConnectionFailed", arg0, arg1);
    }

    /**
     * Key {@code ComputerSet.DisplayName}: {@code Nodes}.
     * 
     * @return
     *     {@code Nodes}
     */
    public static String ComputerSet_DisplayName() {
        return holder.format("ComputerSet.DisplayName");
    }

    /**
     * Key {@code ComputerSet.DisplayName}: {@code Nodes}.
     * 
     * @return
     *     {@code Nodes}
     */
    public static Localizable _ComputerSet_DisplayName() {
        return new Localizable(holder, "ComputerSet.DisplayName");
    }

    /**
     * Key {@code Hudson.MustBeAtLeast}: {@code Must be {0} or greater}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Must be {0} or greater}
     */
    public static String Hudson_MustBeAtLeast(Object arg0) {
        return holder.format("Hudson.MustBeAtLeast", arg0);
    }

    /**
     * Key {@code Hudson.MustBeAtLeast}: {@code Must be {0} or greater}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Must be {0} or greater}
     */
    public static Localizable _Hudson_MustBeAtLeast(Object arg0) {
        return new Localizable(holder, "Hudson.MustBeAtLeast", arg0);
    }

    /**
     * Key {@code CLI.online-node.shortDescription}: {@code Resume using a
     * node for performing builds, to cancel out the earlier "offline-node"
     * command.}.
     * 
     * @return
     *     {@code Resume using a node for performing builds, to cancel out the
     *     earlier "offline-node" command.}
     */
    public static String CLI_online_node_shortDescription() {
        return holder.format("CLI.online-node.shortDescription");
    }

    /**
     * Key {@code CLI.online-node.shortDescription}: {@code Resume using a
     * node for performing builds, to cancel out the earlier "offline-node"
     * command.}.
     * 
     * @return
     *     {@code Resume using a node for performing builds, to cancel out the
     *     earlier "offline-node" command.}
     */
    public static Localizable _CLI_online_node_shortDescription() {
        return new Localizable(holder, "CLI.online-node.shortDescription");
    }

    /**
     * Key {@code Hudson.NotJDKDir}: {@code {0} doesnât look like a JDK
     * directory}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} doesnât look like a JDK directory}
     */
    public static String Hudson_NotJDKDir(Object arg0) {
        return holder.format("Hudson.NotJDKDir", arg0);
    }

    /**
     * Key {@code Hudson.NotJDKDir}: {@code {0} doesnât look like a JDK
     * directory}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} doesnât look like a JDK directory}
     */
    public static Localizable _Hudson_NotJDKDir(Object arg0) {
        return new Localizable(holder, "Hudson.NotJDKDir", arg0);
    }

    /**
     * Key {@code AbstractProject.BuildPermission.Description}: {@code This
     * permission grants the ability to start a new build.}.
     * 
     * @return
     *     {@code This permission grants the ability to start a new build.}
     */
    public static String AbstractProject_BuildPermission_Description() {
        return holder.format("AbstractProject.BuildPermission.Description");
    }

    /**
     * Key {@code AbstractProject.BuildPermission.Description}: {@code This
     * permission grants the ability to start a new build.}.
     * 
     * @return
     *     {@code This permission grants the ability to start a new build.}
     */
    public static Localizable _AbstractProject_BuildPermission_Description() {
        return new Localizable(holder, "AbstractProject.BuildPermission.Description");
    }

    /**
     * Key {@code ResultTrend.Aborted}: {@code Aborted}.
     * 
     * @return
     *     {@code Aborted}
     */
    public static String ResultTrend_Aborted() {
        return holder.format("ResultTrend.Aborted");
    }

    /**
     * Key {@code ResultTrend.Aborted}: {@code Aborted}.
     * 
     * @return
     *     {@code Aborted}
     */
    public static Localizable _ResultTrend_Aborted() {
        return new Localizable(holder, "ResultTrend.Aborted");
    }

    /**
     * Key {@code UpdateCenter.DisplayName}: {@code Update Center}.
     * 
     * @return
     *     {@code Update Center}
     */
    public static String UpdateCenter_DisplayName() {
        return holder.format("UpdateCenter.DisplayName");
    }

    /**
     * Key {@code UpdateCenter.DisplayName}: {@code Update Center}.
     * 
     * @return
     *     {@code Update Center}
     */
    public static Localizable _UpdateCenter_DisplayName() {
        return new Localizable(holder, "UpdateCenter.DisplayName");
    }

    /**
     * Key {@code MyView.DisplayName}: {@code My View}.
     * 
     * @return
     *     {@code My View}
     */
    public static String MyView_DisplayName() {
        return holder.format("MyView.DisplayName");
    }

    /**
     * Key {@code MyView.DisplayName}: {@code My View}.
     * 
     * @return
     *     {@code My View}
     */
    public static Localizable _MyView_DisplayName() {
        return new Localizable(holder, "MyView.DisplayName");
    }

    /**
     * Key {@code UpdateCenter.Status.Success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static String UpdateCenter_Status_Success() {
        return holder.format("UpdateCenter.Status.Success");
    }

    /**
     * Key {@code UpdateCenter.Status.Success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static Localizable _UpdateCenter_Status_Success() {
        return new Localizable(holder, "UpdateCenter.Status.Success");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.cluster}: {@code Cluster
     * Management}.
     * 
     * @return
     *     {@code Cluster Management}
     */
    public static String UpdateCenter_PluginCategory_cluster() {
        return holder.format("UpdateCenter.PluginCategory.cluster");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.cluster}: {@code Cluster
     * Management}.
     * 
     * @return
     *     {@code Cluster Management}
     */
    public static Localizable _UpdateCenter_PluginCategory_cluster() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.cluster");
    }

    /**
     * Key {@code LoadStatistics.Legends.ConnectingExecutors}: {@code
     * Connecting executors}.
     * 
     * @return
     *     {@code Connecting executors}
     */
    public static String LoadStatistics_Legends_ConnectingExecutors() {
        return holder.format("LoadStatistics.Legends.ConnectingExecutors");
    }

    /**
     * Key {@code LoadStatistics.Legends.ConnectingExecutors}: {@code
     * Connecting executors}.
     * 
     * @return
     *     {@code Connecting executors}
     */
    public static Localizable _LoadStatistics_Legends_ConnectingExecutors() {
        return new Localizable(holder, "LoadStatistics.Legends.ConnectingExecutors");
    }

    /**
     * Key {@code Jenkins.SystemRead.Description}: {@code This permission
     * grants read-only access to large parts of the overall system
     * configuration.}.
     * 
     * @return
     *     {@code This permission grants read-only access to large parts of the
     *     overall system configuration.}
     */
    public static String Jenkins_SystemRead_Description() {
        return holder.format("Jenkins.SystemRead.Description");
    }

    /**
     * Key {@code Jenkins.SystemRead.Description}: {@code This permission
     * grants read-only access to large parts of the overall system
     * configuration.}.
     * 
     * @return
     *     {@code This permission grants read-only access to large parts of the
     *     overall system configuration.}
     */
    public static Localizable _Jenkins_SystemRead_Description() {
        return new Localizable(holder, "Jenkins.SystemRead.Description");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.theme}: {@code UI Themes}.
     * 
     * @return
     *     {@code UI Themes}
     */
    public static String UpdateCenter_PluginCategory_theme() {
        return holder.format("UpdateCenter.PluginCategory.theme");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.theme}: {@code UI Themes}.
     * 
     * @return
     *     {@code UI Themes}
     */
    public static Localizable _UpdateCenter_PluginCategory_theme() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.theme");
    }

    /**
     * Key {@code Run.Summary.BrokenSince}: {@code broken since build {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code broken since build {0}}
     */
    public static String Run_Summary_BrokenSince(Object arg0) {
        return holder.format("Run.Summary.BrokenSince", arg0);
    }

    /**
     * Key {@code Run.Summary.BrokenSince}: {@code broken since build {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code broken since build {0}}
     */
    public static Localizable _Run_Summary_BrokenSince(Object arg0) {
        return new Localizable(holder, "Run.Summary.BrokenSince", arg0);
    }

    /**
     * Key {@code AbstractProject.DownstreamBuildInProgress}: {@code
     * Downstream project â{0}â is already building}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Downstream project â{0}â is already building}
     */
    public static String AbstractProject_DownstreamBuildInProgress(Object arg0) {
        return holder.format("AbstractProject.DownstreamBuildInProgress", arg0);
    }

    /**
     * Key {@code AbstractProject.DownstreamBuildInProgress}: {@code
     * Downstream project â{0}â is already building}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Downstream project â{0}â is already building}
     */
    public static Localizable _AbstractProject_DownstreamBuildInProgress(Object arg0) {
        return new Localizable(holder, "AbstractProject.DownstreamBuildInProgress", arg0);
    }

    /**
     * Key {@code View.MissingMode}: {@code No view type is specified}.
     * 
     * @return
     *     {@code No view type is specified}
     */
    public static String View_MissingMode() {
        return holder.format("View.MissingMode");
    }

    /**
     * Key {@code View.MissingMode}: {@code No view type is specified}.
     * 
     * @return
     *     {@code No view type is specified}
     */
    public static Localizable _View_MissingMode() {
        return new Localizable(holder, "View.MissingMode");
    }

    /**
     * Key {@code Hudson.TrailingDot}: {@code A name cannot end with
     * â.â}.
     * 
     * @return
     *     {@code A name cannot end with â.â}
     */
    public static String Hudson_TrailingDot() {
        return holder.format("Hudson.TrailingDot");
    }

    /**
     * Key {@code Hudson.TrailingDot}: {@code A name cannot end with
     * â.â}.
     * 
     * @return
     *     {@code A name cannot end with â.â}
     */
    public static Localizable _Hudson_TrailingDot() {
        return new Localizable(holder, "Hudson.TrailingDot");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.must-be-labeled}: {@code
     * Uncategorized}.
     * 
     * @return
     *     {@code Uncategorized}
     */
    public static String UpdateCenter_PluginCategory_must_be_labeled() {
        return holder.format("UpdateCenter.PluginCategory.must-be-labeled");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.must-be-labeled}: {@code
     * Uncategorized}.
     * 
     * @return
     *     {@code Uncategorized}
     */
    public static Localizable _UpdateCenter_PluginCategory_must_be_labeled() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.must-be-labeled");
    }

    /**
     * Key {@code ResultTrend.Success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static String ResultTrend_Success() {
        return holder.format("ResultTrend.Success");
    }

    /**
     * Key {@code ResultTrend.Success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static Localizable _ResultTrend_Success() {
        return new Localizable(holder, "ResultTrend.Success");
    }

    /**
     * Key {@code Hudson.NoName}: {@code No name is specified}.
     * 
     * @return
     *     {@code No name is specified}
     */
    public static String Hudson_NoName() {
        return holder.format("Hudson.NoName");
    }

    /**
     * Key {@code Hudson.NoName}: {@code No name is specified}.
     * 
     * @return
     *     {@code No name is specified}
     */
    public static Localizable _Hudson_NoName() {
        return new Localizable(holder, "Hudson.NoName");
    }

    /**
     * Key {@code ParametersDefinitionProperty.DisplayName}: {@code This
     * project is parameterized}.
     * 
     * @return
     *     {@code This project is parameterized}
     */
    public static String ParametersDefinitionProperty_DisplayName() {
        return holder.format("ParametersDefinitionProperty.DisplayName");
    }

    /**
     * Key {@code ParametersDefinitionProperty.DisplayName}: {@code This
     * project is parameterized}.
     * 
     * @return
     *     {@code This project is parameterized}
     */
    public static Localizable _ParametersDefinitionProperty_DisplayName() {
        return new Localizable(holder, "ParametersDefinitionProperty.DisplayName");
    }

    /**
     * Key {@code AbstractItem.NewNameUnchanged}: {@code The new name is the
     * same as the current name.}.
     * 
     * @return
     *     {@code The new name is the same as the current name.}
     */
    public static String AbstractItem_NewNameUnchanged() {
        return holder.format("AbstractItem.NewNameUnchanged");
    }

    /**
     * Key {@code AbstractItem.NewNameUnchanged}: {@code The new name is the
     * same as the current name.}.
     * 
     * @return
     *     {@code The new name is the same as the current name.}
     */
    public static Localizable _AbstractItem_NewNameUnchanged() {
        return new Localizable(holder, "AbstractItem.NewNameUnchanged");
    }

    /**
     * Key {@code CLI.keep-build.shortDescription}: {@code Mark the build to
     * keep the build forever.}.
     * 
     * @return
     *     {@code Mark the build to keep the build forever.}
     */
    public static String CLI_keep_build_shortDescription() {
        return holder.format("CLI.keep-build.shortDescription");
    }

    /**
     * Key {@code CLI.keep-build.shortDescription}: {@code Mark the build to
     * keep the build forever.}.
     * 
     * @return
     *     {@code Mark the build to keep the build forever.}
     */
    public static Localizable _CLI_keep_build_shortDescription() {
        return new Localizable(holder, "CLI.keep-build.shortDescription");
    }

    /**
     * Key {@code BallColor.Failed}: {@code Failed}.
     * 
     * @return
     *     {@code Failed}
     */
    public static String BallColor_Failed() {
        return holder.format("BallColor.Failed");
    }

    /**
     * Key {@code BallColor.Failed}: {@code Failed}.
     * 
     * @return
     *     {@code Failed}
     */
    public static Localizable _BallColor_Failed() {
        return new Localizable(holder, "BallColor.Failed");
    }

    /**
     * Key {@code Queue.InQuietPeriod}: {@code In the quiet period. Expires
     * in {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code In the quiet period. Expires in {0}}
     */
    public static String Queue_InQuietPeriod(Object arg0) {
        return holder.format("Queue.InQuietPeriod", arg0);
    }

    /**
     * Key {@code Queue.InQuietPeriod}: {@code In the quiet period. Expires
     * in {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code In the quiet period. Expires in {0}}
     */
    public static Localizable _Queue_InQuietPeriod(Object arg0) {
        return new Localizable(holder, "Queue.InQuietPeriod", arg0);
    }

    /**
     * Key {@code ManagementLink.Category.SECURITY}: {@code Security}.
     * 
     * @return
     *     {@code Security}
     */
    public static String ManagementLink_Category_SECURITY() {
        return holder.format("ManagementLink.Category.SECURITY");
    }

    /**
     * Key {@code ManagementLink.Category.SECURITY}: {@code Security}.
     * 
     * @return
     *     {@code Security}
     */
    public static Localizable _ManagementLink_Category_SECURITY() {
        return new Localizable(holder, "ManagementLink.Category.SECURITY");
    }

    /**
     * Key {@code AbstractProject.PollingVetoed}: {@code SCM polling vetoed
     * by {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code SCM polling vetoed by {0}}
     */
    public static String AbstractProject_PollingVetoed(Object arg0) {
        return holder.format("AbstractProject.PollingVetoed", arg0);
    }

    /**
     * Key {@code AbstractProject.PollingVetoed}: {@code SCM polling vetoed
     * by {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code SCM polling vetoed by {0}}
     */
    public static Localizable _AbstractProject_PollingVetoed(Object arg0) {
        return new Localizable(holder, "AbstractProject.PollingVetoed", arg0);
    }

    /**
     * Key {@code Slave.UnixSlave}: {@code This is a Unix agent}.
     * 
     * @return
     *     {@code This is a Unix agent}
     */
    public static String Slave_UnixSlave() {
        return holder.format("Slave.UnixSlave");
    }

    /**
     * Key {@code Slave.UnixSlave}: {@code This is a Unix agent}.
     * 
     * @return
     *     {@code This is a Unix agent}
     */
    public static Localizable _Slave_UnixSlave() {
        return new Localizable(holder, "Slave.UnixSlave");
    }

    /**
     * Key {@code ItemGroupMixIn.may_not_copy_as_it_contains_secrets_and_}:
     * {@code May not copy {0} as it contains secrets and {1} has {2}/{3} but
     * not /{4}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code May not copy {0} as it contains secrets and {1} has {2}/{3} but
     *     not /{4}}
     */
    public static String ItemGroupMixIn_may_not_copy_as_it_contains_secrets_and_(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return holder.format("ItemGroupMixIn.may_not_copy_as_it_contains_secrets_and_", arg0, arg1, arg2, arg3, arg4);
    }

    /**
     * Key {@code ItemGroupMixIn.may_not_copy_as_it_contains_secrets_and_}:
     * {@code May not copy {0} as it contains secrets and {1} has {2}/{3} but
     * not /{4}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code May not copy {0} as it contains secrets and {1} has {2}/{3} but
     *     not /{4}}
     */
    public static Localizable _ItemGroupMixIn_may_not_copy_as_it_contains_secrets_and_(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return new Localizable(holder, "ItemGroupMixIn.may_not_copy_as_it_contains_secrets_and_", arg0, arg1, arg2, arg3, arg4);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.notifier}: {@code Build
     * Notifiers}.
     * 
     * @return
     *     {@code Build Notifiers}
     */
    public static String UpdateCenter_PluginCategory_notifier() {
        return holder.format("UpdateCenter.PluginCategory.notifier");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.notifier}: {@code Build
     * Notifiers}.
     * 
     * @return
     *     {@code Build Notifiers}
     */
    public static Localizable _UpdateCenter_PluginCategory_notifier() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.notifier");
    }

    /**
     * Key {@code ComputerSet.SlaveAlreadyExists}: {@code Agent called
     * â{0}â already exists}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Agent called â{0}â already exists}
     */
    public static String ComputerSet_SlaveAlreadyExists(Object arg0) {
        return holder.format("ComputerSet.SlaveAlreadyExists", arg0);
    }

    /**
     * Key {@code ComputerSet.SlaveAlreadyExists}: {@code Agent called
     * â{0}â already exists}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Agent called â{0}â already exists}
     */
    public static Localizable _ComputerSet_SlaveAlreadyExists(Object arg0) {
        return new Localizable(holder, "ComputerSet.SlaveAlreadyExists", arg0);
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.agent}: {@code Agent
     * Management}.
     * 
     * @return
     *     {@code Agent Management}
     */
    public static String UpdateCenter_PluginCategory_agent() {
        return holder.format("UpdateCenter.PluginCategory.agent");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.agent}: {@code Agent
     * Management}.
     * 
     * @return
     *     {@code Agent Management}
     */
    public static Localizable _UpdateCenter_PluginCategory_agent() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.agent");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.runcondition}: {@code
     * RunConditions for use by the Run Condition plugin}.
     * 
     * @return
     *     {@code RunConditions for use by the Run Condition plugin}
     */
    public static String UpdateCenter_PluginCategory_runcondition() {
        return holder.format("UpdateCenter.PluginCategory.runcondition");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.runcondition}: {@code
     * RunConditions for use by the Run Condition plugin}.
     * 
     * @return
     *     {@code RunConditions for use by the Run Condition plugin}
     */
    public static Localizable _UpdateCenter_PluginCategory_runcondition() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.runcondition");
    }

    /**
     * Key {@code BallColor.Aborted}: {@code Aborted}.
     * 
     * @return
     *     {@code Aborted}
     */
    public static String BallColor_Aborted() {
        return holder.format("BallColor.Aborted");
    }

    /**
     * Key {@code BallColor.Aborted}: {@code Aborted}.
     * 
     * @return
     *     {@code Aborted}
     */
    public static Localizable _BallColor_Aborted() {
        return new Localizable(holder, "BallColor.Aborted");
    }

    /**
     * Key {@code Hudson.ControlCodeNotAllowed}: {@code No control code is
     * allowed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No control code is allowed: {0}}
     */
    public static String Hudson_ControlCodeNotAllowed(Object arg0) {
        return holder.format("Hudson.ControlCodeNotAllowed", arg0);
    }

    /**
     * Key {@code Hudson.ControlCodeNotAllowed}: {@code No control code is
     * allowed: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No control code is allowed: {0}}
     */
    public static Localizable _Hudson_ControlCodeNotAllowed(Object arg0) {
        return new Localizable(holder, "Hudson.ControlCodeNotAllowed", arg0);
    }

    /**
     * Key {@code ResultTrend.NowUnstable}: {@code Now unstable}.
     * 
     * @return
     *     {@code Now unstable}
     */
    public static String ResultTrend_NowUnstable() {
        return holder.format("ResultTrend.NowUnstable");
    }

    /**
     * Key {@code ResultTrend.NowUnstable}: {@code Now unstable}.
     * 
     * @return
     *     {@code Now unstable}
     */
    public static Localizable _ResultTrend_NowUnstable() {
        return new Localizable(holder, "ResultTrend.NowUnstable");
    }

    /**
     * Key {@code Slave.InvalidConfig.NoName}: {@code Invalid agent
     * configuration. Name is empty}.
     * 
     * @return
     *     {@code Invalid agent configuration. Name is empty}
     */
    public static String Slave_InvalidConfig_NoName() {
        return holder.format("Slave.InvalidConfig.NoName");
    }

    /**
     * Key {@code Slave.InvalidConfig.NoName}: {@code Invalid agent
     * configuration. Name is empty}.
     * 
     * @return
     *     {@code Invalid agent configuration. Name is empty}
     */
    public static Localizable _Slave_InvalidConfig_NoName() {
        return new Localizable(holder, "Slave.InvalidConfig.NoName");
    }

    /**
     * Key {@code ManagementLink.Category.TROUBLESHOOTING}: {@code
     * Troubleshooting}.
     * 
     * @return
     *     {@code Troubleshooting}
     */
    public static String ManagementLink_Category_TROUBLESHOOTING() {
        return holder.format("ManagementLink.Category.TROUBLESHOOTING");
    }

    /**
     * Key {@code ManagementLink.Category.TROUBLESHOOTING}: {@code
     * Troubleshooting}.
     * 
     * @return
     *     {@code Troubleshooting}
     */
    public static Localizable _ManagementLink_Category_TROUBLESHOOTING() {
        return new Localizable(holder, "ManagementLink.Category.TROUBLESHOOTING");
    }

    /**
     * Key {@code LabelExpression_ObsoleteMasterLabel}: {@code This
     * expression includes the label <code>master</code> that is no longer
     * used for the built-in node. Use <code>built-in</code> instead. <a
     * href="https://www.jenkins.io/redirect/built-in-node-migration/"
     * rel="noopener noreferrer" target="_blank">Learn more.</a>}.
     * 
     * @return
     *     {@code This expression includes the label <code>master</code> that is
     *     no longer used for the built-in node. Use <code>built-in</code>
     *     instead. <a
     *     href="https://www.jenkins.io/redirect/built-in-node-migration/"
     *     rel="noopener noreferrer" target="_blank">Learn more.</a>}
     */
    public static String LabelExpression_ObsoleteMasterLabel() {
        return holder.format("LabelExpression_ObsoleteMasterLabel");
    }

    /**
     * Key {@code LabelExpression_ObsoleteMasterLabel}: {@code This
     * expression includes the label <code>master</code> that is no longer
     * used for the built-in node. Use <code>built-in</code> instead. <a
     * href="https://www.jenkins.io/redirect/built-in-node-migration/"
     * rel="noopener noreferrer" target="_blank">Learn more.</a>}.
     * 
     * @return
     *     {@code This expression includes the label <code>master</code> that is
     *     no longer used for the built-in node. Use <code>built-in</code>
     *     instead. <a
     *     href="https://www.jenkins.io/redirect/built-in-node-migration/"
     *     rel="noopener noreferrer" target="_blank">Learn more.</a>}
     */
    public static Localizable _LabelExpression_ObsoleteMasterLabel() {
        return new Localizable(holder, "LabelExpression_ObsoleteMasterLabel");
    }

    /**
     * Key {@code Job.minutes}: {@code mins}.
     * 
     * @return
     *     {@code mins}
     */
    public static String Job_minutes() {
        return holder.format("Job.minutes");
    }

    /**
     * Key {@code Job.minutes}: {@code mins}.
     * 
     * @return
     *     {@code mins}
     */
    public static Localizable _Job_minutes() {
        return new Localizable(holder, "Job.minutes");
    }

    /**
     * Key {@code ResultTrend.StillFailing}: {@code Still failing}.
     * 
     * @return
     *     {@code Still failing}
     */
    public static String ResultTrend_StillFailing() {
        return holder.format("ResultTrend.StillFailing");
    }

    /**
     * Key {@code ResultTrend.StillFailing}: {@code Still failing}.
     * 
     * @return
     *     {@code Still failing}
     */
    public static Localizable _ResultTrend_StillFailing() {
        return new Localizable(holder, "ResultTrend.StillFailing");
    }

    /**
     * Key {@code Slave.Terminated}: {@code {0} agent was terminated}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} agent was terminated}
     */
    public static String Slave_Terminated(Object arg0) {
        return holder.format("Slave.Terminated", arg0);
    }

    /**
     * Key {@code Slave.Terminated}: {@code {0} agent was terminated}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} agent was terminated}
     */
    public static Localizable _Slave_Terminated(Object arg0) {
        return new Localizable(holder, "Slave.Terminated", arg0);
    }

    /**
     * Key {@code AbstractProject.DiscoverPermission.Description}: {@code
     * This permission grants discover access to jobs. Lower than read
     * permissions, it allows you to redirect anonymous users to the login
     * page when they try to access a job url. Without it they would get a
     *  404 error and wouldn''t be able to discover project names.}.
     * 
     * @return
     *     {@code This permission grants discover access to jobs. Lower than read
     *     permissions, it allows you to redirect anonymous users to the login
     *     page when they try to access a job url. Without it they would get a
     *      404 error and wouldn''t be able to discover project names.}
     */
    public static String AbstractProject_DiscoverPermission_Description() {
        return holder.format("AbstractProject.DiscoverPermission.Description");
    }

    /**
     * Key {@code AbstractProject.DiscoverPermission.Description}: {@code
     * This permission grants discover access to jobs. Lower than read
     * permissions, it allows you to redirect anonymous users to the login
     * page when they try to access a job url. Without it they would get a
     *  404 error and wouldn''t be able to discover project names.}.
     * 
     * @return
     *     {@code This permission grants discover access to jobs. Lower than read
     *     permissions, it allows you to redirect anonymous users to the login
     *     page when they try to access a job url. Without it they would get a
     *      404 error and wouldn''t be able to discover project names.}
     */
    public static Localizable _AbstractProject_DiscoverPermission_Description() {
        return new Localizable(holder, "AbstractProject.DiscoverPermission.Description");
    }

    /**
     * Key {@code User.IllegalUsername}: {@code "{0}" is prohibited as a
     * username for security reasons.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is prohibited as a username for security reasons.}
     */
    public static String User_IllegalUsername(Object arg0) {
        return holder.format("User.IllegalUsername", arg0);
    }

    /**
     * Key {@code User.IllegalUsername}: {@code "{0}" is prohibited as a
     * username for security reasons.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code "{0}" is prohibited as a username for security reasons.}
     */
    public static Localizable _User_IllegalUsername(Object arg0) {
        return new Localizable(holder, "User.IllegalUsername", arg0);
    }

    /**
     * Key {@code Hudson.Permissions.Title}: {@code Overall}.
     * 
     * @return
     *     {@code Overall}
     */
    public static String Hudson_Permissions_Title() {
        return holder.format("Hudson.Permissions.Title");
    }

    /**
     * Key {@code Hudson.Permissions.Title}: {@code Overall}.
     * 
     * @return
     *     {@code Overall}
     */
    public static Localizable _Hudson_Permissions_Title() {
        return new Localizable(holder, "Hudson.Permissions.Title");
    }

    /**
     * Key {@code Cause.UserCause.ShortDescription}: {@code Started by user
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by user {0}}
     */
    public static String Cause_UserCause_ShortDescription(Object arg0) {
        return holder.format("Cause.UserCause.ShortDescription", arg0);
    }

    /**
     * Key {@code Cause.UserCause.ShortDescription}: {@code Started by user
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by user {0}}
     */
    public static Localizable _Cause_UserCause_ShortDescription(Object arg0) {
        return new Localizable(holder, "Cause.UserCause.ShortDescription", arg0);
    }

    /**
     * Key {@code UpdateCenter.init}: {@code Initialing update center}.
     * 
     * @return
     *     {@code Initialing update center}
     */
    public static String UpdateCenter_init() {
        return holder.format("UpdateCenter.init");
    }

    /**
     * Key {@code UpdateCenter.init}: {@code Initialing update center}.
     * 
     * @return
     *     {@code Initialing update center}
     */
    public static Localizable _UpdateCenter_init() {
        return new Localizable(holder, "UpdateCenter.init");
    }

    /**
     * Key {@code AbstractProject.Aborted}: {@code Aborted}.
     * 
     * @return
     *     {@code Aborted}
     */
    public static String AbstractProject_Aborted() {
        return holder.format("AbstractProject.Aborted");
    }

    /**
     * Key {@code AbstractProject.Aborted}: {@code Aborted}.
     * 
     * @return
     *     {@code Aborted}
     */
    public static Localizable _AbstractProject_Aborted() {
        return new Localizable(holder, "AbstractProject.Aborted");
    }

    /**
     * Key {@code AbstractProject.Disabled}: {@code Build disabled}.
     * 
     * @return
     *     {@code Build disabled}
     */
    public static String AbstractProject_Disabled() {
        return holder.format("AbstractProject.Disabled");
    }

    /**
     * Key {@code AbstractProject.Disabled}: {@code Build disabled}.
     * 
     * @return
     *     {@code Build disabled}
     */
    public static Localizable _AbstractProject_Disabled() {
        return new Localizable(holder, "AbstractProject.Disabled");
    }

    /**
     * Key {@code Computer.NoSuchSlaveExistsWithoutAdvice}: {@code No such
     * agent "{0}" exists.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such agent "{0}" exists.}
     */
    public static String Computer_NoSuchSlaveExistsWithoutAdvice(Object arg0) {
        return holder.format("Computer.NoSuchSlaveExistsWithoutAdvice", arg0);
    }

    /**
     * Key {@code Computer.NoSuchSlaveExistsWithoutAdvice}: {@code No such
     * agent "{0}" exists.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such agent "{0}" exists.}
     */
    public static Localizable _Computer_NoSuchSlaveExistsWithoutAdvice(Object arg0) {
        return new Localizable(holder, "Computer.NoSuchSlaveExistsWithoutAdvice", arg0);
    }

    /**
     * Key {@code Job.Pronoun}: {@code Project}.
     * 
     * @return
     *     {@code Project}
     */
    public static String Job_Pronoun() {
        return holder.format("Job.Pronoun");
    }

    /**
     * Key {@code Job.Pronoun}: {@code Project}.
     * 
     * @return
     *     {@code Project}
     */
    public static Localizable _Job_Pronoun() {
        return new Localizable(holder, "Job.Pronoun");
    }

    /**
     * Key {@code UpdateCenter.Status.CheckingInternet}: {@code Checking
     * internet connectivity}.
     * 
     * @return
     *     {@code Checking internet connectivity}
     */
    public static String UpdateCenter_Status_CheckingInternet() {
        return holder.format("UpdateCenter.Status.CheckingInternet");
    }

    /**
     * Key {@code UpdateCenter.Status.CheckingInternet}: {@code Checking
     * internet connectivity}.
     * 
     * @return
     *     {@code Checking internet connectivity}
     */
    public static Localizable _UpdateCenter_Status_CheckingInternet() {
        return new Localizable(holder, "UpdateCenter.Status.CheckingInternet");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.upload}: {@code Artifact
     * Uploaders}.
     * 
     * @return
     *     {@code Artifact Uploaders}
     */
    public static String UpdateCenter_PluginCategory_upload() {
        return holder.format("UpdateCenter.PluginCategory.upload");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.upload}: {@code Artifact
     * Uploaders}.
     * 
     * @return
     *     {@code Artifact Uploaders}
     */
    public static Localizable _UpdateCenter_PluginCategory_upload() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.upload");
    }

    /**
     * Key {@code Jenkins.CheckDisplayName.DisplayNameNotUniqueWarning}:
     * {@code The display name, "{0}", is already in use by another job and
     * could cause confusion and delay.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The display name, "{0}", is already in use by another job and
     *     could cause confusion and delay.}
     */
    public static String Jenkins_CheckDisplayName_DisplayNameNotUniqueWarning(Object arg0) {
        return holder.format("Jenkins.CheckDisplayName.DisplayNameNotUniqueWarning", arg0);
    }

    /**
     * Key {@code Jenkins.CheckDisplayName.DisplayNameNotUniqueWarning}:
     * {@code The display name, "{0}", is already in use by another job and
     * could cause confusion and delay.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The display name, "{0}", is already in use by another job and
     *     could cause confusion and delay.}
     */
    public static Localizable _Jenkins_CheckDisplayName_DisplayNameNotUniqueWarning(Object arg0) {
        return new Localizable(holder, "Jenkins.CheckDisplayName.DisplayNameNotUniqueWarning", arg0);
    }

    /**
     * Key {@code AbstractBuild.BuildingRemotely}: {@code Building remotely
     * on {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Building remotely on {0}}
     */
    public static String AbstractBuild_BuildingRemotely(Object arg0) {
        return holder.format("AbstractBuild.BuildingRemotely", arg0);
    }

    /**
     * Key {@code AbstractBuild.BuildingRemotely}: {@code Building remotely
     * on {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Building remotely on {0}}
     */
    public static Localizable _AbstractBuild_BuildingRemotely(Object arg0) {
        return new Localizable(holder, "AbstractBuild.BuildingRemotely", arg0);
    }

    /**
     * Key {@code Computer.DeletePermission.Description}: {@code This
     * permission allows users to delete existing agents.}.
     * 
     * @return
     *     {@code This permission allows users to delete existing agents.}
     */
    public static String Computer_DeletePermission_Description() {
        return holder.format("Computer.DeletePermission.Description");
    }

    /**
     * Key {@code Computer.DeletePermission.Description}: {@code This
     * permission allows users to delete existing agents.}.
     * 
     * @return
     *     {@code This permission allows users to delete existing agents.}
     */
    public static Localizable _Computer_DeletePermission_Description() {
        return new Localizable(holder, "Computer.DeletePermission.Description");
    }

    /**
     * Key {@code ResultTrend.NotBuilt}: {@code Not built}.
     * 
     * @return
     *     {@code Not built}
     */
    public static String ResultTrend_NotBuilt() {
        return holder.format("ResultTrend.NotBuilt");
    }

    /**
     * Key {@code ResultTrend.NotBuilt}: {@code Not built}.
     * 
     * @return
     *     {@code Not built}
     */
    public static Localizable _ResultTrend_NotBuilt() {
        return new Localizable(holder, "ResultTrend.NotBuilt");
    }

    /**
     * Key {@code AbstractItem.NoSuchJobExists}: {@code No such job â{0}â
     * exists. Perhaps you meant â{1}â?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such job â{0}â exists. Perhaps you meant â{1}â?}
     */
    public static String AbstractItem_NoSuchJobExists(Object arg0, Object arg1) {
        return holder.format("AbstractItem.NoSuchJobExists", arg0, arg1);
    }

    /**
     * Key {@code AbstractItem.NoSuchJobExists}: {@code No such job â{0}â
     * exists. Perhaps you meant â{1}â?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such job â{0}â exists. Perhaps you meant â{1}â?}
     */
    public static Localizable _AbstractItem_NoSuchJobExists(Object arg0, Object arg1) {
        return new Localizable(holder, "AbstractItem.NoSuchJobExists", arg0, arg1);
    }

    /**
     * Key {@code Permalink.LastCompletedBuild}: {@code Last completed
     * build}.
     * 
     * @return
     *     {@code Last completed build}
     */
    public static String Permalink_LastCompletedBuild() {
        return holder.format("Permalink.LastCompletedBuild");
    }

    /**
     * Key {@code Permalink.LastCompletedBuild}: {@code Last completed
     * build}.
     * 
     * @return
     *     {@code Last completed build}
     */
    public static Localizable _Permalink_LastCompletedBuild() {
        return new Localizable(holder, "Permalink.LastCompletedBuild");
    }

    /**
     * Key {@code Permalink.LastSuccessfulBuild}: {@code Last successful
     * build}.
     * 
     * @return
     *     {@code Last successful build}
     */
    public static String Permalink_LastSuccessfulBuild() {
        return holder.format("Permalink.LastSuccessfulBuild");
    }

    /**
     * Key {@code Permalink.LastSuccessfulBuild}: {@code Last successful
     * build}.
     * 
     * @return
     *     {@code Last successful build}
     */
    public static Localizable _Permalink_LastSuccessfulBuild() {
        return new Localizable(holder, "Permalink.LastSuccessfulBuild");
    }

    /**
     * Key {@code AbstractBuild_Building}: {@code Building}.
     * 
     * @return
     *     {@code Building}
     */
    public static String AbstractBuild_Building() {
        return holder.format("AbstractBuild_Building");
    }

    /**
     * Key {@code AbstractBuild_Building}: {@code Building}.
     * 
     * @return
     *     {@code Building}
     */
    public static Localizable _AbstractBuild_Building() {
        return new Localizable(holder, "AbstractBuild_Building");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.report}: {@code Build Reports}.
     * 
     * @return
     *     {@code Build Reports}
     */
    public static String UpdateCenter_PluginCategory_report() {
        return holder.format("UpdateCenter.PluginCategory.report");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.report}: {@code Build Reports}.
     * 
     * @return
     *     {@code Build Reports}
     */
    public static Localizable _UpdateCenter_PluginCategory_report() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.report");
    }

    /**
     * Key {@code LoadStatistics.Legends.BusyExecutors}: {@code Busy
     * executors}.
     * 
     * @return
     *     {@code Busy executors}
     */
    public static String LoadStatistics_Legends_BusyExecutors() {
        return holder.format("LoadStatistics.Legends.BusyExecutors");
    }

    /**
     * Key {@code LoadStatistics.Legends.BusyExecutors}: {@code Busy
     * executors}.
     * 
     * @return
     *     {@code Busy executors}
     */
    public static Localizable _LoadStatistics_Legends_BusyExecutors() {
        return new Localizable(holder, "LoadStatistics.Legends.BusyExecutors");
    }

    /**
     * Key {@code AbstractProject.WorkspaceTitle}: {@code Workspace of {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Workspace of {0}}
     */
    public static String AbstractProject_WorkspaceTitle(Object arg0) {
        return holder.format("AbstractProject.WorkspaceTitle", arg0);
    }

    /**
     * Key {@code AbstractProject.WorkspaceTitle}: {@code Workspace of {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Workspace of {0}}
     */
    public static Localizable _AbstractProject_WorkspaceTitle(Object arg0) {
        return new Localizable(holder, "AbstractProject.WorkspaceTitle", arg0);
    }

    /**
     * Key {@code LabelExpression.NoMatch}: {@code No agent/cloud matches
     * this label expression.}.
     * 
     * @return
     *     {@code No agent/cloud matches this label expression.}
     */
    public static String LabelExpression_NoMatch() {
        return holder.format("LabelExpression.NoMatch");
    }

    /**
     * Key {@code LabelExpression.NoMatch}: {@code No agent/cloud matches
     * this label expression.}.
     * 
     * @return
     *     {@code No agent/cloud matches this label expression.}
     */
    public static Localizable _LabelExpression_NoMatch() {
        return new Localizable(holder, "LabelExpression.NoMatch");
    }

    /**
     * Key {@code BallColor.Disabled}: {@code Disabled}.
     * 
     * @return
     *     {@code Disabled}
     */
    public static String BallColor_Disabled() {
        return holder.format("BallColor.Disabled");
    }

    /**
     * Key {@code BallColor.Disabled}: {@code Disabled}.
     * 
     * @return
     *     {@code Disabled}
     */
    public static Localizable _BallColor_Disabled() {
        return new Localizable(holder, "BallColor.Disabled");
    }

    /**
     * Key {@code BallColor.Success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static String BallColor_Success() {
        return holder.format("BallColor.Success");
    }

    /**
     * Key {@code BallColor.Success}: {@code Success}.
     * 
     * @return
     *     {@code Success}
     */
    public static Localizable _BallColor_Success() {
        return new Localizable(holder, "BallColor.Success");
    }

    /**
     * Key {@code Run.Permissions.Title}: {@code Run}.
     * 
     * @return
     *     {@code Run}
     */
    public static String Run_Permissions_Title() {
        return holder.format("Run.Permissions.Title");
    }

    /**
     * Key {@code Run.Permissions.Title}: {@code Run}.
     * 
     * @return
     *     {@code Run}
     */
    public static Localizable _Run_Permissions_Title() {
        return new Localizable(holder, "Run.Permissions.Title");
    }

    /**
     * Key {@code AbstractProject.NoBuilds}: {@code No existing build.
     * Scheduling a new one.}.
     * 
     * @return
     *     {@code No existing build. Scheduling a new one.}
     */
    public static String AbstractProject_NoBuilds() {
        return holder.format("AbstractProject.NoBuilds");
    }

    /**
     * Key {@code AbstractProject.NoBuilds}: {@code No existing build.
     * Scheduling a new one.}.
     * 
     * @return
     *     {@code No existing build. Scheduling a new one.}
     */
    public static Localizable _AbstractProject_NoBuilds() {
        return new Localizable(holder, "AbstractProject.NoBuilds");
    }

    /**
     * Key {@code Cause.UserIdCause.ShortDescription}: {@code Started by user
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by user {0}}
     */
    public static String Cause_UserIdCause_ShortDescription(Object arg0) {
        return holder.format("Cause.UserIdCause.ShortDescription", arg0);
    }

    /**
     * Key {@code Cause.UserIdCause.ShortDescription}: {@code Started by user
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by user {0}}
     */
    public static Localizable _Cause_UserIdCause_ShortDescription(Object arg0) {
        return new Localizable(holder, "Cause.UserIdCause.ShortDescription", arg0);
    }

    /**
     * Key {@code BallColor.Unstable}: {@code Unstable}.
     * 
     * @return
     *     {@code Unstable}
     */
    public static String BallColor_Unstable() {
        return holder.format("BallColor.Unstable");
    }

    /**
     * Key {@code BallColor.Unstable}: {@code Unstable}.
     * 
     * @return
     *     {@code Unstable}
     */
    public static Localizable _BallColor_Unstable() {
        return new Localizable(holder, "BallColor.Unstable");
    }

    /**
     * Key {@code Computer.Permissions.Title}: {@code Agent}.
     * 
     * @return
     *     {@code Agent}
     */
    public static String Computer_Permissions_Title() {
        return holder.format("Computer.Permissions.Title");
    }

    /**
     * Key {@code Computer.Permissions.Title}: {@code Agent}.
     * 
     * @return
     *     {@code Agent}
     */
    public static Localizable _Computer_Permissions_Title() {
        return new Localizable(holder, "Computer.Permissions.Title");
    }

    /**
     * Key {@code View.DeletePermission.Description}: {@code This permission
     * allows users to delete existing views.}.
     * 
     * @return
     *     {@code This permission allows users to delete existing views.}
     */
    public static String View_DeletePermission_Description() {
        return holder.format("View.DeletePermission.Description");
    }

    /**
     * Key {@code View.DeletePermission.Description}: {@code This permission
     * allows users to delete existing views.}.
     * 
     * @return
     *     {@code This permission allows users to delete existing views.}
     */
    public static Localizable _View_DeletePermission_Description() {
        return new Localizable(holder, "View.DeletePermission.Description");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.api-plugin}: {@code Library
     * plugins (for use by other plugins)}.
     * 
     * @return
     *     {@code Library plugins (for use by other plugins)}
     */
    public static String UpdateCenter_PluginCategory_api_plugin() {
        return holder.format("UpdateCenter.PluginCategory.api-plugin");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.api-plugin}: {@code Library
     * plugins (for use by other plugins)}.
     * 
     * @return
     *     {@code Library plugins (for use by other plugins)}
     */
    public static Localizable _UpdateCenter_PluginCategory_api_plugin() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.api-plugin");
    }

    /**
     * Key {@code Run.DeletePermission.Description}: {@code This permission
     * allows users to manually delete specific builds from the build
     * history.}.
     * 
     * @return
     *     {@code This permission allows users to manually delete specific builds
     *     from the build history.}
     */
    public static String Run_DeletePermission_Description() {
        return holder.format("Run.DeletePermission.Description");
    }

    /**
     * Key {@code Run.DeletePermission.Description}: {@code This permission
     * allows users to manually delete specific builds from the build
     * history.}.
     * 
     * @return
     *     {@code This permission allows users to manually delete specific builds
     *     from the build history.}
     */
    public static Localizable _Run_DeletePermission_Description() {
        return new Localizable(holder, "Run.DeletePermission.Description");
    }

    /**
     * Key {@code AbstractProject.AwaitingBuildForWorkspace}: {@code Awaiting
     * build to get a workspace.}.
     * 
     * @return
     *     {@code Awaiting build to get a workspace.}
     */
    public static String AbstractProject_AwaitingBuildForWorkspace() {
        return holder.format("AbstractProject.AwaitingBuildForWorkspace");
    }

    /**
     * Key {@code AbstractProject.AwaitingBuildForWorkspace}: {@code Awaiting
     * build to get a workspace.}.
     * 
     * @return
     *     {@code Awaiting build to get a workspace.}
     */
    public static Localizable _AbstractProject_AwaitingBuildForWorkspace() {
        return new Localizable(holder, "AbstractProject.AwaitingBuildForWorkspace");
    }

    /**
     * Key {@code Hudson.NotANegativeNumber}: {@code Not a negative number}.
     * 
     * @return
     *     {@code Not a negative number}
     */
    public static String Hudson_NotANegativeNumber() {
        return holder.format("Hudson.NotANegativeNumber");
    }

    /**
     * Key {@code Hudson.NotANegativeNumber}: {@code Not a negative number}.
     * 
     * @return
     *     {@code Not a negative number}
     */
    public static Localizable _Hudson_NotANegativeNumber() {
        return new Localizable(holder, "Hudson.NotANegativeNumber");
    }

    /**
     * Key {@code AbstractProject.NoWorkspace}: {@code No workspace is
     * available, so canât check for updates.}.
     * 
     * @return
     *     {@code No workspace is available, so canât check for updates.}
     */
    public static String AbstractProject_NoWorkspace() {
        return holder.format("AbstractProject.NoWorkspace");
    }

    /**
     * Key {@code AbstractProject.NoWorkspace}: {@code No workspace is
     * available, so canât check for updates.}.
     * 
     * @return
     *     {@code No workspace is available, so canât check for updates.}
     */
    public static Localizable _AbstractProject_NoWorkspace() {
        return new Localizable(holder, "AbstractProject.NoWorkspace");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.ios}: {@code iOS Development}.
     * 
     * @return
     *     {@code iOS Development}
     */
    public static String UpdateCenter_PluginCategory_ios() {
        return holder.format("UpdateCenter.PluginCategory.ios");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.ios}: {@code iOS Development}.
     * 
     * @return
     *     {@code iOS Development}
     */
    public static Localizable _UpdateCenter_PluginCategory_ios() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.ios");
    }

    /**
     * Key {@code Job.AllRecentBuildFailed}: {@code All recent builds
     * failed.}.
     * 
     * @return
     *     {@code All recent builds failed.}
     */
    public static String Job_AllRecentBuildFailed() {
        return holder.format("Job.AllRecentBuildFailed");
    }

    /**
     * Key {@code Job.AllRecentBuildFailed}: {@code All recent builds
     * failed.}.
     * 
     * @return
     *     {@code All recent builds failed.}
     */
    public static Localizable _Job_AllRecentBuildFailed() {
        return new Localizable(holder, "Job.AllRecentBuildFailed");
    }

    /**
     * Key {@code ResultTrend.Fixed}: {@code Fixed}.
     * 
     * @return
     *     {@code Fixed}
     */
    public static String ResultTrend_Fixed() {
        return holder.format("ResultTrend.Fixed");
    }

    /**
     * Key {@code ResultTrend.Fixed}: {@code Fixed}.
     * 
     * @return
     *     {@code Fixed}
     */
    public static Localizable _ResultTrend_Fixed() {
        return new Localizable(holder, "ResultTrend.Fixed");
    }

    /**
     * Key {@code AbstractProject.WipeOutPermission.Description}: {@code This
     * permission grants the ability to wipe out the contents of a
     * workspace.}.
     * 
     * @return
     *     {@code This permission grants the ability to wipe out the contents of
     *     a workspace.}
     */
    public static String AbstractProject_WipeOutPermission_Description() {
        return holder.format("AbstractProject.WipeOutPermission.Description");
    }

    /**
     * Key {@code AbstractProject.WipeOutPermission.Description}: {@code This
     * permission grants the ability to wipe out the contents of a
     * workspace.}.
     * 
     * @return
     *     {@code This permission grants the ability to wipe out the contents of
     *     a workspace.}
     */
    public static Localizable _AbstractProject_WipeOutPermission_Description() {
        return new Localizable(holder, "AbstractProject.WipeOutPermission.Description");
    }

    /**
     * Key {@code Computer.Caption}: {@code Agent {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Agent {0}}
     */
    public static String Computer_Caption(Object arg0) {
        return holder.format("Computer.Caption", arg0);
    }

    /**
     * Key {@code Computer.Caption}: {@code Agent {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Agent {0}}
     */
    public static Localizable _Computer_Caption(Object arg0) {
        return new Localizable(holder, "Computer.Caption", arg0);
    }

    /**
     * Key {@code AbstractProject.CustomWorkspaceEmpty}: {@code Custom
     * workspace is empty.}.
     * 
     * @return
     *     {@code Custom workspace is empty.}
     */
    public static String AbstractProject_CustomWorkspaceEmpty() {
        return holder.format("AbstractProject.CustomWorkspaceEmpty");
    }

    /**
     * Key {@code AbstractProject.CustomWorkspaceEmpty}: {@code Custom
     * workspace is empty.}.
     * 
     * @return
     *     {@code Custom workspace is empty.}
     */
    public static Localizable _AbstractProject_CustomWorkspaceEmpty() {
        return new Localizable(holder, "AbstractProject.CustomWorkspaceEmpty");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.database}: {@code Database}.
     * 
     * @return
     *     {@code Database}
     */
    public static String UpdateCenter_PluginCategory_database() {
        return holder.format("UpdateCenter.PluginCategory.database");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.database}: {@code Database}.
     * 
     * @return
     *     {@code Database}
     */
    public static Localizable _UpdateCenter_PluginCategory_database() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.database");
    }

    /**
     * Key {@code UpdateCenter.Status.UnknownHostException}: {@code <span
     * class=error>Failed to resolve host name {0}. Perhaps you need to <a
     * href="{1}manage/pluginManager/advanced">configure HTTP
     * proxy?</a></span>}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code <span class=error>Failed to resolve host name {0}. Perhaps you
     *     need to <a href="{1}manage/pluginManager/advanced">configure HTTP
     *     proxy?</a></span>}
     */
    public static String UpdateCenter_Status_UnknownHostException(Object arg0, Object arg1) {
        return holder.format("UpdateCenter.Status.UnknownHostException", arg0, arg1);
    }

    /**
     * Key {@code UpdateCenter.Status.UnknownHostException}: {@code <span
     * class=error>Failed to resolve host name {0}. Perhaps you need to <a
     * href="{1}manage/pluginManager/advanced">configure HTTP
     * proxy?</a></span>}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code <span class=error>Failed to resolve host name {0}. Perhaps you
     *     need to <a href="{1}manage/pluginManager/advanced">configure HTTP
     *     proxy?</a></span>}
     */
    public static Localizable _UpdateCenter_Status_UnknownHostException(Object arg0, Object arg1) {
        return new Localizable(holder, "UpdateCenter.Status.UnknownHostException", arg0, arg1);
    }

    /**
     * Key {@code Jenkins.IsRestarting}: {@code Jenkins is restarting}.
     * 
     * @return
     *     {@code Jenkins is restarting}
     */
    public static String Jenkins_IsRestarting() {
        return holder.format("Jenkins.IsRestarting");
    }

    /**
     * Key {@code Jenkins.IsRestarting}: {@code Jenkins is restarting}.
     * 
     * @return
     *     {@code Jenkins is restarting}
     */
    public static Localizable _Jenkins_IsRestarting() {
        return new Localizable(holder, "Jenkins.IsRestarting");
    }

    /**
     * Key {@code Queue.HudsonIsAboutToShutDown}: {@code Jenkins is about to
     * shut down}.
     * 
     * @return
     *     {@code Jenkins is about to shut down}
     */
    public static String Queue_HudsonIsAboutToShutDown() {
        return holder.format("Queue.HudsonIsAboutToShutDown");
    }

    /**
     * Key {@code Queue.HudsonIsAboutToShutDown}: {@code Jenkins is about to
     * shut down}.
     * 
     * @return
     *     {@code Jenkins is about to shut down}
     */
    public static Localizable _Queue_HudsonIsAboutToShutDown() {
        return new Localizable(holder, "Queue.HudsonIsAboutToShutDown");
    }

    /**
     * Key {@code Slave.InvalidConfig.Executors}: {@code Invalid agent
     * configuration for {0}. Invalid number of executors.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid agent configuration for {0}. Invalid number of
     *     executors.}
     */
    public static String Slave_InvalidConfig_Executors(Object arg0) {
        return holder.format("Slave.InvalidConfig.Executors", arg0);
    }

    /**
     * Key {@code Slave.InvalidConfig.Executors}: {@code Invalid agent
     * configuration for {0}. Invalid number of executors.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Invalid agent configuration for {0}. Invalid number of
     *     executors.}
     */
    public static Localizable _Slave_InvalidConfig_Executors(Object arg0) {
        return new Localizable(holder, "Slave.InvalidConfig.Executors", arg0);
    }

    /**
     * Key {@code Slave.Network.Mounted.File.System.Warning}: {@code Are you
     * sure you want to use network mounted file system for FS root? Note
     * that this directory does not need to be visible to the controller.}.
     * 
     * @return
     *     {@code Are you sure you want to use network mounted file system for FS
     *     root? Note that this directory does not need to be visible to the
     *     controller.}
     */
    public static String Slave_Network_Mounted_File_System_Warning() {
        return holder.format("Slave.Network.Mounted.File.System.Warning");
    }

    /**
     * Key {@code Slave.Network.Mounted.File.System.Warning}: {@code Are you
     * sure you want to use network mounted file system for FS root? Note
     * that this directory does not need to be visible to the controller.}.
     * 
     * @return
     *     {@code Are you sure you want to use network mounted file system for FS
     *     root? Note that this directory does not need to be visible to the
     *     controller.}
     */
    public static Localizable _Slave_Network_Mounted_File_System_Warning() {
        return new Localizable(holder, "Slave.Network.Mounted.File.System.Warning");
    }

    /**
     * Key {@code AbstractProject.WorkspaceTitleOnComputer}: {@code Workspace
     * of {0} on {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Workspace of {0} on {1}}
     */
    public static String AbstractProject_WorkspaceTitleOnComputer(Object arg0, Object arg1) {
        return holder.format("AbstractProject.WorkspaceTitleOnComputer", arg0, arg1);
    }

    /**
     * Key {@code AbstractProject.WorkspaceTitleOnComputer}: {@code Workspace
     * of {0} on {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Workspace of {0} on {1}}
     */
    public static Localizable _AbstractProject_WorkspaceTitleOnComputer(Object arg0, Object arg1) {
        return new Localizable(holder, "AbstractProject.WorkspaceTitleOnComputer", arg0, arg1);
    }

    /**
     * Key {@code Hudson.BadPortNumber}: {@code Bad port number {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Bad port number {0}}
     */
    public static String Hudson_BadPortNumber(Object arg0) {
        return holder.format("Hudson.BadPortNumber", arg0);
    }

    /**
     * Key {@code Hudson.BadPortNumber}: {@code Bad port number {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Bad port number {0}}
     */
    public static Localizable _Hudson_BadPortNumber(Object arg0) {
        return new Localizable(holder, "Hudson.BadPortNumber", arg0);
    }

    /**
     * Key {@code Cause.UpstreamCause.CausedBy}: {@code originally caused
     * by:}.
     * 
     * @return
     *     {@code originally caused by:}
     */
    public static String Cause_UpstreamCause_CausedBy() {
        return holder.format("Cause.UpstreamCause.CausedBy");
    }

    /**
     * Key {@code Cause.UpstreamCause.CausedBy}: {@code originally caused
     * by:}.
     * 
     * @return
     *     {@code originally caused by:}
     */
    public static Localizable _Cause_UpstreamCause_CausedBy() {
        return new Localizable(holder, "Cause.UpstreamCause.CausedBy");
    }

    /**
     * Key {@code UpdateCenter.n_a}: {@code N/A}.
     * 
     * @return
     *     {@code N/A}
     */
    public static String UpdateCenter_n_a() {
        return holder.format("UpdateCenter.n_a");
    }

    /**
     * Key {@code UpdateCenter.n_a}: {@code N/A}.
     * 
     * @return
     *     {@code N/A}
     */
    public static Localizable _UpdateCenter_n_a() {
        return new Localizable(holder, "UpdateCenter.n_a");
    }

    /**
     * Key {@code Hudson.Computer.DisplayName}: {@code Built-In Node}.
     * 
     * @return
     *     {@code Built-In Node}
     */
    public static String Hudson_Computer_DisplayName() {
        return holder.format("Hudson.Computer.DisplayName");
    }

    /**
     * Key {@code Hudson.Computer.DisplayName}: {@code Built-In Node}.
     * 
     * @return
     *     {@code Built-In Node}
     */
    public static Localizable _Hudson_Computer_DisplayName() {
        return new Localizable(holder, "Hudson.Computer.DisplayName");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.scm}: {@code Source Code
     * Management}.
     * 
     * @return
     *     {@code Source Code Management}
     */
    public static String UpdateCenter_PluginCategory_scm() {
        return holder.format("UpdateCenter.PluginCategory.scm");
    }

    /**
     * Key {@code UpdateCenter.PluginCategory.scm}: {@code Source Code
     * Management}.
     * 
     * @return
     *     {@code Source Code Management}
     */
    public static Localizable _UpdateCenter_PluginCategory_scm() {
        return new Localizable(holder, "UpdateCenter.PluginCategory.scm");
    }

    /**
     * Key {@code Hudson.AdministerPermission.Description}: {@code This
     * permission grants the ability to make system-wide configuration
     * changes, as well as perform highly sensitive operations that amounts
     * to full local system access (within the scope granted by the
     * underlying OS.)}.
     * 
     * @return
     *     {@code This permission grants the ability to make system-wide
     *     configuration changes, as well as perform highly sensitive operations
     *     that amounts to full local system access (within the scope granted by
     *     the underlying OS.)}
     */
    public static String Hudson_AdministerPermission_Description() {
        return holder.format("Hudson.AdministerPermission.Description");
    }

    /**
     * Key {@code Hudson.AdministerPermission.Description}: {@code This
     * permission grants the ability to make system-wide configuration
     * changes, as well as perform highly sensitive operations that amounts
     * to full local system access (within the scope granted by the
     * underlying OS.)}.
     * 
     * @return
     *     {@code This permission grants the ability to make system-wide
     *     configuration changes, as well as perform highly sensitive operations
     *     that amounts to full local system access (within the scope granted by
     *     the underlying OS.)}
     */
    public static Localizable _Hudson_AdministerPermission_Description() {
        return new Localizable(holder, "Hudson.AdministerPermission.Description");
    }

    /**
     * Key {@code Run.Summary.BrokenForALongTime}: {@code broken for a long
     * time}.
     * 
     * @return
     *     {@code broken for a long time}
     */
    public static String Run_Summary_BrokenForALongTime() {
        return holder.format("Run.Summary.BrokenForALongTime");
    }

    /**
     * Key {@code Run.Summary.BrokenForALongTime}: {@code broken for a long
     * time}.
     * 
     * @return
     *     {@code broken for a long time}
     */
    public static Localizable _Run_Summary_BrokenForALongTime() {
        return new Localizable(holder, "Run.Summary.BrokenForALongTime");
    }

    /**
     * Key {@code Run.Summary.Unknown}: {@code ?}.
     * 
     * @return
     *     {@code ?}
     */
    public static String Run_Summary_Unknown() {
        return holder.format("Run.Summary.Unknown");
    }

    /**
     * Key {@code Run.Summary.Unknown}: {@code ?}.
     * 
     * @return
     *     {@code ?}
     */
    public static Localizable _Run_Summary_Unknown() {
        return new Localizable(holder, "Run.Summary.Unknown");
    }

    /**
     * Key {@code Job.NoRenameWhileBuilding}: {@code Unable to rename a job
     * while it is building.}.
     * 
     * @return
     *     {@code Unable to rename a job while it is building.}
     */
    public static String Job_NoRenameWhileBuilding() {
        return holder.format("Job.NoRenameWhileBuilding");
    }

    /**
     * Key {@code Job.NoRenameWhileBuilding}: {@code Unable to rename a job
     * while it is building.}.
     * 
     * @return
     *     {@code Unable to rename a job while it is building.}
     */
    public static Localizable _Job_NoRenameWhileBuilding() {
        return new Localizable(holder, "Job.NoRenameWhileBuilding");
    }

    /**
     * Key {@code Jenkins.CheckDisplayName.NameNotUniqueWarning}: {@code The
     * display name, "{0}", is used as a name by a job and could cause
     * confusing search results.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The display name, "{0}", is used as a name by a job and could
     *     cause confusing search results.}
     */
    public static String Jenkins_CheckDisplayName_NameNotUniqueWarning(Object arg0) {
        return holder.format("Jenkins.CheckDisplayName.NameNotUniqueWarning", arg0);
    }

    /**
     * Key {@code Jenkins.CheckDisplayName.NameNotUniqueWarning}: {@code The
     * display name, "{0}", is used as a name by a job and could cause
     * confusing search results.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The display name, "{0}", is used as a name by a job and could
     *     cause confusing search results.}
     */
    public static Localizable _Jenkins_CheckDisplayName_NameNotUniqueWarning(Object arg0) {
        return new Localizable(holder, "Jenkins.CheckDisplayName.NameNotUniqueWarning", arg0);
    }

}
