// CHECKSTYLE:OFF

package jenkins.security;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ApiTokenProperty.LegacyTokenName}: {@code Legacy Token}.
     * 
     * @return
     *     {@code Legacy Token}
     */
    public static String ApiTokenProperty_LegacyTokenName() {
        return holder.format("ApiTokenProperty.LegacyTokenName");
    }

    /**
     * Key {@code ApiTokenProperty.LegacyTokenName}: {@code Legacy Token}.
     * 
     * @return
     *     {@code Legacy Token}
     */
    public static Localizable _ApiTokenProperty_LegacyTokenName() {
        return new Localizable(holder, "ApiTokenProperty.LegacyTokenName");
    }

    /**
     * Key {@code ApiTokenProperty.NoLegacyToken}: {@code This user currently
     * does not have a legacy token}.
     * 
     * @return
     *     {@code This user currently does not have a legacy token}
     */
    public static String ApiTokenProperty_NoLegacyToken() {
        return holder.format("ApiTokenProperty.NoLegacyToken");
    }

    /**
     * Key {@code ApiTokenProperty.NoLegacyToken}: {@code This user currently
     * does not have a legacy token}.
     * 
     * @return
     *     {@code This user currently does not have a legacy token}
     */
    public static Localizable _ApiTokenProperty_NoLegacyToken() {
        return new Localizable(holder, "ApiTokenProperty.NoLegacyToken");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.TokenIsHidden}: {@code Token
     * is hidden}.
     * 
     * @return
     *     {@code Token is hidden}
     */
    public static String ApiTokenProperty_ChangeToken_TokenIsHidden() {
        return holder.format("ApiTokenProperty.ChangeToken.TokenIsHidden");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.TokenIsHidden}: {@code Token
     * is hidden}.
     * 
     * @return
     *     {@code Token is hidden}
     */
    public static Localizable _ApiTokenProperty_ChangeToken_TokenIsHidden() {
        return new Localizable(holder, "ApiTokenProperty.ChangeToken.TokenIsHidden");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.Success}: {@code <div>Updated.
     * See the new token in the field above</div>}.
     * 
     * @return
     *     {@code <div>Updated. See the new token in the field above</div>}
     */
    public static String ApiTokenProperty_ChangeToken_Success() {
        return holder.format("ApiTokenProperty.ChangeToken.Success");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.Success}: {@code <div>Updated.
     * See the new token in the field above</div>}.
     * 
     * @return
     *     {@code <div>Updated. See the new token in the field above</div>}
     */
    public static Localizable _ApiTokenProperty_ChangeToken_Success() {
        return new Localizable(holder, "ApiTokenProperty.ChangeToken.Success");
    }

    /**
     * Key {@code RekeySecretAdminMonitor.DisplayName}: {@code Re-keying}.
     * 
     * @return
     *     {@code Re-keying}
     */
    public static String RekeySecretAdminMonitor_DisplayName() {
        return holder.format("RekeySecretAdminMonitor.DisplayName");
    }

    /**
     * Key {@code RekeySecretAdminMonitor.DisplayName}: {@code Re-keying}.
     * 
     * @return
     *     {@code Re-keying}
     */
    public static Localizable _RekeySecretAdminMonitor_DisplayName() {
        return new Localizable(holder, "RekeySecretAdminMonitor.DisplayName");
    }

    /**
     * Key {@code UpdateSiteWarningsMonitor.DisplayName}: {@code Update Site
     * Warnings}.
     * 
     * @return
     *     {@code Update Site Warnings}
     */
    public static String UpdateSiteWarningsMonitor_DisplayName() {
        return holder.format("UpdateSiteWarningsMonitor.DisplayName");
    }

    /**
     * Key {@code UpdateSiteWarningsMonitor.DisplayName}: {@code Update Site
     * Warnings}.
     * 
     * @return
     *     {@code Update Site Warnings}
     */
    public static Localizable _UpdateSiteWarningsMonitor_DisplayName() {
        return new Localizable(holder, "UpdateSiteWarningsMonitor.DisplayName");
    }

    /**
     * Key {@code ResourceDomainConfiguration.FailedIdentityCheck}: {@code An
     * error occurred when checking the instance identity at that URL: {0}
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred when checking the instance identity at that
     *     URL: {0} {1}}
     */
    public static String ResourceDomainConfiguration_FailedIdentityCheck(Object arg0, Object arg1) {
        return holder.format("ResourceDomainConfiguration.FailedIdentityCheck", arg0, arg1);
    }

    /**
     * Key {@code ResourceDomainConfiguration.FailedIdentityCheck}: {@code An
     * error occurred when checking the instance identity at that URL: {0}
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred when checking the instance identity at that
     *     URL: {0} {1}}
     */
    public static Localizable _ResourceDomainConfiguration_FailedIdentityCheck(Object arg0, Object arg1) {
        return new Localizable(holder, "ResourceDomainConfiguration.FailedIdentityCheck", arg0, arg1);
    }

    /**
     * Key {@code ResourceDomainConfiguration.InvalidRootURL}: {@code Jenkins
     * URL is set to an invalid value, please report a bug: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Jenkins URL is set to an invalid value, please report a bug:
     *     {0}}
     */
    public static String ResourceDomainConfiguration_InvalidRootURL(Object arg0) {
        return holder.format("ResourceDomainConfiguration.InvalidRootURL", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.InvalidRootURL}: {@code Jenkins
     * URL is set to an invalid value, please report a bug: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Jenkins URL is set to an invalid value, please report a bug:
     *     {0}}
     */
    public static Localizable _ResourceDomainConfiguration_InvalidRootURL(Object arg0) {
        return new Localizable(holder, "ResourceDomainConfiguration.InvalidRootURL", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.SuccessHidden}: {@code
     * <div>Updated. You need to login as the user to see the token</div>}.
     * 
     * @return
     *     {@code <div>Updated. You need to login as the user to see the
     *     token</div>}
     */
    public static String ApiTokenProperty_ChangeToken_SuccessHidden() {
        return holder.format("ApiTokenProperty.ChangeToken.SuccessHidden");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.SuccessHidden}: {@code
     * <div>Updated. You need to login as the user to see the token</div>}.
     * 
     * @return
     *     {@code <div>Updated. You need to login as the user to see the
     *     token</div>}
     */
    public static Localizable _ApiTokenProperty_ChangeToken_SuccessHidden() {
        return new Localizable(holder, "ApiTokenProperty.ChangeToken.SuccessHidden");
    }

    /**
     * Key {@code ResourceDomainConfiguration.DisplayName}: {@code Resource
     * Domain Recommendation}.
     * 
     * @return
     *     {@code Resource Domain Recommendation}
     */
    public static String ResourceDomainConfiguration_DisplayName() {
        return holder.format("ResourceDomainConfiguration.DisplayName");
    }

    /**
     * Key {@code ResourceDomainConfiguration.DisplayName}: {@code Resource
     * Domain Recommendation}.
     * 
     * @return
     *     {@code Resource Domain Recommendation}
     */
    public static Localizable _ResourceDomainConfiguration_DisplayName() {
        return new Localizable(holder, "ResourceDomainConfiguration.DisplayName");
    }

    /**
     * Key {@code ResourceDomainConfiguration.Empty}: {@code Without a
     * resource root URL, resources will be served from the Jenkins URL with
     * Content-Security-Policy set.}.
     * 
     * @return
     *     {@code Without a resource root URL, resources will be served from the
     *     Jenkins URL with Content-Security-Policy set.}
     */
    public static String ResourceDomainConfiguration_Empty() {
        return holder.format("ResourceDomainConfiguration.Empty");
    }

    /**
     * Key {@code ResourceDomainConfiguration.Empty}: {@code Without a
     * resource root URL, resources will be served from the Jenkins URL with
     * Content-Security-Policy set.}.
     * 
     * @return
     *     {@code Without a resource root URL, resources will be served from the
     *     Jenkins URL with Content-Security-Policy set.}
     */
    public static Localizable _ResourceDomainConfiguration_Empty() {
        return new Localizable(holder, "ResourceDomainConfiguration.Empty");
    }

    /**
     * Key {@code ResourceDomainConfiguration.OtherJenkins}: {@code The
     * specified URL points to a different Jenkins instance.}.
     * 
     * @return
     *     {@code The specified URL points to a different Jenkins instance.}
     */
    public static String ResourceDomainConfiguration_OtherJenkins() {
        return holder.format("ResourceDomainConfiguration.OtherJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.OtherJenkins}: {@code The
     * specified URL points to a different Jenkins instance.}.
     * 
     * @return
     *     {@code The specified URL points to a different Jenkins instance.}
     */
    public static Localizable _ResourceDomainConfiguration_OtherJenkins() {
        return new Localizable(holder, "ResourceDomainConfiguration.OtherJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.NotJenkins}: {@code The
     * specified URL does not appear to point to a Jenkins instance.}.
     * 
     * @return
     *     {@code The specified URL does not appear to point to a Jenkins
     *     instance.}
     */
    public static String ResourceDomainConfiguration_NotJenkins() {
        return holder.format("ResourceDomainConfiguration.NotJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.NotJenkins}: {@code The
     * specified URL does not appear to point to a Jenkins instance.}.
     * 
     * @return
     *     {@code The specified URL does not appear to point to a Jenkins
     *     instance.}
     */
    public static Localizable _ResourceDomainConfiguration_NotJenkins() {
        return new Localizable(holder, "ResourceDomainConfiguration.NotJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.NeedsRootURL}: {@code Can only
     * set resource root URL if Jenkins URL is set.}.
     * 
     * @return
     *     {@code Can only set resource root URL if Jenkins URL is set.}
     */
    public static String ResourceDomainConfiguration_NeedsRootURL() {
        return holder.format("ResourceDomainConfiguration.NeedsRootURL");
    }

    /**
     * Key {@code ResourceDomainConfiguration.NeedsRootURL}: {@code Can only
     * set resource root URL if Jenkins URL is set.}.
     * 
     * @return
     *     {@code Can only set resource root URL if Jenkins URL is set.}
     */
    public static Localizable _ResourceDomainConfiguration_NeedsRootURL() {
        return new Localizable(holder, "ResourceDomainConfiguration.NeedsRootURL");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.CapabilityNotAllowed}: {@code
     * <div>Capability to generate a legacy token without an existing one is
     * currently disabled in the security configuration</div>}.
     * 
     * @return
     *     {@code <div>Capability to generate a legacy token without an existing
     *     one is currently disabled in the security configuration</div>}
     */
    public static String ApiTokenProperty_ChangeToken_CapabilityNotAllowed() {
        return holder.format("ApiTokenProperty.ChangeToken.CapabilityNotAllowed");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.CapabilityNotAllowed}: {@code
     * <div>Capability to generate a legacy token without an existing one is
     * currently disabled in the security configuration</div>}.
     * 
     * @return
     *     {@code <div>Capability to generate a legacy token without an existing
     *     one is currently disabled in the security configuration</div>}
     */
    public static Localizable _ApiTokenProperty_ChangeToken_CapabilityNotAllowed() {
        return new Localizable(holder, "ApiTokenProperty.ChangeToken.CapabilityNotAllowed");
    }

    /**
     * Key {@code ResourceDomainConfiguration.IOException}: {@code Failed to
     * connect: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect: {0}}
     */
    public static String ResourceDomainConfiguration_IOException(Object arg0) {
        return holder.format("ResourceDomainConfiguration.IOException", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.IOException}: {@code Failed to
     * connect: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect: {0}}
     */
    public static Localizable _ResourceDomainConfiguration_IOException(Object arg0) {
        return new Localizable(holder, "ResourceDomainConfiguration.IOException", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.SomeJenkins}: {@code The
     * specified URL points to a Jenkins instance, but could not determine
     * whether it is this or another instance.}.
     * 
     * @return
     *     {@code The specified URL points to a Jenkins instance, but could not
     *     determine whether it is this or another instance.}
     */
    public static String ResourceDomainConfiguration_SomeJenkins() {
        return holder.format("ResourceDomainConfiguration.SomeJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.SomeJenkins}: {@code The
     * specified URL points to a Jenkins instance, but could not determine
     * whether it is this or another instance.}.
     * 
     * @return
     *     {@code The specified URL points to a Jenkins instance, but could not
     *     determine whether it is this or another instance.}
     */
    public static Localizable _ResourceDomainConfiguration_SomeJenkins() {
        return new Localizable(holder, "ResourceDomainConfiguration.SomeJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.Invalid}: {@code Not a valid
     * URL.}.
     * 
     * @return
     *     {@code Not a valid URL.}
     */
    public static String ResourceDomainConfiguration_Invalid() {
        return holder.format("ResourceDomainConfiguration.Invalid");
    }

    /**
     * Key {@code ResourceDomainConfiguration.Invalid}: {@code Not a valid
     * URL.}.
     * 
     * @return
     *     {@code Not a valid URL.}
     */
    public static Localizable _ResourceDomainConfiguration_Invalid() {
        return new Localizable(holder, "ResourceDomainConfiguration.Invalid");
    }

    /**
     * Key {@code ResourceDomainConfiguration.ResourceResponse}: {@code The
     * specified URL points to a previously set up resource root URL.}.
     * 
     * @return
     *     {@code The specified URL points to a previously set up resource root
     *     URL.}
     */
    public static String ResourceDomainConfiguration_ResourceResponse() {
        return holder.format("ResourceDomainConfiguration.ResourceResponse");
    }

    /**
     * Key {@code ResourceDomainConfiguration.ResourceResponse}: {@code The
     * specified URL points to a previously set up resource root URL.}.
     * 
     * @return
     *     {@code The specified URL points to a previously set up resource root
     *     URL.}
     */
    public static Localizable _ResourceDomainConfiguration_ResourceResponse() {
        return new Localizable(holder, "ResourceDomainConfiguration.ResourceResponse");
    }

    /**
     * Key {@code ApiTokenProperty.DisplayName}: {@code API Token}.
     * 
     * @return
     *     {@code API Token}
     */
    public static String ApiTokenProperty_DisplayName() {
        return holder.format("ApiTokenProperty.DisplayName");
    }

    /**
     * Key {@code ApiTokenProperty.DisplayName}: {@code API Token}.
     * 
     * @return
     *     {@code API Token}
     */
    public static Localizable _ApiTokenProperty_DisplayName() {
        return new Localizable(holder, "ApiTokenProperty.DisplayName");
    }

    /**
     * Key {@code ResourceDomainConfiguration.SameAsJenkinsRoot}: {@code
     * Cannot use the same host name for both Jenkins URL and resource root
     * URL.}.
     * 
     * @return
     *     {@code Cannot use the same host name for both Jenkins URL and resource
     *     root URL.}
     */
    public static String ResourceDomainConfiguration_SameAsJenkinsRoot() {
        return holder.format("ResourceDomainConfiguration.SameAsJenkinsRoot");
    }

    /**
     * Key {@code ResourceDomainConfiguration.SameAsJenkinsRoot}: {@code
     * Cannot use the same host name for both Jenkins URL and resource root
     * URL.}.
     * 
     * @return
     *     {@code Cannot use the same host name for both Jenkins URL and resource
     *     root URL.}
     */
    public static Localizable _ResourceDomainConfiguration_SameAsJenkinsRoot() {
        return new Localizable(holder, "ResourceDomainConfiguration.SameAsJenkinsRoot");
    }

    /**
     * Key {@code ResourceDomainConfiguration.SameAsCurrent}: {@code You are
     * currently accessing Jenkins through a URL similar to the proposed
     * resource root URL. Saving this URL might remove your access to
     * Jenkins.}.
     * 
     * @return
     *     {@code You are currently accessing Jenkins through a URL similar to
     *     the proposed resource root URL. Saving this URL might remove your
     *     access to Jenkins.}
     */
    public static String ResourceDomainConfiguration_SameAsCurrent() {
        return holder.format("ResourceDomainConfiguration.SameAsCurrent");
    }

    /**
     * Key {@code ResourceDomainConfiguration.SameAsCurrent}: {@code You are
     * currently accessing Jenkins through a URL similar to the proposed
     * resource root URL. Saving this URL might remove your access to
     * Jenkins.}.
     * 
     * @return
     *     {@code You are currently accessing Jenkins through a URL similar to
     *     the proposed resource root URL. Saving this URL might remove your
     *     access to Jenkins.}
     */
    public static Localizable _ResourceDomainConfiguration_SameAsCurrent() {
        return new Localizable(holder, "ResourceDomainConfiguration.SameAsCurrent");
    }

    /**
     * Key {@code ResourceDomainConfiguration.ThisJenkins}: {@code The
     * specified URL is a valid resource root URL candidate.}.
     * 
     * @return
     *     {@code The specified URL is a valid resource root URL candidate.}
     */
    public static String ResourceDomainConfiguration_ThisJenkins() {
        return holder.format("ResourceDomainConfiguration.ThisJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.ThisJenkins}: {@code The
     * specified URL is a valid resource root URL candidate.}.
     * 
     * @return
     *     {@code The specified URL is a valid resource root URL candidate.}
     */
    public static Localizable _ResourceDomainConfiguration_ThisJenkins() {
        return new Localizable(holder, "ResourceDomainConfiguration.ThisJenkins");
    }

    /**
     * Key {@code Token.Created.on}: {@code Token created on {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Token created on {0}}
     */
    public static String Token_Created_on(Object arg0) {
        return holder.format("Token.Created.on", arg0);
    }

    /**
     * Key {@code Token.Created.on}: {@code Token created on {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Token created on {0}}
     */
    public static Localizable _Token_Created_on(Object arg0) {
        return new Localizable(holder, "Token.Created.on", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.Exception}: {@code An exception
     * occurred with the URL: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An exception occurred with the URL: {0}}
     */
    public static String ResourceDomainConfiguration_Exception(Object arg0) {
        return holder.format("ResourceDomainConfiguration.Exception", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.Exception}: {@code An exception
     * occurred with the URL: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An exception occurred with the URL: {0}}
     */
    public static Localizable _ResourceDomainConfiguration_Exception(Object arg0) {
        return new Localizable(holder, "ResourceDomainConfiguration.Exception", arg0);
    }

}
