/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemVisitor;
import hudson.search.Search;
import hudson.search.UserSearchProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Flavor;

public class AutoCompletionCandidates
implements HttpResponse {
    private final List<String> values = new ArrayList<String>();

    public AutoCompletionCandidates add(String v) {
        this.values.add(v);
        return this;
    }

    public AutoCompletionCandidates add(String ... v) {
        this.values.addAll(Arrays.asList(v));
        return this;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object o) throws IOException, ServletException {
        Search.Result r = new Search.Result();
        for (String value : this.values) {
            r.suggestions.add(new Search.Item(value));
        }
        rsp.serveExposedBean(req, (Object)r, Flavor.JSON);
    }

    public static <T extends Item> AutoCompletionCandidates ofJobNames(Class<T> type, String value, @CheckForNull Item self, ItemGroup container) {
        if (self == container) {
            container = self.getParent();
        }
        return AutoCompletionCandidates.ofJobNames(type, value, container);
    }

    @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"}, justification="no big deal")
    public static <T extends Item> AutoCompletionCandidates ofJobNames(final Class<T> type, final String value, ItemGroup container) {
        class Visitor
        extends ItemVisitor {
            String prefix;

            Visitor(String prefix) {
                this.prefix = prefix;
            }

            @Override
            public void onItem(Item i) {
                boolean caseInsensitive;
                String itemName = this.contextualNameOf(i);
                if ((AutoCompletionCandidates.startsWithImpl(itemName, value, caseInsensitive = UserSearchProperty.isCaseInsensitive()) || AutoCompletionCandidates.startsWithImpl(value, itemName, caseInsensitive)) && (value.length() > itemName.length() || !itemName.substring(value.length()).contains("/")) && i.hasPermission(Item.READ)) {
                    if (type.isInstance(i) && AutoCompletionCandidates.startsWithImpl(itemName, value, caseInsensitive)) {
                        candidates.add(itemName);
                    }
                    String oldPrefix = this.prefix;
                    this.prefix = itemName;
                    super.onItem(i);
                    this.prefix = oldPrefix;
                }
            }

            private String contextualNameOf(Item i) {
                if (this.prefix.endsWith("/") || this.prefix.isEmpty()) {
                    return this.prefix + i.getName();
                }
                return this.prefix + "/" + i.getName();
            }
        }
        final AutoCompletionCandidates candidates = new AutoCompletionCandidates();
        if (container == null || container == Jenkins.get()) {
            new Visitor("").onItemGroup(Jenkins.get());
        } else {
            new Visitor("").onItemGroup(container);
            if (value.startsWith("/")) {
                new Visitor("/").onItemGroup(Jenkins.get());
            }
            Object p = "../";
            while (value.startsWith((String)p)) {
                container = ((Item)((Object)container)).getParent();
                new Visitor((String)p).onItemGroup(container);
                p = (String)p + "../";
            }
        }
        return candidates;
    }

    private static boolean startsWithImpl(String str, String prefix, boolean ignoreCase) {
        return ignoreCase ? StringUtils.startsWithIgnoreCase((String)str, (String)prefix) : str.startsWith(prefix);
    }
}

