/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.FileParameterValue;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class FileParameterDefinition
extends ParameterDefinition {
    @DataBoundConstructor
    public FileParameterDefinition(@NonNull String name) {
        super(name);
    }

    public FileParameterDefinition(@NonNull String name, @CheckForNull String description) {
        this(name);
        this.setDescription(description);
    }

    @Override
    public FileParameterValue createValue(StaplerRequest req, JSONObject jo) {
        FileParameterValue p = (FileParameterValue)req.bindJSON(FileParameterValue.class, jo);
        p.setLocation(this.getName());
        p.setDescription(this.getDescription());
        return p;
    }

    @Override
    public ParameterValue createValue(StaplerRequest req) {
        FileItem src;
        try {
            src = req.getFileItem(this.getName());
        }
        catch (IOException | ServletException e) {
            return null;
        }
        if (src == null) {
            return null;
        }
        FileParameterValue p = new FileParameterValue(this.getName(), src, this.getFileName(src.getName()));
        p.setDescription(this.getDescription());
        p.setLocation(this.getName());
        return p;
    }

    private String getFileName(String possiblyPathName) {
        possiblyPathName = possiblyPathName.substring(possiblyPathName.lastIndexOf(47) + 1);
        possiblyPathName = possiblyPathName.substring(possiblyPathName.lastIndexOf(92) + 1);
        return possiblyPathName;
    }

    @Override
    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        File local = Files.createTempFile("jenkins", "parameter", new FileAttribute[0]).toFile();
        if (!value.isEmpty()) {
            command.checkChannel();
            return null;
        }
        FileUtils.copyInputStreamToFile((InputStream)command.stdin, (File)local);
        String name = "stdin";
        FileParameterValue p = new FileParameterValue(this.getName(), local, name);
        p.setDescription(this.getDescription());
        p.setLocation(this.getName());
        return p;
    }

    @Override
    public int hashCode() {
        if (FileParameterDefinition.class != this.getClass()) {
            return super.hashCode();
        }
        return Objects.hash(this.getName(), this.getDescription());
    }

    @Override
    @SuppressFBWarnings(value={"EQ_GETCLASS_AND_CLASS_CONSTANT"}, justification="ParameterDefinitionTest tests that subclasses are not equal to their parent classes, so the behavior appears to be intentional")
    public boolean equals(Object obj) {
        if (FileParameterDefinition.class != this.getClass()) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileParameterDefinition other = (FileParameterDefinition)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        return Objects.equals(this.getDescription(), other.getDescription());
    }

    @Extension
    @Symbol(value={"file", "fileParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.FileParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/file.html";
        }
    }
}

