/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.cli.declarative.OptionHandlerExtension;
import hudson.init.Initializer;
import hudson.model.BallColor;
import hudson.util.EditDistance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.export.CustomExportedBean;

public final class Result
implements Serializable,
CustomExportedBean {
    @NonNull
    public static final Result SUCCESS = new Result("SUCCESS", BallColor.BLUE, 0, true);
    @NonNull
    public static final Result UNSTABLE = new Result("UNSTABLE", BallColor.YELLOW, 1, true);
    @NonNull
    public static final Result FAILURE = new Result("FAILURE", BallColor.RED, 2, true);
    @NonNull
    public static final Result NOT_BUILT = new Result("NOT_BUILT", BallColor.NOTBUILT, 3, false);
    @NonNull
    public static final Result ABORTED = new Result("ABORTED", BallColor.ABORTED, 4, false);
    @NonNull
    private final String name;
    public final int ordinal;
    @NonNull
    public final BallColor color;
    public final boolean completeBuild;
    private static final long serialVersionUID = 1L;
    private static final Result[] all = new Result[]{SUCCESS, UNSTABLE, FAILURE, NOT_BUILT, ABORTED};
    public static final SingleValueConverter conv = new AbstractSingleValueConverter(){

        public boolean canConvert(Class clazz) {
            return clazz == Result.class;
        }

        public Object fromString(String s) {
            return Result.fromString(s);
        }
    };

    private Result(@NonNull String name, @NonNull BallColor color, int ordinal, boolean complete) {
        this.name = name;
        this.color = color;
        this.ordinal = ordinal;
        this.completeBuild = complete;
    }

    @NonNull
    public Result combine(@NonNull Result that) {
        if (this.ordinal < that.ordinal) {
            return that;
        }
        return this;
    }

    public static Result combine(Result r1, Result r2) {
        if (r1 == null) {
            return r2;
        }
        if (r2 == null) {
            return r1;
        }
        return r1.combine(r2);
    }

    public boolean isWorseThan(@NonNull Result that) {
        return this.ordinal > that.ordinal;
    }

    public boolean isWorseOrEqualTo(@NonNull Result that) {
        return this.ordinal >= that.ordinal;
    }

    public boolean isBetterThan(@NonNull Result that) {
        return this.ordinal < that.ordinal;
    }

    public boolean isBetterOrEqualTo(@NonNull Result that) {
        return this.ordinal <= that.ordinal;
    }

    public boolean isCompleteBuild() {
        return this.completeBuild;
    }

    @NonNull
    public String toString() {
        return this.name;
    }

    @NonNull
    public String toExportedObject() {
        return this.name;
    }

    @NonNull
    public static Result fromString(@NonNull String s) {
        for (Result r : all) {
            if (!s.equalsIgnoreCase(r.name)) continue;
            return r;
        }
        return FAILURE;
    }

    @NonNull
    private static List<String> getNames() {
        ArrayList<String> l = new ArrayList<String>();
        for (Result r : all) {
            l.add(r.name);
        }
        return l;
    }

    private Object readResolve() {
        for (Result r : all) {
            if (this.ordinal != r.ordinal) continue;
            return r;
        }
        return FAILURE;
    }

    @Initializer
    public static void init() {
        Stapler.CONVERT_UTILS.register(new Converter(){

            public Object convert(Class type, Object value) {
                return Result.fromString(value.toString());
            }
        }, Result.class);
    }

    @OptionHandlerExtension
    public static final class OptionHandlerImpl
    extends OptionHandler<Result> {
        public OptionHandlerImpl(CmdLineParser parser, OptionDef option, Setter<? super Result> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            String param = params.getParameter(0);
            Result v = Result.fromString(param.replace('-', '_'));
            if (v == FAILURE) {
                throw new CmdLineException(this.owner, "No such status '" + param + "'. Did you mean " + EditDistance.findNearest(param.replace('-', '_').toUpperCase(), Result.getNames()));
            }
            this.setter.addValue((Object)v);
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "STATUS";
        }
    }
}

