/*
 * Decompiled with CFR 0.152.
 */
package hudson.widgets;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.widgets.HistoryWidget;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.model.queue.QueueItem;
import jenkins.widgets.HistoryPageFilter;
import jenkins.widgets.WidgetFactory;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class BuildHistoryWidget<T>
extends HistoryWidget<Queue.Task, T> {
    public BuildHistoryWidget(Queue.Task owner, Iterable<T> baseList, HistoryWidget.Adapter<? super T> adapter) {
        super(owner, baseList, adapter);
    }

    public QueueItem getQueuedItem() {
        return Jenkins.get().getQueue().getItem((Queue.Task)this.owner);
    }

    public List<QueueItem> getQueuedItems() {
        LinkedList<QueueItem> list = new LinkedList<QueueItem>();
        for (Queue.Item item : Jenkins.get().getQueue().getItems()) {
            if (item.getTask() != this.owner) continue;
            list.addFirst(item);
        }
        return list;
    }

    @Override
    public HistoryPageFilter getHistoryPageFilter() {
        HistoryPageFilter historyPageFilter = this.newPageFilter();
        historyPageFilter.add(this.baseList, this.getQueuedItems());
        historyPageFilter.widget = this;
        return this.updateFirstTransientBuildKey(historyPageFilter);
    }

    @Extension
    @Restricted(value={DoNotUse.class})
    @Symbol(value={"buildHistory"})
    public static final class FactoryImpl
    extends WidgetFactory<Job, BuildHistoryWidget> {
        @Override
        public Class<Job> type() {
            return Job.class;
        }

        @Override
        public Class<BuildHistoryWidget> widgetType() {
            return BuildHistoryWidget.class;
        }

        @Override
        @NonNull
        public Collection<BuildHistoryWidget> createFor(@NonNull Job target) {
            if (target instanceof Queue.Task) {
                return List.of(new BuildHistoryWidget<Run>((Queue.Task)((Object)target), (Iterable<Run>)target.getBuilds(), Job.HISTORY_ADAPTER));
            }
            return Collections.emptySet();
        }
    }
}

