/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.security.ResourceDomainConfiguration;
import jenkins.util.HttpServletFilter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class ResourceDomainFilter
implements HttpServletFilter {
    private static final Logger LOGGER = Logger.getLogger(ResourceDomainFilter.class.getName());
    private static final Set<String> ALLOWED_PATHS = new HashSet<String>(Arrays.asList("/static-files", "/favicon.ico", "/favicon.svg", "/robots.txt"));
    public static final String ERROR_RESPONSE = "Jenkins serves only static files on this domain.";

    @Override
    public boolean handle(HttpServletRequest req, HttpServletResponse rsp) throws IOException, ServletException {
        if (ResourceDomainConfiguration.isResourceRequest(req)) {
            String path = req.getPathInfo();
            if (!path.startsWith("/static-files/") && !ALLOWED_PATHS.contains(path)) {
                LOGGER.fine(() -> "Rejecting request to " + req.getRequestURL() + " from " + req.getRemoteAddr() + " on resource domain");
                rsp.sendError(404, ERROR_RESPONSE);
                return true;
            }
            LOGGER.finer(() -> "Accepting request to " + req.getRequestURL() + " from " + req.getRemoteAddr() + " on resource domain");
        }
        return false;
    }
}

