// CHECKSTYLE:OFF

package jenkins.console;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code consoleUrlProviderDisplayName}: {@code Console URL
     * Provider}.
     * 
     * @return
     *     {@code Console URL Provider}
     */
    public static String consoleUrlProviderDisplayName() {
        return holder.format("consoleUrlProviderDisplayName");
    }

    /**
     * Key {@code consoleUrlProviderDisplayName}: {@code Console URL
     * Provider}.
     * 
     * @return
     *     {@code Console URL Provider}
     */
    public static Localizable _consoleUrlProviderDisplayName() {
        return new Localizable(holder, "consoleUrlProviderDisplayName");
    }

    /**
     * Key {@code defaultProviderDisplayName}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static String defaultProviderDisplayName() {
        return holder.format("defaultProviderDisplayName");
    }

    /**
     * Key {@code defaultProviderDisplayName}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static Localizable _defaultProviderDisplayName() {
        return new Localizable(holder, "defaultProviderDisplayName");
    }

}
