/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Functions;
import hudson.Util;
import hudson.XmlFile;
import hudson.cli.declarative.CLIResolver;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.DescriptorByNameOwner;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.Queue;
import hudson.model.User;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.SaveableListener;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.AccessControlled;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.AtomicFileWriter;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import jenkins.model.Loadable;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.SystemProperties;
import jenkins.util.xml.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.HttpDeletable;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.access.AccessDeniedException;
import org.xml.sax.SAXException;

@ExportedBean
@BridgeMethodsAdded
public abstract class AbstractItem
extends Actionable
implements Loadable,
Item,
HttpDeletable,
AccessControlled,
DescriptorByNameOwner,
StaplerProxy {
    private static final Logger LOGGER = Logger.getLogger(AbstractItem.class.getName());
    protected transient String name;
    protected volatile String description;
    private transient ItemGroup parent;
    protected String displayName;
    static final Pattern SECRET_PATTERN = Pattern.compile(">(" + Secret.ENCRYPTED_VALUE_PATTERN + ")<");
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean SKIP_PERMISSION_CHECK = SystemProperties.getBoolean(AbstractItem.class.getName() + ".skipPermissionCheck");
    public static final AlternativeUiTextProvider.Message<AbstractItem> PRONOUN = new AlternativeUiTextProvider.Message();
    public static final AlternativeUiTextProvider.Message<AbstractItem> TASK_NOUN = new AlternativeUiTextProvider.Message();

    protected AbstractItem(ItemGroup parent, String name) {
        this.parent = parent;
        this.doSetName(name);
    }

    @Override
    @Exported(visibility=999)
    public String getName() {
        return this.name;
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get(PRONOUN, this, Messages.AbstractItem_Pronoun());
    }

    public String getTaskNoun() {
        return AlternativeUiTextProvider.get(TASK_NOUN, this, Messages.AbstractItem_TaskNoun());
    }

    @Override
    @Exported
    public String getDisplayName() {
        if (null != this.displayName) {
            return this.displayName;
        }
        return this.getName();
    }

    @Exported
    public String getDisplayNameOrNull() {
        return this.displayName;
    }

    public void setDisplayNameOrNull(String displayName) throws IOException {
        this.setDisplayName(displayName);
    }

    public void setDisplayName(String displayName) throws IOException {
        this.displayName = Util.fixEmptyAndTrim(displayName);
        this.save();
    }

    @Override
    public File getRootDir() {
        return this.getParent().getRootDirFor(this);
    }

    @WithBridgeMethods(value={Jenkins.class}, castRequired=true)
    @NonNull
    public ItemGroup getParent() {
        if (this.parent == null) {
            throw new IllegalStateException("no parent set on " + this.getClass().getName() + "[" + this.name + "]");
        }
        return this.parent;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws IOException {
        this.description = description;
        this.save();
        ItemListener.fireOnUpdated(this);
    }

    protected void doSetName(String name) {
        this.name = name;
    }

    public boolean isNameEditable() {
        return false;
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public HttpResponse doConfirmRename(@QueryParameter String newName) throws IOException {
        newName = newName == null ? null : newName.trim();
        FormValidation validationError = this.doCheckNewName(newName);
        if (validationError.kind != FormValidation.Kind.OK) {
            throw new Failure(validationError.getMessage());
        }
        this.renameTo(newName);
        return HttpResponses.redirectTo((String)("../" + Functions.encode(newName)));
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public FormValidation doCheckNewName(@QueryParameter String newName) {
        if (!this.isNameEditable()) {
            return FormValidation.error("Trying to rename an item that does not support this operation.");
        }
        if (!this.hasPermission(Item.CONFIGURE)) {
            if (this.parent instanceof AccessControlled) {
                ((AccessControlled)((Object)this.parent)).checkPermission(Item.CREATE);
            }
            this.checkPermission(Item.DELETE);
        }
        newName = newName == null ? null : newName.trim();
        try {
            Jenkins.checkGoodName(newName);
            assert (newName != null);
            if (newName.equals(this.name)) {
                return FormValidation.warning(Messages.AbstractItem_NewNameUnchanged());
            }
            Jenkins.get().getProjectNamingStrategy().checkName(this.getParent().getFullName(), newName);
            this.checkIfNameIsUsed(newName);
            this.checkRename(newName);
        }
        catch (Failure e) {
            return FormValidation.error(e.getMessage());
        }
        return FormValidation.ok();
    }

    private void checkIfNameIsUsed(@NonNull String newName) throws Failure {
        try {
            Object item = this.getParent().getItem(newName);
            if (item != null) {
                throw new Failure(Messages.AbstractItem_NewNameInUse(newName));
            }
            try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
                item = this.getParent().getItem(newName);
                if (item != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Unable to rename the job {0}: name {1} is already in use. User {2} has no {3} permission for existing job with the same name", new Object[]{this.getFullName(), newName, ctx.getPreviousContext2().getAuthentication().getName(), Item.DISCOVER.name});
                    }
                    throw new Failure(Messages.Jenkins_NotAllowedName(newName));
                }
            }
        }
        catch (AccessDeniedException ex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to rename the job {0}: name {1} is already in use. User {2} has {3} permission, but no {4} for existing job with the same name", new Object[]{this.getFullName(), newName, User.current(), Item.DISCOVER.name, Item.READ.name});
            }
            throw new Failure(Messages.AbstractItem_NewNameInUse(newName));
        }
    }

    protected void checkRename(@NonNull String newName) throws Failure {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"}, justification="no big deal")
    protected void renameTo(String newName) throws IOException {
        if (!this.isNameEditable()) {
            throw new IOException("Trying to rename an item that does not support this operation.");
        }
        ItemGroup parent = this.getParent();
        String oldName = this.name;
        String oldFullName = this.getFullName();
        ItemGroup itemGroup = parent;
        synchronized (itemGroup) {
            AbstractItem abstractItem = this;
            synchronized (abstractItem) {
                if (newName == null) {
                    throw new IllegalArgumentException("New name is not given");
                }
                if (this.name.equals(newName)) {
                    return;
                }
                Items.verifyItemDoesNotAlreadyExist(parent, newName, this);
                File oldRoot = this.getRootDir();
                this.doSetName(newName);
                File newRoot = this.getRootDir();
                boolean success = false;
                try {
                    boolean interrupted = false;
                    boolean renamed = false;
                    for (int retry = 0; retry < 5; ++retry) {
                        if (oldRoot.renameTo(newRoot)) {
                            renamed = true;
                            break;
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    if (!renamed) {
                        Copy cp = new Copy();
                        cp.setProject(new Project());
                        cp.setTodir(newRoot);
                        FileSet src = new FileSet();
                        src.setDir(oldRoot);
                        cp.addFileset(src);
                        cp.setOverwrite(true);
                        cp.setPreserveLastModified(true);
                        cp.setFailOnError(false);
                        cp.execute();
                        try {
                            Util.deleteRecursive(oldRoot);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    success = true;
                }
                finally {
                    if (!success) {
                        this.doSetName(oldName);
                    }
                }
                parent.onRenamed(this, oldName, newName);
            }
        }
        ItemListener.fireLocationChange(this, oldFullName);
    }

    public void movedTo(DirectlyModifiableTopLevelItemGroup destination, AbstractItem newItem, File destDir) throws IOException {
        newItem.onLoad(destination, this.name);
    }

    @Override
    public abstract Collection<? extends Job> getAllJobs();

    @Override
    @Exported
    public final String getFullName() {
        String n = this.getParent().getFullName();
        if (n.isEmpty()) {
            return this.getName();
        }
        return n + "/" + this.getName();
    }

    @Override
    @Exported
    public final String getFullDisplayName() {
        String n = this.getParent().getFullDisplayName();
        if (n.isEmpty()) {
            return this.getDisplayName();
        }
        return n + " \u00bb " + this.getDisplayName();
    }

    public String getRelativeDisplayNameFrom(ItemGroup p) {
        return Functions.getRelativeDisplayNameFrom(this, p);
    }

    public String getRelativeNameFromGroup(ItemGroup p) {
        return this.getRelativeNameFrom(p);
    }

    @Override
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        this.parent = parent;
        this.doSetName(name);
    }

    @Override
    public void onCopiedFrom(Item src) {
    }

    @Override
    public final String getUrl() {
        String uri;
        StaplerRequest req = Stapler.getCurrentRequest();
        String shortUrl = this.getShortUrl();
        String string = uri = req == null ? null : req.getRequestURI();
        if (req != null) {
            String seed = Functions.getNearestAncestorUrl(req, this);
            LOGGER.log(Level.FINER, "seed={0} for {1} from {2}", new Object[]{seed, this, uri});
            if (seed != null) {
                return seed.substring(req.getContextPath().length() + 1) + "/";
            }
            List ancestors = req.getAncestors();
            if (!ancestors.isEmpty()) {
                Ancestor last = (Ancestor)ancestors.get(ancestors.size() - 1);
                if (last.getObject() instanceof View) {
                    View view = (View)last.getObject();
                    if (view.getOwner().getItemGroup() == this.getParent() && !view.isDefault()) {
                        String prefix = req.getContextPath() + "/";
                        String url = last.getUrl();
                        if (url.startsWith(prefix)) {
                            String base = url.substring(prefix.length()) + "/";
                            LOGGER.log(Level.FINER, "using {0}{1} for {2} from {3} given {4}", new Object[]{base, shortUrl, this, uri, prefix});
                            return base + shortUrl;
                        }
                        LOGGER.finer(() -> url + " does not start with " + prefix + " as expected");
                    } else {
                        LOGGER.log(Level.FINER, "irrelevant {0} for {1} from {2}", new Object[]{view.getViewName(), this, uri});
                    }
                } else {
                    LOGGER.log(Level.FINER, "inapplicable {0} for {1} from {2}", new Object[]{last.getObject(), this, uri});
                }
            } else {
                LOGGER.log(Level.FINER, "no ancestors for {0} from {1}", new Object[]{this, uri});
            }
        } else {
            LOGGER.log(Level.FINER, "no current request for {0}", this);
        }
        String base = this.getParent().getUrl();
        LOGGER.log(Level.FINER, "falling back to {0}{1} for {2} from {3}", new Object[]{base, shortUrl, this, uri});
        return base + shortUrl;
    }

    @Override
    public String getShortUrl() {
        String prefix = this.getParent().getUrlChildPrefix();
        String subdir = Util.rawEncode(this.getName());
        return prefix.equals(".") ? subdir + "/" : prefix + "/" + subdir + "/";
    }

    @Override
    public String getSearchUrl() {
        return this.getShortUrl();
    }

    @Override
    @Exported(visibility=999, name="url")
    public final String getAbsoluteUrl() {
        return Item.super.getAbsoluteUrl();
    }

    public final Api getApi() {
        return new Api(this);
    }

    @Override
    @NonNull
    public ACL getACL() {
        return Jenkins.get().getAuthorizationStrategy().getACL(this);
    }

    @Override
    public synchronized void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        this.getConfigFile().write(this);
        SaveableListener.fireOnChange(this, this.getConfigFile());
    }

    public final XmlFile getConfigFile() {
        return Items.getConfigFile(this);
    }

    protected Object writeReplace() {
        return XmlFile.replaceIfNotAtTopLevel(this, () -> new Replacer(this));
    }

    @RequirePOST
    public synchronized void doSubmitDescription(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(CONFIGURE);
        this.setDescription(req.getParameter("description"));
        rsp.sendRedirect(".");
    }

    @RequirePOST
    public void doDoDelete(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        this.delete();
        if (req == null || rsp == null) {
            return;
        }
        List ancestors = req.getAncestors();
        ListIterator it = ancestors.listIterator(ancestors.size());
        String url = this.getParent().getUrl();
        while (it.hasPrevious()) {
            Object a = ((Ancestor)it.previous()).getObject();
            if (a instanceof View) {
                url = ((View)a).getUrl();
                break;
            }
            if (!(a instanceof ViewGroup) || a == this) continue;
            url = ((ViewGroup)a).getUrl();
            break;
        }
        rsp.sendRedirect2(req.getContextPath() + "/" + url);
    }

    public void delete(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        try {
            this.delete();
            rsp.setStatus(204);
        }
        catch (InterruptedException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void delete() throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void performDelete() throws IOException, InterruptedException {
        this.getConfigFile().delete();
        Util.deleteRecursive(this.getRootDir());
    }

    @WebMethod(name={"config.xml"})
    public void doConfigDotXml(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.getMethod().equals("GET")) {
            rsp.setContentType("application/xml");
            this.writeConfigDotXml((OutputStream)rsp.getOutputStream());
            return;
        }
        if (req.getMethod().equals("POST")) {
            this.updateByXml((Source)new StreamSource(req.getReader()));
            return;
        }
        rsp.sendError(400);
    }

    @Restricted(value={NoExternalUse.class})
    public void writeConfigDotXml(OutputStream os) throws IOException {
        this.checkPermission(EXTENDED_READ);
        XmlFile configFile = this.getConfigFile();
        if (this.hasPermission(CONFIGURE)) {
            hudson.util.IOUtils.copy(configFile.getFile(), os);
        } else {
            String encoding = configFile.sniffEncoding();
            String xml = Files.readString(Util.fileToPath(configFile.getFile()), Charset.forName(encoding));
            Matcher matcher = SECRET_PATTERN.matcher(xml);
            StringBuilder cleanXml = new StringBuilder();
            while (matcher.find()) {
                if (Secret.decrypt(matcher.group(1)) == null) continue;
                matcher.appendReplacement(cleanXml, ">********<");
            }
            matcher.appendTail(cleanXml);
            IOUtils.write((String)cleanXml.toString(), (OutputStream)os, (String)encoding);
        }
    }

    @Deprecated
    public void updateByXml(StreamSource source) throws IOException {
        this.updateByXml((Source)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByXml(Source source) throws IOException {
        this.checkPermission(CONFIGURE);
        XmlFile configXmlFile = this.getConfigFile();
        AtomicFileWriter out = new AtomicFileWriter(configXmlFile.getFile());
        try {
            try {
                XMLUtils.safeTransform(source, new StreamResult(out));
                out.close();
            }
            catch (TransformerException | SAXException e) {
                throw new IOException("Failed to persist config.xml", e);
            }
            Object o = new XmlFile(Items.XSTREAM, out.getTemporaryPath().toFile()).unmarshalNullingOut(this);
            if (o != this) {
                throw new IOException("Expecting " + this.getClass() + " but got " + o.getClass() + " instead");
            }
            Items.whileUpdatingByXml(new NotReallyRoleSensitiveCallable<Void, IOException>(){

                public Void call() throws IOException {
                    AbstractItem.this.onLoad(AbstractItem.this.getParent(), AbstractItem.this.getRootDir().getName());
                    return null;
                }
            });
            Jenkins.get().rebuildDependencyGraphAsync();
            out.commit();
            SaveableListener.fireOnChange(this, this.getConfigFile());
        }
        finally {
            out.abort();
        }
    }

    @RequirePOST
    public void doReload() throws IOException {
        this.load();
    }

    @Override
    public void load() throws IOException {
        this.checkPermission(CONFIGURE);
        this.getConfigFile().unmarshal(this);
        Items.whileUpdatingByXml(new NotReallyRoleSensitiveCallable<Void, IOException>(){

            public Void call() throws IOException {
                AbstractItem.this.onLoad(AbstractItem.this.getParent(), AbstractItem.this.getRootDir().getName());
                return null;
            }
        });
        Jenkins.get().rebuildDependencyGraphAsync();
    }

    @Override
    public String getSearchName() {
        return this.getName();
    }

    public String toString() {
        return super.toString() + "[" + (String)(this.parent != null ? this.getFullName() : "?/" + this.name) + "]";
    }

    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        if (!SKIP_PERMISSION_CHECK) {
            if (!this.hasPermission(Item.DISCOVER)) {
                return null;
            }
            this.checkPermission(Item.READ);
        }
        return this;
    }

    @CLIResolver
    public static AbstractItem resolveForCLI(@Argument(required=true, metaVar="NAME", usage="Item name") String name) throws CmdLineException {
        AbstractItem item = Jenkins.get().getItemByFullName(name, AbstractItem.class);
        if (item == null) {
            AbstractItem project = Items.findNearest(AbstractItem.class, name, Jenkins.get());
            throw new CmdLineException(null, project == null ? Messages.AbstractItem_NoSuchJobExistsWithoutSuggestion(name) : Messages.AbstractItem_NoSuchJobExists(name, project.getFullName()));
        }
        return item;
    }

    private static /* synthetic */ String lambda$delete$2(Queue.Item i) {
        return "failed to cancel " + i;
    }

    private static class Replacer {
        private final String fullName;

        Replacer(AbstractItem i) {
            this.fullName = i.getFullName();
        }

        private Object readResolve() {
            Jenkins j = Jenkins.getInstanceOrNull();
            if (j == null) {
                return null;
            }
            return j.getItemByFullName(this.fullName);
        }
    }
}

