/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.jcraft.jzlib.GZIPOutputStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.PageDecorator;
import hudson.model.PersistentDescriptor;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.node_monitors.ArchitectureMonitor;
import hudson.security.Permission;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jenkins.model.Jenkins;
import jenkins.security.FIPS140;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class UsageStatistics
extends PageDecorator
implements PersistentDescriptor {
    private static final Logger LOG = Logger.getLogger(UsageStatistics.class.getName());
    private final String keyImage;
    private volatile transient RSAPublicKey key;
    private volatile transient long lastAttempt = -1L;
    private static final String DEFAULT_KEY_BYTES = "30819f300d06092a864886f70d010101050003818d0030818902818100c14970473bd90fd1f2d20e4fa6e36ea21f7d46db2f4104a3a8f2eb097d6e26278dfadf3fe9ed05bbbb00a4433f4b7151e6683a169182e6ff2f6b4f2bb6490b2cddef73148c37a2a7421fc75f99fb0fadab46f191806599a208652f4829fd6f76e13195fb81ff3f2fce15a8e9a85ebe15c07c90b34ebdb416bd119f0d74105f3b0203010001";
    private static final long DAY = TimeUnit.DAYS.toMillis(1L);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean DISABLED = SystemProperties.getBoolean(UsageStatistics.class.getName() + ".disabled");

    public UsageStatistics() {
        this(DEFAULT_KEY_BYTES);
    }

    public UsageStatistics(String keyImage) {
        this.keyImage = keyImage;
    }

    public boolean isDue() {
        if (!Jenkins.get().isUsageStatisticsCollected() || DISABLED || FIPS140.useCompliantAlgorithms()) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastAttempt > DAY) {
            this.lastAttempt = now;
            return true;
        }
        return false;
    }

    private RSAPublicKey getKey() {
        try {
            if (this.key == null) {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.key = (RSAPublicKey)keyFactory.generatePublic(new X509EncodedKeySpec(Util.fromHexString(this.keyImage)));
            }
            return this.key;
        }
        catch (GeneralSecurityException e) {
            throw new Error(e);
        }
    }

    public String getStatData() throws IOException {
        Jenkins j = Jenkins.get();
        JSONObject o = new JSONObject();
        o.put("stat", (Object)1);
        o.put("install", (Object)j.getLegacyInstanceId());
        o.put("servletContainer", (Object)j.servletContext.getServerInfo());
        o.put("version", (Object)Jenkins.VERSION);
        ArrayList<JSONObject> nodes = new ArrayList<JSONObject>();
        for (Computer c : j.getComputers()) {
            JSONObject n = new JSONObject();
            if (c.getNode() == j) {
                n.put("master", (Object)true);
                n.put("jvm-vendor", (Object)System.getProperty("java.vm.vendor"));
                n.put("jvm-name", (Object)System.getProperty("java.vm.name"));
                n.put("jvm-version", (Object)System.getProperty("java.version"));
            }
            n.put("executors", (Object)c.getNumExecutors());
            ArchitectureMonitor.DescriptorImpl descriptor = j.getDescriptorByType(ArchitectureMonitor.DescriptorImpl.class);
            n.put("os", descriptor.get(c));
            nodes.add(n);
        }
        o.put("nodes", nodes);
        ArrayList<JSONObject> plugins = new ArrayList<JSONObject>();
        for (PluginWrapper pw : j.getPluginManager().getPlugins()) {
            if (!pw.isActive()) continue;
            JSONObject p = new JSONObject();
            p.put("name", (Object)pw.getShortName());
            p.put("version", (Object)pw.getVersion());
            plugins.add(p);
        }
        o.put("plugins", plugins);
        JSONObject jobs = new JSONObject();
        TopLevelItemDescriptor[] descriptors = Items.all().toArray(new TopLevelItemDescriptor[0]);
        int[] counts = new int[descriptors.length];
        block19: for (TopLevelItem item : j.allItems(TopLevelItem.class)) {
            TopLevelItemDescriptor d = item.getDescriptor();
            for (int i = 0; i < descriptors.length; ++i) {
                if (d != descriptors[i]) continue;
                int n = i;
                counts[n] = counts[n] + 1;
                continue block19;
            }
        }
        for (int i = 0; i < descriptors.length; ++i) {
            jobs.put(descriptors[i].getJsonSafeClassName(), (Object)counts[i]);
        }
        o.put("jobs", (Object)jobs);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (CombinedCipherOutputStream cipheros = new CombinedCipherOutputStream((OutputStream)baos, this.getKey(), "AES");
                 GZIPOutputStream zipos = new GZIPOutputStream((OutputStream)cipheros);
                 OutputStreamWriter w = new OutputStreamWriter((OutputStream)zipos, StandardCharsets.UTF_8);){
                o.write((Writer)w);
            }
            return Base64.getEncoder().encodeToString(baos.toByteArray());
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, "Usage statistics could not be sent ({0})", e.getMessage());
            LOG.log(Level.FINE, "Error sending usage statistics", e);
            return null;
        }
    }

    @Override
    @NonNull
    public Permission getRequiredGlobalConfigPagePermission() {
        return Jenkins.MANAGE;
    }

    @Override
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        try {
            if (DISABLED) {
                Jenkins.get().setNoUsageStatistics(Boolean.TRUE);
            } else {
                Jenkins.get().setNoUsageStatistics(json.has("usageStatisticsCollected") ? null : Boolean.TRUE);
            }
            return true;
        }
        catch (IOException e) {
            throw new Descriptor.FormException(e, "usageStatisticsCollected");
        }
    }

    private static String getKeyAlgorithm(String algorithm) {
        int index = algorithm.indexOf(47);
        return index > 0 ? algorithm.substring(0, index) : algorithm;
    }

    private static Cipher toCipher(RSAKey key, int mode) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(mode, (Key)((Object)key));
        return cipher;
    }

    public static final class CombinedCipherInputStream
    extends FilterInputStream {
        public CombinedCipherInputStream(InputStream in, Cipher asym, String algorithm, int keyLength) throws IOException, GeneralSecurityException {
            super(in);
            String keyAlgorithm = UsageStatistics.getKeyAlgorithm(algorithm);
            byte[] symKeyBytes = new byte[keyLength / 8];
            new DataInputStream(in).readFully(symKeyBytes);
            SecretKeySpec symKey = new SecretKeySpec(asym.doFinal(symKeyBytes), keyAlgorithm);
            Cipher sym = Secret.getCipher(algorithm);
            sym.init(2, (Key)symKey, keyAlgorithm.equals(algorithm) ? null : new IvParameterSpec(symKey.getEncoded()));
            this.in = new CipherInputStream(in, sym);
        }

        public CombinedCipherInputStream(InputStream in, RSAKey key, String algorithm) throws IOException, GeneralSecurityException {
            this(in, UsageStatistics.toCipher(key, 2), algorithm, key.getModulus().bitLength());
        }
    }

    public static final class CombinedCipherOutputStream
    extends FilterOutputStream {
        public CombinedCipherOutputStream(OutputStream out, Cipher asym, String algorithm) throws IOException, GeneralSecurityException {
            super(out);
            String keyAlgorithm = UsageStatistics.getKeyAlgorithm(algorithm);
            SecretKey symKey = KeyGenerator.getInstance(keyAlgorithm).generateKey();
            out.write(asym.doFinal(symKey.getEncoded()));
            Cipher sym = Secret.getCipher(algorithm);
            sym.init(1, (Key)symKey, keyAlgorithm.equals(algorithm) ? null : new IvParameterSpec(symKey.getEncoded()));
            this.out = new CipherOutputStream(out, sym);
        }

        public CombinedCipherOutputStream(OutputStream out, RSAKey key, String algorithm) throws IOException, GeneralSecurityException {
            this(out, UsageStatistics.toCipher(key, 1), algorithm);
        }
    }
}

