/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.Functions;
import hudson.Util;
import hudson.security.AccessDeniedException3;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

@Restricted(value={NoExternalUse.class})
public class HudsonAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private final String loginFormUrl;

    public HudsonAuthenticationEntryPoint(String loginFormUrl) {
        this.loginFormUrl = loginFormUrl;
    }

    public void commence(HttpServletRequest req, HttpServletResponse rsp, AuthenticationException reason) throws IOException, ServletException {
        String requestedWith = req.getHeader("X-Requested-With");
        if ("XMLHttpRequest".equals(requestedWith)) {
            rsp.sendError(403);
        } else {
            PrintWriter out;
            Object uriFrom = req.getRequestURI();
            if (req.getQueryString() != null && !req.getQueryString().isEmpty()) {
                uriFrom = (String)uriFrom + "?" + req.getQueryString();
            }
            Object loginForm = req.getContextPath() + this.loginFormUrl;
            loginForm = MessageFormat.format((String)loginForm, URLEncoder.encode((String)uriFrom, StandardCharsets.UTF_8));
            req.setAttribute("loginForm", loginForm);
            rsp.setStatus(403);
            rsp.setContentType("text/html;charset=UTF-8");
            Functions.advertiseHeaders(rsp);
            AccessDeniedException3 cause = null;
            if (reason instanceof InsufficientAuthenticationException && reason.getCause() instanceof AccessDeniedException3) {
                cause = (AccessDeniedException3)((Object)reason.getCause());
                cause.reportAsHeaders(rsp);
            }
            try {
                out = new PrintWriter(new OutputStreamWriter((OutputStream)rsp.getOutputStream(), StandardCharsets.UTF_8));
            }
            catch (IllegalStateException e) {
                out = rsp.getWriter();
            }
            Util.printRedirect(req.getContextPath(), (String)loginForm, "Authentication required", out);
            if (cause != null) {
                cause.report(out);
            }
            out.printf("-->%n%n</body></html>", new Object[0]);
            for (int i = 0; i < 10; ++i) {
                out.print("                              ");
            }
            out.close();
        }
    }
}

