/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.model.User;
import hudson.security.UserMayOrMayNotExistException2;
import jenkins.security.LastGrantedAuthoritiesProperty;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class ImpersonatingUserDetailsService2
implements UserDetailsService {
    private final UserDetailsService base;

    public ImpersonatingUserDetailsService2(UserDetailsService base) {
        this.base = base;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        try {
            return this.base.loadUserByUsername(username);
        }
        catch (UserMayOrMayNotExistException2 e) {
            return this.attemptToImpersonate(username, (RuntimeException)((Object)e));
        }
    }

    protected UserDetails attemptToImpersonate(String username, RuntimeException e) {
        LastGrantedAuthoritiesProperty p;
        User u = User.getById(username, false);
        if (u != null && (p = u.getProperty(LastGrantedAuthoritiesProperty.class)) != null) {
            return new org.springframework.security.core.userdetails.User(username, "", true, true, true, true, p.getAuthorities2());
        }
        throw e;
    }
}

