/*
 * Decompiled with CFR 0.152.
 */
package jenkins.websocket;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.websocket.Provider;
import jenkins.websocket.WebSocketSession;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;

@Restricted(value={Beta.class})
public class WebSockets {
    private static final Logger LOGGER = Logger.getLogger(WebSockets.class.getName());
    private static final Provider provider = WebSockets.findProvider();

    private static Provider findProvider() {
        Iterator<Provider> it = ServiceLoader.load(Provider.class).iterator();
        while (it.hasNext()) {
            try {
                return it.next();
            }
            catch (ServiceConfigurationError x) {
                LOGGER.log(Level.FINE, null, x);
            }
        }
        return null;
    }

    public static HttpResponse upgrade(final WebSocketSession session) {
        if (provider == null) {
            throw HttpResponses.notFound();
        }
        return (req, rsp, node) -> {
            try {
                session.handler = provider.handle((HttpServletRequest)req, (HttpServletResponse)rsp, new Provider.Listener(){
                    private Object providerSession;

                    public void onWebSocketConnect(Object providerSession) {
                        this.providerSession = providerSession;
                        session.startPings();
                        session.opened();
                    }

                    public Object getProviderSession() {
                        return this.providerSession;
                    }

                    public void onWebSocketClose(int statusCode, String reason) {
                        session.stopPings();
                        session.closed(statusCode, reason);
                    }

                    public void onWebSocketError(Throwable cause) {
                        if (cause instanceof ClosedChannelException) {
                            this.onWebSocketClose(0, cause.toString());
                        } else {
                            session.error(cause);
                        }
                    }

                    public void onWebSocketBinary(byte[] payload, int offset, int length) {
                        try {
                            session.binary(payload, offset, length);
                        }
                        catch (IOException x) {
                            session.error(x);
                        }
                    }

                    public void onWebSocketText(String message) {
                        try {
                            session.text(message);
                        }
                        catch (IOException x) {
                            session.error(x);
                        }
                    }
                });
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, null, x);
                throw HttpResponses.error((Throwable)x);
            }
        };
    }

    public static boolean isSupported() {
        return provider != null;
    }

    private WebSockets() {
    }
}

