/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins.ui.symbol;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Functions;
import hudson.PluginWrapper;
import hudson.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.symbol.SymbolRequest;

public final class Symbol {
    private static final Logger LOGGER = Logger.getLogger(Symbol.class.getName());
    private static final Map<String, Map<String, String>> SYMBOLS = new ConcurrentHashMap<String, Map<String, String>>();
    static final String PLACEHOLDER_SVG = "<svg xmlns=\"http://www.w3.org/2000/svg\" class=\"ionicon\" height=\"48\" viewBox=\"0 0 512 512\"><title>Close</title><path fill=\"none\" stroke=\"currentColor\" stroke-linecap=\"round\" stroke-linejoin=\"round\" stroke-width=\"32\" d=\"M368 368L144 144M368 144L144 368\"/></svg>";
    static final String PLACEHOLDER_MATCHER = "M368 368L144 144M368 144L144 368";

    private Symbol() {
    }

    public static String get(@NonNull SymbolRequest request) {
        String name = request.getName();
        String title = request.getTitle();
        String tooltip = request.getTooltip();
        String htmlTooltip = request.getHtmlTooltip();
        String classes = request.getClasses();
        String pluginName = request.getPluginName();
        String id = request.getId();
        String identifier = StringUtils.defaultIfBlank((String)pluginName, (String)"core");
        Object symbol = SYMBOLS.computeIfAbsent(identifier, key -> new ConcurrentHashMap()).computeIfAbsent(name, key -> Symbol.loadSymbol(identifier, key));
        if (StringUtils.isNotBlank((String)tooltip) && StringUtils.isBlank((String)htmlTooltip)) {
            symbol = ((String)symbol).replaceAll("<svg", "<svg tooltip=\"" + Functions.htmlAttributeEscape(tooltip) + "\"");
        }
        if (StringUtils.isNotBlank((String)htmlTooltip)) {
            symbol = ((String)symbol).replaceAll("<svg", "<svg data-html-tooltip=\"" + Functions.htmlAttributeEscape(htmlTooltip) + "\"");
        }
        if (StringUtils.isNotBlank((String)id)) {
            symbol = ((String)symbol).replaceAll("<svg", "<svg id=\"" + Functions.htmlAttributeEscape(id) + "\"");
        }
        if (StringUtils.isNotBlank((String)classes)) {
            symbol = ((String)symbol).replaceAll("<svg", "<svg class=\"" + Functions.htmlAttributeEscape(classes) + "\"");
        }
        if (StringUtils.isNotBlank((String)title)) {
            symbol = "<span class=\"jenkins-visually-hidden\">" + Util.xmlEscape(title) + "</span>" + (String)symbol;
        }
        return symbol;
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE", "RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"}, justification="Spotbugs doesn't grok try-with-resources")
    private static String loadSymbol(String namespace, String name) {
        String markup = PLACEHOLDER_SVG;
        ClassLoader classLoader = Symbol.getClassLoader(namespace);
        if (classLoader != null) {
            try (InputStream inputStream = classLoader.getResourceAsStream("images/symbols/" + name + ".svg");){
                if (inputStream != null) {
                    markup = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                } else {
                    LOGGER.log(Level.FINE, "Missing symbol " + name + " in " + namespace);
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to load symbol " + name, e);
            }
        }
        return markup.replaceAll("(<title>).*?(</title>)", "$1$2").replaceAll("<svg", "<svg aria-hidden=\"true\"").replaceAll("(class=\").*?(\")", "").replaceAll("(tooltip=\").*?(\")", "").replaceAll("(data-html-tooltip=\").*?(\")", "").replace("stroke:#000", "stroke:currentColor");
    }

    @CheckForNull
    private static ClassLoader getClassLoader(@NonNull String pluginName) {
        if ("core".equals(pluginName)) {
            return Symbol.class.getClassLoader();
        }
        PluginWrapper plugin = Jenkins.get().getPluginManager().getPlugin(pluginName);
        if (plugin != null) {
            return plugin.classLoader;
        }
        return null;
    }
}

