/*
 * Decompiled with CFR 0.152.
 */
package hudson.init.impl;

import hudson.init.Initializer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.compression.CompressionFilter;
import org.kohsuke.stapler.compression.UncaughtExceptionHandler;

public class InstallUncaughtExceptionHandler {
    @Initializer
    public static void init(final Jenkins j) throws IOException {
        CompressionFilter.setUncaughtExceptionHandler((ServletContext)j.servletContext, (UncaughtExceptionHandler)new UncaughtExceptionHandler(){

            public void reportException(Throwable e, ServletContext context, HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
                block2: {
                    req.setAttribute("javax.servlet.error.exception", (Object)e);
                    try {
                        WebApp.get((ServletContext)j.servletContext).getSomeStapler().invoke(req, rsp, (Object)Jenkins.getInstance(), "/oops");
                    }
                    catch (IOException | ServletException x) {
                        if (Stapler.isSocketException((Throwable)x)) break block2;
                        throw x;
                    }
                }
            }
        });
        try {
            Thread.setDefaultUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
            DefaultUncaughtExceptionHandler.LOGGER.log(Level.FINE, "Successfully installed a global UncaughtExceptionHandler.");
        }
        catch (SecurityException ex) {
            DefaultUncaughtExceptionHandler.LOGGER.log(Level.SEVERE, "Failed to set the default UncaughtExceptionHandler.  If any threads die due to unhandled coding errors then there will be no logging of this information.  The lack of this diagnostic information will make it harder to track down issues which will reduce the supportability of Jenkins.  It is highly recommended that you consult the documentation that comes with you servlet container on how to allow the `setDefaultUncaughtExceptionHandler` permission and enable it.", ex);
        }
    }

    private static class DefaultUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private static final Logger LOGGER = Logger.getLogger(InstallUncaughtExceptionHandler.class.getName());

        private DefaultUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable ex) {
            LOGGER.log(Level.SEVERE, "A thread (" + t.getName() + '/' + t.getId() + ") died unexpectedly due to an uncaught exception, this may leave your Jenkins in a bad way and is usually indicative of a bug in the code.", ex);
        }
    }
}

