/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Functions;
import hudson.model.PeriodicWork;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;

public abstract class AsyncPeriodicWork
extends PeriodicWork {
    private static final long LOG_ROTATE_MINUTES = SystemProperties.getLong(AsyncPeriodicWork.class.getName() + ".logRotateMinutes", TimeUnit.DAYS.toMinutes(1L));
    private static final long LOG_ROTATE_SIZE = SystemProperties.getLong(AsyncPeriodicWork.class.getName() + ".logRotateSize", -1L);
    private final long logRotateMillis;
    private final long logRotateSize;
    private long lastRotateMillis = Long.MIN_VALUE;
    public final String name;
    private Thread thread;

    protected AsyncPeriodicWork(String name) {
        this.name = name;
        this.logRotateMillis = TimeUnit.MINUTES.toMillis(SystemProperties.getLong(this.getClass().getName() + ".logRotateMinutes", LOG_ROTATE_MINUTES));
        this.logRotateSize = SystemProperties.getLong(this.getClass().getName() + ".logRotateSize", LOG_ROTATE_SIZE);
    }

    @Override
    public final void doRun() {
        try {
            if (this.thread != null && this.thread.isAlive()) {
                this.logger.log(this.getSlowLoggingLevel(), "{0} thread is still running. Execution aborted.", this.name);
                return;
            }
            this.thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                @Override
                public void run() {
                    AsyncPeriodicWork.this.logger.log(AsyncPeriodicWork.this.getNormalLoggingLevel(), "Started {0}", AsyncPeriodicWork.this.name);
                    long startTime = System.currentTimeMillis();
                    StreamTaskListener l = AsyncPeriodicWork.this.createListener();
                    l.getLogger().printf("Started at %tc%n", new Date(startTime));
                    ACL.impersonate(ACL.SYSTEM);
                    AsyncPeriodicWork.this.execute(l);
                    long stopTime = System.currentTimeMillis();
                    try {
                        l.getLogger().printf("Finished at %tc. %dms%n", new Date(stopTime), stopTime - startTime);
                    }
                    finally {
                        l.closeQuietly();
                    }
                    catch (IOException e) {
                        Functions.printStackTrace((Throwable)e, l.fatalError(e.getMessage()));
                        stopTime = System.currentTimeMillis();
                        try {
                            l.getLogger().printf("Finished at %tc. %dms%n", new Date(stopTime), stopTime - startTime);
                        }
                        finally {
                            l.closeQuietly();
                        }
                    }
                    catch (InterruptedException e2) {
                        Functions.printStackTrace((Throwable)e2, l.fatalError("aborted"));
                        {
                            catch (Throwable throwable) {
                                stopTime = System.currentTimeMillis();
                                try {
                                    l.getLogger().printf("Finished at %tc. %dms%n", new Date(stopTime), stopTime - startTime);
                                }
                                finally {
                                    l.closeQuietly();
                                }
                                throw throwable;
                            }
                        }
                        stopTime = System.currentTimeMillis();
                        try {
                            l.getLogger().printf("Finished at %tc. %dms%n", new Date(stopTime), stopTime - startTime);
                        }
                        finally {
                            l.closeQuietly();
                        }
                    }
                    AsyncPeriodicWork.this.logger.log(AsyncPeriodicWork.this.getNormalLoggingLevel(), "Finished {0}. {1,number} ms", new Object[]{AsyncPeriodicWork.this.name, stopTime - startTime});
                }
            }, this.name + " thread");
            this.thread.start();
        }
        catch (Throwable t) {
            LogRecord lr = new LogRecord(this.getErrorLoggingLevel(), "{0} thread failed with error");
            lr.setThrown(t);
            lr.setParameters(new Object[]{this.name});
            this.logger.log(lr);
        }
    }

    protected StreamTaskListener createListener() {
        File f = this.getLogFile();
        if (!f.getParentFile().isDirectory() && !f.getParentFile().mkdirs()) {
            this.logger.log(this.getErrorLoggingLevel(), "Could not create directory {0}", f.getParentFile());
        }
        if (f.isFile()) {
            if (this.lastRotateMillis + this.logRotateMillis < System.currentTimeMillis() || this.logRotateSize > 0L && f.length() > this.logRotateSize) {
                this.lastRotateMillis = System.currentTimeMillis();
                File prev = null;
                for (int i = 5; i >= 0; --i) {
                    File curr;
                    File file = curr = i == 0 ? f : new File(f.getParentFile(), f.getName() + "." + i);
                    if (curr.isFile()) {
                        if (prev != null && !prev.exists()) {
                            if (!curr.renameTo(prev)) {
                                this.logger.log(this.getErrorLoggingLevel(), "Could not rotate log files {0} to {1}", new Object[]{curr, prev});
                            }
                        } else if (!curr.delete()) {
                            this.logger.log(this.getErrorLoggingLevel(), "Could not delete log file {0} to enable rotation", curr);
                        }
                    }
                    prev = curr;
                }
            }
        } else {
            File newFile;
            this.lastRotateMillis = System.currentTimeMillis();
            File oldFile = new File(Jenkins.getActiveInstance().getRootDir(), f.getName());
            if (oldFile.isFile() && !(newFile = new File(f.getParentFile(), f.getName() + ".1")).isFile()) {
                if (oldFile.renameTo(newFile)) {
                    this.logger.log(this.getNormalLoggingLevel(), "Moved {0} to {1}", new Object[]{oldFile, newFile});
                } else {
                    this.logger.log(this.getErrorLoggingLevel(), "Could not move {0} to {1}", new Object[]{oldFile, newFile});
                }
            }
        }
        try {
            return new StreamTaskListener(f, true, null);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    protected File getLogFile() {
        return new File(Jenkins.getActiveInstance().getRootDir(), "logs/tasks/" + this.name + ".log");
    }

    protected Level getNormalLoggingLevel() {
        return Level.INFO;
    }

    protected Level getSlowLoggingLevel() {
        return this.getNormalLoggingLevel();
    }

    protected Level getErrorLoggingLevel() {
        return Level.SEVERE;
    }

    protected abstract void execute(TaskListener var1) throws IOException, InterruptedException;
}

