/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.labels;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Label;
import hudson.model.Saveable;
import hudson.model.labels.LabelAtomProperty;
import hudson.model.labels.LabelAtomPropertyDescriptor;
import hudson.model.labels.LabelOperatorPrecedence;
import hudson.model.labels.LabelVisitor;
import hudson.model.listeners.SaveableListener;
import hudson.util.DescribableList;
import hudson.util.EditDistance;
import hudson.util.FormApply;
import hudson.util.QuotedStringTokenizer;
import hudson.util.VariableResolver;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class LabelAtom
extends Label
implements Saveable {
    private DescribableList<LabelAtomProperty, LabelAtomPropertyDescriptor> properties = new DescribableList(this);
    protected volatile transient List<Action> transientActions = new Vector<Action>();
    private String description;
    private static final Logger LOGGER = Logger.getLogger(LabelAtom.class.getName());
    private static final XStream2 XSTREAM = new XStream2();

    public LabelAtom(String name) {
        super(name);
    }

    @Override
    public String getExpression() {
        return LabelAtom.escape(this.name);
    }

    @Override
    public boolean isAtom() {
        return true;
    }

    @Override
    public List<Action> getActions() {
        Vector<Action> actions = new Vector<Action>(super.getActions());
        actions.addAll(this.transientActions);
        return Collections.unmodifiableList(actions);
    }

    protected void updateTransientActions() {
        Vector<Action> ta = new Vector<Action>();
        for (LabelAtomProperty p : this.properties) {
            ta.addAll(p.getActions(this));
        }
        this.transientActions = ta;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws IOException {
        this.description = description;
        this.save();
    }

    public DescribableList<LabelAtomProperty, LabelAtomPropertyDescriptor> getProperties() {
        return this.properties;
    }

    @Exported
    public List<LabelAtomProperty> getPropertiesList() {
        return this.properties.toList();
    }

    @Override
    public boolean matches(VariableResolver<Boolean> resolver) {
        return resolver.resolve(this.name);
    }

    @Override
    public <V, P> V accept(LabelVisitor<V, P> visitor, P param) {
        return visitor.onAtom(this, param);
    }

    @Override
    public Set<LabelAtom> listAtoms() {
        return Collections.singleton(this);
    }

    @Override
    public LabelOperatorPrecedence precedence() {
        return LabelOperatorPrecedence.ATOM;
    }

    XmlFile getConfigFile() {
        return new XmlFile(XSTREAM, new File(Jenkins.getInstance().root, "labels/" + this.name + ".xml"));
    }

    @Override
    public void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        try {
            this.getConfigFile().write(this);
            SaveableListener.fireOnChange(this, this.getConfigFile());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + this.getConfigFile(), e);
        }
    }

    public void load() {
        XmlFile file = this.getConfigFile();
        if (file.exists()) {
            try {
                file.unmarshal(this);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + file, e);
            }
        }
        this.properties.setOwner(this);
        this.updateTransientActions();
    }

    public List<LabelAtomPropertyDescriptor> getApplicablePropertyDescriptors() {
        return LabelAtomProperty.all();
    }

    @RequirePOST
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        Jenkins app = Jenkins.getInstance();
        app.checkPermission(Jenkins.ADMINISTER);
        this.properties.rebuild(req, req.getSubmittedForm(), this.getApplicablePropertyDescriptors());
        this.description = req.getSubmittedForm().getString("description");
        this.updateTransientActions();
        this.save();
        FormApply.success(".").generateResponse(req, rsp, null);
    }

    @RequirePOST
    @Restricted(value={DoNotUse.class})
    public synchronized void doSubmitDescription(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        this.setDescription(req.getParameter("description"));
        rsp.sendRedirect(".");
    }

    @Nullable
    public static LabelAtom get(@CheckForNull String l) {
        return Jenkins.getInstance().getLabelAtom(l);
    }

    public static LabelAtom findNearest(String name) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (LabelAtom a : Jenkins.getInstance().getLabelAtoms()) {
            candidates.add(a.getName());
        }
        return LabelAtom.get(EditDistance.findNearest(name, candidates));
    }

    public static boolean needsEscape(String name) {
        try {
            Jenkins.checkGoodName(name);
            for (int i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (" ()\t\n".indexOf(ch) == -1) continue;
                return true;
            }
            return false;
        }
        catch (Failure failure) {
            return true;
        }
    }

    public static String escape(String name) {
        if (LabelAtom.needsEscape(name)) {
            return QuotedStringTokenizer.quote((String)name);
        }
        return name;
    }

    static {
        XSTREAM.registerConverter(new LabelAtomConverter(), 100);
    }

    private static class LabelAtomConverter
    extends XStream2.PassthruConverter<LabelAtom> {
        private Label.ConverterImpl leafLabelConverter = new Label.ConverterImpl();
        private static final Object IN_NESTED = "VisitingInnerLabelAtom";

        private LabelAtomConverter() {
            super(XSTREAM);
        }

        @Override
        public boolean canConvert(Class type) {
            return LabelAtom.class.isAssignableFrom(type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            if (context.get(IN_NESTED) == null) {
                context.put(IN_NESTED, (Object)true);
                try {
                    super.marshal(source, writer, context);
                }
                finally {
                    context.put(IN_NESTED, (Object)false);
                }
            } else {
                this.leafLabelConverter.marshal(source, writer, context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            if (context.get(IN_NESTED) == null) {
                context.put(IN_NESTED, (Object)true);
                try {
                    Object object = super.unmarshal(reader, context);
                    return object;
                }
                finally {
                    context.put(IN_NESTED, (Object)false);
                }
            }
            return this.leafLabelConverter.unmarshal(reader, context);
        }

        @Override
        protected void callback(LabelAtom obj, UnmarshallingContext context) {
        }
    }
}

