/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.queue;

import hudson.model.Queue;
import hudson.model.queue.SubTask;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class Executables {
    @Nonnull
    public static SubTask getParentOf(Queue.Executable e) {
        try {
            return e.getParent();
        }
        catch (AbstractMethodError _) {
            try {
                Method m = e.getClass().getMethod("getParent", new Class[0]);
                m.setAccessible(true);
                return (SubTask)m.invoke((Object)e, new Object[0]);
            }
            catch (IllegalAccessException x) {
                throw (Error)new IllegalAccessError().initCause(x);
            }
            catch (NoSuchMethodException x) {
                throw (Error)new NoSuchMethodError().initCause(x);
            }
            catch (InvocationTargetException x) {
                Throwable y = x.getTargetException();
                if (y instanceof Error) {
                    throw (Error)y;
                }
                if (y instanceof RuntimeException) {
                    throw (RuntimeException)y;
                }
                throw new Error(x);
            }
        }
    }

    public static long getEstimatedDurationFor(@CheckForNull Queue.Executable e) {
        if (e == null) {
            return -1L;
        }
        try {
            return e.getEstimatedDuration();
        }
        catch (AbstractMethodError error) {
            return e.getParent().getEstimatedDuration();
        }
    }
}

