/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.AbortException;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Api;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItemDescriptor;
import hudson.scm.AutoBrowserHolder;
import hudson.scm.ChangeLogParser;
import hudson.scm.Messages;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.util.IOUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class SCM
implements Describable<SCM>,
ExtensionPoint {
    private static boolean useAutoBrowserHolder = SystemProperties.getBoolean(SCM.class.getName() + ".useAutoBrowserHolder");
    private transient AutoBrowserHolder autoBrowserHolder;
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(SCM.class, Messages._SCM_Permissions_Title());
    public static final Permission TAG = new Permission(PERMISSIONS, "Tag", Messages._SCM_TagPermission_Description(), Permission.CREATE, PermissionScope.ITEM);

    public Api getApi() {
        return new Api(this);
    }

    @CheckForNull
    public RepositoryBrowser<?> getBrowser() {
        return null;
    }

    @Exported
    public String getType() {
        return this.getClass().getName();
    }

    @Exported(name="browser")
    @CheckForNull
    public final RepositoryBrowser<?> getEffectiveBrowser() {
        RepositoryBrowser<?> b = this.getBrowser();
        if (b != null) {
            return b;
        }
        if (useAutoBrowserHolder) {
            if (this.autoBrowserHolder == null) {
                this.autoBrowserHolder = new AutoBrowserHolder(this);
            }
            return this.autoBrowserHolder.get();
        }
        return this.guessBrowser();
    }

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    public boolean processWorkspaceBeforeDeletion(@Nonnull Job<?, ?> project, @Nonnull FilePath workspace, @Nonnull Node node) throws IOException, InterruptedException {
        if (project instanceof AbstractProject) {
            return this.processWorkspaceBeforeDeletion((AbstractProject)project, workspace, node);
        }
        return true;
    }

    @Deprecated
    public boolean processWorkspaceBeforeDeletion(AbstractProject<?, ?> project, FilePath workspace, Node node) throws IOException, InterruptedException {
        if (Util.isOverridden(SCM.class, this.getClass(), "processWorkspaceBeforeDeletion", Job.class, FilePath.class, Node.class)) {
            return this.processWorkspaceBeforeDeletion((Job<?, ?>)project, workspace, node);
        }
        return true;
    }

    @Deprecated
    public boolean pollChanges(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        throw new AbstractMethodError("you must override compareRemoteRevisionWith");
    }

    @CheckForNull
    public SCMRevisionState calcRevisionsFromBuild(@Nonnull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        if (build instanceof AbstractBuild && Util.isOverridden(SCM.class, this.getClass(), "calcRevisionsFromBuild", AbstractBuild.class, Launcher.class, TaskListener.class)) {
            return this.calcRevisionsFromBuild((AbstractBuild)build, launcher, listener);
        }
        throw new AbstractMethodError("you must override the new calcRevisionsFromBuild overload");
    }

    @Deprecated
    public SCMRevisionState calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return this.calcRevisionsFromBuild(build, launcher != null ? build.getWorkspace() : null, launcher, listener);
    }

    @Deprecated
    public SCMRevisionState _calcRevisionsFromBuild(AbstractBuild<?, ?> build, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return this.calcRevisionsFromBuild(build, launcher, listener);
    }

    public PollingResult compareRemoteRevisionWith(@Nonnull Job<?, ?> project, @Nullable Launcher launcher, @Nullable FilePath workspace, @Nonnull TaskListener listener, @Nonnull SCMRevisionState baseline) throws IOException, InterruptedException {
        if (project instanceof AbstractProject && Util.isOverridden(SCM.class, this.getClass(), "compareRemoteRevisionWith", AbstractProject.class, Launcher.class, FilePath.class, TaskListener.class, SCMRevisionState.class)) {
            return this.compareRemoteRevisionWith((AbstractProject)project, launcher, workspace, listener, baseline);
        }
        throw new AbstractMethodError("you must override the new overload of compareRemoteRevisionWith");
    }

    @Deprecated
    protected PollingResult compareRemoteRevisionWith(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        return this.compareRemoteRevisionWith((Job<?, ?>)project, launcher, workspace, listener, baseline);
    }

    public final PollingResult poll(AbstractProject<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        if (this.is1_346OrLater()) {
            SCMRevisionState baseline2 = baseline != SCMRevisionState.NONE ? baseline : this.calcRevisionsFromBuild((AbstractBuild<?, ?>)project.getLastBuild(), launcher, listener);
            return this.compareRemoteRevisionWith(project, launcher, workspace, listener, baseline2);
        }
        return this.pollChanges(project, launcher, workspace, listener) ? PollingResult.SIGNIFICANT : PollingResult.NO_CHANGES;
    }

    private boolean is1_346OrLater() {
        for (Class<?> c = this.getClass(); c != SCM.class; c = c.getSuperclass()) {
            try {
                c.getDeclaredMethod("compareRemoteRevisionWith", AbstractProject.class, Launcher.class, FilePath.class, TaskListener.class, SCMRevisionState.class);
                return true;
            }
            catch (NoSuchMethodException e) {
                try {
                    c.getDeclaredMethod("compareRemoteRevisionWith", Job.class, Launcher.class, FilePath.class, TaskListener.class, SCMRevisionState.class);
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
        }
        return false;
    }

    @Nonnull
    public String getKey() {
        return this.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkout(@Nonnull Run<?, ?> build, @Nonnull Launcher launcher, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState baseline) throws IOException, InterruptedException {
        block8: {
            if (build instanceof AbstractBuild && listener instanceof BuildListener && Util.isOverridden(SCM.class, this.getClass(), "checkout", AbstractBuild.class, Launcher.class, FilePath.class, BuildListener.class, File.class)) {
                if (changelogFile == null) {
                    changelogFile = File.createTempFile("changelog", ".xml");
                    try {
                        if (!this.checkout((AbstractBuild)build, launcher, workspace, (BuildListener)listener, changelogFile)) {
                            throw new AbortException();
                        }
                        break block8;
                    }
                    finally {
                        Util.deleteFile(changelogFile);
                    }
                }
                if (!this.checkout((AbstractBuild)build, launcher, workspace, (BuildListener)listener, changelogFile)) {
                    throw new AbortException();
                }
            } else {
                throw new AbstractMethodError("you must override the new overload of checkout");
            }
        }
    }

    @Deprecated
    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, @Nonnull File changelogFile) throws IOException, InterruptedException {
        Run prev = build.getPreviousBuild();
        this.checkout(build, launcher, workspace, listener, changelogFile, prev != null ? prev.getAction(SCMRevisionState.class) : null);
        return true;
    }

    public void postCheckout(@Nonnull Run<?, ?> build, @Nonnull Launcher launcher, @Nonnull FilePath workspace, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        if (build instanceof AbstractBuild && listener instanceof BuildListener) {
            this.postCheckout((AbstractBuild)build, launcher, workspace, (BuildListener)listener);
        }
    }

    @Deprecated
    public void postCheckout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener) throws IOException, InterruptedException {
        if (Util.isOverridden(SCM.class, this.getClass(), "postCheckout", Run.class, Launcher.class, FilePath.class, TaskListener.class)) {
            this.postCheckout(build, launcher, workspace, (TaskListener)listener);
        }
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
    }

    public FilePath getModuleRoot(FilePath workspace, AbstractBuild build) {
        return this.getModuleRoot(workspace);
    }

    @Deprecated
    public FilePath getModuleRoot(FilePath workspace) {
        if (Util.isOverridden(SCM.class, this.getClass(), "getModuleRoot", FilePath.class, AbstractBuild.class)) {
            return this.getModuleRoot(workspace, null);
        }
        return workspace;
    }

    public FilePath[] getModuleRoots(FilePath workspace, AbstractBuild build) {
        if (Util.isOverridden(SCM.class, this.getClass(), "getModuleRoots", FilePath.class)) {
            return this.getModuleRoots(workspace);
        }
        return new FilePath[]{this.getModuleRoot(workspace, build)};
    }

    @Deprecated
    public FilePath[] getModuleRoots(FilePath workspace) {
        if (Util.isOverridden(SCM.class, this.getClass(), "getModuleRoots", FilePath.class, AbstractBuild.class)) {
            return this.getModuleRoots(workspace, null);
        }
        return new FilePath[]{this.getModuleRoot(workspace)};
    }

    public abstract ChangeLogParser createChangeLogParser();

    @Override
    public SCMDescriptor<?> getDescriptor() {
        return (SCMDescriptor)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    @Deprecated
    protected final boolean createEmptyChangeLog(File changelogFile, BuildListener listener, String rootTag) {
        try {
            this.createEmptyChangeLog(changelogFile, (TaskListener)listener, rootTag);
            return true;
        }
        catch (IOException e) {
            Functions.printStackTrace((Throwable)e, listener.error(e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void createEmptyChangeLog(@Nonnull File changelogFile, @Nonnull TaskListener listener, @Nonnull String rootTag) throws IOException {
        FileWriter w = null;
        try {
            w = new FileWriter(changelogFile);
            w.write("<" + rootTag + "/>");
            w.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(w);
            throw throwable;
        }
        IOUtils.closeQuietly(w);
    }

    protected final String nullify(String s) {
        if (s == null) {
            return null;
        }
        if (s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    public static DescriptorExtensionList<SCM, SCMDescriptor<?>> all() {
        return Jenkins.getInstance().getDescriptorList(SCM.class);
    }

    public static List<SCMDescriptor<?>> _for(@CheckForNull Job project) {
        if (project == null) {
            return SCM.all();
        }
        Descriptor pd = Jenkins.getInstance().getDescriptor(project.getClass());
        ArrayList r = new ArrayList();
        for (SCMDescriptor scmDescriptor : SCM.all()) {
            TopLevelItemDescriptor apd;
            if (!scmDescriptor.isApplicable(project) || pd instanceof TopLevelItemDescriptor && !(apd = (TopLevelItemDescriptor)pd).isApplicable(scmDescriptor)) continue;
            r.add(scmDescriptor);
        }
        return r;
    }

    @Deprecated
    public static List<SCMDescriptor<?>> _for(AbstractProject project) {
        return SCM._for((Job)project);
    }

    @CheckForNull
    public RepositoryBrowser<?> guessBrowser() {
        return null;
    }
}

