/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.trilead.ssh2.crypto.Base64;
import hudson.Util;
import hudson.util.Secret;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import jenkins.model.Jenkins;
import jenkins.security.CryptoConfidentialKey;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class HistoricalSecrets {
    private static final String MAGIC = "::::MAGIC::::";

    static Secret decrypt(String data, CryptoConfidentialKey key) throws IOException, GeneralSecurityException {
        byte[] in = Base64.decode((char[])data.toCharArray());
        Secret s = HistoricalSecrets.tryDecrypt(key.decrypt(), in);
        if (s != null) {
            return s;
        }
        Cipher cipher = Secret.getCipher("AES");
        cipher.init(2, HistoricalSecrets.getLegacyKey());
        return HistoricalSecrets.tryDecrypt(cipher, in);
    }

    static Secret tryDecrypt(Cipher cipher, byte[] in) {
        try {
            String plainText = new String(cipher.doFinal(in), StandardCharsets.UTF_8);
            if (plainText.endsWith(MAGIC)) {
                return new Secret(plainText.substring(0, plainText.length() - MAGIC.length()));
            }
            return null;
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    @Deprecated
    static SecretKey getLegacyKey() throws GeneralSecurityException {
        String secret = Secret.SECRET;
        if (secret == null) {
            return Jenkins.getInstance().getSecretKeyAsAES128();
        }
        return Util.toAes128Key(secret);
    }
}

