/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.jna;

import com.sun.jna.ptr.IntByReference;
import hudson.util.jna.Advapi32;
import hudson.util.jna.JnaException;
import hudson.util.jna.WINBASE;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;

public class RegistryKey {
    private int handle;
    private final RegistryKey root;
    private final String path;
    public static final RegistryKey CLASSES_ROOT = new RegistryKey(Integer.MIN_VALUE);
    public static final RegistryKey CURRENT_USER = new RegistryKey(-2147483647);
    public static final RegistryKey LOCAL_MACHINE = new RegistryKey(-2147483646);
    public static final RegistryKey USERS = new RegistryKey(-2147483645);

    private RegistryKey(int handle) {
        this.handle = handle;
        this.root = this;
        this.path = "";
    }

    private RegistryKey(RegistryKey ancestor, String path, int handle) {
        this.handle = handle;
        this.root = ancestor.root;
        this.path = RegistryKey.combine(ancestor.path, path);
    }

    private static String combine(String a, String b) {
        if (a.length() == 0) {
            return b;
        }
        if (b.length() == 0) {
            return a;
        }
        return a + '\\' + b;
    }

    private static String convertBufferToString(byte[] buf) {
        try {
            return new String(buf, 0, buf.length - 2, "UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static int convertBufferToInt(byte[] buf) {
        return (buf[0] & 0xFF) + ((buf[1] & 0xFF) << 8) + ((buf[2] & 0xFF) << 16) + ((buf[3] & 0xFF) << 24);
    }

    public String getStringValue(String valueName) {
        return RegistryKey.convertBufferToString(this.getValue(valueName));
    }

    public int getIntValue(String valueName) {
        return RegistryKey.convertBufferToInt(this.getValue(valueName));
    }

    private byte[] getValue(String valueName) {
        int r;
        byte[] lpData = new byte[1];
        IntByReference pType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        block4: while (true) {
            r = Advapi32.INSTANCE.RegQueryValueEx(this.handle, valueName, null, pType, lpData, lpcbData);
            switch (r) {
                case 234: {
                    lpData = new byte[lpcbData.getValue()];
                    continue block4;
                }
                case 0: {
                    return lpData;
                }
            }
            break;
        }
        throw new JnaException(r);
    }

    public void deleteValue(String valueName) {
        this.check(Advapi32.INSTANCE.RegDeleteValue(this.handle, valueName));
    }

    private void check(int r) {
        if (r != 0) {
            throw new JnaException(r);
        }
    }

    public void setValue(String name, String value) {
        try {
            byte[] bytes = value.getBytes("UTF-16LE");
            int newLength = bytes.length + 2;
            byte[] with0 = new byte[newLength];
            System.arraycopy(bytes, 0, with0, 0, newLength);
            this.check(Advapi32.INSTANCE.RegSetValueEx(this.handle, name, 0, 1, with0, with0.length));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setValue(String name, int value) {
        byte[] data = new byte[]{(byte)(value & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        this.check(Advapi32.INSTANCE.RegSetValueEx(this.handle, name, 0, 4, data, data.length));
    }

    public boolean valueExists(String name) {
        int r;
        byte[] lpData = new byte[1];
        IntByReference pType = new IntByReference();
        IntByReference lpcbData = new IntByReference();
        block5: while (true) {
            r = Advapi32.INSTANCE.RegQueryValueEx(this.handle, name, null, pType, lpData, lpcbData);
            switch (r) {
                case 234: {
                    lpData = new byte[lpcbData.getValue()];
                    continue block5;
                }
                case 2: {
                    return false;
                }
                case 0: {
                    return true;
                }
            }
            break;
        }
        throw new JnaException(r);
    }

    public void delete() {
        this.check(Advapi32.INSTANCE.RegDeleteKey(this.handle, this.path));
        this.dispose();
    }

    public Collection<String> getSubKeys() {
        TreeSet<String> subKeys = new TreeSet<String>();
        char[] lpName = new char[256];
        IntByReference lpcName = new IntByReference(256);
        WINBASE.FILETIME lpftLastWriteTime = new WINBASE.FILETIME();
        int dwIndex = 0;
        while (Advapi32.INSTANCE.RegEnumKeyEx(this.handle, dwIndex, lpName, lpcName, null, null, null, lpftLastWriteTime) == 0) {
            subKeys.add(new String(lpName, 0, lpcName.getValue()));
            lpcName.setValue(256);
            ++dwIndex;
        }
        return subKeys;
    }

    public RegistryKey open(String subKeyName) {
        return this.open(subKeyName, 983103);
    }

    public RegistryKey openReadonly(String subKeyName) {
        return this.open(subKeyName, 131097);
    }

    public RegistryKey open(String subKeyName, int access) {
        IntByReference pHandle = new IntByReference();
        this.check(Advapi32.INSTANCE.RegOpenKeyEx(this.handle, subKeyName, 0, access, pHandle));
        return new RegistryKey(this, subKeyName, pHandle.getValue());
    }

    public TreeMap<String, Object> getValues() {
        TreeMap<String, Object> values = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        char[] lpValueName = new char[16384];
        IntByReference lpcchValueName = new IntByReference(16384);
        IntByReference lpType = new IntByReference();
        byte[] lpData = new byte[1];
        IntByReference lpcbData = new IntByReference();
        lpcbData.setValue(0);
        int dwIndex = 0;
        block9: while (true) {
            int result = Advapi32.INSTANCE.RegEnumValue(this.handle, dwIndex, lpValueName, lpcchValueName, null, lpType, lpData, lpcbData);
            block0 : switch (result) {
                case 259: {
                    return values;
                }
                case 234: {
                    lpData = new byte[lpcbData.getValue()];
                    lpcchValueName = new IntByReference(16384);
                    continue block9;
                }
                case 0: {
                    String name = new String(lpValueName, 0, lpcchValueName.getValue());
                    switch (lpType.getValue()) {
                        case 1: {
                            values.put(name, RegistryKey.convertBufferToString(lpData));
                            break block0;
                        }
                        case 4: {
                            values.put(name, RegistryKey.convertBufferToInt(lpData));
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    this.check(result);
                }
            }
            ++dwIndex;
            lpcbData.setValue(0);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void dispose() {
        if (this.handle != 0) {
            Advapi32.INSTANCE.RegCloseKey(this.handle);
        }
        this.handle = 0;
    }
}

