/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import hudson.PluginWrapper;
import hudson.model.Descriptor;
import hudson.model.UpdateSite;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

@Extension
@Restricted(value={NoExternalUse.class})
public class UpdateSiteWarningsConfiguration
extends GlobalConfiguration {
    private HashSet<String> ignoredWarnings = new HashSet();

    @Override
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public UpdateSiteWarningsConfiguration() {
        this.load();
    }

    @Nonnull
    public Set<String> getIgnoredWarnings() {
        return Collections.unmodifiableSet(this.ignoredWarnings);
    }

    public boolean isIgnored(@Nonnull UpdateSite.Warning warning) {
        return this.ignoredWarnings.contains(warning.id);
    }

    @CheckForNull
    public PluginWrapper getPlugin(@Nonnull UpdateSite.Warning warning) {
        if (warning.type != UpdateSite.Warning.Type.PLUGIN) {
            return null;
        }
        return Jenkins.getInstance().getPluginManager().getPlugin(warning.component);
    }

    @Nonnull
    public Set<UpdateSite.Warning> getAllWarnings() {
        HashSet<UpdateSite.Warning> allWarnings = new HashSet<UpdateSite.Warning>();
        for (UpdateSite site : Jenkins.getInstance().getUpdateCenter().getSites()) {
            UpdateSite.Data data = site.getData();
            if (data == null) continue;
            allWarnings.addAll(data.getWarnings());
        }
        return allWarnings;
    }

    @Nonnull
    public Set<UpdateSite.Warning> getApplicableWarnings() {
        Set<UpdateSite.Warning> allWarnings = this.getAllWarnings();
        HashSet<UpdateSite.Warning> applicableWarnings = new HashSet<UpdateSite.Warning>();
        for (UpdateSite.Warning warning : allWarnings) {
            if (!warning.isRelevant()) continue;
            applicableWarnings.add(warning);
        }
        return Collections.unmodifiableSet(applicableWarnings);
    }

    @Override
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        HashSet<String> newIgnoredWarnings = new HashSet<String>();
        for (Object key : json.keySet()) {
            String warningKey = key.toString();
            if (json.getBoolean(warningKey)) continue;
            newIgnoredWarnings.add(warningKey);
        }
        this.ignoredWarnings = newIgnoredWarnings;
        this.save();
        return true;
    }
}

