/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import hudson.util.ChunkedInputStream;
import hudson.util.ChunkedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class FullDuplexHttpService {
    @Restricted(value={NoExternalUse.class})
    public static boolean DIY_CHUNKING = SystemProperties.getBoolean("hudson.diyChunking");
    @Restricted(value={NoExternalUse.class})
    public static long CONNECTION_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    protected final UUID uuid;
    private InputStream upload;
    private boolean completed;

    protected FullDuplexHttpService(UUID uuid) {
        this.uuid = uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void download(StaplerRequest req, StaplerResponse rsp) throws InterruptedException, IOException {
        rsp.setStatus(200);
        rsp.addHeader("Transfer-Encoding", "chunked");
        Object out = rsp.getOutputStream();
        if (DIY_CHUNKING) {
            out = new ChunkedOutputStream((OutputStream)out);
        }
        out.write(0);
        out.flush();
        long end = System.currentTimeMillis() + CONNECTION_TIMEOUT;
        while (this.upload == null && System.currentTimeMillis() < end) {
            this.wait(1000L);
        }
        if (this.upload == null) {
            throw new IOException("HTTP full-duplex channel timeout: " + this.uuid);
        }
        try {
            this.run(this.upload, (OutputStream)out);
        }
        finally {
            this.completed = true;
            this.notify();
        }
    }

    protected abstract void run(InputStream var1, OutputStream var2) throws IOException, InterruptedException;

    public synchronized void upload(StaplerRequest req, StaplerResponse rsp) throws InterruptedException, IOException {
        rsp.setStatus(200);
        Object in = req.getInputStream();
        if (DIY_CHUNKING) {
            in = new ChunkedInputStream((InputStream)in);
        }
        this.upload = in;
        this.notify();
        while (!this.completed) {
            this.wait();
        }
    }

    public static abstract class Response
    extends HttpResponses.HttpResponseException {
        private final Map<UUID, FullDuplexHttpService> services;

        protected Response(Map<UUID, FullDuplexHttpService> services) {
            this.services = services;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            block6: {
                try {
                    UUID uuid = UUID.fromString(req.getHeader("Session"));
                    rsp.setHeader("Hudson-Duplex", "true");
                    if (req.getHeader("Side").equals("download")) {
                        FullDuplexHttpService service = this.createService(req, uuid);
                        this.services.put(uuid, service);
                        try {
                            service.download(req, rsp);
                            break block6;
                        }
                        finally {
                            this.services.remove(uuid);
                        }
                    }
                    this.services.get(uuid).upload(req, rsp);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
        }

        protected abstract FullDuplexHttpService createService(StaplerRequest var1, UUID var2) throws IOException, InterruptedException;
    }
}

