/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.TokenList;
import org.kohsuke.stapler.bind.BoundObjectTable;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public abstract class ProgressiveRendering {
    private static final Logger LOG = Logger.getLogger(ProgressiveRendering.class.getName());
    private static final Long DEBUG_SLEEP = SystemProperties.getLong("jenkins.util.ProgressiveRendering.DEBUG_SLEEP");
    private static final int CANCELED = -1;
    private static final int ERROR = -2;
    private double status = 0.0;
    private long lastNewsTime;
    private final SecurityContext securityContext = SecurityContextHolder.getContext();
    private final RequestImpl request = ProgressiveRendering.createMockRequest();
    private final String uri = this.request.getRequestURI();
    private long start;
    private BoundObjectTable.Table boundObjectTable;
    private String boundId;

    protected ProgressiveRendering() {
    }

    @JavaScriptMethod
    public final void start() {
        Ancestor ancestor = Stapler.getCurrentRequest().findAncestor(BoundObjectTable.class);
        if (ancestor == null) {
            throw new IllegalStateException("no BoundObjectTable");
        }
        this.boundObjectTable = ((BoundObjectTable)ancestor.getObject()).getTable();
        this.boundId = ancestor.getNextToken(0);
        LOG.log(Level.FINE, "starting rendering {0} at {1}", new Object[]{this.uri, this.boundId});
        final ExecutorService executorService = this.executorService();
        executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SecurityContext orig;
                block5: {
                    ProgressiveRendering.this.lastNewsTime = (ProgressiveRendering.this.start = System.currentTimeMillis());
                    ProgressiveRendering.setCurrentRequest(ProgressiveRendering.this.request);
                    orig = SecurityContextHolder.getContext();
                    try {
                        SecurityContextHolder.setContext((SecurityContext)ProgressiveRendering.this.securityContext);
                        ProgressiveRendering.this.compute();
                        if (ProgressiveRendering.this.status == -1.0 || ProgressiveRendering.this.status == -2.0) break block5;
                        ProgressiveRendering.this.status = 1.0;
                    }
                    catch (Exception x) {
                        try {
                            LOG.log(Level.WARNING, "failed to compute " + ProgressiveRendering.this.uri, x);
                            ProgressiveRendering.this.status = -2.0;
                        }
                        catch (Throwable throwable) {
                            SecurityContextHolder.setContext((SecurityContext)orig);
                            ProgressiveRendering.setCurrentRequest(null);
                            LOG.log(Level.FINE, "{0} finished in {1}msec with status {2}", new Object[]{ProgressiveRendering.this.uri, System.currentTimeMillis() - ProgressiveRendering.this.start, ProgressiveRendering.this.status});
                            throw throwable;
                        }
                        SecurityContextHolder.setContext((SecurityContext)orig);
                        ProgressiveRendering.setCurrentRequest(null);
                        LOG.log(Level.FINE, "{0} finished in {1}msec with status {2}", new Object[]{ProgressiveRendering.this.uri, System.currentTimeMillis() - ProgressiveRendering.this.start, ProgressiveRendering.this.status});
                    }
                }
                SecurityContextHolder.setContext((SecurityContext)orig);
                ProgressiveRendering.setCurrentRequest(null);
                LOG.log(Level.FINE, "{0} finished in {1}msec with status {2}", new Object[]{ProgressiveRendering.this.uri, System.currentTimeMillis() - ProgressiveRendering.this.start, ProgressiveRendering.this.status});
                if (executorService instanceof ScheduledExecutorService) {
                    ((ScheduledExecutorService)executorService).schedule(new Runnable(){

                        @Override
                        public void run() {
                            LOG.log(Level.FINE, "some time has elapsed since {0} finished, so releasing", ProgressiveRendering.this.boundId);
                            ProgressiveRendering.this.release();
                        }
                    }, ProgressiveRendering.this.timeout() * 2L, TimeUnit.MILLISECONDS);
                }
            }
        });
    }

    private void release() {
        try {
            Method release = BoundObjectTable.Table.class.getDeclaredMethod("release", String.class);
            release.setAccessible(true);
            release.invoke((Object)this.boundObjectTable, this.boundId);
        }
        catch (Exception x) {
            LOG.log(Level.WARNING, "failed to unbind " + this.boundId, x);
        }
    }

    private static RequestImpl createMockRequest() {
        RequestImpl currentRequest = (RequestImpl)Stapler.getCurrentRequest();
        HttpServletRequest original = (HttpServletRequest)currentRequest.getRequest();
        final HashMap<String, Object> getters = new HashMap<String, Object>();
        for (Method method : HttpServletRequest.class.getMethods()) {
            Class<?> type;
            String m = method.getName();
            if (!m.startsWith("get") && !m.startsWith("is") || method.getParameterTypes().length != 0 || !(type = method.getReturnType()).isPrimitive() && type != String.class && type != Locale.class) continue;
            try {
                getters.put(m, method.invoke((Object)original, new Object[0]));
            }
            catch (Exception x) {
                LOG.log(Level.WARNING, "cannot mock Stapler request " + method, x);
            }
        }
        List ancestors = currentRequest.ancestors;
        LOG.log(Level.FINER, "mocking ancestors {0} using {1}", new Object[]{ancestors, getters});
        TokenList tokens = currentRequest.tokens;
        return new RequestImpl(Stapler.getCurrent(), (HttpServletRequest)Proxy.newProxyInstance(ProgressiveRendering.class.getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String m = method.getName();
                if (getters.containsKey(m)) {
                    return getters.get(m);
                }
                throw new UnsupportedOperationException(m);
            }
        }), ancestors, tokens);
    }

    private static void setCurrentRequest(RequestImpl request) {
        try {
            Field field = Stapler.class.getDeclaredField("CURRENT_REQUEST");
            field.setAccessible(true);
            ((ThreadLocal)field.get(null)).set(request);
        }
        catch (Exception x) {
            LOG.log(Level.WARNING, "cannot mock Stapler request", x);
        }
    }

    protected abstract void compute() throws Exception;

    @Nonnull
    protected abstract JSON data();

    protected final void progress(double completedFraction) {
        if (completedFraction < 0.0 || completedFraction > 1.0) {
            throw new IllegalArgumentException(completedFraction + " should be in [0,1]");
        }
        this.status = completedFraction;
    }

    protected final boolean canceled() {
        if (DEBUG_SLEEP != null) {
            try {
                Thread.sleep(DEBUG_SLEEP);
            }
            catch (InterruptedException x) {
                // empty catch block
            }
        }
        if (this.status == -2.0) {
            return true;
        }
        long now = System.currentTimeMillis();
        long elapsed = now - this.lastNewsTime;
        if (elapsed > this.timeout()) {
            this.status = -1.0;
            LOG.log(Level.FINE, "{0} canceled due to {1}msec inactivity after {2}msec", new Object[]{this.uri, elapsed, now - this.start});
            return true;
        }
        return false;
    }

    @JavaScriptMethod
    public final JSONObject news() {
        this.lastNewsTime = System.currentTimeMillis();
        JSONObject r = new JSONObject();
        try {
            r.put("data", (Object)this.data());
        }
        catch (RuntimeException x) {
            LOG.log(Level.WARNING, "failed to update " + this.uri, x);
            this.status = -2.0;
        }
        String statusJSON = this.status == 1.0 ? "done" : (this.status == -1.0 ? "canceled" : (this.status == -2.0 ? "error" : Double.valueOf(this.status)));
        r.put("status", (Object)statusJSON);
        if (statusJSON instanceof String) {
            LOG.log(Level.FINE, "finished in news so releasing {0}", this.boundId);
            this.release();
        }
        this.lastNewsTime = System.currentTimeMillis();
        LOG.log(Level.FINER, "news from {0}", this.uri);
        return r;
    }

    protected ExecutorService executorService() {
        return Timer.get();
    }

    protected long timeout() {
        return 15000L;
    }
}

