/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import hudson.BulkChange;
import hudson.Functions;
import hudson.Util;
import hudson.XmlFile;
import hudson.cli.declarative.CLIResolver;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.Descriptor;
import hudson.model.DescriptorByNameOwner;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.SaveableListener;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.util.AlternativeUiTextProvider;
import hudson.util.AtomicFileWriter;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import jenkins.security.NotReallyRoleSensitiveCallable;
import jenkins.util.xml.XMLUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.HttpDeletable;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.xml.sax.SAXException;

@ExportedBean
@BridgeMethodsAdded
public abstract class AbstractItem
extends Actionable
implements Item,
HttpDeletable,
AccessControlled,
DescriptorByNameOwner {
    private static final Logger LOGGER = Logger.getLogger(AbstractItem.class.getName());
    protected transient String name;
    protected volatile String description;
    private transient ItemGroup parent;
    protected String displayName;
    static final Pattern SECRET_PATTERN = Pattern.compile(">(" + Secret.ENCRYPTED_VALUE_PATTERN + ")<");
    public static final AlternativeUiTextProvider.Message<AbstractItem> PRONOUN = new AlternativeUiTextProvider.Message();

    protected AbstractItem(ItemGroup parent, String name) {
        this.parent = parent;
        this.doSetName(name);
    }

    @Override
    public void onCreatedFromScratch() {
    }

    @Override
    @Exported(visibility=999)
    public String getName() {
        return this.name;
    }

    public String getPronoun() {
        return AlternativeUiTextProvider.get(PRONOUN, this, Messages.AbstractItem_Pronoun());
    }

    @Override
    @Exported
    public String getDisplayName() {
        if (null != this.displayName) {
            return this.displayName;
        }
        return this.getName();
    }

    @Exported
    public String getDisplayNameOrNull() {
        return this.displayName;
    }

    public void setDisplayNameOrNull(String displayName) throws IOException {
        this.setDisplayName(displayName);
    }

    public void setDisplayName(String displayName) throws IOException {
        this.displayName = Util.fixEmptyAndTrim(displayName);
        this.save();
    }

    @Override
    public File getRootDir() {
        return this.getParent().getRootDirFor(this);
    }

    @Nonnull
    @WithBridgeMethods(value={Jenkins.class}, castRequired=true)
    public ItemGroup getParent() {
        if (this.parent == null) {
            throw new IllegalStateException("no parent set on " + this.getClass().getName() + "[" + this.name + "]");
        }
        return this.parent;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) throws IOException {
        this.description = description;
        this.save();
        ItemListener.fireOnUpdated(this);
    }

    protected void doSetName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renameTo(String newName) throws IOException {
        ItemGroup parent = this.getParent();
        String oldName = this.name;
        String oldFullName = this.getFullName();
        ItemGroup itemGroup = parent;
        synchronized (itemGroup) {
            AbstractItem abstractItem = this;
            synchronized (abstractItem) {
                if (newName == null) {
                    throw new IllegalArgumentException("New name is not given");
                }
                if (this.name.equals(newName)) {
                    return;
                }
                Items.verifyItemDoesNotAlreadyExist(parent, newName, this);
                File oldRoot = this.getRootDir();
                this.doSetName(newName);
                File newRoot = this.getRootDir();
                boolean success = false;
                try {
                    boolean interrupted = false;
                    boolean renamed = false;
                    for (int retry = 0; retry < 5; ++retry) {
                        if (oldRoot.renameTo(newRoot)) {
                            renamed = true;
                            break;
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    if (!renamed) {
                        Copy cp = new Copy();
                        cp.setProject(new Project());
                        cp.setTodir(newRoot);
                        FileSet src = new FileSet();
                        src.setDir(oldRoot);
                        cp.addFileset(src);
                        cp.setOverwrite(true);
                        cp.setPreserveLastModified(true);
                        cp.setFailOnError(false);
                        cp.execute();
                        try {
                            Util.deleteRecursive(oldRoot);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    success = true;
                }
                finally {
                    if (!success) {
                        this.doSetName(oldName);
                    }
                }
                try {
                    parent.onRenamed(this, oldName, newName);
                }
                catch (AbstractMethodError _) {
                    // empty catch block
                }
            }
        }
        ItemListener.fireLocationChange(this, oldFullName);
    }

    public void movedTo(DirectlyModifiableTopLevelItemGroup destination, AbstractItem newItem, File destDir) throws IOException {
        newItem.onLoad(destination, this.name);
    }

    @Override
    public abstract Collection<? extends Job> getAllJobs();

    @Override
    @Exported
    public final String getFullName() {
        String n = this.getParent().getFullName();
        if (n.length() == 0) {
            return this.getName();
        }
        return n + '/' + this.getName();
    }

    @Override
    @Exported
    public final String getFullDisplayName() {
        String n = this.getParent().getFullDisplayName();
        if (n.length() == 0) {
            return this.getDisplayName();
        }
        return n + " \u00bb " + this.getDisplayName();
    }

    public String getRelativeDisplayNameFrom(ItemGroup p) {
        return Functions.getRelativeDisplayNameFrom(this, p);
    }

    public String getRelativeNameFromGroup(ItemGroup p) {
        return this.getRelativeNameFrom(p);
    }

    @Override
    public String getRelativeNameFrom(ItemGroup p) {
        return Functions.getRelativeNameFrom(this, p);
    }

    @Override
    public String getRelativeNameFrom(Item item) {
        return this.getRelativeNameFrom(item.getParent());
    }

    @Override
    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        this.parent = parent;
        this.doSetName(name);
    }

    @Override
    public void onCopiedFrom(Item src) {
    }

    @Override
    public final String getUrl() {
        String uri;
        StaplerRequest req = Stapler.getCurrentRequest();
        String shortUrl = this.getShortUrl();
        String string = uri = req == null ? null : req.getRequestURI();
        if (req != null) {
            String seed = Functions.getNearestAncestorUrl(req, this);
            LOGGER.log(Level.FINER, "seed={0} for {1} from {2}", new Object[]{seed, this, uri});
            if (seed != null) {
                return seed.substring(req.getContextPath().length() + 1) + '/';
            }
            List ancestors = req.getAncestors();
            if (!ancestors.isEmpty()) {
                Ancestor last = (Ancestor)ancestors.get(ancestors.size() - 1);
                if (last.getObject() instanceof View) {
                    View view = (View)last.getObject();
                    if (view.getOwnerItemGroup() == this.getParent() && !view.isDefault()) {
                        String base = last.getUrl().substring(req.getContextPath().length() + 1) + '/';
                        LOGGER.log(Level.FINER, "using {0}{1} for {2} from {3}", new Object[]{base, shortUrl, this, uri});
                        return base + shortUrl;
                    }
                    LOGGER.log(Level.FINER, "irrelevant {0} for {1} from {2}", new Object[]{view.getViewName(), this, uri});
                } else {
                    LOGGER.log(Level.FINER, "inapplicable {0} for {1} from {2}", new Object[]{last.getObject(), this, uri});
                }
            } else {
                LOGGER.log(Level.FINER, "no ancestors for {0} from {1}", new Object[]{this, uri});
            }
        } else {
            LOGGER.log(Level.FINER, "no current request for {0}", this);
        }
        String base = this.getParent().getUrl();
        LOGGER.log(Level.FINER, "falling back to {0}{1} for {2} from {3}", new Object[]{base, shortUrl, this, uri});
        return base + shortUrl;
    }

    @Override
    public String getShortUrl() {
        String prefix = this.getParent().getUrlChildPrefix();
        String subdir = Util.rawEncode(this.getName());
        return prefix.equals(".") ? subdir + '/' : prefix + '/' + subdir + '/';
    }

    @Override
    public String getSearchUrl() {
        return this.getShortUrl();
    }

    @Override
    @Exported(visibility=999, name="url")
    public final String getAbsoluteUrl() {
        String r = Jenkins.getInstance().getRootUrl();
        if (r == null) {
            throw new IllegalStateException("Root URL isn't configured yet. Cannot compute absolute URL.");
        }
        return Util.encode(r + this.getUrl());
    }

    public final Api getApi() {
        return new Api(this);
    }

    @Override
    public ACL getACL() {
        return Jenkins.getInstance().getAuthorizationStrategy().getACL(this);
    }

    @Override
    public void checkPermission(Permission p) {
        this.getACL().checkPermission(p);
    }

    @Override
    public boolean hasPermission(Permission p) {
        return this.getACL().hasPermission(p);
    }

    @Override
    public synchronized void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        this.getConfigFile().write(this);
        SaveableListener.fireOnChange(this, this.getConfigFile());
    }

    public final XmlFile getConfigFile() {
        return Items.getConfigFile(this);
    }

    @Override
    public Descriptor getDescriptorByName(String className) {
        return Jenkins.getInstance().getDescriptorByName(className);
    }

    @RequirePOST
    public synchronized void doSubmitDescription(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.checkPermission(CONFIGURE);
        this.setDescription(req.getParameter("description"));
        rsp.sendRedirect(".");
    }

    @RequirePOST
    public void doDoDelete(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        this.delete();
        if (req == null || rsp == null) {
            return;
        }
        List ancestors = req.getAncestors();
        ListIterator it = ancestors.listIterator(ancestors.size());
        String url = this.getParent().getUrl();
        while (it.hasPrevious()) {
            Object a = ((Ancestor)it.previous()).getObject();
            if (a instanceof View) {
                url = ((View)a).getUrl();
                break;
            }
            if (!(a instanceof ViewGroup) || a == this) continue;
            url = ((ViewGroup)a).getUrl();
            break;
        }
        rsp.sendRedirect2(req.getContextPath() + '/' + url);
    }

    public void delete(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        try {
            this.doDoDelete(req, rsp);
        }
        catch (InterruptedException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws IOException, InterruptedException {
        this.checkPermission(DELETE);
        AbstractItem abstractItem = this;
        synchronized (abstractItem) {
            this.performDelete();
        }
        this.getParent().onDeleted(this);
        Jenkins.getInstance().rebuildDependencyGraphAsync();
    }

    protected void performDelete() throws IOException, InterruptedException {
        this.getConfigFile().delete();
        Util.deleteRecursive(this.getRootDir());
    }

    @WebMethod(name={"config.xml"})
    public void doConfigDotXml(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.getMethod().equals("GET")) {
            rsp.setContentType("application/xml");
            this.writeConfigDotXml((OutputStream)rsp.getOutputStream());
            return;
        }
        if (req.getMethod().equals("POST")) {
            this.updateByXml((Source)new StreamSource(req.getReader()));
            return;
        }
        rsp.sendError(400);
    }

    @Restricted(value={NoExternalUse.class})
    public void writeConfigDotXml(OutputStream os) throws IOException {
        this.checkPermission(EXTENDED_READ);
        XmlFile configFile = this.getConfigFile();
        if (this.hasPermission(CONFIGURE)) {
            hudson.util.IOUtils.copy(configFile.getFile(), os);
        } else {
            String encoding = configFile.sniffEncoding();
            String xml = FileUtils.readFileToString((File)configFile.getFile(), (String)encoding);
            Matcher matcher = SECRET_PATTERN.matcher(xml);
            StringBuffer cleanXml = new StringBuffer();
            while (matcher.find()) {
                if (Secret.decrypt(matcher.group(1)) == null) continue;
                matcher.appendReplacement(cleanXml, ">********<");
            }
            matcher.appendTail(cleanXml);
            IOUtils.write((String)cleanXml.toString(), (OutputStream)os, (String)encoding);
        }
    }

    @Deprecated
    public void updateByXml(StreamSource source) throws IOException {
        this.updateByXml((Source)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByXml(Source source) throws IOException {
        this.checkPermission(CONFIGURE);
        XmlFile configXmlFile = this.getConfigFile();
        AtomicFileWriter out = new AtomicFileWriter(configXmlFile.getFile());
        try {
            try {
                XMLUtils.safeTransform(source, new StreamResult(out));
                out.close();
            }
            catch (TransformerException | SAXException e) {
                throw new IOException("Failed to persist config.xml", e);
            }
            Object o = new XmlFile(Items.XSTREAM, out.getTemporaryFile()).unmarshal(this);
            if (o != this) {
                throw new IOException("Expecting " + this.getClass() + " but got " + o.getClass() + " instead");
            }
            Items.whileUpdatingByXml(new NotReallyRoleSensitiveCallable<Void, IOException>(){

                public Void call() throws IOException {
                    AbstractItem.this.onLoad(AbstractItem.this.getParent(), AbstractItem.this.getRootDir().getName());
                    return null;
                }
            });
            Jenkins.getInstance().rebuildDependencyGraphAsync();
            out.commit();
            SaveableListener.fireOnChange(this, this.getConfigFile());
        }
        finally {
            out.abort();
        }
    }

    @RequirePOST
    public void doReload() throws IOException {
        this.checkPermission(CONFIGURE);
        this.getConfigFile().unmarshal(this);
        Items.whileUpdatingByXml(new NotReallyRoleSensitiveCallable<Void, IOException>(){

            public Void call() throws IOException {
                AbstractItem.this.onLoad(AbstractItem.this.getParent(), AbstractItem.this.getRootDir().getName());
                return null;
            }
        });
        Jenkins.getInstance().rebuildDependencyGraphAsync();
        SaveableListener.fireOnChange(this, this.getConfigFile());
    }

    @Override
    public String getSearchName() {
        return this.getName();
    }

    public String toString() {
        return super.toString() + '[' + (this.parent != null ? this.getFullName() : "?/" + this.name) + ']';
    }

    @CLIResolver
    public static AbstractItem resolveForCLI(@Argument(required=true, metaVar="NAME", usage="Job name") String name) throws CmdLineException {
        AbstractItem item = Jenkins.getInstance().getItemByFullName(name, AbstractItem.class);
        if (item == null) {
            AbstractProject project = AbstractProject.findNearest(name);
            throw new CmdLineException(null, project == null ? Messages.AbstractItem_NoSuchJobExistsWithoutSuggestion(name) : Messages.AbstractItem_NoSuchJobExists(name, project.getFullName()));
        }
        return item;
    }
}

