/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.cli.declarative.CLIResolver;
import hudson.console.AnnotatedLargeText;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.BuildTimelineWidget;
import hudson.model.ComputerPanelBox;
import hudson.model.ComputerPinger;
import hudson.model.ComputerSet;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Job;
import hudson.model.LoadStatistics;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.OneOffExecutor;
import hudson.model.Queue;
import hudson.model.RSS;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.TransientComputerActionFactory;
import hudson.model.User;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.WorkUnit;
import hudson.node_monitors.NodeMonitor;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.PermissionScope;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeProperty;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.WorkspaceList;
import hudson.util.DaemonThreadFactory;
import hudson.util.EditDistance;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.Futures;
import hudson.util.NamingThreadFactory;
import hudson.util.RemotingDiagnostics;
import hudson.util.RunList;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.GuardedBy;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.ContextResettingExecutorService;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public abstract class Computer
extends Actionable
implements AccessControlled,
ExecutorListener {
    private final CopyOnWriteArrayList<Executor> executors = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OneOffExecutor> oneOffExecutors = new CopyOnWriteArrayList();
    private int numExecutors;
    protected volatile OfflineCause offlineCause;
    private long connectTime = 0L;
    private boolean temporarilyOffline;
    protected String nodeName;
    private volatile String cachedHostName;
    private volatile boolean hostNameCached;
    private volatile EnvVars cachedEnvironment;
    private final WorkspaceList workspaceList = new WorkspaceList();
    protected transient List<Action> transientActions;
    protected final Object statusChangeLock = new Object();
    private final transient List<TerminationRequest> terminatedBy = Collections.synchronizedList(new ArrayList());
    public static final ExecutorService threadPoolForRemoting = new ContextResettingExecutorService(Executors.newCachedThreadPool(new ExceptionCatchingThreadFactory(new NamingThreadFactory(new DaemonThreadFactory(), "Computer.threadPoolForRemoting"))));
    public static final PermissionGroup PERMISSIONS = new PermissionGroup(Computer.class, Messages._Computer_Permissions_Title());
    public static final Permission CONFIGURE = new Permission(PERMISSIONS, "Configure", Messages._Computer_ConfigurePermission_Description(), Permission.CONFIGURE, PermissionScope.COMPUTER);
    public static final Permission EXTENDED_READ = new Permission(PERMISSIONS, "ExtendedRead", Messages._Computer_ExtendedReadPermission_Description(), CONFIGURE, SystemProperties.getBoolean("hudson.security.ExtendedReadPermission"), new PermissionScope[]{PermissionScope.COMPUTER});
    public static final Permission DELETE = new Permission(PERMISSIONS, "Delete", Messages._Computer_DeletePermission_Description(), Permission.DELETE, PermissionScope.COMPUTER);
    public static final Permission CREATE = new Permission(PERMISSIONS, "Create", Messages._Computer_CreatePermission_Description(), Permission.CREATE, PermissionScope.JENKINS);
    public static final Permission DISCONNECT = new Permission(PERMISSIONS, "Disconnect", Messages._Computer_DisconnectPermission_Description(), Jenkins.ADMINISTER, PermissionScope.COMPUTER);
    public static final Permission CONNECT = new Permission(PERMISSIONS, "Connect", Messages._Computer_ConnectPermission_Description(), DISCONNECT, PermissionScope.COMPUTER);
    public static final Permission BUILD = new Permission(PERMISSIONS, "Build", Messages._Computer_BuildPermission_Description(), Permission.WRITE, PermissionScope.COMPUTER);
    private static final Logger LOGGER = Logger.getLogger(Computer.class.getName());

    public void recordTermination() {
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null) {
            this.terminatedBy.add(new TerminationRequest(String.format("Termination requested at %s by %s [id=%d] from HTTP request for %s", new Date(), Thread.currentThread(), Thread.currentThread().getId(), request.getRequestURL())));
        } else {
            this.terminatedBy.add(new TerminationRequest(String.format("Termination requested at %s by %s [id=%d]", new Date(), Thread.currentThread(), Thread.currentThread().getId())));
        }
    }

    public List<TerminationRequest> getTerminatedBy() {
        return new ArrayList<TerminationRequest>(this.terminatedBy);
    }

    public Computer(Node node) {
        this.setNode(node);
    }

    public List<ComputerPanelBox> getComputerPanelBoxs() {
        return ComputerPanelBox.all(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Action> getActions() {
        ArrayList<Action> result = new ArrayList<Action>();
        result.addAll(super.getActions());
        Computer computer = this;
        synchronized (computer) {
            if (this.transientActions == null) {
                this.transientActions = TransientComputerActionFactory.createAllFor(this);
            }
            result.addAll(this.transientActions);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public void addAction(@Nonnull Action a) {
        if (a == null) {
            throw new IllegalArgumentException("Action must be non-null");
        }
        super.getActions().add(a);
    }

    @Nonnull
    public File getLogFile() {
        return new File(this.getLogDir(), "slave.log");
    }

    @Nonnull
    protected File getLogDir() {
        File dir = new File(Jenkins.getInstance().getRootDir(), "logs/slaves/" + this.nodeName);
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.severe("Failed to create agent log directory " + dir.getAbsolutePath());
        }
        return dir;
    }

    public WorkspaceList getWorkspaceList() {
        return this.workspaceList;
    }

    public String getLog() throws IOException {
        return Util.loadFile(this.getLogFile());
    }

    public AnnotatedLargeText<Computer> getLogText() {
        return new AnnotatedLargeText<Computer>(this.getLogFile(), Charset.defaultCharset(), false, this);
    }

    @Override
    public ACL getACL() {
        return Jenkins.getInstance().getAuthorizationStrategy().getACL(this);
    }

    @Override
    public void checkPermission(Permission permission) {
        this.getACL().checkPermission(permission);
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.getACL().hasPermission(permission);
    }

    @Exported
    public OfflineCause getOfflineCause() {
        return this.offlineCause;
    }

    @Exported
    public String getOfflineCauseReason() {
        if (this.offlineCause == null) {
            return "";
        }
        String gsub_base = hudson.slaves.Messages.SlaveComputer_DisconnectedBy("", "");
        String gsub1 = "^" + gsub_base + "[\\w\\W]* \\: ";
        String gsub2 = "^" + gsub_base + "[\\w\\W]*";
        String newString = this.offlineCause.toString().replaceAll(gsub1, "");
        return newString.replaceAll(gsub2, "");
    }

    @Nullable
    public abstract VirtualChannel getChannel();

    public abstract Charset getDefaultCharset();

    public abstract List<LogRecord> getLogRecords() throws IOException, InterruptedException;

    public abstract void doLaunchSlaveAgent(StaplerRequest var1, StaplerResponse var2) throws IOException, ServletException;

    @Deprecated
    public final void launch() {
        this.connect(true);
    }

    public final Future<?> connect(boolean forceReconnect) {
        this.connectTime = System.currentTimeMillis();
        return this._connect(forceReconnect);
    }

    protected abstract Future<?> _connect(boolean var1);

    @Deprecated
    public void cliConnect(boolean force) throws ExecutionException, InterruptedException {
        this.checkPermission(CONNECT);
        this.connect(force).get();
    }

    public final long getConnectTime() {
        return this.connectTime;
    }

    public Future<?> disconnect(OfflineCause cause) {
        this.recordTermination();
        this.offlineCause = cause;
        if (Util.isOverridden(Computer.class, this.getClass(), "disconnect", new Class[0])) {
            return this.disconnect();
        }
        this.connectTime = 0L;
        return Futures.precomputed(null);
    }

    @Deprecated
    public Future<?> disconnect() {
        this.recordTermination();
        if (Util.isOverridden(Computer.class, this.getClass(), "disconnect", OfflineCause.class)) {
            return this.disconnect(null);
        }
        this.connectTime = 0L;
        return Futures.precomputed(null);
    }

    @Deprecated
    public void cliDisconnect(String cause) throws ExecutionException, InterruptedException {
        this.checkPermission(DISCONNECT);
        this.disconnect(new OfflineCause.ByCLI(cause)).get();
    }

    @Deprecated
    public void cliOffline(String cause) throws ExecutionException, InterruptedException {
        this.checkPermission(DISCONNECT);
        this.setTemporarilyOffline(true, new OfflineCause.ByCLI(cause));
    }

    @Deprecated
    public void cliOnline() throws ExecutionException, InterruptedException {
        this.checkPermission(CONNECT);
        this.setTemporarilyOffline(false, null);
    }

    @Exported
    public int getNumExecutors() {
        return this.numExecutors;
    }

    @Nonnull
    public String getName() {
        return this.nodeName != null ? this.nodeName : "";
    }

    @CheckForNull
    public abstract Boolean isUnix();

    @CheckForNull
    public Node getNode() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            return null;
        }
        if (this.nodeName == null) {
            return j;
        }
        return j.getNode(this.nodeName);
    }

    @Exported
    public LoadStatistics getLoadStatistics() {
        return LabelAtom.get((String)(this.nodeName != null ? this.nodeName : Jenkins.getInstance().getSelfLabel().toString())).loadStatistics;
    }

    public BuildTimelineWidget getTimeline() {
        return new BuildTimelineWidget(this.getBuilds());
    }

    @Override
    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    @Override
    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
    }

    @Override
    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
    }

    @Exported
    public boolean isOffline() {
        return this.temporarilyOffline || this.getChannel() == null;
    }

    public final boolean isOnline() {
        return !this.isOffline();
    }

    @Exported
    public boolean isManualLaunchAllowed() {
        return this.getRetentionStrategy().isManualLaunchAllowed(this);
    }

    public abstract boolean isConnecting();

    @Exported
    @Deprecated
    public boolean isJnlpAgent() {
        return false;
    }

    @Exported
    public boolean isLaunchSupported() {
        return true;
    }

    @Exported
    @Deprecated
    public boolean isTemporarilyOffline() {
        return this.temporarilyOffline;
    }

    @Deprecated
    public void setTemporarilyOffline(boolean temporarilyOffline) {
        this.setTemporarilyOffline(temporarilyOffline, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemporarilyOffline(boolean temporarilyOffline, OfflineCause cause) {
        this.offlineCause = temporarilyOffline ? cause : null;
        this.temporarilyOffline = temporarilyOffline;
        Node node = this.getNode();
        if (node != null) {
            node.setTemporaryOfflineCause(this.offlineCause);
        }
        Object object = this.statusChangeLock;
        synchronized (object) {
            this.statusChangeLock.notifyAll();
        }
        for (ComputerListener cl : ComputerListener.all()) {
            if (temporarilyOffline) {
                cl.onTemporarilyOffline(this, cause);
                continue;
            }
            cl.onTemporarilyOnline(this);
        }
    }

    @Exported
    public String getIcon() {
        if (this.isOffline()) {
            return "computer-x.png";
        }
        return "computer.png";
    }

    @Exported
    public String getIconClassName() {
        if (this.isOffline()) {
            return "icon-computer-x";
        }
        return "icon-computer";
    }

    public String getIconAltText() {
        if (this.isOffline()) {
            return "[offline]";
        }
        return "[online]";
    }

    @Override
    @Exported
    @Nonnull
    public String getDisplayName() {
        return this.nodeName;
    }

    public String getCaption() {
        return Messages.Computer_Caption(this.nodeName);
    }

    public String getUrl() {
        return "computer/" + Util.rawEncode(this.getName()) + "/";
    }

    public List<AbstractProject> getTiedJobs() {
        Node node = this.getNode();
        return node != null ? node.getSelfLabel().getTiedJobs() : Collections.EMPTY_LIST;
    }

    public RunList getBuilds() {
        return RunList.fromJobs(Jenkins.getInstance().allItems(Job.class)).node(this.getNode());
    }

    protected void setNode(Node node) {
        assert (node != null);
        this.nodeName = node instanceof Slave ? node.getNodeName() : null;
        this.setNumExecutors(node.getNumExecutors());
        if (this.temporarilyOffline) {
            node.setTemporaryOfflineCause(this.offlineCause);
        }
    }

    protected void kill() {
        this.setNumExecutors(0);
    }

    @Restricted(value={NoExternalUse.class})
    @GuardedBy(value="hudson.model.Queue.lock")
    void inflictMortalWound() {
        this.setNumExecutors(0);
    }

    protected void onRemoved() {
    }

    @GuardedBy(value="hudson.model.Queue.lock")
    private void setNumExecutors(int n) {
        this.numExecutors = n;
        int diff = this.executors.size() - n;
        if (diff > 0) {
            Queue.withLock(new Runnable(){

                @Override
                public void run() {
                    for (Executor e : Computer.this.executors) {
                        if (!e.isIdle()) continue;
                        e.interrupt();
                    }
                }
            });
        }
        if (diff < 0) {
            this.addNewExecutorIfNecessary();
        }
    }

    private void addNewExecutorIfNecessary() {
        HashSet<Integer> availableNumbers = new HashSet<Integer>();
        for (int i = 0; i < this.numExecutors; ++i) {
            availableNumbers.add(i);
        }
        for (Executor executor : this.executors) {
            availableNumbers.remove(executor.getNumber());
        }
        for (Integer number : availableNumbers) {
            if (this.executors.size() >= this.numExecutors) continue;
            Executor e = new Executor(this, number);
            this.executors.add(e);
        }
    }

    public int countIdle() {
        int n = 0;
        for (Executor e : this.executors) {
            if (!e.isIdle()) continue;
            ++n;
        }
        return n;
    }

    public final int countBusy() {
        return this.countExecutors() - this.countIdle();
    }

    public final int countExecutors() {
        return this.executors.size();
    }

    @Exported
    public List<Executor> getExecutors() {
        return new ArrayList<Executor>(this.executors);
    }

    @Exported
    public List<OneOffExecutor> getOneOffExecutors() {
        return new ArrayList<OneOffExecutor>(this.oneOffExecutors);
    }

    @Restricted(value={NoExternalUse.class})
    public List<DisplayExecutor> getDisplayExecutors() {
        ArrayList<DisplayExecutor> result = new ArrayList<DisplayExecutor>(this.executors.size() + this.oneOffExecutors.size());
        int index = 0;
        for (Executor executor : this.executors) {
            if (executor.isDisplayCell()) {
                result.add(new DisplayExecutor(Integer.toString(index + 1), String.format("executors/%d", index), executor));
            }
            ++index;
        }
        index = 0;
        for (OneOffExecutor oneOffExecutor : this.oneOffExecutors) {
            if (oneOffExecutor.isDisplayCell()) {
                result.add(new DisplayExecutor("", String.format("oneOffExecutors/%d", index), oneOffExecutor));
            }
            ++index;
        }
        return result;
    }

    @Exported
    public final boolean isIdle() {
        if (!this.oneOffExecutors.isEmpty()) {
            return false;
        }
        for (Executor e : this.executors) {
            if (e.isIdle()) continue;
            return false;
        }
        return true;
    }

    public final boolean isPartiallyIdle() {
        for (Executor e : this.executors) {
            if (!e.isIdle()) continue;
            return true;
        }
        return false;
    }

    public final long getIdleStartMilliseconds() {
        long firstIdle = Long.MIN_VALUE;
        for (Executor executor : this.oneOffExecutors) {
            firstIdle = Math.max(firstIdle, executor.getIdleStartMilliseconds());
        }
        for (Executor executor : this.executors) {
            firstIdle = Math.max(firstIdle, executor.getIdleStartMilliseconds());
        }
        return firstIdle;
    }

    public final long getDemandStartMilliseconds() {
        long firstDemand = Long.MAX_VALUE;
        for (Queue.BuildableItem item : Jenkins.getInstance().getQueue().getBuildableItems(this)) {
            firstDemand = Math.min(item.buildableStartMilliseconds, firstDemand);
        }
        return firstDemand;
    }

    protected void removeExecutor(final Executor e) {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Computer computer = Computer.this;
                synchronized (computer) {
                    Jenkins ciBase;
                    Computer.this.executors.remove(e);
                    Computer.this.addNewExecutorIfNecessary();
                    if (!Computer.this.isAlive() && (ciBase = Jenkins.getInstanceOrNull()) != null) {
                        ciBase.removeComputer(Computer.this);
                    }
                }
            }
        };
        if (!Queue.tryWithLock(task)) {
            threadPoolForRemoting.submit(Queue.wrapWithLock(task));
        }
    }

    protected boolean isAlive() {
        for (Executor e : this.executors) {
            if (!e.isActive()) continue;
            return true;
        }
        return false;
    }

    public void interrupt() {
        Queue.withLock(new Runnable(){

            @Override
            public void run() {
                for (Executor e : Computer.this.executors) {
                    e.interruptForShutdown();
                }
            }
        });
    }

    @Override
    public String getSearchUrl() {
        return this.getUrl();
    }

    public abstract RetentionStrategy getRetentionStrategy();

    @Exported(inline=true)
    public Map<String, Object> getMonitorData() {
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (this.hasPermission(CONNECT)) {
            for (NodeMonitor monitor : NodeMonitor.getAll()) {
                r.put(monitor.getClass().getName(), monitor.data(this));
            }
        }
        return r;
    }

    public Map<Object, Object> getSystemProperties() throws IOException, InterruptedException {
        return RemotingDiagnostics.getSystemProperties(this.getChannel());
    }

    @Deprecated
    public Map<String, String> getEnvVars() throws IOException, InterruptedException {
        return this.getEnvironment();
    }

    public EnvVars getEnvironment() throws IOException, InterruptedException {
        EnvVars cachedEnvironment = this.cachedEnvironment;
        if (cachedEnvironment != null) {
            return new EnvVars(cachedEnvironment);
        }
        this.cachedEnvironment = cachedEnvironment = EnvVars.getRemote(this.getChannel());
        return new EnvVars(cachedEnvironment);
    }

    @Nonnull
    public EnvVars buildEnvironment(@Nonnull TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = new EnvVars();
        Node node = this.getNode();
        if (node == null) {
            return env;
        }
        for (NodeProperty nodeProperty : Jenkins.getInstance().getGlobalNodeProperties()) {
            nodeProperty.buildEnvVars(env, listener);
        }
        for (NodeProperty nodeProperty : node.getNodeProperties()) {
            nodeProperty.buildEnvVars(env, listener);
        }
        String rootUrl = Jenkins.getInstance().getRootUrl();
        if (rootUrl != null) {
            env.put("HUDSON_URL", rootUrl);
            env.put("JENKINS_URL", rootUrl);
        }
        return env;
    }

    public Map<String, String> getThreadDump() throws IOException, InterruptedException {
        return RemotingDiagnostics.getThreadDump(this.getChannel());
    }

    public RemotingDiagnostics.HeapDump getHeapDump() throws IOException {
        return new RemotingDiagnostics.HeapDump(this, this.getChannel());
    }

    public String getHostName() throws IOException, InterruptedException {
        if (this.hostNameCached) {
            return this.cachedHostName;
        }
        VirtualChannel channel = this.getChannel();
        if (channel == null) {
            return null;
        }
        for (String address : (List)channel.call((Callable)new ListPossibleNames())) {
            try {
                InetAddress ia = InetAddress.getByName(address);
                if (!(ia instanceof Inet4Address)) {
                    LOGGER.log(Level.FINE, "{0} is not an IPv4 address", address);
                    continue;
                }
                if (!ComputerPinger.checkIsReachable(ia, 3)) {
                    LOGGER.log(Level.FINE, "{0} didn't respond to ping", address);
                    continue;
                }
                this.cachedHostName = ia.getCanonicalHostName();
                this.hostNameCached = true;
                return this.cachedHostName;
            }
            catch (IOException e) {
                LogRecord lr = new LogRecord(Level.FINE, "Failed to parse {0}");
                lr.setThrown(e);
                lr.setParameters(new Object[]{address});
                LOGGER.log(lr);
            }
        }
        this.cachedHostName = (String)channel.call((Callable)new GetFallbackName());
        this.hostNameCached = true;
        return this.cachedHostName;
    }

    final void startFlyWeightTask(WorkUnit p) {
        OneOffExecutor e = new OneOffExecutor(this);
        e.start(p);
        this.oneOffExecutors.add(e);
    }

    final void remove(OneOffExecutor e) {
        this.oneOffExecutors.remove(e);
    }

    public void doRssAll(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " all builds", this.getBuilds());
    }

    public void doRssFailed(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.rss(req, rsp, " failed builds", this.getBuilds().failureOnly());
    }

    private void rss(StaplerRequest req, StaplerResponse rsp, String suffix, RunList runs) throws IOException, ServletException {
        RSS.forwardToRss(this.getDisplayName() + suffix, this.getUrl(), runs.newBuilds(), Run.FEED_ADAPTER, req, (HttpServletResponse)rsp);
    }

    @RequirePOST
    public HttpResponse doToggleOffline(@QueryParameter String offlineMessage) throws IOException, ServletException {
        if (!this.temporarilyOffline) {
            this.checkPermission(DISCONNECT);
            offlineMessage = Util.fixEmptyAndTrim(offlineMessage);
            this.setTemporarilyOffline(!this.temporarilyOffline, new OfflineCause.UserCause(User.current(), offlineMessage));
        } else {
            this.checkPermission(CONNECT);
            this.setTemporarilyOffline(!this.temporarilyOffline, null);
        }
        return HttpResponses.redirectToDot();
    }

    @RequirePOST
    public HttpResponse doChangeOfflineCause(@QueryParameter String offlineMessage) throws IOException, ServletException {
        this.checkPermission(DISCONNECT);
        offlineMessage = Util.fixEmptyAndTrim(offlineMessage);
        this.setTemporarilyOffline(true, new OfflineCause.UserCause(User.current(), offlineMessage));
        return HttpResponses.redirectToDot();
    }

    public Api getApi() {
        return new Api(this);
    }

    public void doDumpExportTable(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        this.checkPermission(Jenkins.ADMINISTER);
        rsp.setContentType("text/plain");
        try (PrintWriter w = new PrintWriter(rsp.getCompressedWriter((HttpServletRequest)req));){
            VirtualChannel vc = this.getChannel();
            if (vc instanceof Channel) {
                w.println("Master to slave");
                ((Channel)vc).dumpExportTable(w);
                w.flush();
                w.println("\n\n\nSlave to master");
                w.print((String)vc.call((Callable)new DumpExportTableTask()));
            } else {
                w.println(Messages.Computer_BadChannel());
            }
        }
    }

    public void doScript(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this._doScript(req, rsp, "_script.jelly");
    }

    public void doScriptText(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this._doScript(req, rsp, "_scriptText.jelly");
    }

    protected void _doScript(StaplerRequest req, StaplerResponse rsp, String view) throws IOException, ServletException {
        Jenkins._doScript(req, rsp, req.getView((Object)this, view), this.getChannel(), this.getACL());
    }

    @RequirePOST
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(CONFIGURE);
        String proposedName = Util.fixEmptyAndTrim(req.getSubmittedForm().getString("name"));
        Jenkins.checkGoodName(proposedName);
        Node node = this.getNode();
        if (node == null) {
            throw new ServletException("No such node " + this.nodeName);
        }
        if (!proposedName.equals(this.nodeName) && Jenkins.getActiveInstance().getNode(proposedName) != null) {
            throw new Descriptor.FormException(Messages.ComputerSet_SlaveAlreadyExists(proposedName), "name");
        }
        Node result = node.reconfigure(req, req.getSubmittedForm());
        Jenkins.getInstance().getNodesObject().replaceNode(this.getNode(), result);
        rsp.sendRedirect2("../" + result.getNodeName() + '/');
    }

    @WebMethod(name={"config.xml"})
    public void doConfigDotXml(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (req.getMethod().equals("GET")) {
            this.checkPermission(EXTENDED_READ);
            rsp.setContentType("application/xml");
            Node node = this.getNode();
            if (node == null) {
                throw HttpResponses.notFound();
            }
            Jenkins.XSTREAM2.toXMLUTF8(node, (OutputStream)rsp.getOutputStream());
            return;
        }
        if (req.getMethod().equals("POST")) {
            this.updateByXml((InputStream)req.getInputStream());
            return;
        }
        rsp.sendError(400);
    }

    public void updateByXml(InputStream source) throws IOException, ServletException {
        this.checkPermission(CONFIGURE);
        Node result = (Node)Jenkins.XSTREAM2.fromXML(source);
        Jenkins.getInstance().getNodesObject().replaceNode(this.getNode(), result);
    }

    @RequirePOST
    public HttpResponse doDoDelete() throws IOException {
        this.checkPermission(DELETE);
        Node node = this.getNode();
        if (node != null) {
            Jenkins.getInstance().removeNode(node);
        } else {
            Jenkins app = Jenkins.getInstance();
            app.removeComputer(this);
        }
        return new HttpRedirect("..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilOnline() throws InterruptedException {
        Object object = this.statusChangeLock;
        synchronized (object) {
            while (!this.isOnline()) {
                this.statusChangeLock.wait(1000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilOffline() throws InterruptedException {
        Object object = this.statusChangeLock;
        synchronized (object) {
            while (!this.isOffline()) {
                this.statusChangeLock.wait(1000L);
            }
        }
    }

    public void doProgressiveLog(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.getLogText().doProgressText(req, rsp);
    }

    @Nullable
    public static Computer currentComputer() {
        Executor e = Executor.currentExecutor();
        return e != null ? e.getOwner() : null;
    }

    @OverridingMethodsMustInvokeSuper
    public boolean isAcceptingTasks() {
        Node node = this.getNode();
        return this.getRetentionStrategy().isAcceptingTasks(this) && (node == null || node.isAcceptingTasks());
    }

    @CLIResolver
    public static Computer resolveForCLI(@Argument(required=true, metaVar="NAME", usage="Agent name, or empty string for master") String name) throws CmdLineException {
        Jenkins h = Jenkins.getInstance();
        Computer item = h.getComputer(name);
        if (item == null) {
            List<String> names = ComputerSet.getComputerNames();
            String adv = EditDistance.findNearest(name, names);
            throw new IllegalArgumentException(adv == null ? Messages.Computer_NoSuchSlaveExistsWithoutAdvice(name) : Messages.Computer_NoSuchSlaveExists(name, adv));
        }
        return item;
    }

    @Initializer
    public static void relocateOldLogs() {
        Computer.relocateOldLogs(Jenkins.getInstance().getRootDir());
    }

    static void relocateOldLogs(File dir) {
        final Pattern logfile = Pattern.compile("slave-(.*)\\.log(\\.[0-9]+)?");
        File[] logfiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return logfile.matcher(name).matches();
            }
        });
        if (logfiles == null) {
            return;
        }
        for (File f : logfiles) {
            Matcher m = logfile.matcher(f.getName());
            if (m.matches()) {
                File newLocation = new File(dir, "logs/slaves/" + m.group(1) + "/slave.log" + Util.fixNull(m.group(2)));
                newLocation.getParentFile().mkdirs();
                boolean relocationSuccessful = f.renameTo(newLocation);
                if (relocationSuccessful) {
                    LOGGER.log(Level.INFO, "Relocated log file {0} to {1}", new Object[]{f.getPath(), newLocation.getPath()});
                    continue;
                }
                LOGGER.log(Level.WARNING, "Cannot relocate log file {0} to {1}", new Object[]{f.getPath(), newLocation.getPath()});
                continue;
            }
            assert (false);
        }
    }

    public static class TerminationRequest
    extends RuntimeException {
        private final long when = System.currentTimeMillis();

        public TerminationRequest(String message) {
            super(message);
        }

        public long getWhen() {
            return this.when;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class DisplayExecutor
    implements ModelObject {
        @Nonnull
        private final String displayName;
        @Nonnull
        private final String url;
        @Nonnull
        private final Executor executor;

        public DisplayExecutor(@Nonnull String displayName, @Nonnull String url, @Nonnull Executor executor) {
            this.displayName = displayName;
            this.url = url;
            this.executor = executor;
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return this.displayName;
        }

        @Nonnull
        public String getUrl() {
            return this.url;
        }

        @Nonnull
        public Executor getExecutor() {
            return this.executor;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("DisplayExecutor{");
            sb.append("displayName='").append(this.displayName).append('\'');
            sb.append(", url='").append(this.url).append('\'');
            sb.append(", executor=").append(this.executor);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisplayExecutor that = (DisplayExecutor)o;
            return this.executor.equals(that.executor);
        }

        public int hashCode() {
            return this.executor.hashCode();
        }

        @Extension(ordinal=1.7976931348623157E308)
        @Restricted(value={DoNotUse.class})
        public static class InternalComputerListener
        extends ComputerListener {
            @Override
            public void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
                c.cachedEnvironment = null;
            }
        }
    }

    private static final class DumpExportTableTask
    extends MasterToSlaveCallable<String, IOException> {
        private DumpExportTableTask() {
        }

        public String call() throws IOException {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            Channel.current().dumpExportTable(pw);
            pw.close();
            return sw.toString();
        }
    }

    private static class GetFallbackName
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;

        private GetFallbackName() {
        }

        public String call() throws IOException {
            return SystemProperties.getString("host.name");
        }
    }

    private static class ListPossibleNames
    extends MasterToSlaveCallable<List<String>, IOException> {
        private static final Logger LOGGER = Logger.getLogger(ListPossibleNames.class.getName());
        private static final long serialVersionUID = 1L;

        private ListPossibleNames() {
        }

        public List<String> call() throws IOException {
            ArrayList<String> names = new ArrayList<String>();
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                LOGGER.log(Level.FINE, "Listing up IP addresses for {0}", ni.getDisplayName());
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress ia = e.nextElement();
                    if (ia.isLoopbackAddress()) {
                        LOGGER.log(Level.FINE, "{0} is a loopback address", ia);
                        continue;
                    }
                    if (!(ia instanceof Inet4Address)) {
                        LOGGER.log(Level.FINE, "{0} is not an IPv4 address", ia);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "{0} is a viable candidate", ia);
                    names.add(ia.getHostAddress());
                }
            }
            return names;
        }
    }
}

