/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import hudson.ExtensionPoint;
import hudson.ProxyConfiguration;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.PageDecorator;
import hudson.model.UpdateSite;
import hudson.util.FormValidation;
import hudson.util.QuotedStringTokenizer;
import hudson.util.TextFile;
import hudson.util.TimeUnit2;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.DownloadSettings;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class DownloadService
extends PageDecorator {
    private static final String signatureValidatorPrefix = "downloadable";
    public static boolean neverUpdate = SystemProperties.getBoolean(DownloadService.class.getName() + ".never");
    public static boolean signatureCheck = !SystemProperties.getBoolean(DownloadService.class.getName() + ".noSignatureCheck");

    public String generateFragment() {
        if (!DownloadSettings.usePostBack()) {
            return "";
        }
        if (neverUpdate) {
            return "";
        }
        if (this.doesNotSupportPostMessage()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        if (Jenkins.getInstance().hasPermission(Jenkins.READ)) {
            long now = System.currentTimeMillis();
            for (Downloadable d : Downloadable.all()) {
                if (d.getDue() >= now || d.lastAttempt + 10000L >= now) continue;
                buf.append("<script>").append("Behaviour.addLoadEvent(function() {").append("  downloadService.download(").append(QuotedStringTokenizer.quote((String)d.getId())).append(',').append(QuotedStringTokenizer.quote((String)this.mapHttps(d.getUrl()))).append(',').append("{version:" + QuotedStringTokenizer.quote((String)Jenkins.VERSION) + '}').append(',').append(QuotedStringTokenizer.quote((String)(Stapler.getCurrentRequest().getContextPath() + '/' + this.getUrl() + "/byId/" + d.getId() + "/postBack"))).append(',').append("null);").append("});").append("</script>");
                d.lastAttempt = now;
            }
        }
        return buf.toString();
    }

    private boolean doesNotSupportPostMessage() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return false;
        }
        String ua = req.getHeader("User-Agent");
        if (ua == null) {
            return false;
        }
        return ua.contains("Windows") && (ua.contains(" MSIE 5.") || ua.contains(" MSIE 6.") || ua.contains(" MSIE 7."));
    }

    private String mapHttps(String url) {
        if (url.startsWith("http://updates.jenkins-ci.org/") && Jenkins.getInstance().isRootUrlSecure()) {
            return "https" + url.substring(4);
        }
        return url;
    }

    public Downloadable getById(String id) {
        for (Downloadable d : Downloadable.all()) {
            if (!d.getId().equals(id)) continue;
            return d;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public static String loadJSON(URL src) throws IOException {
        Throwable throwable = null;
        try (InputStream is = ProxyConfiguration.open(src).getInputStream();){
            String jsonp = IOUtils.toString((InputStream)is, (String)"UTF-8");
            int start = jsonp.indexOf(123);
            int end = jsonp.lastIndexOf(125);
            if (start >= 0 && end > start) {
                String string = jsonp.substring(start, end + 1);
                return string;
            }
            try {
                throw new IOException("Could not find JSON in " + src);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static String loadJSONHTML(URL src) throws IOException {
        Throwable throwable = null;
        try (InputStream is = ProxyConfiguration.open(src).getInputStream();){
            String jsonp = IOUtils.toString((InputStream)is, (String)"UTF-8");
            String preamble = "window.parent.postMessage(JSON.stringify(";
            int start = jsonp.indexOf(preamble);
            int end = jsonp.lastIndexOf("),'*');");
            if (start >= 0 && end > start) {
                String string = jsonp.substring(start + preamble.length(), end).trim();
                return string;
            }
            try {
                throw new IOException("Could not find JSON in " + src);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static class Downloadable
    implements ExtensionPoint {
        private final String id;
        private final String url;
        private final long interval;
        private volatile long due = 0L;
        private volatile long lastAttempt = Long.MIN_VALUE;
        private static final Logger LOGGER = Logger.getLogger(Downloadable.class.getName());
        private static final long DEFAULT_INTERVAL = SystemProperties.getLong(Downloadable.class.getName() + ".defaultInterval", TimeUnit2.DAYS.toMillis(1L));

        public Downloadable(String id, String url, long interval) {
            this.id = id;
            this.url = url;
            this.interval = interval;
        }

        public Downloadable() {
            this.id = this.getClass().getName().replace('$', '.');
            this.url = this.id + ".json";
            this.interval = DEFAULT_INTERVAL;
        }

        public Downloadable(Class id) {
            this(id.getName().replace('$', '.'));
        }

        public Downloadable(String id) {
            this(id, id + ".json");
        }

        public Downloadable(String id, String url) {
            this(id, url, DEFAULT_INTERVAL);
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return Jenkins.getInstance().getUpdateCenter().getDefaultBaseUrl() + "updates/" + this.url;
        }

        public List<String> getUrls() {
            ArrayList<String> updateSites = new ArrayList<String>();
            for (UpdateSite site : Jenkins.getActiveInstance().getUpdateCenter().getSiteList()) {
                String siteUrl = site.getUrl();
                int baseUrlEnd = siteUrl.indexOf("update-center.json");
                if (baseUrlEnd != -1) {
                    String siteBaseUrl = siteUrl.substring(0, baseUrlEnd);
                    updateSites.add(siteBaseUrl + "updates/" + this.url);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Url {0} does not look like an update center:", siteUrl);
            }
            return updateSites;
        }

        public long getInterval() {
            return this.interval;
        }

        public TextFile getDataFile() {
            return new TextFile(new File(Jenkins.getInstance().getRootDir(), "updates/" + this.id));
        }

        public long getDue() {
            if (this.due == 0L) {
                this.due = this.getDataFile().file.lastModified() + this.interval;
            }
            return this.due;
        }

        public JSONObject getData() throws IOException {
            TextFile df = this.getDataFile();
            if (df.exists()) {
                try {
                    return JSONObject.fromObject((Object)df.read());
                }
                catch (JSONException e) {
                    df.delete();
                    throw new IOException("Failed to parse " + df + " into JSON", e);
                }
            }
            return null;
        }

        @RequirePOST
        public void doPostBack(StaplerRequest req, StaplerResponse rsp) throws IOException {
            DownloadSettings.checkPostBackAccess();
            long dataTimestamp = System.currentTimeMillis();
            this.due = dataTimestamp + this.getInterval();
            String json = IOUtils.toString((InputStream)req.getInputStream(), (String)"UTF-8");
            FormValidation e = this.load(json, dataTimestamp);
            if (e.kind != FormValidation.Kind.OK) {
                LOGGER.severe(e.renderHtml());
                throw e;
            }
            rsp.setContentType("text/plain");
        }

        private FormValidation load(String json, long dataTimestamp) throws IOException {
            TextFile df = this.getDataFile();
            df.write(json);
            df.file.setLastModified(dataTimestamp);
            LOGGER.info("Obtained the updated data file for " + this.id);
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation updateNow() throws IOException {
            ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
            boolean toolInstallerMetadataExists = false;
            for (UpdateSite updatesite : Jenkins.getActiveInstance().getUpdateCenter().getSiteList()) {
                String jsonString;
                String site = updatesite.getMetadataUrlForDownloadable(this.url);
                if (site == null) {
                    return FormValidation.warning("The update site " + site + " does not look like an update center");
                }
                try {
                    jsonString = DownloadService.loadJSONHTML(new URL(site + ".html?id=" + URLEncoder.encode(this.getId(), "UTF-8") + "&version=" + URLEncoder.encode(Jenkins.VERSION, "UTF-8")));
                    toolInstallerMetadataExists = true;
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Could not load json from " + site, e);
                    continue;
                }
                JSONObject o = JSONObject.fromObject((Object)jsonString);
                if (signatureCheck) {
                    FormValidation e = updatesite.getJsonSignatureValidator("downloadable '" + this.id + "'").verifySignature(o);
                    if (e.kind != FormValidation.Kind.OK) {
                        LOGGER.log(Level.WARNING, "signature check failed for " + site, e);
                        continue;
                    }
                }
                jsonList.add(o);
            }
            if (jsonList.size() == 0 && toolInstallerMetadataExists) {
                return FormValidation.warning("None of the tool installer metadata passed the signature check");
            }
            if (!toolInstallerMetadataExists) {
                LOGGER.log(Level.WARNING, "No tool installer metadata found for " + this.id);
                return FormValidation.ok();
            }
            JSONObject reducedJson = this.reduce(jsonList);
            return this.load(reducedJson.toString(), System.currentTimeMillis());
        }

        public JSONObject reduce(List<JSONObject> jsonList) {
            return jsonList.get(0);
        }

        public static <T> boolean hasDuplicates(List<T> genericList, String comparator) {
            Field field;
            if (genericList.isEmpty()) {
                return false;
            }
            try {
                field = genericList.get(0).getClass().getDeclaredField(comparator);
            }
            catch (NoSuchFieldException e) {
                LOGGER.warning("comparator: " + comparator + "does not exist for " + genericList.get(0).getClass() + ", " + e);
                return false;
            }
            for (int i = 0; i < genericList.size(); ++i) {
                T data1 = genericList.get(i);
                for (int j = i + 1; j < genericList.size(); ++j) {
                    T data2 = genericList.get(j);
                    try {
                        if (!field.get(data1).equals(field.get(data2))) continue;
                        return true;
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.warning("could not access field: " + comparator + ", " + e);
                    }
                }
            }
            return false;
        }

        public static ExtensionList<Downloadable> all() {
            return ExtensionList.lookup(Downloadable.class);
        }

        public static Downloadable get(String id) {
            for (Downloadable d : Downloadable.all()) {
                if (!d.id.equals(id)) continue;
                return d;
            }
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class DownloadableListener
    extends ExtensionListListener {
        private static final Logger LOGGER = Logger.getLogger(DownloadableListener.class.getName());

        @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
        public static void installListener() {
            ExtensionList.lookup(Downloadable.class).addListener(new DownloadableListener());
        }

        @Override
        public void onChange() {
            for (Downloadable d : Downloadable.all()) {
                TextFile f = d.getDataFile();
                if (f == null || !f.exists()) {
                    LOGGER.log(Level.FINE, "Updating metadata for " + d.getId());
                    try {
                        d.updateNow();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to update metadata for " + d.getId(), e);
                    }
                    continue;
                }
                LOGGER.log(Level.FINER, "Skipping update of metadata for " + d.getId());
            }
        }
    }
}

