/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.PasswordParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.util.Secret;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class PasswordParameterDefinition
extends SimpleParameterDefinition {
    @Restricted(value={NoExternalUse.class})
    public static final String DEFAULT_VALUE = "<DEFAULT>";
    private Secret defaultValue;

    @DataBoundConstructor
    public PasswordParameterDefinition(String name, String defaultValue, String description) {
        super(name, description);
        this.defaultValue = Secret.fromString(defaultValue);
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof PasswordParameterValue) {
            PasswordParameterValue value = (PasswordParameterValue)defaultValue;
            return new PasswordParameterDefinition(this.getName(), Secret.toString(value.getValue()), this.getDescription());
        }
        return this;
    }

    @Override
    public ParameterValue createValue(String value) {
        return new PasswordParameterValue(this.getName(), value, this.getDescription());
    }

    @Override
    public PasswordParameterValue createValue(StaplerRequest req, JSONObject jo) {
        PasswordParameterValue value = (PasswordParameterValue)req.bindJSON(PasswordParameterValue.class, jo);
        if (value.getValue().getPlainText().equals(DEFAULT_VALUE)) {
            value = new PasswordParameterValue(this.getName(), this.getDefaultValue());
        }
        value.setDescription(this.getDescription());
        return value;
    }

    @Override
    public ParameterValue getDefaultParameterValue() {
        return new PasswordParameterValue(this.getName(), this.getDefaultValue(), this.getDescription());
    }

    public String getDefaultValue() {
        return Secret.toString(this.defaultValue);
    }

    @Restricted(value={DoNotUse.class})
    public Secret getDefaultValueAsSecret() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = Secret.fromString(defaultValue);
    }

    @Extension
    @Symbol(value={"password", "nonStoredPasswordParam"})
    public static final class ParameterDescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.PasswordParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/string.html";
        }
    }
}

