/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.lifecycle.Lifecycle;
import hudson.lifecycle.RestartNotSupportedException;
import hudson.model.AbstractModelObject;
import hudson.model.AdministrativeMonitor;
import hudson.model.Api;
import hudson.model.DownloadService;
import hudson.model.Messages;
import hudson.model.PageDecorator;
import hudson.model.Saveable;
import hudson.model.UpdateSite;
import hudson.model.User;
import hudson.model.listeners.SaveableListener;
import hudson.remoting.AtmostOneThreadExecutor;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.DaemonThreadFactory;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.IOException2;
import hudson.util.IOUtils;
import hudson.util.NamingThreadFactory;
import hudson.util.PersistedList;
import hudson.util.XStream2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.ServletException;
import jenkins.MissingDependencyException;
import jenkins.RestartRequiredException;
import jenkins.install.InstallUtil;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import jenkins.util.io.OnMaster;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class UpdateCenter
extends AbstractModelObject
implements Saveable,
OnMaster {
    private static final String UPDATE_CENTER_URL = SystemProperties.getString(UpdateCenter.class.getName() + ".updateCenterUrl", "http://updates.jenkins-ci.org/");
    private static final int PLUGIN_DOWNLOAD_READ_TIMEOUT = SystemProperties.getInteger(UpdateCenter.class.getName() + ".pluginDownloadReadTimeoutSeconds", 60) * 1000;
    public static final String PREDEFINED_UPDATE_SITE_ID = "default";
    public static final String ID_DEFAULT = SystemProperties.getString(UpdateCenter.class.getName() + ".defaultUpdateSiteId", "default");
    @Restricted(value={NoExternalUse.class})
    public static final String ID_UPLOAD = "_upload";
    private final ExecutorService installerService = new AtmostOneThreadExecutor((ThreadFactory)new NamingThreadFactory(new DaemonThreadFactory(), "Update center installer thread"));
    protected final ExecutorService updateService = Executors.newCachedThreadPool(new NamingThreadFactory(new DaemonThreadFactory(), "Update site data downloader"));
    private final Vector<UpdateCenterJob> jobs = new Vector();
    private final Set<UpdateSite> sourcesUsed = new HashSet<UpdateSite>();
    private final PersistedList<UpdateSite> sites = new PersistedList(this);
    private UpdateCenterConfiguration config;
    private boolean requiresRestart;
    private static final AtomicInteger iota = new AtomicInteger();
    private static final Logger LOGGER = Logger.getLogger(UpdateCenter.class.getName());
    @Deprecated
    public static boolean neverUpdate = SystemProperties.getBoolean(UpdateCenter.class.getName() + ".never");
    public static final XStream2 XSTREAM = new XStream2();

    public UpdateCenter() {
        this.configure(new UpdateCenterConfiguration());
    }

    UpdateCenter(@Nonnull UpdateCenterConfiguration configuration) {
        this.configure(configuration);
    }

    @Nonnull
    public static UpdateCenter createUpdateCenter(@CheckForNull UpdateCenterConfiguration config) {
        String requiredClassName = SystemProperties.getString(UpdateCenter.class.getName() + ".className", null);
        if (requiredClassName == null) {
            LOGGER.log(Level.FINE, "Using the default Update Center implementation");
            return UpdateCenter.createDefaultUpdateCenter(config);
        }
        LOGGER.log(Level.FINE, "Using the custom update center: {0}", requiredClassName);
        try {
            Class<UpdateCenter> clazz = Class.forName(requiredClassName).asSubclass(UpdateCenter.class);
            if (!UpdateCenter.class.isAssignableFrom(clazz)) {
                LOGGER.log(Level.SEVERE, "The specified custom Update Center {0} is not an instance of {1}. Falling back to default.", new Object[]{requiredClassName, UpdateCenter.class.getName()});
                return UpdateCenter.createDefaultUpdateCenter(config);
            }
            Class<UpdateCenter> ucClazz = clazz.asSubclass(UpdateCenter.class);
            Constructor<UpdateCenter> defaultConstructor = ucClazz.getConstructor(new Class[0]);
            Constructor<UpdateCenter> configConstructor = ucClazz.getConstructor(UpdateCenterConfiguration.class);
            LOGGER.log(Level.FINE, "Using the constructor {0} Update Center configuration for {1}", new Object[]{config != null ? "with" : "without", requiredClassName});
            return config != null ? configConstructor.newInstance(config) : defaultConstructor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            LOGGER.log(Level.WARNING, "UpdateCenter class {0} does not extend hudson.model.UpdateCenter. Using default.", requiredClassName);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.WARNING, String.format("UpdateCenter class %s does not define one of the required constructors. Using default", requiredClassName), e);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Unable to instantiate custom plugin manager [%s]. Using default.", requiredClassName), e);
        }
        return UpdateCenter.createDefaultUpdateCenter(config);
    }

    @Nonnull
    private static UpdateCenter createDefaultUpdateCenter(@CheckForNull UpdateCenterConfiguration config) {
        return config != null ? new UpdateCenter(config) : new UpdateCenter();
    }

    public Api getApi() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        return new Api(this);
    }

    public void configure(UpdateCenterConfiguration config) {
        if (config != null) {
            this.config = config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported
    public List<UpdateCenterJob> getJobs() {
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            return new ArrayList<UpdateCenterJob>(this.jobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateCenterJob getJob(int id) {
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            for (UpdateCenterJob job : this.jobs) {
                if (job.id != id) continue;
                return job;
            }
        }
        return null;
    }

    public InstallationJob getJob(UpdateSite.Plugin plugin) {
        List<UpdateCenterJob> jobList = this.getJobs();
        Collections.reverse(jobList);
        for (UpdateCenterJob job : jobList) {
            if (!(job instanceof InstallationJob)) continue;
            InstallationJob ij = (InstallationJob)job;
            if (!ij.plugin.name.equals(plugin.name) || !ij.plugin.sourceId.equals(plugin.sourceId)) continue;
            return ij;
        }
        return null;
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doConnectionStatus(StaplerRequest request) {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        try {
            UpdateSite site;
            String siteId = request.getParameter("siteId");
            if (siteId == null) {
                siteId = ID_DEFAULT;
            } else if (siteId.equals(PREDEFINED_UPDATE_SITE_ID)) {
                siteId = ID_DEFAULT;
            }
            ConnectionCheckJob checkJob = this.getConnectionCheckJob(siteId);
            if (checkJob == null && (site = this.getSite(siteId)) != null) {
                checkJob = this.addConnectionCheckJob(site);
            }
            if (checkJob != null) {
                boolean isOffline = false;
                for (ConnectionStatus status : checkJob.connectionStates.values()) {
                    if (!ConnectionStatus.FAILED.equals((Object)status)) continue;
                    isOffline = true;
                    break;
                }
                if (isOffline) {
                    checkJob.run();
                    isOffline = false;
                    for (ConnectionStatus status : checkJob.connectionStates.values()) {
                        if (!ConnectionStatus.FAILED.equals((Object)status)) continue;
                        isOffline = true;
                        break;
                    }
                    if (!isOffline) {
                        this.updateAllSites();
                    }
                }
                return HttpResponses.okJSON(checkJob.connectionStates);
            }
            return HttpResponses.errorJSON(String.format("Cannot check connection status of the update site with ID='%s'. This update center cannot be resolved", siteId));
        }
        catch (Exception e) {
            return HttpResponses.errorJSON(String.format("ERROR: %s", e.getMessage()));
        }
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doIncompleteInstallStatus() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        try {
            Map<String, String> jobs = InstallUtil.getPersistedInstallStatus();
            if (jobs == null) {
                jobs = Collections.emptyMap();
            }
            return HttpResponses.okJSON(jobs);
        }
        catch (Exception e) {
            return HttpResponses.errorJSON(String.format("ERROR: %s", e.getMessage()));
        }
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized void persistInstallStatus() {
        List<UpdateCenterJob> jobs = this.getJobs();
        boolean activeInstalls = false;
        for (UpdateCenterJob job : jobs) {
            if (!(job instanceof InstallationJob)) continue;
            InstallationJob installationJob = (InstallationJob)job;
            if (installationJob.status.isSuccess()) continue;
            activeInstalls = true;
        }
        if (activeInstalls) {
            InstallUtil.persistInstallStatus(jobs);
        } else {
            InstallUtil.clearInstallStatus();
        }
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doInstallStatus(StaplerRequest request) {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        try {
            String correlationId = request.getParameter("correlationId");
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("state", Jenkins.getInstance().getInstallState().name());
            ArrayList installStates = new ArrayList();
            response.put("jobs", installStates);
            List<UpdateCenterJob> jobCopy = this.getJobs();
            for (UpdateCenterJob job : jobCopy) {
                if (!(job instanceof InstallationJob)) continue;
                UUID jobCorrelationId = job.getCorrelationId();
                if (correlationId != null && (jobCorrelationId == null || !correlationId.equals(jobCorrelationId.toString()))) continue;
                InstallationJob installationJob = (InstallationJob)job;
                LinkedHashMap<String, String> pluginInfo = new LinkedHashMap<String, String>();
                pluginInfo.put("name", installationJob.plugin.name);
                pluginInfo.put("version", installationJob.plugin.version);
                pluginInfo.put("title", installationJob.plugin.title);
                pluginInfo.put("installStatus", installationJob.status.getType());
                pluginInfo.put("requiresRestart", Boolean.toString(installationJob.status.requiresRestart()));
                if (jobCorrelationId != null) {
                    pluginInfo.put("correlationId", jobCorrelationId.toString());
                }
                installStates.add(pluginInfo);
            }
            return HttpResponses.okJSON(JSONObject.fromObject(response));
        }
        catch (Exception e) {
            return HttpResponses.errorJSON(String.format("ERROR: %s", e.getMessage()));
        }
    }

    public HudsonUpgradeJob getHudsonJob() {
        List<UpdateCenterJob> jobList = this.getJobs();
        Collections.reverse(jobList);
        for (UpdateCenterJob job : jobList) {
            if (!(job instanceof HudsonUpgradeJob)) continue;
            return (HudsonUpgradeJob)job;
        }
        return null;
    }

    public PersistedList<UpdateSite> getSites() {
        return this.sites;
    }

    @Exported(name="sites")
    public List<UpdateSite> getSiteList() {
        return this.sites.toList();
    }

    @CheckForNull
    public UpdateSite getSite(String id) {
        return this.getById(id);
    }

    public String getLastUpdatedString() {
        long newestTs = 0L;
        for (UpdateSite s : this.sites) {
            if (s.getDataTimestamp() <= newestTs) continue;
            newestTs = s.getDataTimestamp();
        }
        if (newestTs == 0L) {
            return Messages.UpdateCenter_n_a();
        }
        return Util.getPastTimeString(System.currentTimeMillis() - newestTs);
    }

    @CheckForNull
    public UpdateSite getById(String id) {
        for (UpdateSite s : this.sites) {
            if (!s.getId().equals(id)) continue;
            return s;
        }
        return null;
    }

    @CheckForNull
    public UpdateSite getCoreSource() {
        for (UpdateSite s : this.sites) {
            UpdateSite.Data data = s.getData();
            if (data == null || data.core == null) continue;
            return s;
        }
        return null;
    }

    @Deprecated
    public String getDefaultBaseUrl() {
        return this.config.getUpdateCenterUrl();
    }

    @CheckForNull
    public UpdateSite.Plugin getPlugin(String artifactId) {
        for (UpdateSite s : this.sites) {
            UpdateSite.Plugin p = s.getPlugin(artifactId);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @RequirePOST
    public void doUpgrade(StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        HudsonUpgradeJob job = new HudsonUpgradeJob(this.getCoreSource(), Jenkins.getAuthentication());
        if (!Lifecycle.get().canRewriteHudsonWar()) {
            this.sendError("Jenkins upgrade not supported in this running mode");
            return;
        }
        LOGGER.info("Scheduling the core upgrade");
        this.addJob(job);
        rsp.sendRedirect2(".");
    }

    @RequirePOST
    public HttpResponse doInvalidateData() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        for (UpdateSite site : this.sites) {
            site.doInvalidateData();
        }
        return HttpResponses.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public void doSafeRestart(StaplerRequest request, StaplerResponse response) throws IOException, ServletException {
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            if (!this.isRestartScheduled()) {
                Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
                this.addJob(new RestartJenkinsJob(this.getCoreSource()));
                LOGGER.info("Scheduling Jenkins reboot");
            }
        }
        response.sendRedirect2(".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public void doCancelRestart(StaplerResponse response) throws IOException, ServletException {
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            for (UpdateCenterJob job : this.jobs) {
                if (!(job instanceof RestartJenkinsJob) || !((RestartJenkinsJob)job).cancel()) continue;
                LOGGER.info("Scheduled Jenkins reboot unscheduled");
            }
        }
        response.sendRedirect2(".");
    }

    @Exported
    public boolean isRestartRequiredForCompletion() {
        return this.requiresRestart;
    }

    public boolean isRestartScheduled() {
        for (UpdateCenterJob job : this.getJobs()) {
            RestartJenkinsJob.RestartJenkinsJobStatus status;
            if (!(job instanceof RestartJenkinsJob) || !((status = ((RestartJenkinsJob)job).status) instanceof RestartJenkinsJob.Pending) && !(status instanceof RestartJenkinsJob.Running)) continue;
            return true;
        }
        return false;
    }

    public boolean isDowngradable() {
        return new File(Lifecycle.get().getHudsonWar() + ".bak").exists();
    }

    @RequirePOST
    public void doDowngrade(StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        if (!this.isDowngradable()) {
            this.sendError("Jenkins downgrade is not possible, probably backup does not exist");
            return;
        }
        HudsonDowngradeJob job = new HudsonDowngradeJob(this.getCoreSource(), Jenkins.getAuthentication());
        LOGGER.info("Scheduling the core downgrade");
        this.addJob(job);
        rsp.sendRedirect2(".");
    }

    @RequirePOST
    public void doRestart(StaplerResponse rsp) throws IOException, ServletException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        HudsonDowngradeJob job = new HudsonDowngradeJob(this.getCoreSource(), Jenkins.getAuthentication());
        LOGGER.info("Scheduling the core downgrade");
        this.addJob(job);
        rsp.sendRedirect2(".");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBackupVersion() {
        try (JarFile backupWar = new JarFile(new File(Lifecycle.get().getHudsonWar() + ".bak"));){
            Attributes attrs = backupWar.getManifest().getMainAttributes();
            String v = attrs.getValue("Jenkins-Version");
            if (v == null) {
                v = attrs.getValue("Hudson-Version");
            }
            String string = v;
            return string;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read backup version ", e);
            return null;
        }
    }

    synchronized Future<UpdateCenterJob> addJob(UpdateCenterJob job) {
        this.addConnectionCheckJob(job.site);
        return job.submit();
    }

    @Nonnull
    private ConnectionCheckJob addConnectionCheckJob(@Nonnull UpdateSite site) {
        if (this.sourcesUsed.add(site)) {
            ConnectionCheckJob connectionCheckJob = this.newConnectionCheckJob(site);
            connectionCheckJob.submit();
            return connectionCheckJob;
        }
        ConnectionCheckJob connectionCheckJob = this.getConnectionCheckJob(site);
        if (connectionCheckJob != null) {
            return connectionCheckJob;
        }
        throw new IllegalStateException("Illegal addition of an UpdateCenter job without calling UpdateCenter.addJob. No ConnectionCheckJob found for the site.");
    }

    @Restricted(value={NoExternalUse.class})
    ConnectionCheckJob newConnectionCheckJob(UpdateSite site) {
        return new ConnectionCheckJob(site);
    }

    @CheckForNull
    private ConnectionCheckJob getConnectionCheckJob(@Nonnull String siteId) {
        UpdateSite site = this.getSite(siteId);
        if (site == null) {
            return null;
        }
        return this.getConnectionCheckJob(site);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private ConnectionCheckJob getConnectionCheckJob(@Nonnull UpdateSite site) {
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            for (UpdateCenterJob job : this.jobs) {
                if (!(job instanceof ConnectionCheckJob) || !job.site.getId().equals(site.getId())) continue;
                return (ConnectionCheckJob)job;
            }
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return Messages.UpdateCenter_DisplayName();
    }

    @Override
    public String getSearchUrl() {
        return "updateCenter";
    }

    @Override
    public synchronized void save() {
        if (BulkChange.contains(this)) {
            return;
        }
        try {
            this.getConfigFile().write(this.sites);
            SaveableListener.fireOnChange(this, this.getConfigFile());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + this.getConfigFile(), e);
        }
    }

    public synchronized void load() throws IOException {
        XmlFile file = this.getConfigFile();
        if (file.exists()) {
            try {
                this.sites.replaceBy(((PersistedList)file.unmarshal(this.sites)).toList());
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + file, e);
            }
            boolean defaultSiteExists = false;
            for (UpdateSite site : this.sites) {
                if (site.isLegacyDefault()) {
                    this.sites.remove(site);
                    continue;
                }
                if (!ID_DEFAULT.equals(site.getId())) continue;
                defaultSiteExists = true;
            }
            if (!defaultSiteExists) {
                this.sites.add(this.createDefaultUpdateSite());
            }
        } else if (this.sites.isEmpty()) {
            this.sites.add(this.createDefaultUpdateSite());
        }
    }

    protected UpdateSite createDefaultUpdateSite() {
        return new UpdateSite(PREDEFINED_UPDATE_SITE_ID, this.config.getUpdateCenterUrl() + "update-center.json");
    }

    private XmlFile getConfigFile() {
        return new XmlFile(XSTREAM, new File(Jenkins.getInstance().root, UpdateCenter.class.getName() + ".xml"));
    }

    @Exported
    public List<UpdateSite.Plugin> getAvailables() {
        LinkedHashMap<String, UpdateSite.Plugin> pluginMap = new LinkedHashMap<String, UpdateSite.Plugin>();
        for (UpdateSite site : this.sites) {
            for (UpdateSite.Plugin plugin : site.getAvailables()) {
                String altKey;
                UpdateSite.Plugin existing = (UpdateSite.Plugin)pluginMap.get(plugin.name);
                if (existing == null) {
                    pluginMap.put(plugin.name, plugin);
                    continue;
                }
                if (existing.version.equals(plugin.version) || pluginMap.containsKey(altKey = plugin.name + ":" + plugin.version)) continue;
                pluginMap.put(altKey, plugin);
            }
        }
        return new ArrayList<UpdateSite.Plugin>(pluginMap.values());
    }

    public PluginEntry[] getCategorizedAvailables() {
        TreeSet<PluginEntry> entries = new TreeSet<PluginEntry>();
        for (UpdateSite.Plugin p : this.getAvailables()) {
            if (p.categories == null || p.categories.length == 0) {
                entries.add(new PluginEntry(p, UpdateCenter.getCategoryDisplayName(null)));
                continue;
            }
            for (String c : p.categories) {
                entries.add(new PluginEntry(p, UpdateCenter.getCategoryDisplayName(c)));
            }
        }
        return entries.toArray(new PluginEntry[entries.size()]);
    }

    private static String getCategoryDisplayName(String category) {
        if (category == null) {
            return Messages.UpdateCenter_PluginCategory_misc();
        }
        try {
            return (String)Messages.class.getMethod("UpdateCenter_PluginCategory_" + category.replace('-', '_'), new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            return Messages.UpdateCenter_PluginCategory_unrecognized(category);
        }
    }

    public List<UpdateSite.Plugin> getUpdates() {
        LinkedHashMap<String, UpdateSite.Plugin> pluginMap = new LinkedHashMap<String, UpdateSite.Plugin>();
        for (UpdateSite site : this.sites) {
            for (UpdateSite.Plugin plugin : site.getUpdates()) {
                String altKey;
                UpdateSite.Plugin existing = (UpdateSite.Plugin)pluginMap.get(plugin.name);
                if (existing == null) {
                    pluginMap.put(plugin.name, plugin);
                    continue;
                }
                if (existing.version.equals(plugin.version) || pluginMap.containsKey(altKey = plugin.name + ":" + plugin.version)) continue;
                pluginMap.put(altKey, plugin);
            }
        }
        return new ArrayList<UpdateSite.Plugin>(pluginMap.values());
    }

    public List<FormValidation> updateAllSites() throws InterruptedException, ExecutionException {
        ArrayList<Future<FormValidation>> futures = new ArrayList<Future<FormValidation>>();
        for (UpdateSite site : this.getSites()) {
            Future<FormValidation> future = site.updateDirectly(DownloadService.signatureCheck);
            if (future == null) continue;
            futures.add(future);
        }
        ArrayList<FormValidation> results = new ArrayList<FormValidation>();
        for (Future future : futures) {
            results.add((FormValidation)future.get());
        }
        return results;
    }

    private void verifyChecksums(String expectedSHA1, String actualSha1, File downloadedFile) throws IOException {
        if (expectedSHA1 != null) {
            if (actualSha1 == null) {
                throw new IOException("Failed to compute SHA-1 of downloaded file, refusing installation");
            }
            if (!expectedSHA1.equals(actualSha1)) {
                throw new IOException("Downloaded file " + downloadedFile.getAbsolutePath() + " does not match expected SHA-1, expected '" + expectedSHA1 + "', actual '" + actualSha1 + "'");
            }
        }
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED, fatal=false)
    public static void init(Jenkins h) throws IOException {
        h.getUpdateCenter().load();
    }

    @Restricted(value={NoExternalUse.class})
    public static void updateDefaultSite() {
        UpdateSite site = Jenkins.getInstance().getUpdateCenter().getSite(ID_DEFAULT);
        if (site == null) {
            LOGGER.log(Level.SEVERE, "Upgrading Jenkins. Cannot retrieve the default Update Site ''{0}''. Plugin installation may fail.", ID_DEFAULT);
            return;
        }
        try {
            site.updateDirectlyNow(true);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Upgrading Jenkins. Failed to update the default Update Site '" + ID_DEFAULT + "'. Plugin upgrades may fail.", e);
        }
    }

    static /* synthetic */ AtomicInteger access$500() {
        return iota;
    }

    static {
        XSTREAM.alias("site", UpdateSite.class);
        XSTREAM.alias("sites", PersistedList.class);
    }

    @Extension
    public static class PageDecoratorImpl
    extends PageDecorator {
    }

    public static final class PluginEntry
    implements Comparable<PluginEntry> {
        public UpdateSite.Plugin plugin;
        public String category;

        private PluginEntry(UpdateSite.Plugin p, String c) {
            this.plugin = p;
            this.category = c;
        }

        @Override
        public int compareTo(PluginEntry o) {
            int r = this.category.compareTo(o.category);
            if (r == 0) {
                r = this.plugin.name.compareToIgnoreCase(o.plugin.name);
            }
            return r;
        }
    }

    public final class HudsonDowngradeJob
    extends DownloadJob {
        public HudsonDowngradeJob(UpdateSite site, Authentication auth) {
            super(site, auth);
        }

        @Override
        protected URL getURL() throws MalformedURLException {
            return new URL(this.site.getData().core.url);
        }

        @Override
        protected File getDestination() {
            return Lifecycle.get().getHudsonWar();
        }

        @Override
        public String getName() {
            return "jenkins.war";
        }

        @Override
        protected void onSuccess() {
            this.status = new DownloadJob.Success();
        }

        @Override
        public void run() {
            try {
                LOGGER.info("Starting the downgrade of " + this.getName() + " on behalf of " + this.getUser().getName());
                this._run();
                LOGGER.info("Downgrading successful: " + this.getName());
                this.status = new DownloadJob.Success();
                this.onSuccess();
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to downgrade " + this.getName(), e);
                this.status = new DownloadJob.Failure(e);
                this.error = e;
            }
        }

        @Override
        protected void _run() throws IOException {
            File backup = new File(Lifecycle.get().getHudsonWar() + ".bak");
            File dst = this.getDestination();
            UpdateCenter.this.config.install(this, backup, dst);
        }

        @Override
        protected void replace(File dst, File src) throws IOException {
            Lifecycle.get().rewriteHudsonWar(src);
        }
    }

    public final class HudsonUpgradeJob
    extends DownloadJob {
        public HudsonUpgradeJob(UpdateSite site, Authentication auth) {
            super(site, auth);
        }

        @Override
        protected URL getURL() throws MalformedURLException {
            return new URL(this.site.getData().core.url);
        }

        @Override
        protected File getDestination() {
            return Lifecycle.get().getHudsonWar();
        }

        @Override
        public String getName() {
            return "jenkins.war";
        }

        @Override
        protected void onSuccess() {
            this.status = new DownloadJob.Success();
        }

        @Override
        protected void replace(File dst, File src) throws IOException {
            String expectedSHA1 = this.site.getData().core.getSha1();
            UpdateCenter.this.verifyChecksums(expectedSHA1, this.getComputedSHA1(), src);
            Lifecycle.get().rewriteHudsonWar(src);
        }
    }

    public final class PluginDowngradeJob
    extends DownloadJob {
        public final UpdateSite.Plugin plugin;
        private final PluginManager pm;

        public PluginDowngradeJob(UpdateSite.Plugin plugin, UpdateSite site, Authentication auth) {
            super(site, auth);
            this.pm = Jenkins.getInstance().getPluginManager();
            this.plugin = plugin;
        }

        @Override
        protected URL getURL() throws MalformedURLException {
            return new URL(this.plugin.url);
        }

        @Override
        protected File getDestination() {
            File baseDir = this.pm.rootDir;
            File legacy = new File(baseDir, this.plugin.name + ".hpi");
            if (legacy.exists()) {
                return legacy;
            }
            return new File(baseDir, this.plugin.name + ".jpi");
        }

        protected File getBackup() {
            File baseDir = this.pm.rootDir;
            return new File(baseDir, this.plugin.name + ".bak");
        }

        @Override
        public String getName() {
            return this.plugin.getDisplayName();
        }

        @Override
        public void run() {
            try {
                LOGGER.info("Starting the downgrade of " + this.getName() + " on behalf of " + this.getUser().getName());
                this._run();
                LOGGER.info("Downgrade successful: " + this.getName());
                this.status = new DownloadJob.Success();
                this.onSuccess();
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to downgrade " + this.getName(), e);
                this.status = new DownloadJob.Failure(e);
                this.error = e;
            }
        }

        @Override
        protected void _run() throws IOException {
            File dst = this.getDestination();
            File backup = this.getBackup();
            UpdateCenter.this.config.install(this, backup, dst);
        }

        @Override
        protected void replace(File dst, File backup) throws IOException {
            dst.delete();
            if (!backup.renameTo(dst)) {
                throw new IOException("Failed to rename " + backup + " to " + dst);
            }
        }

        @Override
        protected void onSuccess() {
            this.pm.pluginUploaded = true;
        }

        public String toString() {
            return super.toString() + "[plugin=" + this.plugin.title + "]";
        }
    }

    public class InstallationJob
    extends DownloadJob {
        @Exported
        public final UpdateSite.Plugin plugin;
        protected final PluginManager pm;
        protected final boolean dynamicLoad;

        @Deprecated
        public InstallationJob(UpdateSite.Plugin plugin, UpdateSite site, Authentication auth) {
            this(plugin, site, auth, false);
        }

        public InstallationJob(UpdateSite.Plugin plugin, UpdateSite site, Authentication auth, boolean dynamicLoad) {
            super(site, auth);
            this.pm = Jenkins.getInstance().getPluginManager();
            this.plugin = plugin;
            this.dynamicLoad = dynamicLoad;
        }

        @Override
        protected URL getURL() throws MalformedURLException {
            return new URL(this.plugin.url);
        }

        @Override
        protected File getDestination() {
            File baseDir = this.pm.rootDir;
            return new File(baseDir, this.plugin.name + ".jpi");
        }

        private File getLegacyDestination() {
            File baseDir = this.pm.rootDir;
            return new File(baseDir, this.plugin.name + ".hpi");
        }

        @Override
        public String getName() {
            return this.plugin.getDisplayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void _run() throws IOException, DownloadJob.InstallationStatus {
            block19: {
                if (this.wasInstalled()) {
                    LOGGER.info("Skipping duplicate install of: " + this.plugin.getDisplayName() + "@" + this.plugin.version);
                    return;
                }
                try {
                    super._run();
                    PluginWrapper pw = this.plugin.getInstalled();
                    if (pw != null && pw.isBundled()) {
                        SecurityContext oldContext = ACL.impersonate(ACL.SYSTEM);
                        try {
                            pw.doPin();
                        }
                        finally {
                            SecurityContextHolder.setContext((SecurityContext)oldContext);
                        }
                    }
                    if (this.dynamicLoad) {
                        try {
                            this.pm.dynamicLoad(this.getDestination());
                            break block19;
                        }
                        catch (RestartRequiredException e) {
                            throw new DownloadJob.SuccessButRequiresRestart(e.message);
                        }
                        catch (Exception e) {
                            throw new IOException("Failed to dynamically deploy this plugin", e);
                        }
                    }
                    throw new DownloadJob.SuccessButRequiresRestart(Messages._UpdateCenter_DownloadButNotActivated());
                }
                finally {
                    InstallationJob installationJob = this;
                    synchronized (installationJob) {
                        LOGGER.fine("Install complete for: " + this.plugin.getDisplayName() + "@" + this.plugin.version);
                        this.status = new DownloadJob.Skipped();
                        this.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean wasInstalled() {
            UpdateCenter updateCenter = UpdateCenter.this;
            synchronized (updateCenter) {
                for (UpdateCenterJob job : UpdateCenter.this.getJobs()) {
                    if (job == this) {
                        return false;
                    }
                    if (!(job instanceof InstallationJob)) continue;
                    InstallationJob ij = (InstallationJob)job;
                    if (!ij.plugin.equals(this.plugin) || !ij.plugin.version.equals(this.plugin.version)) continue;
                    InstallationJob installationJob = ij;
                    synchronized (installationJob) {
                        if (ij.status instanceof DownloadJob.Installing || ij.status instanceof DownloadJob.Pending) {
                            try {
                                LOGGER.fine("Waiting for other plugin install of: " + this.plugin.getDisplayName() + "@" + this.plugin.version);
                                ij.wait();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    return true;
                }
                return false;
            }
        }

        @Override
        protected void onSuccess() {
            this.pm.pluginUploaded = true;
        }

        public String toString() {
            return super.toString() + "[plugin=" + this.plugin.title + "]";
        }

        @Override
        protected void replace(File dst, File src) throws IOException {
            UpdateCenter.this.verifyChecksums(this.plugin.getSha1(), this.getComputedSHA1(), src);
            File bak = Util.changeExtension(dst, ".bak");
            bak.delete();
            File legacy = this.getLegacyDestination();
            if (legacy.exists() && !legacy.renameTo(bak)) {
                legacy.delete();
            }
            if (dst.exists() && !dst.renameTo(bak)) {
                dst.delete();
            }
            if (!src.renameTo(dst)) {
                throw new IOException("Failed to rename " + src + " to " + dst);
            }
        }
    }

    public abstract class DownloadJob
    extends UpdateCenterJob {
        @Exported(inline=true)
        public volatile InstallationStatus status;
        private String computedSHA1;
        private Authentication authentication;

        protected abstract URL getURL() throws MalformedURLException;

        protected abstract File getDestination();

        @Exported
        public abstract String getName();

        protected abstract void onSuccess();

        @CheckForNull
        protected String getComputedSHA1() {
            return this.computedSHA1;
        }

        public Authentication getUser() {
            return this.authentication;
        }

        protected DownloadJob(UpdateSite site, Authentication authentication) {
            super(site);
            this.status = new Pending();
            this.authentication = authentication;
        }

        @Override
        public void run() {
            try {
                LOGGER.info("Starting the installation of " + this.getName() + " on behalf of " + this.getUser().getName());
                this._run();
                LOGGER.info("Installation successful: " + this.getName());
                this.status = new Success();
                this.onSuccess();
            }
            catch (InstallationStatus e) {
                this.status = e;
                if (this.status.isSuccess()) {
                    this.onSuccess();
                }
                UpdateCenter.this.requiresRestart = (byte)(UpdateCenter.this.requiresRestart | (this.status.requiresRestart() ? 1 : 0));
            }
            catch (MissingDependencyException e) {
                LOGGER.log(Level.SEVERE, "Failed to install {0}: {1}", new Object[]{this.getName(), e.getMessage()});
                this.status = new Failure((Throwable)e);
                this.error = e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to install " + this.getName(), e);
                this.status = new Failure(e);
                this.error = e;
            }
        }

        protected void _run() throws IOException, InstallationStatus {
            URL src = this.getURL();
            UpdateCenter.this.config.preValidate(this, src);
            File dst = this.getDestination();
            File tmp = UpdateCenter.this.config.download(this, src);
            UpdateCenter.this.config.postValidate(this, tmp);
            UpdateCenter.this.config.install(this, tmp, dst);
        }

        protected void replace(File dst, File src) throws IOException {
            File bak = Util.changeExtension(dst, ".bak");
            bak.delete();
            dst.renameTo(bak);
            dst.delete();
            if (!src.renameTo(dst)) {
                throw new IOException("Failed to rename " + src + " to " + dst);
            }
        }

        public class Installing
        extends InstallationStatus {
            public final int percentage;

            public Installing(int percentage) {
                this.percentage = percentage;
            }
        }

        public class Pending
        extends InstallationStatus {
        }

        public class Skipped
        extends InstallationStatus {
            @Override
            public boolean isSuccess() {
                return true;
            }
        }

        public class Success
        extends InstallationStatus {
            @Override
            public boolean isSuccess() {
                return true;
            }
        }

        public class SuccessButRequiresRestart
        extends Success {
            private final Localizable message;

            public SuccessButRequiresRestart(Localizable message) {
                this.message = message;
            }

            @Override
            public String getMessage() {
                return this.message.toString();
            }

            @Override
            public boolean requiresRestart() {
                return true;
            }
        }

        public class Failure
        extends InstallationStatus {
            public final Throwable problem;

            public Failure(Throwable problem) {
                this.problem = problem;
            }

            public String getProblemStackTrace() {
                return Functions.printThrowable(this.problem);
            }
        }

        @ExportedBean
        public abstract class InstallationStatus
        extends Throwable {
            public final int id = UpdateCenter.access$500().incrementAndGet();

            @Exported
            public boolean isSuccess() {
                return false;
            }

            @Exported
            public final String getType() {
                return this.getClass().getSimpleName();
            }

            public boolean requiresRestart() {
                return false;
            }
        }
    }

    public class NoOpJob
    extends EnableJob {
        public NoOpJob(UpdateSite site, @Nonnull Authentication auth, UpdateSite.Plugin plugin) {
            super(site, auth, plugin, false);
        }

        @Override
        public void run() {
            this.status = new DownloadJob.Success();
        }
    }

    public class EnableJob
    extends InstallationJob {
        public EnableJob(UpdateSite site, @Nonnull Authentication auth, UpdateSite.Plugin plugin, boolean dynamicLoad) {
            super(plugin, site, auth, dynamicLoad);
        }

        public UpdateSite.Plugin getPlugin() {
            return this.plugin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PluginWrapper installed;
                PluginWrapper pluginWrapper = installed = this.plugin.getInstalled();
                synchronized (pluginWrapper) {
                    if (!installed.isEnabled()) {
                        try {
                            installed.enable();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, "Failed to enable " + this.plugin.getDisplayName(), e);
                            this.error = e;
                            this.status = new DownloadJob.Failure((Throwable)e);
                        }
                        if (this.dynamicLoad) {
                            try {
                                this.pm.dynamicLoad(this.getDestination(), true);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, "Failed to dynamically load " + this.plugin.getDisplayName(), e);
                                this.error = e;
                                UpdateCenter.this.requiresRestart = true;
                                this.status = new DownloadJob.Failure((Throwable)e);
                            }
                        } else {
                            UpdateCenter.this.requiresRestart = true;
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "An unexpected error occurred while attempting to enable " + this.plugin.getDisplayName(), e);
                this.error = e;
                UpdateCenter.this.requiresRestart = true;
                this.status = new DownloadJob.Failure(e);
            }
            if (this.status instanceof DownloadJob.Pending) {
                this.status = new DownloadJob.Success();
            }
        }
    }

    public final class ConnectionCheckJob
    extends UpdateCenterJob {
        private final Vector<String> statuses;
        final Map<String, ConnectionStatus> connectionStates;

        public ConnectionCheckJob(UpdateSite site) {
            super(site);
            this.statuses = new Vector();
            this.connectionStates = new ConcurrentHashMap<String, ConnectionStatus>();
            this.connectionStates.put("internet", ConnectionStatus.PRECHECK);
            this.connectionStates.put("updatesite", ConnectionStatus.PRECHECK);
        }

        @Override
        public void run() {
            this.connectionStates.put("internet", ConnectionStatus.UNCHECKED);
            this.connectionStates.put("updatesite", ConnectionStatus.UNCHECKED);
            if (UpdateCenter.ID_UPLOAD.equals(this.site.getId())) {
                return;
            }
            LOGGER.fine("Doing a connectivity check");
            Future<?> internetCheck = null;
            try {
                final String connectionCheckUrl = this.site.getConnectionCheckUrl();
                if (connectionCheckUrl != null) {
                    this.connectionStates.put("internet", ConnectionStatus.CHECKING);
                    this.statuses.add(Messages.UpdateCenter_Status_CheckingInternet());
                    internetCheck = UpdateCenter.this.updateService.submit(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    UpdateCenter.this.config.checkConnection(ConnectionCheckJob.this, connectionCheckUrl);
                                }
                                catch (Exception e) {
                                    if (!e.getMessage().contains("Connection timed out")) break block2;
                                    ConnectionCheckJob.this.connectionStates.put("internet", ConnectionStatus.FAILED);
                                    ConnectionCheckJob.this.statuses.add(Messages.UpdateCenter_Status_ConnectionFailed(connectionCheckUrl));
                                    return;
                                }
                            }
                            ConnectionCheckJob.this.connectionStates.put("internet", ConnectionStatus.OK);
                        }
                    });
                } else {
                    LOGGER.log(Level.WARNING, "Update site ''{0}'' does not declare the connection check URL. Skipping the network availability check.", this.site.getId());
                    this.connectionStates.put("internet", ConnectionStatus.SKIPPED);
                }
                this.connectionStates.put("updatesite", ConnectionStatus.CHECKING);
                this.statuses.add(Messages.UpdateCenter_Status_CheckingJavaNet());
                UpdateCenter.this.config.checkUpdateCenter(this, this.site.getUrl());
                this.connectionStates.put("updatesite", ConnectionStatus.OK);
                this.statuses.add(Messages.UpdateCenter_Status_Success());
            }
            catch (UnknownHostException e) {
                this.connectionStates.put("updatesite", ConnectionStatus.FAILED);
                this.statuses.add(Messages.UpdateCenter_Status_UnknownHostException(e.getMessage()));
                this.addStatus(e);
                this.error = e;
            }
            catch (Exception e) {
                this.connectionStates.put("updatesite", ConnectionStatus.FAILED);
                this.statuses.add(Functions.printThrowable(e));
                this.error = e;
            }
            if (internetCheck != null) {
                try {
                    internetCheck.get();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error completing internet connectivity check: " + e.getMessage(), e);
                }
            }
        }

        private void addStatus(UnknownHostException e) {
            this.statuses.add("<pre>" + Functions.xmlEscape(Functions.printThrowable(e)) + "</pre>");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getStatuses() {
            Vector<String> vector = this.statuses;
            synchronized (vector) {
                return this.statuses.toArray(new String[this.statuses.size()]);
            }
        }
    }

    public class RestartJenkinsJob
    extends UpdateCenterJob {
        @Exported(inline=true)
        public volatile RestartJenkinsJobStatus status;
        private String authentication;

        public synchronized boolean cancel() {
            if (this.status instanceof Pending) {
                this.status = new Canceled();
                return true;
            }
            return false;
        }

        public RestartJenkinsJob(UpdateSite site) {
            super(site);
            this.status = new Pending();
            this.authentication = Jenkins.getAuthentication().getName();
        }

        @Override
        public synchronized void run() {
            if (!(this.status instanceof Pending)) {
                return;
            }
            this.status = new Running();
            try (ACLContext _ = ACL.as(User.get(this.authentication, false, Collections.emptyMap()));){
                Jenkins.getInstance().safeRestart();
            }
            catch (RestartNotSupportedException exception) {
                this.status = new Failure();
                this.error = exception;
            }
        }

        public class Canceled
        extends RestartJenkinsJobStatus {
        }

        public class Failure
        extends RestartJenkinsJobStatus {
        }

        public class Running
        extends RestartJenkinsJobStatus {
        }

        public class Pending
        extends RestartJenkinsJobStatus {
            @Exported
            public String getType() {
                return this.getClass().getSimpleName();
            }
        }

        @ExportedBean
        public abstract class RestartJenkinsJobStatus {
            @Exported
            public final int id = UpdateCenter.access$500().incrementAndGet();
        }
    }

    @ExportedBean
    public abstract class UpdateCenterJob
    implements Runnable {
        @Exported
        public final int id = UpdateCenter.access$500().incrementAndGet();
        public final UpdateSite site;
        private UUID correlationId = null;
        protected Throwable error;

        protected UpdateCenterJob(UpdateSite site) {
            this.site = site;
        }

        public Api getApi() {
            return new Api(this);
        }

        public UUID getCorrelationId() {
            return this.correlationId;
        }

        public void setCorrelationId(UUID correlationId) {
            if (this.correlationId != null) {
                throw new IllegalStateException("Illegal call to set the 'correlationId'. Already set.");
            }
            this.correlationId = correlationId;
        }

        @Deprecated
        public void schedule() {
            this.submit();
        }

        @Exported
        public String getType() {
            return this.getClass().getSimpleName();
        }

        public Future<UpdateCenterJob> submit() {
            LOGGER.fine("Scheduling " + this + " to installerService");
            UpdateCenter.this.jobs.add(this);
            return UpdateCenter.this.installerService.submit(this, this);
        }

        @Exported
        public String getErrorMessage() {
            return this.error != null ? this.error.getMessage() : null;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    public static class UpdateCenterConfiguration
    implements ExtensionPoint {
        public void checkConnection(ConnectionCheckJob job, String connectionCheckUrl) throws IOException {
            this.testConnection(new URL(connectionCheckUrl));
        }

        public void checkUpdateCenter(ConnectionCheckJob job, String updateCenterUrl) throws IOException {
            this.testConnection(UpdateCenterConfiguration.toUpdateCenterCheckUrl(updateCenterUrl));
        }

        static URL toUpdateCenterCheckUrl(String updateCenterUrl) throws MalformedURLException {
            URL url = updateCenterUrl.startsWith("http://") || updateCenterUrl.startsWith("https://") ? new URL(updateCenterUrl + (updateCenterUrl.indexOf(63) == -1 ? "?uctest" : "&uctest")) : new URL(updateCenterUrl);
            return url;
        }

        public void preValidate(DownloadJob job, URL src) throws IOException {
        }

        public void postValidate(DownloadJob job, File src) throws IOException {
        }

        public File download(DownloadJob job, URL src) throws IOException {
            File file;
            MessageDigest sha1 = null;
            try {
                sha1 = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException ignored) {
                // empty catch block
            }
            CountingInputStream in = null;
            OutputStream out = null;
            URLConnection con = null;
            try {
                con = this.connect(job, src);
                con.setReadTimeout(PLUGIN_DOWNLOAD_READ_TIMEOUT);
                int total = con.getContentLength();
                in = new CountingInputStream(con.getInputStream());
                byte[] buf = new byte[8192];
                File dst = job.getDestination();
                File tmp = new File(dst.getPath() + ".tmp");
                out = new FileOutputStream(tmp);
                if (sha1 != null) {
                    out = new DigestOutputStream(out, sha1);
                }
                LOGGER.info("Downloading " + job.getName());
                Thread t = Thread.currentThread();
                String oldName = t.getName();
                t.setName(oldName + ": " + src);
                try {
                    int len;
                    while ((len = in.read(buf)) >= 0) {
                        out.write(buf, 0, len);
                        DownloadJob downloadJob = job;
                        downloadJob.getClass();
                        job.status = downloadJob.new DownloadJob.Installing(total == -1 ? -1 : in.getCount() * 100 / total);
                    }
                }
                catch (IOException e) {
                    throw new IOException("Failed to load " + src + " to " + tmp, e);
                }
                finally {
                    IOUtils.closeQuietly(out);
                    t.setName(oldName);
                }
                if (total != -1 && (long)total != tmp.length()) {
                    throw new IOException("Inconsistent file length: expected " + total + " but only got " + tmp.length());
                }
                if (sha1 != null) {
                    byte[] digest = sha1.digest();
                    job.computedSHA1 = Base64.encodeBase64String((byte[])digest);
                }
                file = tmp;
            }
            catch (IOException e) {
                try {
                    String extraMessage = "";
                    if (con != null && con.getURL() != null && !src.toString().equals(con.getURL().toString())) {
                        extraMessage = " (redirected to: " + con.getURL() + ")";
                    }
                    throw new IOException2("Failed to download from " + src + extraMessage, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly(out);
            return file;
        }

        protected URLConnection connect(DownloadJob job, URL src) throws IOException {
            return ProxyConfiguration.open(src);
        }

        public void install(DownloadJob job, File src, File dst) throws IOException {
            job.replace(dst, src);
        }

        public void upgrade(DownloadJob job, File src, File dst) throws IOException {
            job.replace(dst, src);
        }

        @Deprecated
        public String getConnectionCheckUrl() {
            return "http://www.google.com";
        }

        @Deprecated
        public String getUpdateCenterUrl() {
            return UPDATE_CENTER_URL;
        }

        @Deprecated
        public String getPluginRepositoryBaseUrl() {
            return "http://jenkins-ci.org/";
        }

        private void testConnection(URL url) throws IOException {
            block5: {
                try {
                    URLConnection connection = ProxyConfiguration.open(url);
                    if (connection instanceof HttpURLConnection) {
                        int responseCode = ((HttpURLConnection)connection).getResponseCode();
                        if (200 != responseCode) {
                            throw new HttpRetryException("Invalid response code (" + responseCode + ") from URL: " + url, responseCode);
                        }
                    } else {
                        Util.copyStreamAndClose(connection.getInputStream(), (OutputStream)new NullOutputStream());
                    }
                }
                catch (SSLHandshakeException e) {
                    if (!e.getMessage().contains("PKIX path building failed")) break block5;
                    throw new IOException("Failed to validate the SSL certificate of " + url, e);
                }
            }
        }
    }

    @Extension
    @Symbol(value={"coreUpdate"})
    public static final class CoreUpdateMonitor
    extends AdministrativeMonitor {
        @Override
        public String getDisplayName() {
            return Messages.UpdateCenter_CoreUpdateMonitor_DisplayName();
        }

        @Override
        public boolean isActivated() {
            UpdateSite.Data data = this.getData();
            return data != null && data.hasCoreUpdates();
        }

        public UpdateSite.Data getData() {
            UpdateSite cs = Jenkins.getInstance().getUpdateCenter().getCoreSource();
            if (cs != null) {
                return cs.getData();
            }
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    static enum ConnectionStatus {
        PRECHECK,
        SKIPPED,
        CHECKING,
        UNCHECKED,
        OK,
        FAILED;

        static final String INTERNET = "internet";
        static final String UPDATE_SITE = "updatesite";
    }
}

