/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import hudson.Util;
import hudson.model.AdministrativeMonitor;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.Descriptor;
import hudson.node_monitors.Messages;
import hudson.node_monitors.MonitorMarkedNodeOffline;
import hudson.node_monitors.NodeMonitor;
import hudson.slaves.OfflineCause;
import hudson.triggers.SafeTimerTask;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.Jenkins;
import jenkins.util.Timer;

public abstract class AbstractNodeMonitorDescriptor<T>
extends Descriptor<NodeMonitor> {
    private volatile transient Record record = null;
    @GuardedBy(value="this")
    private transient Record inProgress = null;
    @GuardedBy(value="this")
    private transient long inProgressStarted = Long.MIN_VALUE;
    private static final Logger LOGGER = Logger.getLogger(AbstractNodeMonitorDescriptor.class.getName());
    private static final long HOUR = 3600000L;

    @Deprecated
    protected AbstractNodeMonitorDescriptor() {
        this(3600000L);
    }

    @Deprecated
    protected AbstractNodeMonitorDescriptor(long interval) {
        this.schedule(interval);
    }

    @Deprecated
    protected AbstractNodeMonitorDescriptor(Class<? extends NodeMonitor> clazz) {
        this(clazz, 3600000L);
    }

    @Deprecated
    protected AbstractNodeMonitorDescriptor(Class<? extends NodeMonitor> clazz, long interval) {
        super(clazz);
        this.schedule(interval);
    }

    private void schedule(long interval) {
        Timer.get().scheduleAtFixedRate(new SafeTimerTask(){

            @Override
            public void doRun() {
                AbstractNodeMonitorDescriptor.this.triggerUpdate();
            }
        }, interval, interval, TimeUnit.MILLISECONDS);
    }

    protected abstract T monitor(Computer var1) throws IOException, InterruptedException;

    protected Map<Computer, T> monitor() throws InterruptedException {
        HashMap<Computer, T> data = new HashMap<Computer, T>();
        for (Computer c : Jenkins.getInstance().getComputers()) {
            try {
                Thread.currentThread().setName("Monitoring " + c.getDisplayName() + " for " + this.getDisplayName());
                if (c.getChannel() == null) {
                    data.put(c, null);
                    continue;
                }
                data.put(c, this.monitor(c));
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Failed to monitor " + c.getDisplayName() + " for " + this.getDisplayName(), e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to monitor " + c.getDisplayName() + " for " + this.getDisplayName(), e);
            }
            catch (InterruptedException e) {
                throw (InterruptedException)new InterruptedException("Node monitoring " + c.getDisplayName() + " for " + this.getDisplayName() + " aborted.").initCause(e);
            }
        }
        return data;
    }

    public T get(Computer c) {
        if (this.record == null || !this.record.data.containsKey(c)) {
            this.triggerUpdate();
            return null;
        }
        return (T)this.record.data.get(c);
    }

    private synchronized boolean isInProgress() {
        return this.inProgress != null && this.inProgress.isAlive();
    }

    public long getTimestamp() {
        return this.record == null ? 0L : this.record.timestamp;
    }

    public String getTimestampString() {
        if (this.record == null) {
            return Messages.AbstractNodeMonitorDescriptor_NoDataYet();
        }
        return Util.getPastTimeString(System.currentTimeMillis() - this.record.timestamp);
    }

    public boolean isIgnored() {
        NodeMonitor m = ComputerSet.getMonitors().get(this);
        return m == null || m.isIgnored();
    }

    protected boolean markOnline(Computer c) {
        if (this.isIgnored() || c.isOnline()) {
            return false;
        }
        c.setTemporarilyOffline(false, null);
        return true;
    }

    protected boolean markOffline(Computer c, OfflineCause oc) {
        if (this.isIgnored() || c.isTemporarilyOffline()) {
            return false;
        }
        c.setTemporarilyOffline(true, oc);
        MonitorMarkedNodeOffline no = AdministrativeMonitor.all().get(MonitorMarkedNodeOffline.class);
        if (no != null) {
            no.active = true;
        }
        return true;
    }

    @Deprecated
    protected boolean markOffline(Computer c) {
        return this.markOffline(c, null);
    }

    synchronized Thread triggerUpdate() {
        if (this.inProgress != null) {
            if (!this.inProgress.isAlive()) {
                LOGGER.log(Level.WARNING, "Previous {0} monitoring activity died without cleaning up after itself", this.getDisplayName());
                this.inProgress = null;
            } else if (System.currentTimeMillis() > this.inProgressStarted + this.getMonitoringTimeOut() + 1000L) {
                LOGGER.log(Level.WARNING, "Previous {0} monitoring activity still in progress. Interrupting", this.getDisplayName());
                this.inProgress.interrupt();
                this.inProgress = null;
            } else {
                return this.inProgress;
            }
        }
        Record t = new Record();
        t.start();
        this.inProgress = t;
        this.inProgressStarted = System.currentTimeMillis();
        return this.inProgress;
    }

    protected long getMonitoringTimeOut() {
        return TimeUnit.SECONDS.toMillis(30L);
    }

    private final class Record
    extends Thread {
        private Map<Computer, T> data;
        private long timestamp;

        public Record() {
            super("Monitoring thread for " + AbstractNodeMonitorDescriptor.this.getDisplayName() + " started on " + new Date());
            this.data = Collections.emptyMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                String oldName = this.getName();
                this.data = AbstractNodeMonitorDescriptor.this.monitor();
                this.setName(oldName);
                this.timestamp = System.currentTimeMillis();
                AbstractNodeMonitorDescriptor.this.record = this;
                LOGGER.log(Level.FINE, "Node monitoring {0} completed in {1}ms", new Object[]{AbstractNodeMonitorDescriptor.this.getDisplayName(), System.currentTimeMillis() - startTime});
            }
            catch (InterruptedException x2) {
                AbstractNodeMonitorDescriptor x2 = AbstractNodeMonitorDescriptor.this;
                synchronized (x2) {
                    if (AbstractNodeMonitorDescriptor.this.inProgress == this) {
                        AbstractNodeMonitorDescriptor.this.inProgress = null;
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Unexpected node monitoring termination: " + AbstractNodeMonitorDescriptor.this.getDisplayName(), t);
            }
            finally {
                AbstractNodeMonitorDescriptor startTime = AbstractNodeMonitorDescriptor.this;
                synchronized (startTime) {
                    if (AbstractNodeMonitorDescriptor.this.inProgress == this) {
                        AbstractNodeMonitorDescriptor.this.inProgress = null;
                    }
                }
            }
        }
    }
}

