/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.User;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.remoting.Callable;
import hudson.security.ACLContext;
import hudson.security.AccessDeniedException2;
import hudson.security.Messages;
import hudson.security.Permission;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.NonSerializableSecurityContext;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class ACL {
    public static final Sid EVERYONE = new Sid(){

        public String toString() {
            return "EVERYONE";
        }
    };
    @Restricted(value={NoExternalUse.class})
    public static final String ANONYMOUS_USERNAME = "anonymous";
    public static final Sid ANONYMOUS = new PrincipalSid("anonymous");
    protected static final Sid[] AUTOMATIC_SIDS = new Sid[]{EVERYONE, ANONYMOUS};
    @Restricted(value={NoExternalUse.class})
    public static final String SYSTEM_USERNAME = "SYSTEM";
    public static final Authentication SYSTEM = new UsernamePasswordAuthenticationToken((Object)"SYSTEM", (Object)"SYSTEM");

    public final void checkPermission(@Nonnull Permission p) {
        Authentication a = Jenkins.getAuthentication();
        if (!this.hasPermission(a, p)) {
            throw new AccessDeniedException2(a, p);
        }
    }

    public final boolean hasPermission(@Nonnull Permission p) {
        return this.hasPermission(Jenkins.getAuthentication(), p);
    }

    public abstract boolean hasPermission(@Nonnull Authentication var1, @Nonnull Permission var2);

    public final void checkCreatePermission(@Nonnull ItemGroup c, @Nonnull TopLevelItemDescriptor d) {
        Authentication a = Jenkins.getAuthentication();
        if (!this.hasCreatePermission(a, c, d)) {
            throw new AccessDeniedException(Messages.AccessDeniedException2_MissingPermission(a.getName(), Item.CREATE.group.title + "/" + Item.CREATE.name + Item.CREATE + "/" + d.getDisplayName()));
        }
    }

    public boolean hasCreatePermission(@Nonnull Authentication a, @Nonnull ItemGroup c, @Nonnull TopLevelItemDescriptor d) {
        return true;
    }

    public final void checkCreatePermission(@Nonnull ViewGroup c, @Nonnull ViewDescriptor d) {
        Authentication a = Jenkins.getAuthentication();
        if (!this.hasCreatePermission(a, c, d)) {
            throw new AccessDeniedException(Messages.AccessDeniedException2_MissingPermission(a.getName(), View.CREATE.group.title + "/" + View.CREATE.name + View.CREATE + "/" + d.getDisplayName()));
        }
    }

    public boolean hasCreatePermission(@Nonnull Authentication a, @Nonnull ViewGroup c, @Nonnull ViewDescriptor d) {
        return true;
    }

    @Deprecated
    @Nonnull
    public static SecurityContext impersonate(@Nonnull Authentication auth) {
        SecurityContext old = SecurityContextHolder.getContext();
        SecurityContextHolder.setContext((SecurityContext)new NonSerializableSecurityContext(auth));
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void impersonate(@Nonnull Authentication auth, @Nonnull Runnable body) {
        SecurityContext old = ACL.impersonate(auth);
        try {
            body.run();
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static <V, T extends Exception> V impersonate(Authentication auth, Callable<V, T> body) throws T {
        SecurityContext old = ACL.impersonate(auth);
        try {
            Object object = body.call();
            return (V)object;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)old);
        }
    }

    @Nonnull
    public static ACLContext as(@Nonnull Authentication auth) {
        ACLContext context = new ACLContext(SecurityContextHolder.getContext());
        SecurityContextHolder.setContext((SecurityContext)new NonSerializableSecurityContext(auth));
        return context;
    }

    @Nonnull
    public static ACLContext as(@CheckForNull User user) {
        return ACL.as(user == null ? Jenkins.ANONYMOUS : user.impersonate());
    }
}

