/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.security.ACL;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.BCrypt;
import hudson.security.FederatedLoginService;
import hudson.security.GroupDetails;
import hudson.security.InvalidatableUserDetails;
import hudson.security.Messages;
import hudson.security.Permission;
import hudson.security.PermissionAdder;
import hudson.security.SecurityRealm;
import hudson.security.captcha.CaptchaSupport;
import hudson.util.PluginServletFilter;
import hudson.util.Protector;
import hudson.util.Scrambler;
import hudson.util.XStream2;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.acegisecurity.providers.encoding.ShaPasswordEncoder;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.dao.DataAccessException;

public class HudsonPrivateSecurityRealm
extends AbstractPasswordBasedSecurityRealm
implements ModelObject,
AccessControlled {
    private final boolean disableSignup;
    private final boolean enableCaptcha;
    private static final String FEDERATED_IDENTITY_SESSION_KEY = HudsonPrivateSecurityRealm.class.getName() + ".federatedIdentity";
    private static final GrantedAuthority[] TEST_AUTHORITY = new GrantedAuthority[]{AUTHENTICATED_AUTHORITY};
    static final PasswordEncoder CLASSIC = new PasswordEncoder(){
        private final PasswordEncoder passwordEncoder = new ShaPasswordEncoder(256);

        public String encodePassword(String rawPass, Object _) throws DataAccessException {
            return this.hash(rawPass);
        }

        public boolean isPasswordValid(String encPass, String rawPass, Object _) throws DataAccessException {
            int i = encPass.indexOf(58);
            if (i < 0) {
                return false;
            }
            String salt = encPass.substring(0, i);
            return encPass.substring(i + 1).equals(this.passwordEncoder.encodePassword(rawPass, (Object)salt));
        }

        private String hash(String password) {
            String salt = this.generateSalt();
            return salt + ':' + this.passwordEncoder.encodePassword(password, (Object)salt);
        }

        private String generateSalt() {
            StringBuilder buf = new StringBuilder();
            SecureRandom sr = new SecureRandom();
            for (int i = 0; i < 6; ++i) {
                boolean upper = sr.nextBoolean();
                char ch = (char)(sr.nextInt(26) + 97);
                if (upper) {
                    ch = Character.toUpperCase(ch);
                }
                buf.append(ch);
            }
            return buf.toString();
        }
    };
    private static final PasswordEncoder JBCRYPT_ENCODER = new PasswordEncoder(){

        public String encodePassword(String rawPass, Object _) throws DataAccessException {
            return BCrypt.hashpw(rawPass, BCrypt.gensalt());
        }

        public boolean isPasswordValid(String encPass, String rawPass, Object _) throws DataAccessException {
            return BCrypt.checkpw(rawPass, encPass);
        }
    };
    public static final PasswordEncoder PASSWORD_ENCODER = new PasswordEncoder(){
        private static final String JBCRYPT_HEADER = "#jbcrypt:";

        public String encodePassword(String rawPass, Object salt) throws DataAccessException {
            return JBCRYPT_HEADER + JBCRYPT_ENCODER.encodePassword(rawPass, salt);
        }

        public boolean isPasswordValid(String encPass, String rawPass, Object salt) throws DataAccessException {
            if (encPass.startsWith(JBCRYPT_HEADER)) {
                return JBCRYPT_ENCODER.isPasswordValid(encPass.substring(JBCRYPT_HEADER.length()), rawPass, salt);
            }
            return CLASSIC.isPasswordValid(encPass, rawPass, salt);
        }
    };
    private static final Filter CREATE_FIRST_USER_FILTER = new Filter(){

        public void init(FilterConfig config) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest req = (HttpServletRequest)request;
            if (req.getRequestURI().equals(req.getContextPath() + "/") || req.getRequestURI().equals(req.getContextPath() + "/manage")) {
                if (this.needsToCreateFirstUser()) {
                    ((HttpServletResponse)response).sendRedirect("securityRealm/firstUser");
                } else {
                    PluginServletFilter.removeFilter(this);
                    chain.doFilter(request, response);
                }
            } else {
                chain.doFilter(request, response);
            }
        }

        private boolean needsToCreateFirstUser() {
            return !HudsonPrivateSecurityRealm.hasSomeUser() && Jenkins.getInstance().getSecurityRealm() instanceof HudsonPrivateSecurityRealm;
        }

        public void destroy() {
        }
    };
    private static final Logger LOGGER = Logger.getLogger(HudsonPrivateSecurityRealm.class.getName());

    @Deprecated
    public HudsonPrivateSecurityRealm(boolean allowsSignup) {
        this(allowsSignup, false, null);
    }

    @DataBoundConstructor
    public HudsonPrivateSecurityRealm(boolean allowsSignup, boolean enableCaptcha, CaptchaSupport captchaSupport) {
        this.disableSignup = !allowsSignup;
        this.enableCaptcha = enableCaptcha;
        this.setCaptchaSupport(captchaSupport);
        if (!allowsSignup && !HudsonPrivateSecurityRealm.hasSomeUser()) {
            try {
                PluginServletFilter.addFilter(CREATE_FIRST_USER_FILTER);
            }
            catch (ServletException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public boolean allowsSignup() {
        return !this.disableSignup;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean getAllowsSignup() {
        return this.allowsSignup();
    }

    public boolean isEnableCaptcha() {
        return this.enableCaptcha;
    }

    private static boolean hasSomeUser() {
        for (User u : User.getAll()) {
            if (u.getProperty(Details.class) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        throw new UsernameNotFoundException(groupname);
    }

    @Override
    public Details loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        Details p;
        User u = User.getById(username, false);
        Details details = p = u != null ? u.getProperty(Details.class) : null;
        if (p == null) {
            throw new UsernameNotFoundException("Password is not set: " + username);
        }
        if (p.getUser() == null) {
            throw new AssertionError();
        }
        return p;
    }

    @Override
    protected Details authenticate(String username, String password) throws AuthenticationException {
        Details u = this.loadUserByUsername(username);
        if (!u.isPasswordCorrect(password)) {
            String message;
            try {
                message = ResourceBundle.getBundle("org.acegisecurity.messages").getString("AbstractUserDetailsAuthenticationProvider.badCredentials");
            }
            catch (MissingResourceException x) {
                message = "Bad credentials";
            }
            throw new BadCredentialsException(message);
        }
        return u;
    }

    @Override
    public HttpResponse commenceSignup(final FederatedLoginService.FederatedIdentity identity) {
        Stapler.getCurrentRequest().getSession().setAttribute(FEDERATED_IDENTITY_SESSION_KEY, (Object)identity);
        return new ForwardToView(this, "signupWithFederatedIdentity.jelly"){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                SignupInfo si = new SignupInfo(identity);
                si.errorMessage = Messages.HudsonPrivateSecurityRealm_WouldYouLikeToSignUp(identity.getPronoun(), identity.getIdentifier());
                req.setAttribute("data", (Object)si);
                super.generateResponse(req, rsp, node);
            }
        };
    }

    @RequirePOST
    public User doCreateAccountWithFederatedIdentity(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        User u = this._doCreateAccount(req, rsp, "signupWithFederatedIdentity.jelly");
        if (u != null) {
            ((FederatedLoginService.FederatedIdentity)req.getSession().getAttribute(FEDERATED_IDENTITY_SESSION_KEY)).addTo(u);
        }
        return u;
    }

    @RequirePOST
    public User doCreateAccount(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        return this._doCreateAccount(req, rsp, "signup.jelly");
    }

    private User _doCreateAccount(StaplerRequest req, StaplerResponse rsp, String formView) throws ServletException, IOException {
        if (!this.allowsSignup()) {
            throw HttpResponses.error((int)401, (Throwable)new Exception("User sign up is prohibited"));
        }
        boolean firstUser = !HudsonPrivateSecurityRealm.hasSomeUser();
        User u = this.createAccount(req, rsp, this.enableCaptcha, formView);
        if (u != null) {
            if (firstUser) {
                this.tryToMakeAdmin(u);
            }
            this.loginAndTakeBack(req, rsp, u);
        }
        return u;
    }

    private void loginAndTakeBack(StaplerRequest req, StaplerResponse rsp, User u) throws ServletException, IOException {
        UsernamePasswordAuthenticationToken a = new UsernamePasswordAuthenticationToken((Object)u.getId(), (Object)req.getParameter("password1"));
        a = this.getSecurityComponents().manager.authenticate((Authentication)a);
        SecurityContextHolder.getContext().setAuthentication((Authentication)a);
        req.getView((Object)this, "success.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @RequirePOST
    public void doCreateAccountByAdmin(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.createAccountByAdmin(req, rsp, "addUser.jelly", ".");
    }

    @Restricted(value={NoExternalUse.class})
    public User createAccountByAdmin(StaplerRequest req, StaplerResponse rsp, String addUserView, String successView) throws IOException, ServletException {
        this.checkPermission(Jenkins.ADMINISTER);
        User u = this.createAccount(req, rsp, false, addUserView);
        if (u != null && successView != null) {
            rsp.sendRedirect(successView);
        }
        return u;
    }

    @RequirePOST
    public void doCreateFirstAccount(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (HudsonPrivateSecurityRealm.hasSomeUser()) {
            rsp.sendError(401, "First user was already created");
            return;
        }
        User u = this.createAccount(req, rsp, false, "firstUser.jelly");
        if (u != null) {
            this.tryToMakeAdmin(u);
            this.loginAndTakeBack(req, rsp, u);
        }
    }

    private void tryToMakeAdmin(User u) {
        AuthorizationStrategy as = Jenkins.getInstance().getAuthorizationStrategy();
        for (PermissionAdder adder : ExtensionList.lookup(PermissionAdder.class)) {
            if (!adder.add(as, u, Jenkins.ADMINISTER)) continue;
            return;
        }
    }

    private User createAccount(StaplerRequest req, StaplerResponse rsp, boolean selfRegistration, String formView) throws ServletException, IOException {
        User user;
        SignupInfo si = new SignupInfo(req);
        if (selfRegistration && !this.validateCaptcha(si.captcha)) {
            si.errorMessage = Messages.HudsonPrivateSecurityRealm_CreateAccount_TextNotMatchWordInImage();
        }
        if (si.password1 != null && !si.password1.equals(si.password2)) {
            si.errorMessage = Messages.HudsonPrivateSecurityRealm_CreateAccount_PasswordNotMatch();
        }
        if (si.password1 == null || si.password1.length() == 0) {
            si.errorMessage = Messages.HudsonPrivateSecurityRealm_CreateAccount_PasswordRequired();
        }
        if (si.username == null || si.username.length() == 0) {
            si.errorMessage = Messages.HudsonPrivateSecurityRealm_CreateAccount_UserNameRequired();
        } else {
            user = User.getById(si.username, false);
            if (null != user && user.getProperty(Details.class) != null) {
                si.errorMessage = Messages.HudsonPrivateSecurityRealm_CreateAccount_UserNameAlreadyTaken();
            }
        }
        if (si.fullname == null || si.fullname.length() == 0) {
            si.fullname = si.username;
        }
        if (this.isMailerPluginPresent() && (si.email == null || !si.email.contains("@"))) {
            si.errorMessage = Messages.HudsonPrivateSecurityRealm_CreateAccount_InvalidEmailAddress();
        }
        if (!User.isIdOrFullnameAllowed(si.username)) {
            si.errorMessage = hudson.model.Messages.User_IllegalUsername(si.username);
        }
        if (!User.isIdOrFullnameAllowed(si.fullname)) {
            si.errorMessage = hudson.model.Messages.User_IllegalFullname(si.fullname);
        }
        if (si.errorMessage != null) {
            req.setAttribute("data", (Object)si);
            req.getView((Object)this, formView).forward((ServletRequest)req, (ServletResponse)rsp);
            return null;
        }
        user = this.createAccount(si.username, si.password1);
        user.setFullName(si.fullname);
        if (this.isMailerPluginPresent()) {
            try {
                Class<?> up = Jenkins.getInstance().pluginManager.uberClassLoader.loadClass("hudson.tasks.Mailer$UserProperty");
                Constructor<?> c = up.getDeclaredConstructor(String.class);
                user.addProperty((UserProperty)c.newInstance(si.email));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
        user.save();
        return user;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isMailerPluginPresent() {
        try {
            return null != Jenkins.getInstance().pluginManager.uberClassLoader.loadClass("hudson.tasks.Mailer$UserProperty");
        }
        catch (ClassNotFoundException e) {
            LOGGER.finer("Mailer plugin not present");
            return false;
        }
    }

    public User createAccount(String userName, String password) throws IOException {
        User user = User.getById(userName, true);
        user.addProperty(Details.fromPlainPassword(password));
        return user;
    }

    @Override
    public String getDisplayName() {
        return Messages.HudsonPrivateSecurityRealm_DisplayName();
    }

    @Override
    public ACL getACL() {
        return Jenkins.getInstance().getACL();
    }

    @Override
    public void checkPermission(Permission permission) {
        Jenkins.getInstance().checkPermission(permission);
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return Jenkins.getInstance().hasPermission(permission);
    }

    public List<User> getAllUsers() {
        ArrayList<User> r = new ArrayList<User>();
        for (User u : User.getAll()) {
            if (u.getProperty(Details.class) == null) continue;
            r.add(u);
        }
        Collections.sort(r);
        return r;
    }

    public User getUser(String id) {
        return User.getById(id, true);
    }

    @Extension
    @Symbol(value={"local"})
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        @Override
        public String getDisplayName() {
            return Messages.HudsonPrivateSecurityRealm_DisplayName();
        }
    }

    @Extension
    @Symbol(value={"localUsers"})
    public static final class ManageUserLinks
    extends ManagementLink {
        @Override
        public String getIconFileName() {
            if (Jenkins.getInstance().getSecurityRealm() instanceof HudsonPrivateSecurityRealm) {
                return "user.png";
            }
            return null;
        }

        @Override
        public String getUrlName() {
            return "securityRealm/";
        }

        @Override
        public String getDisplayName() {
            return Messages.HudsonPrivateSecurityRealm_ManageUserLinks_DisplayName();
        }

        @Override
        public String getDescription() {
            return Messages.HudsonPrivateSecurityRealm_ManageUserLinks_Description();
        }
    }

    public static final class Details
    extends UserProperty
    implements InvalidatableUserDetails {
        private String passwordHash;
        @Deprecated
        private transient String password;

        private Details(String passwordHash) {
            this.passwordHash = passwordHash;
        }

        static Details fromHashedPassword(String hashed) {
            return new Details(hashed);
        }

        static Details fromPlainPassword(String rawPassword) {
            return new Details(PASSWORD_ENCODER.encodePassword(rawPassword, null));
        }

        public GrantedAuthority[] getAuthorities() {
            return TEST_AUTHORITY;
        }

        public String getPassword() {
            return this.passwordHash;
        }

        public boolean isPasswordCorrect(String candidate) {
            return PASSWORD_ENCODER.isPasswordValid(this.getPassword(), candidate, null);
        }

        public String getProtectedPassword() {
            return Protector.protect(Stapler.getCurrentRequest().getSession().getId() + ':' + this.getPassword());
        }

        public String getUsername() {
            return this.user.getId();
        }

        User getUser() {
            return this.user;
        }

        public boolean isAccountNonExpired() {
            return true;
        }

        public boolean isAccountNonLocked() {
            return true;
        }

        public boolean isCredentialsNonExpired() {
            return true;
        }

        public boolean isEnabled() {
            return true;
        }

        @Override
        public boolean isInvalid() {
            return this.user == null;
        }

        @Extension
        @Symbol(value={"password"})
        public static final class DescriptorImpl
        extends UserPropertyDescriptor {
            @Override
            public String getDisplayName() {
                return Messages.HudsonPrivateSecurityRealm_Details_DisplayName();
            }

            @Override
            public Details newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
                String prefix;
                if (req == null) {
                    throw new Descriptor.FormException("Stapler request is missing in the call", "staplerRequest");
                }
                String pwd = Util.fixEmpty(req.getParameter("user.password"));
                String pwd2 = Util.fixEmpty(req.getParameter("user.password2"));
                if (!Util.fixNull(pwd).equals(Util.fixNull(pwd2))) {
                    throw new Descriptor.FormException("Please confirm the password by typing it twice", "user.password2");
                }
                String data = Protector.unprotect(pwd);
                if (data != null && data.startsWith(prefix = Stapler.getCurrentRequest().getSession().getId() + ':')) {
                    return Details.fromHashedPassword(data.substring(prefix.length()));
                }
                return Details.fromPlainPassword(Util.fixNull(pwd));
            }

            @Override
            public boolean isEnabled() {
                return Jenkins.getInstance().getSecurityRealm() instanceof HudsonPrivateSecurityRealm;
            }

            @Override
            public UserProperty newInstance(User user) {
                return null;
            }
        }

        public static class ConverterImpl
        extends XStream2.PassthruConverter<Details> {
            public ConverterImpl(XStream2 xstream) {
                super(xstream);
            }

            @Override
            protected void callback(Details d, UnmarshallingContext context) {
                if (d.password != null && d.passwordHash == null) {
                    d.passwordHash = PASSWORD_ENCODER.encodePassword(Scrambler.descramble(d.password), null);
                    OldDataMonitor.report(context, "1.283");
                }
            }
        }
    }

    public static final class SignupInfo {
        public String username;
        public String password1;
        public String password2;
        public String fullname;
        public String email;
        public String captcha;
        public String errorMessage;

        public SignupInfo() {
        }

        public SignupInfo(StaplerRequest req) {
            req.bindParameters((Object)this);
        }

        public SignupInfo(FederatedLoginService.FederatedIdentity i) {
            this.username = i.getNickname();
            this.fullname = i.getFullName();
            this.email = i.getEmailAddress();
        }
    }
}

