/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import groovy.lang.Binding;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.cli.CLICommand;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.security.AuthenticationManagerProxy;
import hudson.security.ChainedServletFilter;
import hudson.security.CliAuthenticator;
import hudson.security.FederatedLoginService;
import hudson.security.GroupDetails;
import hudson.security.TokenBasedRememberMeServices2;
import hudson.security.UserDetailsServiceProxy;
import hudson.security.UserMayOrMayNotExistException;
import hudson.security.captcha.CaptchaSupport;
import hudson.util.DescriptorList;
import hudson.util.spring.BeanBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

public abstract class SecurityRealm
extends AbstractDescribableImpl<SecurityRealm>
implements ExtensionPoint {
    private CaptchaSupport captchaSupport;
    private transient SecurityComponents securityComponents;
    public static final SecurityRealm NO_AUTHENTICATION = new None();
    @Deprecated
    public static final DescriptorList<SecurityRealm> LIST = new DescriptorList<SecurityRealm>(SecurityRealm.class);
    private static final Logger LOGGER = Logger.getLogger(SecurityRealm.class.getName());
    public static final GrantedAuthority AUTHENTICATED_AUTHORITY = new GrantedAuthorityImpl("authenticated");

    public abstract SecurityComponents createSecurityComponents();

    public IdStrategy getUserIdStrategy() {
        return IdStrategy.CASE_INSENSITIVE;
    }

    public IdStrategy getGroupIdStrategy() {
        return this.getUserIdStrategy();
    }

    @Deprecated
    public CliAuthenticator createCliAuthenticator(final CLICommand command) {
        return new CliAuthenticator(){

            @Override
            public Authentication authenticate() {
                return command.getTransportAuthentication();
            }
        };
    }

    @Override
    public Descriptor<SecurityRealm> getDescriptor() {
        return super.getDescriptor();
    }

    public String getAuthenticationGatewayUrl() {
        return "j_acegi_security_check";
    }

    public String getLoginUrl() {
        return "login";
    }

    public boolean canLogOut() {
        return true;
    }

    protected String getPostLogOutUrl(StaplerRequest req, Authentication auth) {
        return req.getContextPath() + "/";
    }

    public CaptchaSupport getCaptchaSupport() {
        return this.captchaSupport;
    }

    public void setCaptchaSupport(CaptchaSupport captchaSupport) {
        this.captchaSupport = captchaSupport;
    }

    public List<Descriptor<CaptchaSupport>> getCaptchaSupportDescriptors() {
        return CaptchaSupport.all();
    }

    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.clearContext();
        Cookie cookie = new Cookie("ACEGI_SECURITY_HASHED_REMEMBER_ME_COOKIE", "");
        cookie.setPath(req.getContextPath().length() > 0 ? req.getContextPath() : "/");
        rsp.addCookie(cookie);
        rsp.sendRedirect2(this.getPostLogOutUrl(req, auth));
    }

    public boolean allowsSignup() {
        Class<?> clz = this.getClass();
        return clz.getClassLoader().getResource(clz.getName().replace('.', '/') + "/signup.jelly") != null;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.getSecurityComponents().userDetails.loadUserByUsername(username);
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        throw new UserMayOrMayNotExistException(groupname);
    }

    public GroupDetails loadGroupByGroupname(String groupname, boolean fetchMembers) throws UsernameNotFoundException, DataAccessException {
        return this.loadGroupByGroupname(groupname);
    }

    public HttpResponse commenceSignup(FederatedLoginService.FederatedIdentity identity) {
        throw new UnsupportedOperationException();
    }

    public final void doCaptcha(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (this.captchaSupport != null) {
            String id = req.getSession().getId();
            rsp.setContentType("image/png");
            rsp.addHeader("Cache-Control", "no-cache");
            this.captchaSupport.generateImage(id, (OutputStream)rsp.getOutputStream());
        }
    }

    protected final boolean validateCaptcha(String text) {
        if (this.captchaSupport != null) {
            String id = Stapler.getCurrentRequest().getSession().getId();
            return this.captchaSupport.validateCaptcha(id, text);
        }
        return true;
    }

    public static <T> T findBean(Class<T> type, ApplicationContext context) {
        Map m = context.getBeansOfType(type);
        switch (m.size()) {
            case 0: {
                throw new IllegalArgumentException("No beans of " + type + " are defined");
            }
            case 1: {
                return type.cast(m.values().iterator().next());
            }
        }
        throw new IllegalArgumentException("Multiple beans of " + type + " are defined: " + m);
    }

    public synchronized SecurityComponents getSecurityComponents() {
        if (this.securityComponents == null) {
            this.securityComponents = this.createSecurityComponents();
        }
        return this.securityComponents;
    }

    public Filter createFilter(FilterConfig filterConfig) {
        LOGGER.entering(SecurityRealm.class.getName(), "createFilter");
        Binding binding = new Binding();
        SecurityComponents sc = this.getSecurityComponents();
        binding.setVariable("securityComponents", (Object)sc);
        binding.setVariable("securityRealm", (Object)this);
        BeanBuilder builder = new BeanBuilder();
        builder.parse(filterConfig.getServletContext().getResourceAsStream("/WEB-INF/security/SecurityFilters.groovy"), binding);
        WebApplicationContext context = builder.createApplicationContext();
        return (Filter)context.getBean("filter");
    }

    @Restricted(value={DoNotUse.class})
    public static String getFrom() {
        String from = null;
        String returnValue = null;
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null && request.getSession(false) != null) {
            from = (String)request.getSession().getAttribute("from");
        } else if (request != null) {
            from = request.getParameter("from");
        }
        if (from == null && request != null && request.getRequestURI() != null && !request.getRequestURI().equals("/loginError") && !request.getRequestURI().equals("/login")) {
            from = request.getRequestURI();
        }
        from = StringUtils.defaultIfBlank((String)from, (String)"/").trim();
        try {
            returnValue = URLEncoder.encode(from, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return StringUtils.isBlank((String)returnValue) ? "/" : returnValue;
    }

    public static DescriptorExtensionList<SecurityRealm, Descriptor<SecurityRealm>> all() {
        return Jenkins.getInstance().getDescriptorList(SecurityRealm.class);
    }

    public static final class SecurityComponents {
        public final AuthenticationManager manager;
        public final UserDetailsService userDetails;
        public final RememberMeServices rememberMe;

        public SecurityComponents() {
            this(new AuthenticationManagerProxy());
        }

        public SecurityComponents(AuthenticationManager manager) {
            this(manager, new UserDetailsServiceProxy());
        }

        public SecurityComponents(AuthenticationManager manager, UserDetailsService userDetails) {
            this(manager, userDetails, SecurityComponents.createRememberMeService(userDetails));
        }

        public SecurityComponents(AuthenticationManager manager, UserDetailsService userDetails, RememberMeServices rememberMe) {
            assert (manager != null && userDetails != null && rememberMe != null);
            this.manager = manager;
            this.userDetails = userDetails;
            this.rememberMe = rememberMe;
        }

        private static RememberMeServices createRememberMeService(UserDetailsService uds) {
            TokenBasedRememberMeServices2 rms = new TokenBasedRememberMeServices2();
            rms.setUserDetailsService(uds);
            rms.setKey(Jenkins.getInstance().getSecretKey());
            rms.setParameter("remember_me");
            return rms;
        }
    }

    private static class None
    extends SecurityRealm {
        private None() {
        }

        @Override
        public SecurityComponents createSecurityComponents() {
            return new SecurityComponents(new AuthenticationManager(){

                public Authentication authenticate(Authentication authentication) {
                    return authentication;
                }
            }, new UserDetailsService(){

                public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
                    throw new UsernameNotFoundException(username);
                }
            });
        }

        @Override
        public Descriptor<SecurityRealm> getDescriptor() {
            return null;
        }

        @Override
        public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
            throw new UsernameNotFoundException(groupname);
        }

        @Override
        public Filter createFilter(FilterConfig filterConfig) {
            return new ChainedServletFilter();
        }

        private Object readResolve() {
            return NO_AUTHENTICATION;
        }
    }
}

