/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import hudson.Extension;
import hudson.Functions;
import hudson.model.Api;
import hudson.model.UnprotectedRootAction;
import java.util.ArrayList;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@Extension
@Symbol(value={"whoAmI"})
@ExportedBean
public class WhoAmI
implements UnprotectedRootAction {
    public Api getApi() {
        return new Api(this);
    }

    @Exported
    public String getName() {
        return this.auth().getName();
    }

    @Exported
    public boolean isAuthenticated() {
        return this.auth().isAuthenticated();
    }

    @Exported
    public boolean isAnonymous() {
        return Functions.isAnonymous();
    }

    @Exported
    public String getDetails() {
        return this.auth().getDetails() != null ? this.auth().getDetails().toString() : null;
    }

    @Exported
    public String getToString() {
        return this.auth().toString();
    }

    private Authentication auth() {
        return Jenkins.getAuthentication();
    }

    @Exported
    public String[] getAuthorities() {
        if (this.auth().getAuthorities() == null) {
            return new String[0];
        }
        ArrayList<String> authorities = new ArrayList<String>();
        for (GrantedAuthority a : this.auth().getAuthorities()) {
            authorities.add(a.getAuthority());
        }
        return authorities.toArray(new String[authorities.size()]);
    }

    @Override
    public String getIconFileName() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return "Who Am I";
    }

    @Override
    public String getUrlName() {
        return "whoAmI";
    }
}

