/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.Slave;
import hudson.slaves.Messages;
import hudson.slaves.OfflineCause;
import hudson.slaves.SlaveComputer;
import hudson.util.DescriptorList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class RetentionStrategy<T extends Computer>
extends AbstractDescribableImpl<RetentionStrategy<?>>
implements ExtensionPoint {
    @Deprecated
    public static final DescriptorList<RetentionStrategy<?>> LIST = new DescriptorList<RetentionStrategy>(RetentionStrategy.class);
    public static final RetentionStrategy<Computer> NOOP = new RetentionStrategy<Computer>(){
        private final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

        @Override
        @GuardedBy(value="hudson.model.Queue.lock")
        public long check(Computer c) {
            return 60L;
        }

        @Override
        public void start(Computer c) {
            c.connect(false);
        }

        @Override
        public Descriptor<RetentionStrategy<?>> getDescriptor() {
            return this.DESCRIPTOR;
        }

        class DescriptorImpl
        extends Descriptor<RetentionStrategy<?>> {
            DescriptorImpl() {
            }
        }
    };
    public static final Always INSTANCE = new Always();

    @GuardedBy(value="hudson.model.Queue.lock")
    public abstract long check(T var1);

    public boolean isManualLaunchAllowed(T c) {
        return true;
    }

    public boolean isAcceptingTasks(T c) {
        return true;
    }

    public void start(T c) {
        Queue.withLock(new Runnable((Computer)c){
            final /* synthetic */ Computer val$c;
            {
                this.val$c = computer;
            }

            @Override
            public void run() {
                RetentionStrategy.this.check(this.val$c);
            }
        });
    }

    public static DescriptorExtensionList<RetentionStrategy<?>, Descriptor<RetentionStrategy<?>>> all() {
        return Jenkins.getInstance().getDescriptorList(RetentionStrategy.class);
    }

    public static class Demand
    extends RetentionStrategy<SlaveComputer> {
        private static final Logger logger = Logger.getLogger(Demand.class.getName());
        private final long inDemandDelay;
        private final long idleDelay;

        @DataBoundConstructor
        public Demand(long inDemandDelay, long idleDelay) {
            this.inDemandDelay = Math.max(0L, inDemandDelay);
            this.idleDelay = Math.max(1L, idleDelay);
        }

        public long getInDemandDelay() {
            return this.inDemandDelay;
        }

        public long getIdleDelay() {
            return this.idleDelay;
        }

        @Override
        @GuardedBy(value="hudson.model.Queue.lock")
        public long check(SlaveComputer c) {
            if (c.isOffline() && c.isLaunchSupported()) {
                HashMap<Computer, Integer> availableComputers = new HashMap<Computer, Integer>();
                for (Computer o : Jenkins.getInstance().getComputers()) {
                    int idleExecutors;
                    if (!o.isOnline() && !o.isConnecting() || !o.isPartiallyIdle() || !o.isAcceptingTasks() || (idleExecutors = o.countIdle()) <= 0) continue;
                    availableComputers.put(o, idleExecutors);
                }
                boolean needComputer = false;
                long demandMilliseconds = 0L;
                for (Queue.BuildableItem item : Queue.getInstance().getBuildableItems()) {
                    boolean needExecutor = true;
                    for (Computer o : Collections.unmodifiableSet(availableComputers.keySet())) {
                        Node otherNode = o.getNode();
                        if (otherNode == null || otherNode.canTake(item) != null) continue;
                        needExecutor = false;
                        int availableExecutors = (Integer)availableComputers.remove(o);
                        if (availableExecutors > 1) {
                            availableComputers.put(o, availableExecutors - 1);
                            break;
                        }
                        availableComputers.remove(o);
                        break;
                    }
                    Slave checkedNode = c.getNode();
                    if (!needExecutor || checkedNode == null || checkedNode.canTake(item) != null) continue;
                    demandMilliseconds = System.currentTimeMillis() - item.buildableStartMilliseconds;
                    needComputer = demandMilliseconds > this.inDemandDelay * 1000L * 60L;
                    break;
                }
                if (needComputer) {
                    logger.log(Level.INFO, "Launching computer {0} as it has been in demand for {1}", new Object[]{c.getName(), Util.getTimeSpanString(demandMilliseconds)});
                    c.connect(false);
                }
            } else if (c.isIdle()) {
                long idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds();
                if (idleMilliseconds > this.idleDelay * 1000L * 60L) {
                    logger.log(Level.INFO, "Disconnecting computer {0} as it has been idle for {1}", new Object[]{c.getName(), Util.getTimeSpanString(idleMilliseconds)});
                    c.disconnect(new OfflineCause.IdleOfflineCause());
                } else {
                    return TimeUnit.MILLISECONDS.toMinutes(TimeUnit.MINUTES.toMillis(this.idleDelay) - idleMilliseconds);
                }
            }
            return 1L;
        }

        @Extension
        @Symbol(value={"demand"})
        public static class DescriptorImpl
        extends Descriptor<RetentionStrategy<?>> {
            @Override
            public String getDisplayName() {
                return Messages.RetentionStrategy_Demand_displayName();
            }
        }
    }

    public static class Always
    extends RetentionStrategy<SlaveComputer> {
        @DataBoundConstructor
        public Always() {
        }

        @Override
        @GuardedBy(value="hudson.model.Queue.lock")
        public long check(SlaveComputer c) {
            if (c.isOffline() && !c.isConnecting() && c.isLaunchSupported()) {
                c.tryReconnect();
            }
            return 1L;
        }

        @Extension(ordinal=100.0)
        @Symbol(value={"always"})
        public static class DescriptorImpl
        extends Descriptor<RetentionStrategy<?>> {
            @Override
            public String getDisplayName() {
                return Messages.RetentionStrategy_Always_displayName();
            }
        }
    }
}

