/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks._maven;

import hudson.console.LineTransformationOutputStream;
import hudson.tasks._maven.Maven3MojoNote;
import hudson.tasks._maven.MavenErrorNote;
import hudson.tasks._maven.MavenMojoNote;
import hudson.tasks._maven.MavenWarningNote;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;

public class MavenConsoleAnnotator
extends LineTransformationOutputStream {
    private final OutputStream out;
    private final Charset charset;

    public MavenConsoleAnnotator(OutputStream out, Charset charset) {
        this.out = out;
        this.charset = charset;
    }

    @Override
    protected void eol(byte[] b, int len) throws IOException {
        String line = this.charset.decode(ByteBuffer.wrap(b, 0, len)).toString();
        Matcher m = MavenMojoNote.PATTERN.matcher(line = this.trimEOL(line));
        if (m.matches()) {
            new MavenMojoNote().encodeTo(this.out);
        }
        if ((m = Maven3MojoNote.PATTERN.matcher(line)).matches()) {
            new Maven3MojoNote().encodeTo(this.out);
        }
        if ((m = MavenWarningNote.PATTERN.matcher(line)).find()) {
            new MavenWarningNote().encodeTo(this.out);
        }
        if ((m = MavenErrorNote.PATTERN.matcher(line)).find()) {
            new MavenErrorNote().encodeTo(this.out);
        }
        this.out.write(b, 0, len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.out.close();
    }
}

