/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.trilead.ssh2.crypto.Base64;
import hudson.EnvVars;
import hudson.Functions;
import hudson.ProxyConfiguration;
import hudson.RelativePath;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.Messages;
import hudson.util.ReflectionUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.springframework.util.StringUtils;

public abstract class FormValidation
extends IOException
implements HttpResponse {
    private static final FormValidation OK = FormValidation.respond(Kind.OK, "<div/>");
    public final Kind kind;

    public static FormValidation error(String message) {
        return FormValidation.errorWithMarkup(message == null ? null : Util.escape(message));
    }

    public static FormValidation warning(String message) {
        return FormValidation.warningWithMarkup(message == null ? null : Util.escape(message));
    }

    public static FormValidation ok(String message) {
        return FormValidation.okWithMarkup(message == null ? null : Util.escape(message));
    }

    public static FormValidation ok() {
        return OK;
    }

    public static FormValidation error(String format, Object ... args) {
        return FormValidation.error(String.format(format, args));
    }

    public static FormValidation warning(String format, Object ... args) {
        return FormValidation.warning(String.format(format, args));
    }

    public static FormValidation ok(String format, Object ... args) {
        return FormValidation.ok(String.format(format, args));
    }

    public static FormValidation error(Throwable e, String message) {
        return FormValidation._error(Kind.ERROR, e, message);
    }

    public static FormValidation warning(Throwable e, String message) {
        return FormValidation._error(Kind.WARNING, e, message);
    }

    private static FormValidation _error(Kind kind, Throwable e, String message) {
        if (e == null) {
            return FormValidation._errorWithMarkup(Util.escape(message), kind);
        }
        return FormValidation._errorWithMarkup(Util.escape(message) + " <a href='#' class='showDetails'>" + Messages.FormValidation_Error_Details() + "</a><pre style='display:none'>" + Util.escape(Functions.printThrowable(e)) + "</pre>", kind);
    }

    public static FormValidation error(Throwable e, String format, Object ... args) {
        return FormValidation.error(e, String.format(format, args));
    }

    public static FormValidation warning(Throwable e, String format, Object ... args) {
        return FormValidation.warning(e, String.format(format, args));
    }

    @Nonnull
    public static FormValidation aggregate(@Nonnull Collection<FormValidation> validations) {
        if (validations == null || validations.isEmpty()) {
            return FormValidation.ok();
        }
        if (validations.size() == 1) {
            return validations.iterator().next();
        }
        StringBuilder sb = new StringBuilder("<ul style='list-style-type: none; padding-left: 0; margin: 0'>");
        Kind worst = Kind.OK;
        for (FormValidation validation : validations) {
            sb.append("<li>").append(validation.renderHtml()).append("</li>");
            if (validation.kind.ordinal() <= worst.ordinal()) continue;
            worst = validation.kind;
        }
        sb.append("</ul>");
        return FormValidation.respond(worst, sb.toString());
    }

    public static FormValidation errorWithMarkup(String message) {
        return FormValidation._errorWithMarkup(message, Kind.ERROR);
    }

    public static FormValidation warningWithMarkup(String message) {
        return FormValidation._errorWithMarkup(message, Kind.WARNING);
    }

    public static FormValidation okWithMarkup(String message) {
        return FormValidation._errorWithMarkup(message, Kind.OK);
    }

    private static FormValidation _errorWithMarkup(final String message, Kind kind) {
        if (message == null) {
            return FormValidation.ok();
        }
        return new FormValidation(kind, message){

            @Override
            public String renderHtml() {
                StaplerRequest req = Stapler.getCurrentRequest();
                if (req == null) {
                    return message;
                }
                return "<div class=" + this.kind.name().toLowerCase(Locale.ENGLISH) + "><img src='" + req.getContextPath() + Jenkins.RESOURCE_PATH + "/images/none.gif' height=16 width=1>" + message + "</div>";
            }

            @Override
            public String toString() {
                return (Object)((Object)this.kind) + ": " + message;
            }
        };
    }

    public static FormValidation respond(Kind kind, final String html) {
        return new FormValidation(kind){

            @Override
            public String renderHtml() {
                return html;
            }

            @Override
            public String toString() {
                return (Object)((Object)this.kind) + ": " + html;
            }
        };
    }

    public static FormValidation validateExecutable(String exe) {
        return FormValidation.validateExecutable(exe, FileValidator.NOOP);
    }

    public static FormValidation validateExecutable(String exe, FileValidator exeValidator) {
        if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
            return FormValidation.ok();
        }
        if ((exe = Util.fixEmpty(exe)) == null) {
            return FormValidation.ok();
        }
        if (exe.indexOf(File.separatorChar) >= 0) {
            File f = new File(exe);
            if (f.exists()) {
                return exeValidator.validate(f);
            }
            File fexe = new File(exe + ".exe");
            if (fexe.exists()) {
                return exeValidator.validate(fexe);
            }
            return FormValidation.error("There's no such file: " + exe);
        }
        String path = EnvVars.masterEnvVars.get("PATH");
        String tokenizedPath = "";
        String delimiter = null;
        if (path != null) {
            for (String _dir : Util.tokenize(path.replace("\\", "\\\\"), File.pathSeparator)) {
                if (delimiter == null) {
                    delimiter = ", ";
                } else {
                    tokenizedPath = tokenizedPath + delimiter;
                }
                tokenizedPath = tokenizedPath + _dir.replace('\\', '/');
                File dir = new File(_dir);
                File f = new File(dir, exe);
                if (f.exists()) {
                    return exeValidator.validate(f);
                }
                File fexe = new File(dir, exe + ".exe");
                if (!fexe.exists()) continue;
                return exeValidator.validate(fexe);
            }
            tokenizedPath = tokenizedPath + ".";
        } else {
            tokenizedPath = "unavailable.";
        }
        return FormValidation.error("There's no such executable " + exe + " in PATH: " + tokenizedPath);
    }

    public static FormValidation validateNonNegativeInteger(String value) {
        try {
            if (Integer.parseInt(value) < 0) {
                return FormValidation.error(hudson.model.Messages.Hudson_NotANonNegativeNumber());
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error(hudson.model.Messages.Hudson_NotANumber());
        }
    }

    public static FormValidation validatePositiveInteger(String value) {
        try {
            if (Integer.parseInt(value) <= 0) {
                return FormValidation.error(hudson.model.Messages.Hudson_NotAPositiveNumber());
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error(hudson.model.Messages.Hudson_NotANumber());
        }
    }

    public static FormValidation validateRequired(String value) {
        if (Util.fixEmptyAndTrim(value) == null) {
            return FormValidation.error(Messages.FormValidation_ValidateRequired());
        }
        return FormValidation.ok();
    }

    public static FormValidation validateBase64(String value, boolean allowWhitespace, boolean allowEmpty, String errorMessage) {
        try {
            String v = value;
            if (!(allowWhitespace || v.indexOf(32) < 0 && v.indexOf(10) < 0)) {
                return FormValidation.error(errorMessage);
            }
            v = v.trim();
            if (!allowEmpty && v.length() == 0) {
                return FormValidation.error(errorMessage);
            }
            Base64.decode((char[])v.toCharArray());
            return FormValidation.ok();
        }
        catch (IOException e) {
            return FormValidation.error(errorMessage);
        }
    }

    private FormValidation(Kind kind) {
        this.kind = kind;
    }

    private FormValidation(Kind kind, String message) {
        super(message);
        this.kind = kind;
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        this.respond(rsp, this.renderHtml());
    }

    public abstract String renderHtml();

    protected void respond(StaplerResponse rsp, String html) throws IOException, ServletException {
        rsp.setContentType("text/html;charset=UTF-8");
        rsp.getWriter().print(html);
    }

    public static class CheckMethod {
        private final Descriptor descriptor;
        private final Method method;
        private final String capitalizedFieldName;
        private final List<String> names;
        private volatile String checkUrl;
        private volatile String dependsOn;

        public CheckMethod(Descriptor descriptor, String fieldName) {
            this.descriptor = descriptor;
            this.capitalizedFieldName = StringUtils.capitalize((String)fieldName);
            this.method = ReflectionUtils.getPublicMethodNamed(descriptor.getClass(), "doCheck" + this.capitalizedFieldName);
            if (this.method != null) {
                this.names = new ArrayList<String>();
                this.findParameters(this.method);
            } else {
                this.names = null;
            }
        }

        private void findParameters(Method method) {
            for (ReflectionUtils.Parameter p : ReflectionUtils.getParameters(method)) {
                QueryParameter qp = p.annotation(QueryParameter.class);
                if (qp != null) {
                    String name = qp.value();
                    if (name.length() == 0) {
                        name = p.name();
                    }
                    if (name == null || name.length() == 0 || name.equals("value")) continue;
                    RelativePath rp = p.annotation(RelativePath.class);
                    if (rp != null) {
                        name = rp.value() + '/' + name;
                    }
                    this.names.add(name);
                    continue;
                }
                Method m = ReflectionUtils.getPublicMethodNamed(p.type(), "fromStapler");
                if (m == null) continue;
                this.findParameters(m);
            }
        }

        public String toCheckUrl() {
            if (this.names == null) {
                return null;
            }
            if (this.checkUrl == null) {
                StringBuilder buf = new StringBuilder(Util.singleQuote(this.relativePath()));
                if (!this.names.isEmpty()) {
                    buf.append("+qs(this).addThis()");
                    for (String name : this.names) {
                        buf.append(".nearBy('" + name + "')");
                    }
                    buf.append(".toString()");
                }
                this.checkUrl = buf.toString();
            }
            return '\'' + Functions.jsStringEscape(Descriptor.getCurrentDescriptorByNameUrl()) + "/'+" + this.checkUrl;
        }

        public String toStemUrl() {
            if (this.names == null) {
                return null;
            }
            return Descriptor.getCurrentDescriptorByNameUrl() + '/' + this.relativePath();
        }

        public String getDependsOn() {
            if (this.names == null) {
                return null;
            }
            if (this.dependsOn == null) {
                this.dependsOn = Util.join(this.names, " ");
            }
            return this.dependsOn;
        }

        private String relativePath() {
            return this.descriptor.getDescriptorUrl() + "/check" + this.capitalizedFieldName;
        }
    }

    public static abstract class URLCheck {
        protected BufferedReader open(URL url) throws IOException {
            URLConnection con = ProxyConfiguration.open(url);
            if (con == null) {
                throw new IOException(url.toExternalForm());
            }
            return new BufferedReader(new InputStreamReader(con.getInputStream(), this.getCharset(con)));
        }

        protected boolean findText(BufferedReader in, String literal) throws IOException {
            String line;
            while ((line = in.readLine()) != null) {
                if (line.indexOf(literal) == -1) continue;
                return true;
            }
            return false;
        }

        protected FormValidation handleIOException(String url, IOException e) throws IOException, ServletException {
            if (e.getMessage().equals(url)) {
                return FormValidation.error("Unable to connect " + url);
            }
            return FormValidation.error(e.getMessage());
        }

        private String getCharset(URLConnection con) {
            for (String t : con.getContentType().split(";")) {
                if (!(t = t.trim().toLowerCase(Locale.ENGLISH)).startsWith("charset=")) continue;
                return t.substring(8);
            }
            return "UTF-8";
        }

        protected abstract FormValidation check() throws IOException, ServletException;
    }

    public static abstract class FileValidator {
        public static final FileValidator NOOP = new FileValidator(){

            @Override
            public FormValidation validate(File f) {
                return FormValidation.ok();
            }
        };

        public abstract FormValidation validate(File var1);
    }

    public static enum Kind {
        OK,
        WARNING,
        ERROR;

    }
}

