/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class Graph {
    private final long timestamp;
    private final int defaultW;
    private final int defaultH;
    private volatile JFreeChart graph;

    protected Graph(long timestamp, int defaultW, int defaultH) {
        this.timestamp = timestamp;
        this.defaultW = defaultW;
        this.defaultH = defaultH;
    }

    protected Graph(Calendar timestamp, int defaultW, int defaultH) {
        this(timestamp.getTimeInMillis(), defaultW, defaultH);
    }

    protected abstract JFreeChart createGraph();

    private BufferedImage render(StaplerRequest req, ChartRenderingInfo info) {
        String h;
        String w = req.getParameter("width");
        if (w == null) {
            w = String.valueOf(this.defaultW);
        }
        if ((h = req.getParameter("height")) == null) {
            h = String.valueOf(this.defaultH);
        }
        Color graphBg = Graph.stringToColor(req.getParameter("graphBg"));
        Color plotBg = Graph.stringToColor(req.getParameter("plotBg"));
        if (this.graph == null) {
            this.graph = this.createGraph();
        }
        this.graph.setBackgroundPaint((Paint)graphBg);
        Plot p = this.graph.getPlot();
        p.setBackgroundPaint((Paint)plotBg);
        return this.graph.createBufferedImage(Integer.parseInt(w), Integer.parseInt(h), info);
    }

    @Nonnull
    private static Color stringToColor(@CheckForNull String s) {
        if (s != null) {
            try {
                return Color.decode("0x" + s);
            }
            catch (NumberFormatException e) {
                return Color.WHITE;
            }
        }
        return Color.WHITE;
    }

    public void doPng(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.checkIfModified(this.timestamp, rsp)) {
            return;
        }
        try {
            BufferedImage image = this.render(req, null);
            rsp.setContentType("image/png");
            ServletOutputStream os = rsp.getOutputStream();
            ImageIO.write((RenderedImage)image, "PNG", (OutputStream)os);
            os.close();
        }
        catch (Error e) {
            if (e.getMessage().contains("Probable fatal error:No fonts found")) {
                rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
                return;
            }
            throw e;
        }
        catch (HeadlessException e) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
        }
    }

    public void doMap(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.checkIfModified(this.timestamp, rsp)) {
            return;
        }
        ChartRenderingInfo info = new ChartRenderingInfo();
        this.render(req, info);
        rsp.setContentType("text/plain;charset=UTF-8");
        rsp.getWriter().println(ChartUtilities.getImageMap((String)"map", (ChartRenderingInfo)info));
    }
}

