/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.console.ConsoleNote;
import hudson.model.TaskListener;
import hudson.util.AbstractTaskListener;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogTaskListener
extends AbstractTaskListener
implements Serializable {
    private final TaskListener delegate;
    private static final long serialVersionUID = 1L;

    public LogTaskListener(Logger logger, Level level) {
        this.delegate = new StreamTaskListener(new LogOutputStream(logger, level, new Throwable().getStackTrace()[1]));
    }

    @Override
    public PrintStream getLogger() {
        return this.delegate.getLogger();
    }

    @Override
    public PrintWriter error(String msg) {
        return this.delegate.error(msg);
    }

    @Override
    public PrintWriter error(String format, Object ... args) {
        return this.delegate.error(format, args);
    }

    @Override
    public PrintWriter fatalError(String msg) {
        return this.delegate.fatalError(msg);
    }

    @Override
    public PrintWriter fatalError(String format, Object ... args) {
        return this.delegate.fatalError(format, args);
    }

    @Override
    public void annotate(ConsoleNote ann) {
    }

    public void close() {
        this.delegate.getLogger().close();
    }

    private static class LogOutputStream
    extends OutputStream {
        private final Logger logger;
        private final Level level;
        private final StackTraceElement caller;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public LogOutputStream(Logger logger, Level level, StackTraceElement caller) {
            this.logger = logger;
            this.level = level;
            this.caller = caller;
        }

        @Override
        public void write(int b) throws IOException {
            if (b == 13 || b == 10) {
                this.flush();
            } else {
                this.baos.write(b);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.baos.size() > 0) {
                LogRecord lr = new LogRecord(this.level, this.baos.toString());
                lr.setLoggerName(this.logger.getName());
                lr.setSourceClassName(this.caller.getClassName());
                lr.setSourceMethodName(this.caller.getMethodName());
                this.logger.log(lr);
            }
            this.baos.reset();
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }
    }
}

